# -*- coding: utf-8 -*-
"""工具模块"""

from .config_manager import ConfigManager, config, get_config, load_config
from .logger import Logger, logger, get_logger, setup_logger
from .events import (
    EventType, Event, User, Gift,
    ChatEvent, GiftEvent, EntranceEvent, FollowEvent, LikeEvent, RoomStatsEvent,
    EventEmitter, event_emitter, get_event_emitter
)

# 延迟导入依赖 cv2 的模块，避免在没有安装 opencv 时导致整个模块加载失败
def __getattr__(name):
    """延迟导入 cv2 相关模块"""
    if name == 'VideoAntiDetection':
        from .video_anti_detection import VideoAntiDetection
        return VideoAntiDetection
    elif name == 'BeautyFilter':
        from .beauty_filter import BeautyFilter
        return BeautyFilter
    elif name == 'QuickBeautyPresets':
        from .beauty_filter import QuickBeautyPresets
        return QuickBeautyPresets
    elif name == 'FaceStickerFilter':
        from .face_sticker import FaceStickerFilter
        return FaceStickerFilter
    elif name == 'FaceDeformation':
        from .face_deformation import FaceDeformation
        return FaceDeformation
    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")

__all__ = [
    'ConfigManager', 'config', 'get_config', 'load_config',
    'Logger', 'logger', 'get_logger', 'setup_logger',
    'EventType', 'Event', 'User', 'Gift',
    'ChatEvent', 'GiftEvent', 'EntranceEvent', 'FollowEvent', 'LikeEvent', 'RoomStatsEvent',
    'EventEmitter', 'event_emitter', 'get_event_emitter',
    'VideoAntiDetection', 'BeautyFilter', 'QuickBeautyPresets', 'FaceStickerFilter', 'FaceDeformation'
]
