-- LuaGObject Adw (libadwaita) overrides
-- © 2025 Victoria Lacroix
-- Licensed under the terms of an MIT license: http://www.opensource.org/licenses/mit-license.php

local LuaGObject = require "LuaGObject"
local Adw = LuaGObject.Adw
local Gtk = LuaGObject.Gtk

local log = LuaGObject.log.domain "LuaGObject.Adw"

-- Constructor container support --

Adw.Carousel._container_add = Adw.Carousel.append
Adw.PreferencesDialog._container_add = Adw.PreferencesDialog._method.add
Adw.PreferencesPage._container_add = Adw.PreferencesPage._method.add
Adw.PreferencesGroup._container_add = Adw.PreferencesGroup._method.add
Adw.ExpanderRow._container_add = Adw.ExpanderRow.add_row

-- These classes were introduced in later versions of Adw, and thus may not always be available.
-- Introduced in Adw 1.7
if Adw.WrapBox then
	Adw.WrapBox._container_add = Adw.WrapBox._method.append
end

--Introduced in Adw 1.8
if Adw.ShortcutsDialog then
	Adw.ShortcutsDialog._container_add = Adw.ShortcutsDialog.add
end
if Adw.ShortcutsSection then
	Adw.ShortcutsSection._container_add = Adw.ShortcutsSection.add
end

-- Adw.TabView overrides --

function Adw.TabView:_container_add(child)
	if Gtk.Widget:is_type_of(child) then
		child = { child }
	end
	if type(child) ~= "table" then
		error("%s: Child must be table or GTK Widget", self._type.name)
	end
	if #child ~= 1 or not Gtk.Widget:is_type_of(child[1]) then
		error("%s: Child must contain only a single GTK Widget.", self._type.name)
	end
	local page
	if child.pinned then
		page = self:append_pinned(child[1])
	else
		page = self:append(child[1])
	end
	if type(child.title) == "string" then
		page.title = child.title
	end
end

-- Adw.ViewStack overrides --

function Adw.ViewStack:_container_add(child)
	if Gtk.Widget:is_type_of(child) then
		child = { child }
	end
	if type(child) ~= "table" then
		error("%s: Child must be table or GTK Widget", self._type.name)
	end
	if #child ~= 1 or not Gtk.Widget:is_type_of(child[1]) then
		error("%s: Child table must contain one GTK Widget.", self._type.name)
	end
	if type(child.icon_name) == "string" and type(child.title) == "string" and type(child.name) == "string" then
		self:add_titled_with_icon(child[1], child.name, child.title, child.icon_name)
	elseif type(child.title) == "string" and type(child.name) == "string" then
		self:add_titled(child[1], child.name, child.title)
	elseif type(child.name) == "string" then
		self:add_named(child[1], child.name)
	else
		self:add(child[1])
	end
end

-- Adw.ActionRow overrides --

Adw.ActionRow._attribute = {
	prefixes = {},
	suffixes = {},
}

function Adw.ActionRow._attribute.prefixes:get()
	error("%s: Cannot read prefixes; attribute is write-only.", self._type.name)
end
function Adw.ActionRow._attribute.prefixes:set(value)
	if Gtk.Widget:is_type_of(value) then
		value = { value }
	end
	if type(value) ~= "table" then
		error("%s: Can only write table or Gtk.Widget to add_prefixes.", self._type.name)
	end
	for _, c in ipairs(value) do
		self:add_prefix(c)
	end
end

function Adw.ActionRow._attribute.suffixes:get()
	error("%s: Cannot read suffixes; attribute is write-only.", self._type.name)
end
function Adw.ActionRow._attribute.suffixes:set(value)
	if Gtk.Widget:is_type_of(value) then
		value = { value }
	end
	if type(value) ~= "table" then
		error("%s: Can only write table or Widget to add_suffixes.", self._type.name)
	end
	for _, v in ipairs(value) do
		self:add_suffix(v)
	end
end

-- Adw.HeaderBar overrides --

Adw.HeaderBar._attribute = {
	end_packs = {},
	start_packs = {},
}

function Adw.HeaderBar._attribute.end_packs:get()
	error("%s: Cannot read end_packs; attribute is write-only.", self._type.name)
end
function Adw.HeaderBar._attribute.end_packs:set(value)
	if Gtk.Widget:is_type_of(value) then
		value = { value }
	end
	if type(value) ~= "table" then
		error("%s: Can only write table or Widget to end_packs.", self._type.name)
	end
	for _, v in ipairs(value) do
		self:pack_end(v)
	end
end

function Adw.HeaderBar._attribute.start_packs:get()
	error("%s: Cannot read start_packs; attribute is write-only.", self._type.name)
end
function Adw.HeaderBar._attribute.start_packs:set(value)
	if Gtk.Widget:is_type_of(value) then
		value = { value }
	end
	if type(value) ~= "table" then
		error("%s: Can only write table or Widget to start_packs.", self._type.name)
	end
	for _, v in ipairs(value) do
		self:pack_start(v)
	end
end

-- Adw.ToolbarView overrides --

-- Adw.ToolbarView was introduced in Adw 1.4. It should only be overridden if it exists.
if Adw.ToolbarView then
	Adw.ToolbarView._attribute = {
		bottom_bars = {},
		top_bars = {},
	}

	function Adw.ToolbarView._attribute.bottom_bars:get()
		error("%s: Cannot read bottom_bars; attribute is write-only.", self._type.name)
	end
	function Adw.ToolbarView._attribute.bottom_bars:set(value)
		if Gtk.Widget:is_type_of(value) then
			value = { value }
		end
		if type(value) ~= "table" then
			error("%s: Can only write table or Gtk.Widget to add_bottom_bars.", self._type.name)
		end
		for _, v in ipairs(values) do
			self:add_bottom_bar(v)
		end
	end

	function Adw.ToolbarView._attribute.top_bars:get()
		error("%s: Cannot read top_bars; attribute is write-only.", self._type.name)
	end
	function Adw.ToolbarView._attribute.top_bars:set(value)
		if Gtk.Widget:is_type_of(value) then
			value = { value }
		end
		if type(value) ~= "table" then
			error("%s: Can only write table or Gtk.Widget to add_top_bars.", self._type.name)
		end
		for _, v in ipairs(value) do
			self:add_top_bar(v)
		end
	end
end
