---
title: Documentation for the powershell Generator
---

## METADATA

| Property | Value | Notes |
| -------- | ----- | ----- |
| generator name | powershell | pass this to the generate command after -g |
| generator stability | BETA | |
| generator type | CLIENT | |
| generator language | PowerShell | |
| generator default templating engine | mustache | |
| helpTxt | Generates a PowerShell API client (beta) | |

## CONFIG OPTIONS
These options may be applied as additional-properties (cli) or configOptions (plugins). Refer to [configuration docs](https://openapi-generator.tech/docs/configuration) for more details.

| Option | Description | Values | Default |
| ------ | ----------- | ------ | ------- |
|apiNamePrefix|Prefix that will be appended to all PS objects. Default: empty string. e.g. Pet =&gt; PSPet.| |null|
|commonVerbs|PS common verb mappings. e.g. Delete=Remove:Patch=Update to map Delete with Remove and Patch with Update accordingly.| |null|
|disallowAdditionalPropertiesIfNotPresent|If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.|<dl><dt>**false**</dt><dd>The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.</dd><dt>**true**</dt><dd>Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.</dd></dl>|true|
|discardReadOnly|Set discardReadonly to true to generate the Initialize cmdlet without readonly parameters| |null|
|iconUri|A URL to an icon representing the generated PowerShell module| |null|
|licenseUri|A URL to the license for the generated PowerShell module| |null|
|modelsCmdletVerb|Verb to be used when generating the Models cmdlets in the examples.| |Initialize|
|packageGuid|GUID for PowerShell module (e.g. a27b908d-2a20-467f-bc32-af6f3a654ac5). A random GUID will be generated by default.| |null|
|packageName|Client package name (e.g. PSTwitter).| |PSOpenAPITools|
|packageVersion|Package version (e.g. 0.1.2).| |0.1.2|
|powershellGalleryUrl|URL to the module in PowerShell Gallery (e.g. https://www.powershellgallery.com/packages/PSTwitter/).| |null|
|projectUri|A URL to the main website for this project| |null|
|releaseNotes|Release notes of the generated PowerShell module| |null|
|skipVerbParsing|Set skipVerbParsing to not try get powershell verbs of operation names| |null|
|tags|Tags applied to the generated PowerShell module. These help with module discovery in online galleries| |null|
|useClassNameInModelsExamples|Use classname instead of name when generating the Models cmdlets in the examples.| |true|
|useOneOfDiscriminatorLookup|Use the discriminator's mapping in oneOf to speed up the model lookup. IMPORTANT: Validation (e.g. one and only one match in oneOf's schemas) will be skipped.| |null|

## IMPORT MAPPING

| Type/Alias | Imports |
| ---------- | ------- |


## INSTANTIATION TYPES

| Type/Alias | Instantiated By |
| ---------- | --------------- |


## LANGUAGE PRIMITIVES

<ul class="column-ul">
<li>Boolean</li>
<li>Byte</li>
<li>Byte[]</li>
<li>Char</li>
<li>Decimal</li>
<li>Double</li>
<li>Guid</li>
<li>Int16</li>
<li>Int32</li>
<li>Int64</li>
<li>ProgressRecord</li>
<li>SByte</li>
<li>SecureString</li>
<li>Single</li>
<li>String</li>
<li>System.DateTime</li>
<li>System.IO.FileInfo</li>
<li>TimeSpan</li>
<li>UInt16</li>
<li>UInt32</li>
<li>UInt64</li>
<li>Uri</li>
<li>Version</li>
<li>XmlDocument</li>
</ul>

## RESERVED WORDS

<ul class="column-ul">
<li>args</li>
<li>begin</li>
<li>break</li>
<li>catch</li>
<li>consolefilename</li>
<li>continue</li>
<li>data</li>
<li>do</li>
<li>dynamicparam</li>
<li>else</li>
<li>elseif</li>
<li>end</li>
<li>error</li>
<li>event</li>
<li>eventargs</li>
<li>eventsubscriber</li>
<li>executioncontext</li>
<li>exit</li>
<li>false</li>
<li>filter</li>
<li>finally</li>
<li>for</li>
<li>foreach</li>
<li>from</li>
<li>function</li>
<li>home</li>
<li>host</li>
<li>if</li>
<li>in</li>
<li>input</li>
<li>lastexitcode</li>
<li>local</li>
<li>matches</li>
<li>myinvocation</li>
<li>nestedpromptlevel</li>
<li>null</li>
<li>param</li>
<li>pid</li>
<li>private</li>
<li>process</li>
<li>profile</li>
<li>pscmdlet</li>
<li>pscommandpath</li>
<li>psculture</li>
<li>psdebugcontext</li>
<li>pshome</li>
<li>psitem</li>
<li>psscriptroot</li>
<li>pssenderinfo</li>
<li>psuiculture</li>
<li>psversiontable</li>
<li>return</li>
<li>sender</li>
<li>shellid</li>
<li>stacktrace</li>
<li>switch</li>
<li>this</li>
<li>throw</li>
<li>trap</li>
<li>true</li>
<li>try</li>
<li>until</li>
<li>where</li>
<li>while</li>
</ul>

## FEATURE SET


### Client Modification Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|BasePath|✗|ToolingExtension
|Authorizations|✗|ToolingExtension
|UserAgent|✗|ToolingExtension
|MockServer|✗|ToolingExtension

### Data Type Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Custom|✗|OAS2,OAS3
|Int32|✓|OAS2,OAS3
|Int64|✓|OAS2,OAS3
|Float|✓|OAS2,OAS3
|Double|✓|OAS2,OAS3
|Decimal|✓|ToolingExtension
|String|✓|OAS2,OAS3
|Byte|✓|OAS2,OAS3
|Binary|✓|OAS2,OAS3
|Boolean|✓|OAS2,OAS3
|Date|✓|OAS2,OAS3
|DateTime|✓|OAS2,OAS3
|Password|✓|OAS2,OAS3
|File|✓|OAS2
|Uuid|✗|
|Array|✓|OAS2,OAS3
|Null|✗|OAS3
|AnyType|✗|OAS2,OAS3
|Object|✓|OAS2,OAS3
|Maps|✓|ToolingExtension
|CollectionFormat|✓|OAS2
|CollectionFormatMulti|✓|OAS2
|Enum|✓|OAS2,OAS3
|ArrayOfEnum|✓|ToolingExtension
|ArrayOfModel|✓|ToolingExtension
|ArrayOfCollectionOfPrimitives|✓|ToolingExtension
|ArrayOfCollectionOfModel|✓|ToolingExtension
|ArrayOfCollectionOfEnum|✓|ToolingExtension
|MapOfEnum|✓|ToolingExtension
|MapOfModel|✓|ToolingExtension
|MapOfCollectionOfPrimitives|✓|ToolingExtension
|MapOfCollectionOfModel|✓|ToolingExtension
|MapOfCollectionOfEnum|✓|ToolingExtension

### Documentation Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Readme|✓|ToolingExtension
|Model|✓|ToolingExtension
|Api|✓|ToolingExtension

### Global Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Host|✓|OAS2,OAS3
|BasePath|✓|OAS2,OAS3
|Info|✓|OAS2,OAS3
|Schemes|✗|OAS2,OAS3
|PartialSchemes|✓|OAS2,OAS3
|Consumes|✓|OAS2
|Produces|✓|OAS2
|ExternalDocumentation|✓|OAS2,OAS3
|Examples|✓|OAS2,OAS3
|XMLStructureDefinitions|✗|OAS2,OAS3
|MultiServer|✗|OAS3
|ParameterizedServer|✗|OAS3
|ParameterStyling|✗|OAS3
|Callbacks|✗|OAS3
|LinkObjects|✗|OAS3

### Parameter Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Path|✓|OAS2,OAS3
|Query|✓|OAS2,OAS3
|Header|✓|OAS2,OAS3
|Body|✓|OAS2
|FormUnencoded|✓|OAS2
|FormMultipart|✓|OAS2
|Cookie|✗|OAS3

### Schema Support Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Simple|✓|OAS2,OAS3
|Composite|✓|OAS2,OAS3
|Polymorphism|✗|OAS2,OAS3
|Union|✗|OAS3
|allOf|✗|OAS2,OAS3
|anyOf|✗|OAS3
|oneOf|✗|OAS3
|not|✗|OAS3

### Security Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|BasicAuth|✓|OAS2,OAS3
|ApiKey|✓|OAS2,OAS3
|OpenIDConnect|✗|OAS3
|BearerToken|✓|OAS3
|OAuth2_Implicit|✗|OAS2,OAS3
|OAuth2_Password|✗|OAS2,OAS3
|OAuth2_ClientCredentials|✗|OAS2,OAS3
|OAuth2_AuthorizationCode|✗|OAS2,OAS3
|SignatureAuth|✓|OAS3
|AWSV4Signature|✗|ToolingExtension

### Wire Format Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|JSON|✓|OAS2,OAS3
|XML|✓|OAS2,OAS3
|PROTOBUF|✗|ToolingExtension
|Custom|✗|OAS2,OAS3
