/*
 * Echo Server API
 *
 * Echo Server API
 *
 * The version of the OpenAPI document: 0.1.0
 * Contact: team@openapitools.org
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Org.OpenAPITools.Client;
using Org.OpenAPITools.Model;

namespace Org.OpenAPITools.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IHeaderApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Test header parameter(s)
        /// </summary>
        /// <remarks>
        /// Test header parameter(s)
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerHeader"> (optional)</param>
        /// <param name="booleanHeader"> (optional)</param>
        /// <param name="stringHeader"> (optional)</param>
        /// <param name="enumNonrefStringHeader"> (optional)</param>
        /// <param name="enumRefStringHeader"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        string TestHeaderIntegerBooleanStringEnums(int? integerHeader = default, bool? booleanHeader = default, string? stringHeader = default, string? enumNonrefStringHeader = default, StringEnumRef? enumRefStringHeader = default, int operationIndex = 0);

        /// <summary>
        /// Test header parameter(s)
        /// </summary>
        /// <remarks>
        /// Test header parameter(s)
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerHeader"> (optional)</param>
        /// <param name="booleanHeader"> (optional)</param>
        /// <param name="stringHeader"> (optional)</param>
        /// <param name="enumNonrefStringHeader"> (optional)</param>
        /// <param name="enumRefStringHeader"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        ApiResponse<string> TestHeaderIntegerBooleanStringEnumsWithHttpInfo(int? integerHeader = default, bool? booleanHeader = default, string? stringHeader = default, string? enumNonrefStringHeader = default, StringEnumRef? enumRefStringHeader = default, int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IHeaderApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// Test header parameter(s)
        /// </summary>
        /// <remarks>
        /// Test header parameter(s)
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerHeader"> (optional)</param>
        /// <param name="booleanHeader"> (optional)</param>
        /// <param name="stringHeader"> (optional)</param>
        /// <param name="enumNonrefStringHeader"> (optional)</param>
        /// <param name="enumRefStringHeader"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        System.Threading.Tasks.Task<string> TestHeaderIntegerBooleanStringEnumsAsync(int? integerHeader = default, bool? booleanHeader = default, string? stringHeader = default, string? enumNonrefStringHeader = default, StringEnumRef? enumRefStringHeader = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default);

        /// <summary>
        /// Test header parameter(s)
        /// </summary>
        /// <remarks>
        /// Test header parameter(s)
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerHeader"> (optional)</param>
        /// <param name="booleanHeader"> (optional)</param>
        /// <param name="stringHeader"> (optional)</param>
        /// <param name="enumNonrefStringHeader"> (optional)</param>
        /// <param name="enumRefStringHeader"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        System.Threading.Tasks.Task<ApiResponse<string>> TestHeaderIntegerBooleanStringEnumsWithHttpInfoAsync(int? integerHeader = default, bool? booleanHeader = default, string? stringHeader = default, string? enumNonrefStringHeader = default, StringEnumRef? enumRefStringHeader = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IHeaderApi : IHeaderApiSync, IHeaderApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class HeaderApi : IHeaderApi
    {
        private Org.OpenAPITools.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="HeaderApi"/> class.
        /// </summary>
        /// <returns></returns>
        public HeaderApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="HeaderApi"/> class.
        /// </summary>
        /// <returns></returns>
        public HeaderApi(string basePath)
        {
            this.Configuration = Org.OpenAPITools.Client.Configuration.MergeConfigurations(
                Org.OpenAPITools.Client.GlobalConfiguration.Instance,
                new Org.OpenAPITools.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Org.OpenAPITools.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Org.OpenAPITools.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Org.OpenAPITools.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="HeaderApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public HeaderApi(Org.OpenAPITools.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Org.OpenAPITools.Client.Configuration.MergeConfigurations(
                Org.OpenAPITools.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Org.OpenAPITools.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Org.OpenAPITools.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Org.OpenAPITools.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="HeaderApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public HeaderApi(Org.OpenAPITools.Client.ISynchronousClient client, Org.OpenAPITools.Client.IAsynchronousClient asyncClient, Org.OpenAPITools.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Org.OpenAPITools.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Org.OpenAPITools.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Org.OpenAPITools.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Org.OpenAPITools.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Org.OpenAPITools.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Test header parameter(s) Test header parameter(s)
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerHeader"> (optional)</param>
        /// <param name="booleanHeader"> (optional)</param>
        /// <param name="stringHeader"> (optional)</param>
        /// <param name="enumNonrefStringHeader"> (optional)</param>
        /// <param name="enumRefStringHeader"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        public string TestHeaderIntegerBooleanStringEnums(int? integerHeader = default, bool? booleanHeader = default, string? stringHeader = default, string? enumNonrefStringHeader = default, StringEnumRef? enumRefStringHeader = default, int operationIndex = 0)
        {
            Org.OpenAPITools.Client.ApiResponse<string> localVarResponse = TestHeaderIntegerBooleanStringEnumsWithHttpInfo(integerHeader, booleanHeader, stringHeader, enumNonrefStringHeader, enumRefStringHeader);
            return localVarResponse.Data;
        }

        /// <summary>
        /// Test header parameter(s) Test header parameter(s)
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerHeader"> (optional)</param>
        /// <param name="booleanHeader"> (optional)</param>
        /// <param name="stringHeader"> (optional)</param>
        /// <param name="enumNonrefStringHeader"> (optional)</param>
        /// <param name="enumRefStringHeader"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        public Org.OpenAPITools.Client.ApiResponse<string> TestHeaderIntegerBooleanStringEnumsWithHttpInfo(int? integerHeader = default, bool? booleanHeader = default, string? stringHeader = default, string? enumNonrefStringHeader = default, StringEnumRef? enumRefStringHeader = default, int operationIndex = 0)
        {
            Org.OpenAPITools.Client.RequestOptions localVarRequestOptions = new Org.OpenAPITools.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Org.OpenAPITools.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            var localVarMultipartFormData = localVarContentType == "multipart/form-data";
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Org.OpenAPITools.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (integerHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("integer_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(integerHeader)); // header parameter
            }
            if (booleanHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("boolean_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(booleanHeader)); // header parameter
            }
            if (stringHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("string_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(stringHeader)); // header parameter
            }
            if (enumNonrefStringHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("enum_nonref_string_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(enumNonrefStringHeader)); // header parameter
            }
            if (enumRefStringHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("enum_ref_string_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(enumRefStringHeader)); // header parameter
            }

            localVarRequestOptions.Operation = "HeaderApi.TestHeaderIntegerBooleanStringEnums";
            localVarRequestOptions.OperationIndex = operationIndex;


            // make the HTTP request
            var localVarResponse = this.Client.Get<string>("/header/integer/boolean/string/enums", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TestHeaderIntegerBooleanStringEnums", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Test header parameter(s) Test header parameter(s)
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerHeader"> (optional)</param>
        /// <param name="booleanHeader"> (optional)</param>
        /// <param name="stringHeader"> (optional)</param>
        /// <param name="enumNonrefStringHeader"> (optional)</param>
        /// <param name="enumRefStringHeader"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        public async System.Threading.Tasks.Task<string> TestHeaderIntegerBooleanStringEnumsAsync(int? integerHeader = default, bool? booleanHeader = default, string? stringHeader = default, string? enumNonrefStringHeader = default, StringEnumRef? enumRefStringHeader = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default)
        {
            Org.OpenAPITools.Client.ApiResponse<string> localVarResponse = await TestHeaderIntegerBooleanStringEnumsWithHttpInfoAsync(integerHeader, booleanHeader, stringHeader, enumNonrefStringHeader, enumRefStringHeader, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// Test header parameter(s) Test header parameter(s)
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerHeader"> (optional)</param>
        /// <param name="booleanHeader"> (optional)</param>
        /// <param name="stringHeader"> (optional)</param>
        /// <param name="enumNonrefStringHeader"> (optional)</param>
        /// <param name="enumRefStringHeader"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        public async System.Threading.Tasks.Task<Org.OpenAPITools.Client.ApiResponse<string>> TestHeaderIntegerBooleanStringEnumsWithHttpInfoAsync(int? integerHeader = default, bool? booleanHeader = default, string? stringHeader = default, string? enumNonrefStringHeader = default, StringEnumRef? enumRefStringHeader = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default)
        {

            Org.OpenAPITools.Client.RequestOptions localVarRequestOptions = new Org.OpenAPITools.Client.RequestOptions();

            string[] _contentTypes = new string[] {
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Org.OpenAPITools.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Org.OpenAPITools.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (integerHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("integer_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(integerHeader)); // header parameter
            }
            if (booleanHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("boolean_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(booleanHeader)); // header parameter
            }
            if (stringHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("string_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(stringHeader)); // header parameter
            }
            if (enumNonrefStringHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("enum_nonref_string_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(enumNonrefStringHeader)); // header parameter
            }
            if (enumRefStringHeader != null)
            {
                localVarRequestOptions.HeaderParameters.Add("enum_ref_string_header", Org.OpenAPITools.Client.ClientUtils.ParameterToString(enumRefStringHeader)); // header parameter
            }

            localVarRequestOptions.Operation = "HeaderApi.TestHeaderIntegerBooleanStringEnums";
            localVarRequestOptions.OperationIndex = operationIndex;


            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.GetAsync<string>("/header/integer/boolean/string/enums", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TestHeaderIntegerBooleanStringEnums", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
