/*
Echo Server API

Echo Server API

API version: 0.1.0
Contact: team@openapitools.org
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
	"time"
)

// checks if the DataQuery type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DataQuery{}

// DataQuery struct for DataQuery
type DataQuery struct {
	Query
	// test suffix
	Suffix *string `json:"suffix,omitempty"`
	// Some text containing white spaces
	Text *string `json:"text,omitempty"`
	// A date
	Date *time.Time `json:"date,omitempty"`
}

// NewDataQuery instantiates a new DataQuery object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDataQuery() *DataQuery {
	this := DataQuery{}
	return &this
}

// NewDataQueryWithDefaults instantiates a new DataQuery object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDataQueryWithDefaults() *DataQuery {
	this := DataQuery{}
	return &this
}

// GetSuffix returns the Suffix field value if set, zero value otherwise.
func (o *DataQuery) GetSuffix() string {
	if o == nil || IsNil(o.Suffix) {
		var ret string
		return ret
	}
	return *o.Suffix
}

// GetSuffixOk returns a tuple with the Suffix field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataQuery) GetSuffixOk() (*string, bool) {
	if o == nil || IsNil(o.Suffix) {
		return nil, false
	}
	return o.Suffix, true
}

// HasSuffix returns a boolean if a field has been set.
func (o *DataQuery) HasSuffix() bool {
	if o != nil && !IsNil(o.Suffix) {
		return true
	}

	return false
}

// SetSuffix gets a reference to the given string and assigns it to the Suffix field.
func (o *DataQuery) SetSuffix(v string) {
	o.Suffix = &v
}

// GetText returns the Text field value if set, zero value otherwise.
func (o *DataQuery) GetText() string {
	if o == nil || IsNil(o.Text) {
		var ret string
		return ret
	}
	return *o.Text
}

// GetTextOk returns a tuple with the Text field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataQuery) GetTextOk() (*string, bool) {
	if o == nil || IsNil(o.Text) {
		return nil, false
	}
	return o.Text, true
}

// HasText returns a boolean if a field has been set.
func (o *DataQuery) HasText() bool {
	if o != nil && !IsNil(o.Text) {
		return true
	}

	return false
}

// SetText gets a reference to the given string and assigns it to the Text field.
func (o *DataQuery) SetText(v string) {
	o.Text = &v
}

// GetDate returns the Date field value if set, zero value otherwise.
func (o *DataQuery) GetDate() time.Time {
	if o == nil || IsNil(o.Date) {
		var ret time.Time
		return ret
	}
	return *o.Date
}

// GetDateOk returns a tuple with the Date field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataQuery) GetDateOk() (*time.Time, bool) {
	if o == nil || IsNil(o.Date) {
		return nil, false
	}
	return o.Date, true
}

// HasDate returns a boolean if a field has been set.
func (o *DataQuery) HasDate() bool {
	if o != nil && !IsNil(o.Date) {
		return true
	}

	return false
}

// SetDate gets a reference to the given time.Time and assigns it to the Date field.
func (o *DataQuery) SetDate(v time.Time) {
	o.Date = &v
}

func (o DataQuery) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DataQuery) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	serializedQuery, errQuery := json.Marshal(o.Query)
	if errQuery != nil {
		return map[string]interface{}{}, errQuery
	}
	errQuery = json.Unmarshal([]byte(serializedQuery), &toSerialize)
	if errQuery != nil {
		return map[string]interface{}{}, errQuery
	}
	if !IsNil(o.Suffix) {
		toSerialize["suffix"] = o.Suffix
	}
	if !IsNil(o.Text) {
		toSerialize["text"] = o.Text
	}
	if !IsNil(o.Date) {
		toSerialize["date"] = o.Date
	}
	return toSerialize, nil
}

type NullableDataQuery struct {
	value *DataQuery
	isSet bool
}

func (v NullableDataQuery) Get() *DataQuery {
	return v.value
}

func (v *NullableDataQuery) Set(val *DataQuery) {
	v.value = val
	v.isSet = true
}

func (v NullableDataQuery) IsSet() bool {
	return v.isSet
}

func (v *NullableDataQuery) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDataQuery(val *DataQuery) *NullableDataQuery {
	return &NullableDataQuery{value: val, isSet: true}
}

func (v NullableDataQuery) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDataQuery) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


