/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.apis

import java.io.IOException
import okhttp3.Call
import okhttp3.HttpUrl

import org.openapitools.client.models.ApiStringEnumRef

import com.squareup.moshi.Json

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

open class HeaderApi(basePath: kotlin.String = defaultBasePath, client: Call.Factory = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "http://localhost:3000")
        }
    }

    /**
     * enum for parameter enumNonrefStringHeader
     */
     enum class EnumNonrefStringHeaderTestHeaderIntegerBooleanStringEnums(val value: kotlin.String) {
         @Json(name = "success") success("success"),
         @Json(name = "failure") failure("failure"),
         @Json(name = "unclassified") unclassified("unclassified");

        /**
         * Override [toString()] to avoid using the enum variable name as the value, and instead use
         * the actual value defined in the API spec file.
         *
         * This solves a problem when the variable name and its value are different, and ensures that
         * the client sends the correct enum values to the server always.
         */
        override fun toString(): kotlin.String = "$value"
     }

    /**
     * GET /header/integer/boolean/string/enums
     * Test header parameter(s)
     * Test header parameter(s)
     * @param integerHeader  (optional)
     * @param booleanHeader  (optional)
     * @param stringHeader  (optional)
     * @param enumNonrefStringHeader  (optional)
     * @param enumRefStringHeader  (optional)
     * @return kotlin.String
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun testHeaderIntegerBooleanStringEnums(integerHeader: kotlin.Int? = null, booleanHeader: kotlin.Boolean? = null, stringHeader: kotlin.String? = null, enumNonrefStringHeader: EnumNonrefStringHeaderTestHeaderIntegerBooleanStringEnums? = null, enumRefStringHeader: ApiStringEnumRef? = null) : kotlin.String {
        val localVarResponse = testHeaderIntegerBooleanStringEnumsWithHttpInfo(integerHeader = integerHeader, booleanHeader = booleanHeader, stringHeader = stringHeader, enumNonrefStringHeader = enumNonrefStringHeader, enumRefStringHeader = enumRefStringHeader)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.String
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * GET /header/integer/boolean/string/enums
     * Test header parameter(s)
     * Test header parameter(s)
     * @param integerHeader  (optional)
     * @param booleanHeader  (optional)
     * @param stringHeader  (optional)
     * @param enumNonrefStringHeader  (optional)
     * @param enumRefStringHeader  (optional)
     * @return ApiResponse<kotlin.String?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun testHeaderIntegerBooleanStringEnumsWithHttpInfo(integerHeader: kotlin.Int?, booleanHeader: kotlin.Boolean?, stringHeader: kotlin.String?, enumNonrefStringHeader: EnumNonrefStringHeaderTestHeaderIntegerBooleanStringEnums?, enumRefStringHeader: ApiStringEnumRef?) : ApiResponse<kotlin.String?> {
        val localVariableConfig = testHeaderIntegerBooleanStringEnumsRequestConfig(integerHeader = integerHeader, booleanHeader = booleanHeader, stringHeader = stringHeader, enumNonrefStringHeader = enumNonrefStringHeader, enumRefStringHeader = enumRefStringHeader)

        return request<Unit, kotlin.String>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation testHeaderIntegerBooleanStringEnums
     *
     * @param integerHeader  (optional)
     * @param booleanHeader  (optional)
     * @param stringHeader  (optional)
     * @param enumNonrefStringHeader  (optional)
     * @param enumRefStringHeader  (optional)
     * @return RequestConfig
     */
    fun testHeaderIntegerBooleanStringEnumsRequestConfig(integerHeader: kotlin.Int?, booleanHeader: kotlin.Boolean?, stringHeader: kotlin.String?, enumNonrefStringHeader: EnumNonrefStringHeaderTestHeaderIntegerBooleanStringEnums?, enumRefStringHeader: ApiStringEnumRef?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        integerHeader?.apply { localVariableHeaders["integer_header"] = this.toString() }
        booleanHeader?.apply { localVariableHeaders["boolean_header"] = this.toString() }
        stringHeader?.apply { localVariableHeaders["string_header"] = this.toString() }
        enumNonrefStringHeader?.apply { localVariableHeaders["enum_nonref_string_header"] = this.toString() }
        enumRefStringHeader?.apply { localVariableHeaders["enum_ref_string_header"] = this.toString() }
        localVariableHeaders["Accept"] = "text/plain"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/header/integer/boolean/string/enums",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
