/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.apis

import java.io.IOException
import okhttp3.Call
import okhttp3.HttpUrl

import org.openapitools.client.models.ApiPet
import org.openapitools.client.models.ApiStringEnumRef
import org.openapitools.client.models.ApiTestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter

import com.squareup.moshi.Json

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

open class QueryApi(basePath: kotlin.String = defaultBasePath, client: Call.Factory = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "http://localhost:3000")
        }
    }

    /**
     * enum for parameter enumNonrefStringQuery
     */
     enum class EnumNonrefStringQueryTestEnumRefString(val value: kotlin.String) {
         @Json(name = "success") success("success"),
         @Json(name = "failure") failure("failure"),
         @Json(name = "unclassified") unclassified("unclassified");

        /**
         * Override [toString()] to avoid using the enum variable name as the value, and instead use
         * the actual value defined in the API spec file.
         *
         * This solves a problem when the variable name and its value are different, and ensures that
         * the client sends the correct enum values to the server always.
         */
        override fun toString(): kotlin.String = "$value"
     }

    /**
     * GET /query/enum_ref_string
     * Test query parameter(s)
     * Test query parameter(s)
     * @param enumNonrefStringQuery  (optional)
     * @param enumRefStringQuery  (optional)
     * @return kotlin.String
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun testEnumRefString(enumNonrefStringQuery: EnumNonrefStringQueryTestEnumRefString? = null, enumRefStringQuery: ApiStringEnumRef? = null) : kotlin.String {
        val localVarResponse = testEnumRefStringWithHttpInfo(enumNonrefStringQuery = enumNonrefStringQuery, enumRefStringQuery = enumRefStringQuery)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.String
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * GET /query/enum_ref_string
     * Test query parameter(s)
     * Test query parameter(s)
     * @param enumNonrefStringQuery  (optional)
     * @param enumRefStringQuery  (optional)
     * @return ApiResponse<kotlin.String?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun testEnumRefStringWithHttpInfo(enumNonrefStringQuery: EnumNonrefStringQueryTestEnumRefString?, enumRefStringQuery: ApiStringEnumRef?) : ApiResponse<kotlin.String?> {
        val localVariableConfig = testEnumRefStringRequestConfig(enumNonrefStringQuery = enumNonrefStringQuery, enumRefStringQuery = enumRefStringQuery)

        return request<Unit, kotlin.String>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation testEnumRefString
     *
     * @param enumNonrefStringQuery  (optional)
     * @param enumRefStringQuery  (optional)
     * @return RequestConfig
     */
    fun testEnumRefStringRequestConfig(enumNonrefStringQuery: EnumNonrefStringQueryTestEnumRefString?, enumRefStringQuery: ApiStringEnumRef?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (enumNonrefStringQuery != null) {
                    put("enum_nonref_string_query", listOf(enumNonrefStringQuery.value))
                }
                if (enumRefStringQuery != null) {
                    put("enum_ref_string_query", listOf(enumRefStringQuery.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "text/plain"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/query/enum_ref_string",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * GET /query/datetime/date/string
     * Test query parameter(s)
     * Test query parameter(s)
     * @param datetimeQuery  (optional)
     * @param dateQuery  (optional)
     * @param stringQuery  (optional)
     * @return kotlin.String
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun testQueryDatetimeDateString(datetimeQuery: java.time.OffsetDateTime? = null, dateQuery: java.time.LocalDate? = null, stringQuery: kotlin.String? = null) : kotlin.String {
        val localVarResponse = testQueryDatetimeDateStringWithHttpInfo(datetimeQuery = datetimeQuery, dateQuery = dateQuery, stringQuery = stringQuery)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.String
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * GET /query/datetime/date/string
     * Test query parameter(s)
     * Test query parameter(s)
     * @param datetimeQuery  (optional)
     * @param dateQuery  (optional)
     * @param stringQuery  (optional)
     * @return ApiResponse<kotlin.String?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun testQueryDatetimeDateStringWithHttpInfo(datetimeQuery: java.time.OffsetDateTime?, dateQuery: java.time.LocalDate?, stringQuery: kotlin.String?) : ApiResponse<kotlin.String?> {
        val localVariableConfig = testQueryDatetimeDateStringRequestConfig(datetimeQuery = datetimeQuery, dateQuery = dateQuery, stringQuery = stringQuery)

        return request<Unit, kotlin.String>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation testQueryDatetimeDateString
     *
     * @param datetimeQuery  (optional)
     * @param dateQuery  (optional)
     * @param stringQuery  (optional)
     * @return RequestConfig
     */
    fun testQueryDatetimeDateStringRequestConfig(datetimeQuery: java.time.OffsetDateTime?, dateQuery: java.time.LocalDate?, stringQuery: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (datetimeQuery != null) {
                    put("datetime_query", listOf(parseDateToQueryString(datetimeQuery)))
                }
                if (dateQuery != null) {
                    put("date_query", listOf(parseDateToQueryString(dateQuery)))
                }
                if (stringQuery != null) {
                    put("string_query", listOf(stringQuery.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "text/plain"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/query/datetime/date/string",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * GET /query/integer/boolean/string
     * Test query parameter(s)
     * Test query parameter(s)
     * @param integerQuery  (optional)
     * @param booleanQuery  (optional)
     * @param stringQuery  (optional)
     * @return kotlin.String
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun testQueryIntegerBooleanString(integerQuery: kotlin.Int? = null, booleanQuery: kotlin.Boolean? = null, stringQuery: kotlin.String? = null) : kotlin.String {
        val localVarResponse = testQueryIntegerBooleanStringWithHttpInfo(integerQuery = integerQuery, booleanQuery = booleanQuery, stringQuery = stringQuery)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.String
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * GET /query/integer/boolean/string
     * Test query parameter(s)
     * Test query parameter(s)
     * @param integerQuery  (optional)
     * @param booleanQuery  (optional)
     * @param stringQuery  (optional)
     * @return ApiResponse<kotlin.String?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun testQueryIntegerBooleanStringWithHttpInfo(integerQuery: kotlin.Int?, booleanQuery: kotlin.Boolean?, stringQuery: kotlin.String?) : ApiResponse<kotlin.String?> {
        val localVariableConfig = testQueryIntegerBooleanStringRequestConfig(integerQuery = integerQuery, booleanQuery = booleanQuery, stringQuery = stringQuery)

        return request<Unit, kotlin.String>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation testQueryIntegerBooleanString
     *
     * @param integerQuery  (optional)
     * @param booleanQuery  (optional)
     * @param stringQuery  (optional)
     * @return RequestConfig
     */
    fun testQueryIntegerBooleanStringRequestConfig(integerQuery: kotlin.Int?, booleanQuery: kotlin.Boolean?, stringQuery: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (integerQuery != null) {
                    put("integer_query", listOf(integerQuery.toString()))
                }
                if (booleanQuery != null) {
                    put("boolean_query", listOf(booleanQuery.toString()))
                }
                if (stringQuery != null) {
                    put("string_query", listOf(stringQuery.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "text/plain"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/query/integer/boolean/string",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * GET /query/style_deepObject/explode_true/object
     * Test query parameter(s)
     * Test query parameter(s)
     * @param queryObject  (optional)
     * @return kotlin.String
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun testQueryStyleDeepObjectExplodeTrueObject(queryObject: ApiPet? = null) : kotlin.String {
        val localVarResponse = testQueryStyleDeepObjectExplodeTrueObjectWithHttpInfo(queryObject = queryObject)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.String
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * GET /query/style_deepObject/explode_true/object
     * Test query parameter(s)
     * Test query parameter(s)
     * @param queryObject  (optional)
     * @return ApiResponse<kotlin.String?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun testQueryStyleDeepObjectExplodeTrueObjectWithHttpInfo(queryObject: ApiPet?) : ApiResponse<kotlin.String?> {
        val localVariableConfig = testQueryStyleDeepObjectExplodeTrueObjectRequestConfig(queryObject = queryObject)

        return request<Unit, kotlin.String>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation testQueryStyleDeepObjectExplodeTrueObject
     *
     * @param queryObject  (optional)
     * @return RequestConfig
     */
    fun testQueryStyleDeepObjectExplodeTrueObjectRequestConfig(queryObject: ApiPet?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (queryObject != null) {
                    if (queryObject.id != null) {
                        put("queryObject[id]", listOf(queryObject.id.toString()))
                    }
                    if (queryObject.name != null) {
                        put("queryObject[name]", listOf(queryObject.name.toString()))
                    }
                    if (queryObject.category != null) {
                        put("queryObject[category]", listOf(queryObject.category.toString()))
                    }
                    if (queryObject.photoUrls != null) {
                        put("queryObject[photoUrls]", toMultiValue(queryObject.photoUrls.toList(), ""))
                    }
                    if (queryObject.tags != null) {
                        put("queryObject[tags]", toMultiValue(queryObject.tags.toList(), ""))
                    }
                    if (queryObject.status != null) {
                        put("queryObject[status]", listOf(queryObject.status.value))
                    }
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "text/plain"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/query/style_deepObject/explode_true/object",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * GET /query/style_form/explode_true/array_string
     * Test query parameter(s)
     * Test query parameter(s)
     * @param queryObject  (optional)
     * @return kotlin.String
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun testQueryStyleFormExplodeTrueArrayString(queryObject: ApiTestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter? = null) : kotlin.String {
        val localVarResponse = testQueryStyleFormExplodeTrueArrayStringWithHttpInfo(queryObject = queryObject)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.String
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * GET /query/style_form/explode_true/array_string
     * Test query parameter(s)
     * Test query parameter(s)
     * @param queryObject  (optional)
     * @return ApiResponse<kotlin.String?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun testQueryStyleFormExplodeTrueArrayStringWithHttpInfo(queryObject: ApiTestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter?) : ApiResponse<kotlin.String?> {
        val localVariableConfig = testQueryStyleFormExplodeTrueArrayStringRequestConfig(queryObject = queryObject)

        return request<Unit, kotlin.String>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation testQueryStyleFormExplodeTrueArrayString
     *
     * @param queryObject  (optional)
     * @return RequestConfig
     */
    fun testQueryStyleFormExplodeTrueArrayStringRequestConfig(queryObject: ApiTestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (queryObject != null) {
                    if (queryObject.propertyValues != null) {
                        put("values", toMultiValue(queryObject.propertyValues.toList(), ""))
                    }
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "text/plain"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/query/style_form/explode_true/array_string",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }

    /**
     * GET /query/style_form/explode_true/object
     * Test query parameter(s)
     * Test query parameter(s)
     * @param queryObject  (optional)
     * @return kotlin.String
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun testQueryStyleFormExplodeTrueObject(queryObject: ApiPet? = null) : kotlin.String {
        val localVarResponse = testQueryStyleFormExplodeTrueObjectWithHttpInfo(queryObject = queryObject)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> (localVarResponse as Success<*>).data as kotlin.String
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * GET /query/style_form/explode_true/object
     * Test query parameter(s)
     * Test query parameter(s)
     * @param queryObject  (optional)
     * @return ApiResponse<kotlin.String?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Suppress("UNCHECKED_CAST")
    @Throws(IllegalStateException::class, IOException::class)
    fun testQueryStyleFormExplodeTrueObjectWithHttpInfo(queryObject: ApiPet?) : ApiResponse<kotlin.String?> {
        val localVariableConfig = testQueryStyleFormExplodeTrueObjectRequestConfig(queryObject = queryObject)

        return request<Unit, kotlin.String>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation testQueryStyleFormExplodeTrueObject
     *
     * @param queryObject  (optional)
     * @return RequestConfig
     */
    fun testQueryStyleFormExplodeTrueObjectRequestConfig(queryObject: ApiPet?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (queryObject != null) {
                    if (queryObject.id != null) {
                        put("id", listOf(queryObject.id.toString()))
                    }
                    if (queryObject.name != null) {
                        put("name", listOf(queryObject.name.toString()))
                    }
                    if (queryObject.category != null) {
                        put("category", listOf(queryObject.category.toString()))
                    }
                    if (queryObject.photoUrls != null) {
                        put("photoUrls", toMultiValue(queryObject.photoUrls.toList(), ""))
                    }
                    if (queryObject.tags != null) {
                        put("tags", toMultiValue(queryObject.tags.toList(), ""))
                    }
                    if (queryObject.status != null) {
                        put("status", listOf(queryObject.status.value))
                    }
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "text/plain"

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/query/style_form/explode_true/object",
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
