<?php
/**
 * FormApi
 * PHP version 8.1
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Echo Server API
 *
 * Echo Server API
 *
 * The version of the OpenAPI document: 0.1.0
 * Contact: team@openapitools.org
 * @generated Generated by: https://openapi-generator.tech
 * Generator version: 7.20.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use InvalidArgumentException;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\ObjectSerializer;

/**
 * FormApi Class Doc Comment
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FormApi
{
    /**
     * @var ClientInterface
     */
    protected ClientInterface $client;

    /**
     * @var Configuration
     */
    protected Configuration $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @var int Host index
     */
    protected int $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'testFormIntegerBooleanString' => [
            'application/x-www-form-urlencoded',
        ],
        'testFormObjectMultipart' => [
            'multipart/form-data',
        ],
        'testFormOneof' => [
            'application/x-www-form-urlencoded',
        ],
    ];

    /**
     * @param ClientInterface|null $client
     * @param Configuration|null   $config
     * @param HeaderSelector|null  $selector
     * @param int                  $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex(int $hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex(): int
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig(): Configuration
    {
        return $this->config;
    }

    /**
     * Operation testFormIntegerBooleanString
     *
     * Test form parameter(s)
     *
     * @param  int|null $integer_form integer_form (optional)
     * @param  bool|null $boolean_form boolean_form (optional)
     * @param  string|null $string_form string_form (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testFormIntegerBooleanString(
        ?int $integer_form = null,
        ?bool $boolean_form = null,
        ?string $string_form = null,
        string $contentType = self::contentTypes['testFormIntegerBooleanString'][0]
    ): string
    {
        list($response) = $this->testFormIntegerBooleanStringWithHttpInfo($integer_form, $boolean_form, $string_form, $contentType);
        return $response;
    }

    /**
     * Operation testFormIntegerBooleanStringWithHttpInfo
     *
     * Test form parameter(s)
     *
     * @param  int|null $integer_form (optional)
     * @param  bool|null $boolean_form (optional)
     * @param  string|null $string_form (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testFormIntegerBooleanStringWithHttpInfo(
        ?int $integer_form = null,
        ?bool $boolean_form = null,
        ?string $string_form = null,
        string $contentType = self::contentTypes['testFormIntegerBooleanString'][0]
    ): array
    {
        $request = $this->testFormIntegerBooleanStringRequest($integer_form, $boolean_form, $string_form, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testFormIntegerBooleanStringAsync
     *
     * Test form parameter(s)
     *
     * @param  int|null $integer_form (optional)
     * @param  bool|null $boolean_form (optional)
     * @param  string|null $string_form (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testFormIntegerBooleanStringAsync(
        ?int $integer_form = null,
        ?bool $boolean_form = null,
        ?string $string_form = null,
        string $contentType = self::contentTypes['testFormIntegerBooleanString'][0]
    ): PromiseInterface
    {
        return $this->testFormIntegerBooleanStringAsyncWithHttpInfo($integer_form, $boolean_form, $string_form, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testFormIntegerBooleanStringAsyncWithHttpInfo
     *
     * Test form parameter(s)
     *
     * @param  int|null $integer_form (optional)
     * @param  bool|null $boolean_form (optional)
     * @param  string|null $string_form (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testFormIntegerBooleanStringAsyncWithHttpInfo(
        ?int $integer_form = null,
        ?bool $boolean_form = null,
        ?string $string_form = null,
        string $contentType = self::contentTypes['testFormIntegerBooleanString'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testFormIntegerBooleanStringRequest($integer_form, $boolean_form, $string_form, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testFormIntegerBooleanString'
     *
     * @param  int|null $integer_form (optional)
     * @param  bool|null $boolean_form (optional)
     * @param  string|null $string_form (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testFormIntegerBooleanStringRequest(
        ?int $integer_form = null,
        ?bool $boolean_form = null,
        ?string $string_form = null,
        string $contentType = self::contentTypes['testFormIntegerBooleanString'][0]
    ): Request
    {





        $resourcePath = '/form/integer/boolean/string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'integer_form' => $integer_form,
            'boolean_form' => $boolean_form,
            'string_form' => $string_form,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testFormObjectMultipart
     *
     * Test form parameter(s) for multipart schema
     *
     * @param  \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker marker (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormObjectMultipart'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testFormObjectMultipart(
        \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker,
        string $contentType = self::contentTypes['testFormObjectMultipart'][0]
    ): string
    {
        list($response) = $this->testFormObjectMultipartWithHttpInfo($marker, $contentType);
        return $response;
    }

    /**
     * Operation testFormObjectMultipartWithHttpInfo
     *
     * Test form parameter(s) for multipart schema
     *
     * @param  \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormObjectMultipart'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testFormObjectMultipartWithHttpInfo(
        \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker,
        string $contentType = self::contentTypes['testFormObjectMultipart'][0]
    ): array
    {
        $request = $this->testFormObjectMultipartRequest($marker, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testFormObjectMultipartAsync
     *
     * Test form parameter(s) for multipart schema
     *
     * @param  \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormObjectMultipart'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testFormObjectMultipartAsync(
        \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker,
        string $contentType = self::contentTypes['testFormObjectMultipart'][0]
    ): PromiseInterface
    {
        return $this->testFormObjectMultipartAsyncWithHttpInfo($marker, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testFormObjectMultipartAsyncWithHttpInfo
     *
     * Test form parameter(s) for multipart schema
     *
     * @param  \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormObjectMultipart'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testFormObjectMultipartAsyncWithHttpInfo(
        \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker,
        string $contentType = self::contentTypes['testFormObjectMultipart'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testFormObjectMultipartRequest($marker, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testFormObjectMultipart'
     *
     * @param  \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormObjectMultipart'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testFormObjectMultipartRequest(
        \OpenAPI\Client\Model\TestFormObjectMultipartRequestMarker $marker,
        string $contentType = self::contentTypes['testFormObjectMultipart'][0]
    ): Request
    {

        // verify the required parameter 'marker' is set
        if ($marker === null || (is_array($marker) && count($marker) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $marker when calling testFormObjectMultipart'
            );
        }


        $resourcePath = '/form/object/multipart';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'marker' => $marker,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testFormOneof
     *
     * Test form parameter(s) for oneOf schema
     *
     * @param  string|null $form1 form1 (optional)
     * @param  int|null $form2 form2 (optional)
     * @param  string|null $form3 form3 (optional)
     * @param  bool|null $form4 form4 (optional)
     * @param  int|null $id id (optional)
     * @param  string|null $name name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormOneof'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testFormOneof(
        ?string $form1 = null,
        ?int $form2 = null,
        ?string $form3 = null,
        ?bool $form4 = null,
        ?int $id = null,
        ?string $name = null,
        string $contentType = self::contentTypes['testFormOneof'][0]
    ): string
    {
        list($response) = $this->testFormOneofWithHttpInfo($form1, $form2, $form3, $form4, $id, $name, $contentType);
        return $response;
    }

    /**
     * Operation testFormOneofWithHttpInfo
     *
     * Test form parameter(s) for oneOf schema
     *
     * @param  string|null $form1 (optional)
     * @param  int|null $form2 (optional)
     * @param  string|null $form3 (optional)
     * @param  bool|null $form4 (optional)
     * @param  int|null $id (optional)
     * @param  string|null $name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormOneof'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testFormOneofWithHttpInfo(
        ?string $form1 = null,
        ?int $form2 = null,
        ?string $form3 = null,
        ?bool $form4 = null,
        ?int $id = null,
        ?string $name = null,
        string $contentType = self::contentTypes['testFormOneof'][0]
    ): array
    {
        $request = $this->testFormOneofRequest($form1, $form2, $form3, $form4, $id, $name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testFormOneofAsync
     *
     * Test form parameter(s) for oneOf schema
     *
     * @param  string|null $form1 (optional)
     * @param  int|null $form2 (optional)
     * @param  string|null $form3 (optional)
     * @param  bool|null $form4 (optional)
     * @param  int|null $id (optional)
     * @param  string|null $name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormOneof'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testFormOneofAsync(
        ?string $form1 = null,
        ?int $form2 = null,
        ?string $form3 = null,
        ?bool $form4 = null,
        ?int $id = null,
        ?string $name = null,
        string $contentType = self::contentTypes['testFormOneof'][0]
    ): PromiseInterface
    {
        return $this->testFormOneofAsyncWithHttpInfo($form1, $form2, $form3, $form4, $id, $name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testFormOneofAsyncWithHttpInfo
     *
     * Test form parameter(s) for oneOf schema
     *
     * @param  string|null $form1 (optional)
     * @param  int|null $form2 (optional)
     * @param  string|null $form3 (optional)
     * @param  bool|null $form4 (optional)
     * @param  int|null $id (optional)
     * @param  string|null $name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormOneof'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testFormOneofAsyncWithHttpInfo(
        ?string $form1 = null,
        ?int $form2 = null,
        ?string $form3 = null,
        ?bool $form4 = null,
        ?int $id = null,
        ?string $name = null,
        string $contentType = self::contentTypes['testFormOneof'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testFormOneofRequest($form1, $form2, $form3, $form4, $id, $name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testFormOneof'
     *
     * @param  string|null $form1 (optional)
     * @param  int|null $form2 (optional)
     * @param  string|null $form3 (optional)
     * @param  bool|null $form4 (optional)
     * @param  int|null $id (optional)
     * @param  string|null $name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testFormOneof'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testFormOneofRequest(
        ?string $form1 = null,
        ?int $form2 = null,
        ?string $form3 = null,
        ?bool $form4 = null,
        ?int $id = null,
        ?string $name = null,
        string $contentType = self::contentTypes['testFormOneof'][0]
    ): Request
    {








        $resourcePath = '/form/oneof';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'form1' => $form1,
            'form2' => $form2,
            'form3' => $form3,
            'form4' => $form4,
            'id' => $id,
            'name' => $name,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption(): array
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response,
    ): array {
        if (in_array($dataType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode,
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
