<?php
/**
 * QueryApi
 * PHP version 8.1
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Echo Server API
 *
 * Echo Server API
 *
 * The version of the OpenAPI document: 0.1.0
 * Contact: team@openapitools.org
 * @generated Generated by: https://openapi-generator.tech
 * Generator version: 7.20.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use InvalidArgumentException;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\ObjectSerializer;

/**
 * QueryApi Class Doc Comment
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class QueryApi
{
    /**
     * @var ClientInterface
     */
    protected ClientInterface $client;

    /**
     * @var Configuration
     */
    protected Configuration $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @var int Host index
     */
    protected int $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'testEnumRefString' => [
            'application/json',
        ],
        'testQueryDatetimeDateString' => [
            'application/json',
        ],
        'testQueryIntegerBooleanString' => [
            'application/json',
        ],
        'testQueryStyleDeepObjectExplodeTrueObject' => [
            'application/json',
        ],
        'testQueryStyleDeepObjectExplodeTrueObjectAllOf' => [
            'application/json',
        ],
        'testQueryStyleFormExplodeFalseArrayInteger' => [
            'application/json',
        ],
        'testQueryStyleFormExplodeFalseArrayString' => [
            'application/json',
        ],
        'testQueryStyleFormExplodeTrueArrayString' => [
            'application/json',
        ],
        'testQueryStyleFormExplodeTrueObject' => [
            'application/json',
        ],
        'testQueryStyleFormExplodeTrueObjectAllOf' => [
            'application/json',
        ],
        'testQueryStyleJsonSerializationObject' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface|null $client
     * @param Configuration|null   $config
     * @param HeaderSelector|null  $selector
     * @param int                  $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex(int $hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex(): int
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig(): Configuration
    {
        return $this->config;
    }

    /**
     * Operation testEnumRefString
     *
     * Test query parameter(s)
     *
     * @param  string|null $enum_nonref_string_query enum_nonref_string_query (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_query enum_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumRefString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testEnumRefString(
        ?string $enum_nonref_string_query = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_query = null,
        string $contentType = self::contentTypes['testEnumRefString'][0]
    ): string
    {
        list($response) = $this->testEnumRefStringWithHttpInfo($enum_nonref_string_query, $enum_ref_string_query, $contentType);
        return $response;
    }

    /**
     * Operation testEnumRefStringWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  string|null $enum_nonref_string_query (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumRefString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEnumRefStringWithHttpInfo(
        ?string $enum_nonref_string_query = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_query = null,
        string $contentType = self::contentTypes['testEnumRefString'][0]
    ): array
    {
        $request = $this->testEnumRefStringRequest($enum_nonref_string_query, $enum_ref_string_query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testEnumRefStringAsync
     *
     * Test query parameter(s)
     *
     * @param  string|null $enum_nonref_string_query (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumRefString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEnumRefStringAsync(
        ?string $enum_nonref_string_query = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_query = null,
        string $contentType = self::contentTypes['testEnumRefString'][0]
    ): PromiseInterface
    {
        return $this->testEnumRefStringAsyncWithHttpInfo($enum_nonref_string_query, $enum_ref_string_query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEnumRefStringAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  string|null $enum_nonref_string_query (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumRefString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testEnumRefStringAsyncWithHttpInfo(
        ?string $enum_nonref_string_query = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_query = null,
        string $contentType = self::contentTypes['testEnumRefString'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testEnumRefStringRequest($enum_nonref_string_query, $enum_ref_string_query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEnumRefString'
     *
     * @param  string|null $enum_nonref_string_query (optional)
     * @param  \OpenAPI\Client\Model\StringEnumRef|null $enum_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testEnumRefString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testEnumRefStringRequest(
        ?string $enum_nonref_string_query = null,
        ?\OpenAPI\Client\Model\StringEnumRef $enum_ref_string_query = null,
        string $contentType = self::contentTypes['testEnumRefString'][0]
    ): Request
    {




        $resourcePath = '/query/enum_ref_string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_nonref_string_query,
            'enum_nonref_string_query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $enum_ref_string_query?->value,
            'enum_ref_string_query', // param base name
            'StringEnumRef', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryDatetimeDateString
     *
     * Test query parameter(s)
     *
     * @param  \DateTime|null $datetime_query datetime_query (optional)
     * @param  \DateTime|null $date_query date_query (optional)
     * @param  string|null $string_query string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryDatetimeDateString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryDatetimeDateString(
        ?\DateTime $datetime_query = null,
        ?\DateTime $date_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryDatetimeDateString'][0]
    ): string
    {
        list($response) = $this->testQueryDatetimeDateStringWithHttpInfo($datetime_query, $date_query, $string_query, $contentType);
        return $response;
    }

    /**
     * Operation testQueryDatetimeDateStringWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \DateTime|null $datetime_query (optional)
     * @param  \DateTime|null $date_query (optional)
     * @param  string|null $string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryDatetimeDateString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryDatetimeDateStringWithHttpInfo(
        ?\DateTime $datetime_query = null,
        ?\DateTime $date_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryDatetimeDateString'][0]
    ): array
    {
        $request = $this->testQueryDatetimeDateStringRequest($datetime_query, $date_query, $string_query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryDatetimeDateStringAsync
     *
     * Test query parameter(s)
     *
     * @param  \DateTime|null $datetime_query (optional)
     * @param  \DateTime|null $date_query (optional)
     * @param  string|null $string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryDatetimeDateString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryDatetimeDateStringAsync(
        ?\DateTime $datetime_query = null,
        ?\DateTime $date_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryDatetimeDateString'][0]
    ): PromiseInterface
    {
        return $this->testQueryDatetimeDateStringAsyncWithHttpInfo($datetime_query, $date_query, $string_query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryDatetimeDateStringAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \DateTime|null $datetime_query (optional)
     * @param  \DateTime|null $date_query (optional)
     * @param  string|null $string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryDatetimeDateString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryDatetimeDateStringAsyncWithHttpInfo(
        ?\DateTime $datetime_query = null,
        ?\DateTime $date_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryDatetimeDateString'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryDatetimeDateStringRequest($datetime_query, $date_query, $string_query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryDatetimeDateString'
     *
     * @param  \DateTime|null $datetime_query (optional)
     * @param  \DateTime|null $date_query (optional)
     * @param  string|null $string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryDatetimeDateString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryDatetimeDateStringRequest(
        ?\DateTime $datetime_query = null,
        ?\DateTime $date_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryDatetimeDateString'][0]
    ): Request
    {





        $resourcePath = '/query/datetime/date/string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $datetime_query,
            'datetime_query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_query,
            'date_query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $string_query,
            'string_query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryIntegerBooleanString
     *
     * Test query parameter(s)
     *
     * @param  int|null $integer_query integer_query (optional)
     * @param  bool|null $boolean_query boolean_query (optional)
     * @param  string|null $string_query string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryIntegerBooleanString(
        ?int $integer_query = null,
        ?bool $boolean_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryIntegerBooleanString'][0]
    ): string
    {
        list($response) = $this->testQueryIntegerBooleanStringWithHttpInfo($integer_query, $boolean_query, $string_query, $contentType);
        return $response;
    }

    /**
     * Operation testQueryIntegerBooleanStringWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  int|null $integer_query (optional)
     * @param  bool|null $boolean_query (optional)
     * @param  string|null $string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryIntegerBooleanStringWithHttpInfo(
        ?int $integer_query = null,
        ?bool $boolean_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryIntegerBooleanString'][0]
    ): array
    {
        $request = $this->testQueryIntegerBooleanStringRequest($integer_query, $boolean_query, $string_query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryIntegerBooleanStringAsync
     *
     * Test query parameter(s)
     *
     * @param  int|null $integer_query (optional)
     * @param  bool|null $boolean_query (optional)
     * @param  string|null $string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryIntegerBooleanStringAsync(
        ?int $integer_query = null,
        ?bool $boolean_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryIntegerBooleanString'][0]
    ): PromiseInterface
    {
        return $this->testQueryIntegerBooleanStringAsyncWithHttpInfo($integer_query, $boolean_query, $string_query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryIntegerBooleanStringAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  int|null $integer_query (optional)
     * @param  bool|null $boolean_query (optional)
     * @param  string|null $string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryIntegerBooleanStringAsyncWithHttpInfo(
        ?int $integer_query = null,
        ?bool $boolean_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryIntegerBooleanString'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryIntegerBooleanStringRequest($integer_query, $boolean_query, $string_query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryIntegerBooleanString'
     *
     * @param  int|null $integer_query (optional)
     * @param  bool|null $boolean_query (optional)
     * @param  string|null $string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryIntegerBooleanString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryIntegerBooleanStringRequest(
        ?int $integer_query = null,
        ?bool $boolean_query = null,
        ?string $string_query = null,
        string $contentType = self::contentTypes['testQueryIntegerBooleanString'][0]
    ): Request
    {





        $resourcePath = '/query/integer/boolean/string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $integer_query,
            'integer_query', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $boolean_query,
            'boolean_query', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $string_query,
            'string_query', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryStyleDeepObjectExplodeTrueObject
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryStyleDeepObjectExplodeTrueObject(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'][0]
    ): string
    {
        list($response) = $this->testQueryStyleDeepObjectExplodeTrueObjectWithHttpInfo($query_object, $contentType);
        return $response;
    }

    /**
     * Operation testQueryStyleDeepObjectExplodeTrueObjectWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryStyleDeepObjectExplodeTrueObjectWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'][0]
    ): array
    {
        $request = $this->testQueryStyleDeepObjectExplodeTrueObjectRequest($query_object, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryStyleDeepObjectExplodeTrueObjectAsync
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleDeepObjectExplodeTrueObjectAsync(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'][0]
    ): PromiseInterface
    {
        return $this->testQueryStyleDeepObjectExplodeTrueObjectAsyncWithHttpInfo($query_object, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryStyleDeepObjectExplodeTrueObjectAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleDeepObjectExplodeTrueObjectAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryStyleDeepObjectExplodeTrueObjectRequest($query_object, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryStyleDeepObjectExplodeTrueObject'
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryStyleDeepObjectExplodeTrueObjectRequest(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObject'][0]
    ): Request
    {



        $resourcePath = '/query/style_deepObject/explode_true/object';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query_object,
            'query_object', // param base name
            'object', // openApiType
            'deepObject', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryStyleDeepObjectExplodeTrueObjectAllOf
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter|null $query_object query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryStyleDeepObjectExplodeTrueObjectAllOf(
        ?\OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'][0]
    ): string
    {
        list($response) = $this->testQueryStyleDeepObjectExplodeTrueObjectAllOfWithHttpInfo($query_object, $contentType);
        return $response;
    }

    /**
     * Operation testQueryStyleDeepObjectExplodeTrueObjectAllOfWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryStyleDeepObjectExplodeTrueObjectAllOfWithHttpInfo(
        ?\OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'][0]
    ): array
    {
        $request = $this->testQueryStyleDeepObjectExplodeTrueObjectAllOfRequest($query_object, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryStyleDeepObjectExplodeTrueObjectAllOfAsync
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleDeepObjectExplodeTrueObjectAllOfAsync(
        ?\OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'][0]
    ): PromiseInterface
    {
        return $this->testQueryStyleDeepObjectExplodeTrueObjectAllOfAsyncWithHttpInfo($query_object, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryStyleDeepObjectExplodeTrueObjectAllOfAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleDeepObjectExplodeTrueObjectAllOfAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryStyleDeepObjectExplodeTrueObjectAllOfRequest($query_object, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryStyleDeepObjectExplodeTrueObjectAllOf'
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryStyleDeepObjectExplodeTrueObjectAllOfRequest(
        ?\OpenAPI\Client\Model\TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleDeepObjectExplodeTrueObjectAllOf'][0]
    ): Request
    {



        $resourcePath = '/query/style_deepObject/explode_true/object/allOf';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query_object,
            'query_object', // param base name
            '\OpenAPIClientModelBirdOpenAPIClientModelCategory', // openApiType
            'deepObject', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryStyleFormExplodeFalseArrayInteger
     *
     * Test query parameter(s)
     *
     * @param  int[]|null $query_object query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryStyleFormExplodeFalseArrayInteger(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'][0]
    ): string
    {
        list($response) = $this->testQueryStyleFormExplodeFalseArrayIntegerWithHttpInfo($query_object, $contentType);
        return $response;
    }

    /**
     * Operation testQueryStyleFormExplodeFalseArrayIntegerWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  int[]|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryStyleFormExplodeFalseArrayIntegerWithHttpInfo(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'][0]
    ): array
    {
        $request = $this->testQueryStyleFormExplodeFalseArrayIntegerRequest($query_object, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryStyleFormExplodeFalseArrayIntegerAsync
     *
     * Test query parameter(s)
     *
     * @param  int[]|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeFalseArrayIntegerAsync(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'][0]
    ): PromiseInterface
    {
        return $this->testQueryStyleFormExplodeFalseArrayIntegerAsyncWithHttpInfo($query_object, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryStyleFormExplodeFalseArrayIntegerAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  int[]|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeFalseArrayIntegerAsyncWithHttpInfo(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryStyleFormExplodeFalseArrayIntegerRequest($query_object, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryStyleFormExplodeFalseArrayInteger'
     *
     * @param  int[]|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryStyleFormExplodeFalseArrayIntegerRequest(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayInteger'][0]
    ): Request
    {



        $resourcePath = '/query/style_form/explode_false/array_integer';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query_object,
            'query_object', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryStyleFormExplodeFalseArrayString
     *
     * Test query parameter(s)
     *
     * @param  string[]|null $query_object query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryStyleFormExplodeFalseArrayString(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayString'][0]
    ): string
    {
        list($response) = $this->testQueryStyleFormExplodeFalseArrayStringWithHttpInfo($query_object, $contentType);
        return $response;
    }

    /**
     * Operation testQueryStyleFormExplodeFalseArrayStringWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  string[]|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryStyleFormExplodeFalseArrayStringWithHttpInfo(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayString'][0]
    ): array
    {
        $request = $this->testQueryStyleFormExplodeFalseArrayStringRequest($query_object, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryStyleFormExplodeFalseArrayStringAsync
     *
     * Test query parameter(s)
     *
     * @param  string[]|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeFalseArrayStringAsync(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayString'][0]
    ): PromiseInterface
    {
        return $this->testQueryStyleFormExplodeFalseArrayStringAsyncWithHttpInfo($query_object, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryStyleFormExplodeFalseArrayStringAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  string[]|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeFalseArrayStringAsyncWithHttpInfo(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayString'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryStyleFormExplodeFalseArrayStringRequest($query_object, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryStyleFormExplodeFalseArrayString'
     *
     * @param  string[]|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeFalseArrayString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryStyleFormExplodeFalseArrayStringRequest(
        ?array $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeFalseArrayString'][0]
    ): Request
    {



        $resourcePath = '/query/style_form/explode_false/array_string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query_object,
            'query_object', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryStyleFormExplodeTrueArrayString
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter|null $query_object query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueArrayString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryStyleFormExplodeTrueArrayString(
        ?\OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueArrayString'][0]
    ): string
    {
        list($response) = $this->testQueryStyleFormExplodeTrueArrayStringWithHttpInfo($query_object, $contentType);
        return $response;
    }

    /**
     * Operation testQueryStyleFormExplodeTrueArrayStringWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueArrayString'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryStyleFormExplodeTrueArrayStringWithHttpInfo(
        ?\OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueArrayString'][0]
    ): array
    {
        $request = $this->testQueryStyleFormExplodeTrueArrayStringRequest($query_object, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryStyleFormExplodeTrueArrayStringAsync
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueArrayString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeTrueArrayStringAsync(
        ?\OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueArrayString'][0]
    ): PromiseInterface
    {
        return $this->testQueryStyleFormExplodeTrueArrayStringAsyncWithHttpInfo($query_object, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryStyleFormExplodeTrueArrayStringAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueArrayString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeTrueArrayStringAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueArrayString'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryStyleFormExplodeTrueArrayStringRequest($query_object, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryStyleFormExplodeTrueArrayString'
     *
     * @param  \OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueArrayString'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryStyleFormExplodeTrueArrayStringRequest(
        ?\OpenAPI\Client\Model\TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueArrayString'][0]
    ): Request
    {



        $resourcePath = '/query/style_form/explode_true/array_string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query_object,
            'query_object', // param base name
            'object', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryStyleFormExplodeTrueObject
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryStyleFormExplodeTrueObject(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObject'][0]
    ): string
    {
        list($response) = $this->testQueryStyleFormExplodeTrueObjectWithHttpInfo($query_object, $contentType);
        return $response;
    }

    /**
     * Operation testQueryStyleFormExplodeTrueObjectWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryStyleFormExplodeTrueObjectWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObject'][0]
    ): array
    {
        $request = $this->testQueryStyleFormExplodeTrueObjectRequest($query_object, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryStyleFormExplodeTrueObjectAsync
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeTrueObjectAsync(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObject'][0]
    ): PromiseInterface
    {
        return $this->testQueryStyleFormExplodeTrueObjectAsyncWithHttpInfo($query_object, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryStyleFormExplodeTrueObjectAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeTrueObjectAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObject'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryStyleFormExplodeTrueObjectRequest($query_object, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryStyleFormExplodeTrueObject'
     *
     * @param  \OpenAPI\Client\Model\Pet|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObject'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryStyleFormExplodeTrueObjectRequest(
        ?\OpenAPI\Client\Model\Pet $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObject'][0]
    ): Request
    {



        $resourcePath = '/query/style_form/explode_true/object';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query_object,
            'query_object', // param base name
            'object', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryStyleFormExplodeTrueObjectAllOf
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\DataQuery|null $query_object query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryStyleFormExplodeTrueObjectAllOf(
        ?\OpenAPI\Client\Model\DataQuery $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'][0]
    ): string
    {
        list($response) = $this->testQueryStyleFormExplodeTrueObjectAllOfWithHttpInfo($query_object, $contentType);
        return $response;
    }

    /**
     * Operation testQueryStyleFormExplodeTrueObjectAllOfWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\DataQuery|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryStyleFormExplodeTrueObjectAllOfWithHttpInfo(
        ?\OpenAPI\Client\Model\DataQuery $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'][0]
    ): array
    {
        $request = $this->testQueryStyleFormExplodeTrueObjectAllOfRequest($query_object, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryStyleFormExplodeTrueObjectAllOfAsync
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\DataQuery|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeTrueObjectAllOfAsync(
        ?\OpenAPI\Client\Model\DataQuery $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'][0]
    ): PromiseInterface
    {
        return $this->testQueryStyleFormExplodeTrueObjectAllOfAsyncWithHttpInfo($query_object, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryStyleFormExplodeTrueObjectAllOfAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\DataQuery|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleFormExplodeTrueObjectAllOfAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\DataQuery $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryStyleFormExplodeTrueObjectAllOfRequest($query_object, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryStyleFormExplodeTrueObjectAllOf'
     *
     * @param  \OpenAPI\Client\Model\DataQuery|null $query_object (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryStyleFormExplodeTrueObjectAllOfRequest(
        ?\OpenAPI\Client\Model\DataQuery $query_object = null,
        string $contentType = self::contentTypes['testQueryStyleFormExplodeTrueObjectAllOf'][0]
    ): Request
    {



        $resourcePath = '/query/style_form/explode_true/object/allOf';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $query_object,
            'query_object', // param base name
            'ObjectOpenAPIClientModelQuery', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation testQueryStyleJsonSerializationObject
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $json_serialized_object_ref_string_query json_serialized_object_ref_string_query (optional)
     * @param  \OpenAPI\Client\Model\Pet[]|null $json_serialized_object_array_ref_string_query json_serialized_object_array_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleJsonSerializationObject'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return string
     */
    public function testQueryStyleJsonSerializationObject(
        ?\OpenAPI\Client\Model\Pet $json_serialized_object_ref_string_query = null,
        ?array $json_serialized_object_array_ref_string_query = null,
        string $contentType = self::contentTypes['testQueryStyleJsonSerializationObject'][0]
    ): string
    {
        list($response) = $this->testQueryStyleJsonSerializationObjectWithHttpInfo($json_serialized_object_ref_string_query, $json_serialized_object_array_ref_string_query, $contentType);
        return $response;
    }

    /**
     * Operation testQueryStyleJsonSerializationObjectWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $json_serialized_object_ref_string_query (optional)
     * @param  \OpenAPI\Client\Model\Pet[]|null $json_serialized_object_array_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleJsonSerializationObject'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryStyleJsonSerializationObjectWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $json_serialized_object_ref_string_query = null,
        ?array $json_serialized_object_array_ref_string_query = null,
        string $contentType = self::contentTypes['testQueryStyleJsonSerializationObject'][0]
    ): array
    {
        $request = $this->testQueryStyleJsonSerializationObjectRequest($json_serialized_object_ref_string_query, $json_serialized_object_array_ref_string_query, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation testQueryStyleJsonSerializationObjectAsync
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $json_serialized_object_ref_string_query (optional)
     * @param  \OpenAPI\Client\Model\Pet[]|null $json_serialized_object_array_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleJsonSerializationObject'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleJsonSerializationObjectAsync(
        ?\OpenAPI\Client\Model\Pet $json_serialized_object_ref_string_query = null,
        ?array $json_serialized_object_array_ref_string_query = null,
        string $contentType = self::contentTypes['testQueryStyleJsonSerializationObject'][0]
    ): PromiseInterface
    {
        return $this->testQueryStyleJsonSerializationObjectAsyncWithHttpInfo($json_serialized_object_ref_string_query, $json_serialized_object_array_ref_string_query, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryStyleJsonSerializationObjectAsyncWithHttpInfo
     *
     * Test query parameter(s)
     *
     * @param  \OpenAPI\Client\Model\Pet|null $json_serialized_object_ref_string_query (optional)
     * @param  \OpenAPI\Client\Model\Pet[]|null $json_serialized_object_array_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleJsonSerializationObject'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function testQueryStyleJsonSerializationObjectAsyncWithHttpInfo(
        ?\OpenAPI\Client\Model\Pet $json_serialized_object_ref_string_query = null,
        ?array $json_serialized_object_array_ref_string_query = null,
        string $contentType = self::contentTypes['testQueryStyleJsonSerializationObject'][0]
    ): PromiseInterface
    {
        $returnType = 'string';
        $request = $this->testQueryStyleJsonSerializationObjectRequest($json_serialized_object_ref_string_query, $json_serialized_object_array_ref_string_query, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryStyleJsonSerializationObject'
     *
     * @param  \OpenAPI\Client\Model\Pet|null $json_serialized_object_ref_string_query (optional)
     * @param  \OpenAPI\Client\Model\Pet[]|null $json_serialized_object_array_ref_string_query (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['testQueryStyleJsonSerializationObject'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function testQueryStyleJsonSerializationObjectRequest(
        ?\OpenAPI\Client\Model\Pet $json_serialized_object_ref_string_query = null,
        ?array $json_serialized_object_array_ref_string_query = null,
        string $contentType = self::contentTypes['testQueryStyleJsonSerializationObject'][0]
    ): Request
    {




        $resourcePath = '/query/style_jsonSerialization/object';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $json_serialized_object_ref_string_query,
            'json_serialized_object_ref_string_query', // param base name
            '', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $json_serialized_object_array_ref_string_query,
            'json_serialized_object_array_ref_string_query', // param base name
            '', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['text/plain', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption(): array
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response,
    ): array {
        if (in_array($dataType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode,
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
