#' Echo Server API
#'
#' Echo Server API
#'
#' The version of the OpenAPI document: 0.1.0
#' Contact: team@openapitools.org
#' Generated by: https://openapi-generator.tech
#'
#' @docType class
#' @title Query operations
#' @description QueryApi
#' @format An \code{R6Class} generator object
#' @field api_client Handles the client-server communication.
#'
#' @examples
#' \dontrun{
#' ####################  TestEnumRefString  ####################
#'
#' library(openapi)
#' var_enum_nonref_string_query <- "enum_nonref_string_query_example" # character |  (Optional)
#' var_enum_ref_string_query <- StringEnumRef$new() # StringEnumRef |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestEnumRefString(enum_nonref_string_query = var_enum_nonref_string_query, enum_ref_string_query = var_enum_ref_string_querydata_file = "result.txt")
#' result <- api_instance$TestEnumRefString(enum_nonref_string_query = var_enum_nonref_string_query, enum_ref_string_query = var_enum_ref_string_query)
#' dput(result)
#'
#'
#' ####################  TestQueryDatetimeDateString  ####################
#'
#' library(openapi)
#' var_datetime_query <- "datetime_query_example" # character |  (Optional)
#' var_date_query <- "date_query_example" # character |  (Optional)
#' var_string_query <- "string_query_example" # character |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryDatetimeDateString(datetime_query = var_datetime_query, date_query = var_date_query, string_query = var_string_querydata_file = "result.txt")
#' result <- api_instance$TestQueryDatetimeDateString(datetime_query = var_datetime_query, date_query = var_date_query, string_query = var_string_query)
#' dput(result)
#'
#'
#' ####################  TestQueryIntegerBooleanString  ####################
#'
#' library(openapi)
#' var_integer_query <- 56 # integer |  (Optional)
#' var_boolean_query <- "boolean_query_example" # character |  (Optional)
#' var_string_query <- "string_query_example" # character |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryIntegerBooleanString(integer_query = var_integer_query, boolean_query = var_boolean_query, string_query = var_string_querydata_file = "result.txt")
#' result <- api_instance$TestQueryIntegerBooleanString(integer_query = var_integer_query, boolean_query = var_boolean_query, string_query = var_string_query)
#' dput(result)
#'
#'
#' ####################  TestQueryStyleDeepObjectExplodeTrueObject  ####################
#'
#' library(openapi)
#' var_query_object <- Pet$new("name_example", c("photoUrls_example"), 123, Category$new(123, "name_example"), c(Tag$new(123, "name_example")), "available") # Pet |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryStyleDeepObjectExplodeTrueObject(query_object = var_query_objectdata_file = "result.txt")
#' result <- api_instance$TestQueryStyleDeepObjectExplodeTrueObject(query_object = var_query_object)
#' dput(result)
#'
#'
#' ####################  TestQueryStyleDeepObjectExplodeTrueObjectAllOf  ####################
#'
#' library(openapi)
#' var_query_object <- test_query_style_deepObject_explode_true_object_allOf_query_object_parameter$new("size_example", "color_example", 123, "name_example") # TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryStyleDeepObjectExplodeTrueObjectAllOf(query_object = var_query_objectdata_file = "result.txt")
#' result <- api_instance$TestQueryStyleDeepObjectExplodeTrueObjectAllOf(query_object = var_query_object)
#' dput(result)
#'
#'
#' ####################  TestQueryStyleFormExplodeFalseArrayInteger  ####################
#'
#' library(openapi)
#' var_query_object <- c(123) # array[integer] |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryStyleFormExplodeFalseArrayInteger(query_object = var_query_objectdata_file = "result.txt")
#' result <- api_instance$TestQueryStyleFormExplodeFalseArrayInteger(query_object = var_query_object)
#' dput(result)
#'
#'
#' ####################  TestQueryStyleFormExplodeFalseArrayString  ####################
#'
#' library(openapi)
#' var_query_object <- c("inner_example") # array[character] |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryStyleFormExplodeFalseArrayString(query_object = var_query_objectdata_file = "result.txt")
#' result <- api_instance$TestQueryStyleFormExplodeFalseArrayString(query_object = var_query_object)
#' dput(result)
#'
#'
#' ####################  TestQueryStyleFormExplodeTrueArrayString  ####################
#'
#' library(openapi)
#' var_query_object <- test_query_style_form_explode_true_array_string_query_object_parameter$new(c("values_example")) # TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryStyleFormExplodeTrueArrayString(query_object = var_query_objectdata_file = "result.txt")
#' result <- api_instance$TestQueryStyleFormExplodeTrueArrayString(query_object = var_query_object)
#' dput(result)
#'
#'
#' ####################  TestQueryStyleFormExplodeTrueObject  ####################
#'
#' library(openapi)
#' var_query_object <- Pet$new("name_example", c("photoUrls_example"), 123, Category$new(123, "name_example"), c(Tag$new(123, "name_example")), "available") # Pet |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryStyleFormExplodeTrueObject(query_object = var_query_objectdata_file = "result.txt")
#' result <- api_instance$TestQueryStyleFormExplodeTrueObject(query_object = var_query_object)
#' dput(result)
#'
#'
#' ####################  TestQueryStyleFormExplodeTrueObjectAllOf  ####################
#'
#' library(openapi)
#' var_query_object <- DataQuery$new(123, c("SUCCESS"), "suffix_example", "text_example", "date_example") # DataQuery |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryStyleFormExplodeTrueObjectAllOf(query_object = var_query_objectdata_file = "result.txt")
#' result <- api_instance$TestQueryStyleFormExplodeTrueObjectAllOf(query_object = var_query_object)
#' dput(result)
#'
#'
#' ####################  TestQueryStyleJsonSerializationObject  ####################
#'
#' library(openapi)
#' var_json_serialized_object_ref_string_query <- Pet$new("name_example", c("photoUrls_example"), 123, Category$new(123, "name_example"), c(Tag$new(123, "name_example")), "available") # Pet |  (Optional)
#' var_json_serialized_object_array_ref_string_query <- c(Pet$new("name_example", c("photoUrls_example"), 123, Category$new(123, "name_example"), c(Tag$new(123, "name_example")), "available")) # array[Pet] |  (Optional)
#'
#' #Test query parameter(s)
#' api_instance <- QueryApi$new()
#'
#' # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#' # result <- api_instance$TestQueryStyleJsonSerializationObject(json_serialized_object_ref_string_query = var_json_serialized_object_ref_string_query, json_serialized_object_array_ref_string_query = var_json_serialized_object_array_ref_string_querydata_file = "result.txt")
#' result <- api_instance$TestQueryStyleJsonSerializationObject(json_serialized_object_ref_string_query = var_json_serialized_object_ref_string_query, json_serialized_object_array_ref_string_query = var_json_serialized_object_array_ref_string_query)
#' dput(result)
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @export
QueryApi <- R6::R6Class(
  "QueryApi",
  public = list(
    api_client = NULL,

    #' @description
    #' Initialize a new QueryApi.
    #'
    #' @param api_client An instance of API client.
    initialize = function(api_client) {
      if (!missing(api_client)) {
        self$api_client <- api_client
      } else {
        self$api_client <- ApiClient$new()
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param enum_nonref_string_query (optional) No description
    #' @param enum_ref_string_query (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestEnumRefString = function(enum_nonref_string_query = NULL, enum_ref_string_query = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestEnumRefStringWithHttpInfo(enum_nonref_string_query, enum_ref_string_query, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param enum_nonref_string_query (optional) No description
    #' @param enum_ref_string_query (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestEnumRefStringWithHttpInfo = function(enum_nonref_string_query = NULL, enum_ref_string_query = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`enum_nonref_string_query`) && is.null(`enum_nonref_string_query`)) {
        stop("Invalid value for `enum_nonref_string_query` when calling QueryApi$TestEnumRefString, `enum_nonref_string_query` is not nullable")
      }

      if (!missing(`enum_ref_string_query`) && is.null(`enum_ref_string_query`)) {
        stop("Invalid value for `enum_ref_string_query` when calling QueryApi$TestEnumRefString, `enum_ref_string_query` is not nullable")
      }

      if (!is.null(`enum_nonref_string_query`) && !(`enum_nonref_string_query` %in% c("success", "failure", "unclassified"))) {
        stop("Invalid value for enum_nonref_string_query when calling QueryApi$TestEnumRefString. Must be [success, failure, unclassified].")
      }
      query_params[["enum_nonref_string_query"]] <- `enum_nonref_string_query`

      query_params[["enum_ref_string_query"]] <- `enum_ref_string_query`

      local_var_url_path <- "/query/enum_ref_string"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param datetime_query (optional) No description
    #' @param date_query (optional) No description
    #' @param string_query (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryDatetimeDateString = function(datetime_query = NULL, date_query = NULL, string_query = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryDatetimeDateStringWithHttpInfo(datetime_query, date_query, string_query, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param datetime_query (optional) No description
    #' @param date_query (optional) No description
    #' @param string_query (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryDatetimeDateStringWithHttpInfo = function(datetime_query = NULL, date_query = NULL, string_query = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`datetime_query`) && is.null(`datetime_query`)) {
        stop("Invalid value for `datetime_query` when calling QueryApi$TestQueryDatetimeDateString, `datetime_query` is not nullable")
      }

      if (!missing(`date_query`) && is.null(`date_query`)) {
        stop("Invalid value for `date_query` when calling QueryApi$TestQueryDatetimeDateString, `date_query` is not nullable")
      }

      if (!missing(`string_query`) && is.null(`string_query`)) {
        stop("Invalid value for `string_query` when calling QueryApi$TestQueryDatetimeDateString, `string_query` is not nullable")
      }

      query_params[["datetime_query"]] <- `datetime_query`

      query_params[["date_query"]] <- `date_query`

      query_params[["string_query"]] <- `string_query`

      local_var_url_path <- "/query/datetime/date/string"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param integer_query (optional) No description
    #' @param boolean_query (optional) No description
    #' @param string_query (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryIntegerBooleanString = function(integer_query = NULL, boolean_query = NULL, string_query = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryIntegerBooleanStringWithHttpInfo(integer_query, boolean_query, string_query, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param integer_query (optional) No description
    #' @param boolean_query (optional) No description
    #' @param string_query (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryIntegerBooleanStringWithHttpInfo = function(integer_query = NULL, boolean_query = NULL, string_query = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`integer_query`) && is.null(`integer_query`)) {
        stop("Invalid value for `integer_query` when calling QueryApi$TestQueryIntegerBooleanString, `integer_query` is not nullable")
      }

      if (!missing(`boolean_query`) && is.null(`boolean_query`)) {
        stop("Invalid value for `boolean_query` when calling QueryApi$TestQueryIntegerBooleanString, `boolean_query` is not nullable")
      }

      if (!missing(`string_query`) && is.null(`string_query`)) {
        stop("Invalid value for `string_query` when calling QueryApi$TestQueryIntegerBooleanString, `string_query` is not nullable")
      }

      query_params[["integer_query"]] <- `integer_query`

      query_params[["boolean_query"]] <- `boolean_query`

      query_params[["string_query"]] <- `string_query`

      local_var_url_path <- "/query/integer/boolean/string"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryStyleDeepObjectExplodeTrueObject = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryStyleDeepObjectExplodeTrueObjectWithHttpInfo(query_object, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryStyleDeepObjectExplodeTrueObjectWithHttpInfo = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`query_object`) && is.null(`query_object`)) {
        stop("Invalid value for `query_object` when calling QueryApi$TestQueryStyleDeepObjectExplodeTrueObject, `query_object` is not nullable")
      }

      query_params[["query_object"]] <- `query_object`

      local_var_url_path <- "/query/style_deepObject/explode_true/object"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryStyleDeepObjectExplodeTrueObjectAllOf = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryStyleDeepObjectExplodeTrueObjectAllOfWithHttpInfo(query_object, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryStyleDeepObjectExplodeTrueObjectAllOfWithHttpInfo = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`query_object`) && is.null(`query_object`)) {
        stop("Invalid value for `query_object` when calling QueryApi$TestQueryStyleDeepObjectExplodeTrueObjectAllOf, `query_object` is not nullable")
      }

      query_params[["query_object"]] <- `query_object`

      local_var_url_path <- "/query/style_deepObject/explode_true/object/allOf"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryStyleFormExplodeFalseArrayInteger = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryStyleFormExplodeFalseArrayIntegerWithHttpInfo(query_object, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryStyleFormExplodeFalseArrayIntegerWithHttpInfo = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`query_object`) && is.null(`query_object`)) {
        stop("Invalid value for `query_object` when calling QueryApi$TestQueryStyleFormExplodeFalseArrayInteger, `query_object` is not nullable")
      }

      # no explore
      query_params[["query_object"]] <- I(paste(lapply(`query_object`, URLencode, reserved = TRUE), collapse = ","))

      local_var_url_path <- "/query/style_form/explode_false/array_integer"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryStyleFormExplodeFalseArrayString = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryStyleFormExplodeFalseArrayStringWithHttpInfo(query_object, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryStyleFormExplodeFalseArrayStringWithHttpInfo = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`query_object`) && is.null(`query_object`)) {
        stop("Invalid value for `query_object` when calling QueryApi$TestQueryStyleFormExplodeFalseArrayString, `query_object` is not nullable")
      }

      # no explore
      query_params[["query_object"]] <- I(paste(lapply(`query_object`, URLencode, reserved = TRUE), collapse = ","))

      local_var_url_path <- "/query/style_form/explode_false/array_string"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryStyleFormExplodeTrueArrayString = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryStyleFormExplodeTrueArrayStringWithHttpInfo(query_object, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryStyleFormExplodeTrueArrayStringWithHttpInfo = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`query_object`) && is.null(`query_object`)) {
        stop("Invalid value for `query_object` when calling QueryApi$TestQueryStyleFormExplodeTrueArrayString, `query_object` is not nullable")
      }

      query_params[["query_object"]] <- `query_object`

      local_var_url_path <- "/query/style_form/explode_true/array_string"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryStyleFormExplodeTrueObject = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryStyleFormExplodeTrueObjectWithHttpInfo(query_object, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryStyleFormExplodeTrueObjectWithHttpInfo = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`query_object`) && is.null(`query_object`)) {
        stop("Invalid value for `query_object` when calling QueryApi$TestQueryStyleFormExplodeTrueObject, `query_object` is not nullable")
      }

      query_params[["query_object"]] <- `query_object`

      local_var_url_path <- "/query/style_form/explode_true/object"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryStyleFormExplodeTrueObjectAllOf = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryStyleFormExplodeTrueObjectAllOfWithHttpInfo(query_object, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param query_object (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryStyleFormExplodeTrueObjectAllOfWithHttpInfo = function(query_object = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`query_object`) && is.null(`query_object`)) {
        stop("Invalid value for `query_object` when calling QueryApi$TestQueryStyleFormExplodeTrueObjectAllOf, `query_object` is not nullable")
      }

      query_params[["query_object"]] <- `query_object`

      local_var_url_path <- "/query/style_form/explode_true/object/allOf"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param json_serialized_object_ref_string_query (optional) No description
    #' @param json_serialized_object_array_ref_string_query (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    TestQueryStyleJsonSerializationObject = function(json_serialized_object_ref_string_query = NULL, json_serialized_object_array_ref_string_query = NULL, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$TestQueryStyleJsonSerializationObjectWithHttpInfo(json_serialized_object_ref_string_query, json_serialized_object_array_ref_string_query, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Test query parameter(s)
    #'
    #' @param json_serialized_object_ref_string_query (optional) No description
    #' @param json_serialized_object_array_ref_string_query (optional) No description
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    TestQueryStyleJsonSerializationObjectWithHttpInfo = function(json_serialized_object_ref_string_query = NULL, json_serialized_object_array_ref_string_query = NULL, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (!missing(`json_serialized_object_ref_string_query`) && is.null(`json_serialized_object_ref_string_query`)) {
        stop("Invalid value for `json_serialized_object_ref_string_query` when calling QueryApi$TestQueryStyleJsonSerializationObject, `json_serialized_object_ref_string_query` is not nullable")
      }

      if (!missing(`json_serialized_object_array_ref_string_query`) && is.null(`json_serialized_object_array_ref_string_query`)) {
        stop("Invalid value for `json_serialized_object_array_ref_string_query` when calling QueryApi$TestQueryStyleJsonSerializationObject, `json_serialized_object_array_ref_string_query` is not nullable")
      }

      query_params[["json_serialized_object_ref_string_query"]] <- `json_serialized_object_ref_string_query`

      # no explore
      query_params[["json_serialized_object_array_ref_string_query"]] <- I(paste(lapply(`json_serialized_object_array_ref_string_query`, URLencode, reserved = TRUE), collapse = ","))

      local_var_url_path <- "/query/style_jsonSerialization/object"

      # The Accept request HTTP header
      local_var_accepts <- list("text/plain")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            stop("Failed to deserialize response")
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        ApiResponse$new(content = paste("Server returned ", local_var_resp$status_code, " response status code."),
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        ApiResponse$new(content = "API client error",
                        response = local_var_resp,
                        status_code = local_var_resp$status_code)
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (is.null(local_var_resp$response) || all(local_var_resp$response == "")) {
          local_var_resp$response <- "API server error"
        }
        return(local_var_resp)
      }
    }
  )
)
