# R API client for openapi

Echo Server API

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project. By using the [OpenAPI spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 0.1.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.RClientCodegen

## Installation

### Prerequisites

Install the dependencies

```R
install.packages("jsonlite")
install.packages("httr")
install.packages("base64enc")
```

### Build the package

```sh
git clone https://github.com/GIT_USER_ID/GIT_REPO_ID
cd GIT_REPO_ID
R CMD build .
R CMD check openapi_1.0.0.tar.gz --no-manual
R CMD INSTALL --preclean openapi_1.0.0.tar.gz
```

### Install the package

```R
install.packages("openapi")
```

To install directly from Github, use `devtools`:
```R
install.packages("devtools")
library(devtools)
install_github("GIT_USER_ID/GIT_REPO_ID")
```

To install the package from a local file:
```R
install.packages("openapi_1.0.0.tar.gz", repos = NULL, type = "source")
```

### Usage

```R
library(openapi)
```

### Reformat code

To reformat code using [styler](https://styler.r-lib.org/index.html), please run the following in the R console:

```R
install.packages("remotes")
remotes::install_github("r-lib/styler@v1.7.0.9003")
library("styler")
style_dir()
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:3000*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**TestAuthHttpBasic**](docs/AuthApi.md#TestAuthHttpBasic) | **POST** /auth/http/basic | To test HTTP basic authentication
*AuthApi* | [**TestAuthHttpBearer**](docs/AuthApi.md#TestAuthHttpBearer) | **POST** /auth/http/bearer | To test HTTP bearer authentication
*BodyApi* | [**TestBinaryGif**](docs/BodyApi.md#TestBinaryGif) | **POST** /binary/gif | Test binary (gif) response body
*BodyApi* | [**TestBodyApplicationOctetstreamBinary**](docs/BodyApi.md#TestBodyApplicationOctetstreamBinary) | **POST** /body/application/octetstream/binary | Test body parameter(s)
*BodyApi* | [**TestBodyMultipartFormdataArrayOfBinary**](docs/BodyApi.md#TestBodyMultipartFormdataArrayOfBinary) | **POST** /body/application/octetstream/array_of_binary | Test array of binary in multipart mime
*BodyApi* | [**TestBodyMultipartFormdataSingleBinary**](docs/BodyApi.md#TestBodyMultipartFormdataSingleBinary) | **POST** /body/application/octetstream/single_binary | Test single binary in multipart mime
*BodyApi* | [**TestEchoBodyAllOfPet**](docs/BodyApi.md#TestEchoBodyAllOfPet) | **POST** /echo/body/allOf/Pet | Test body parameter(s)
*BodyApi* | [**TestEchoBodyFreeFormObjectResponseString**](docs/BodyApi.md#TestEchoBodyFreeFormObjectResponseString) | **POST** /echo/body/FreeFormObject/response_string | Test free form object
*BodyApi* | [**TestEchoBodyPet**](docs/BodyApi.md#TestEchoBodyPet) | **POST** /echo/body/Pet | Test body parameter(s)
*BodyApi* | [**TestEchoBodyPetResponseString**](docs/BodyApi.md#TestEchoBodyPetResponseString) | **POST** /echo/body/Pet/response_string | Test empty response body
*BodyApi* | [**TestEchoBodyStringEnum**](docs/BodyApi.md#TestEchoBodyStringEnum) | **POST** /echo/body/string_enum | Test string enum response body
*BodyApi* | [**TestEchoBodyTagResponseString**](docs/BodyApi.md#TestEchoBodyTagResponseString) | **POST** /echo/body/Tag/response_string | Test empty json (request body)
*FormApi* | [**TestFormIntegerBooleanString**](docs/FormApi.md#TestFormIntegerBooleanString) | **POST** /form/integer/boolean/string | Test form parameter(s)
*FormApi* | [**TestFormObjectMultipart**](docs/FormApi.md#TestFormObjectMultipart) | **POST** /form/object/multipart | Test form parameter(s) for multipart schema
*FormApi* | [**TestFormOneof**](docs/FormApi.md#TestFormOneof) | **POST** /form/oneof | Test form parameter(s) for oneOf schema
*HeaderApi* | [**TestHeaderIntegerBooleanStringEnums**](docs/HeaderApi.md#TestHeaderIntegerBooleanStringEnums) | **GET** /header/integer/boolean/string/enums | Test header parameter(s)
*PathApi* | [**TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath**](docs/PathApi.md#TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath) | **GET** /path/string/{path_string}/integer/{path_integer}/{enum_nonref_string_path}/{enum_ref_string_path} | Test path parameter(s)
*QueryApi* | [**TestEnumRefString**](docs/QueryApi.md#TestEnumRefString) | **GET** /query/enum_ref_string | Test query parameter(s)
*QueryApi* | [**TestQueryDatetimeDateString**](docs/QueryApi.md#TestQueryDatetimeDateString) | **GET** /query/datetime/date/string | Test query parameter(s)
*QueryApi* | [**TestQueryIntegerBooleanString**](docs/QueryApi.md#TestQueryIntegerBooleanString) | **GET** /query/integer/boolean/string | Test query parameter(s)
*QueryApi* | [**TestQueryStyleDeepObjectExplodeTrueObject**](docs/QueryApi.md#TestQueryStyleDeepObjectExplodeTrueObject) | **GET** /query/style_deepObject/explode_true/object | Test query parameter(s)
*QueryApi* | [**TestQueryStyleDeepObjectExplodeTrueObjectAllOf**](docs/QueryApi.md#TestQueryStyleDeepObjectExplodeTrueObjectAllOf) | **GET** /query/style_deepObject/explode_true/object/allOf | Test query parameter(s)
*QueryApi* | [**TestQueryStyleFormExplodeFalseArrayInteger**](docs/QueryApi.md#TestQueryStyleFormExplodeFalseArrayInteger) | **GET** /query/style_form/explode_false/array_integer | Test query parameter(s)
*QueryApi* | [**TestQueryStyleFormExplodeFalseArrayString**](docs/QueryApi.md#TestQueryStyleFormExplodeFalseArrayString) | **GET** /query/style_form/explode_false/array_string | Test query parameter(s)
*QueryApi* | [**TestQueryStyleFormExplodeTrueArrayString**](docs/QueryApi.md#TestQueryStyleFormExplodeTrueArrayString) | **GET** /query/style_form/explode_true/array_string | Test query parameter(s)
*QueryApi* | [**TestQueryStyleFormExplodeTrueObject**](docs/QueryApi.md#TestQueryStyleFormExplodeTrueObject) | **GET** /query/style_form/explode_true/object | Test query parameter(s)
*QueryApi* | [**TestQueryStyleFormExplodeTrueObjectAllOf**](docs/QueryApi.md#TestQueryStyleFormExplodeTrueObjectAllOf) | **GET** /query/style_form/explode_true/object/allOf | Test query parameter(s)
*QueryApi* | [**TestQueryStyleJsonSerializationObject**](docs/QueryApi.md#TestQueryStyleJsonSerializationObject) | **GET** /query/style_jsonSerialization/object | Test query parameter(s)


## Documentation for Models

 - [Bird](docs/Bird.md)
 - [Category](docs/Category.md)
 - [DataQuery](docs/DataQuery.md)
 - [DefaultValue](docs/DefaultValue.md)
 - [NumberPropertiesOnly](docs/NumberPropertiesOnly.md)
 - [Pet](docs/Pet.md)
 - [Query](docs/Query.md)
 - [StringEnumRef](docs/StringEnumRef.md)
 - [Tag](docs/Tag.md)
 - [TestFormObjectMultipartRequestMarker](docs/TestFormObjectMultipartRequestMarker.md)
 - [TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter](docs/TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter.md)
 - [TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter](docs/TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter.md)


## Documentation for Authorization


Authentication schemes defined for the API:
### http_auth

- **Type**: HTTP basic authentication

### http_bearer_auth

- **Type**: Bearer authentication


## Author

team@openapitools.org
