# java-resttemplate-list-schema-validation

issue-17485

- API version: 0.1.0

- Generator version: 7.20.0-SNAPSHOT

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*

## Requirements

Building the API client library requires:

1. Java 1.8+
2. Maven/Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapitools</groupId>
  <artifactId>java-resttemplate-list-schema-validation</artifactId>
  <version>0.1.0</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
  repositories {
    mavenCentral()     // Needed if the 'java-resttemplate-list-schema-validation' jar has been published to maven central.
    mavenLocal()       // Needed if the 'java-resttemplate-list-schema-validation' jar has been published to the local maven repo.
  }

  dependencies {
     implementation "org.openapitools:java-resttemplate-list-schema-validation:0.1.0"
  }
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

- `target/java-resttemplate-list-schema-validation-0.1.0.jar`
- `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import org.openapitools.client.*;
import org.openapitools.client.auth.*;
import org.openapitools.client.model.*;
import org.openapitools.client.api.UserApi;

public class UserApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://api.example.xyz/v1");
        
        UserApi apiInstance = new UserApi(defaultClient);
        List<@Pattern(regexp = "^[a-zA-Z0-9]$")String> username = Arrays.asList(); // List<@Pattern(regexp = "^[a-zA-Z0-9]$")String> | The name of the user
        try {
            apiInstance.userGet(username);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserApi#userGet");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://api.example.xyz/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*UserApi* | [**userGet**](docs/UserApi.md#userGet) | **GET** /user | 


## Documentation for Models



<a id="documentation-for-authorization"></a>
## Documentation for Authorization

Endpoints do not require authorization.


## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author



