# sealed-interface-webclient

ByRefOrValue

- API version: 0.0.1

- Generator version: 7.20.0-SNAPSHOT

This tests for a oneOf interface representation



*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*

## Requirements

Building the API client library requires:

1. Java 1.8+
2. Maven/Gradle

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapitools</groupId>
  <artifactId>sealed-interface-webclient</artifactId>
  <version>0.0.1</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
  repositories {
    mavenCentral()     // Needed if the 'sealed-interface-webclient' jar has been published to maven central.
    mavenLocal()       // Needed if the 'sealed-interface-webclient' jar has been published to the local maven repo.
  }

  dependencies {
     implementation "org.openapitools:sealed-interface-webclient:0.0.1"
  }
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

- `target/sealed-interface-webclient-0.0.1.jar`
- `target/lib/*.jar`

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import org.openapitools.client.*;
import org.openapitools.client.auth.*;
import org.openapitools.client.model.*;
import org.openapitools.client.api.BarApi;

public class BarApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://localhost:8080");
        
        BarApi apiInstance = new BarApi(defaultClient);
        BarCreate barCreate = new BarCreate(); // BarCreate | 
        try {
            Bar result = apiInstance.createBar(barCreate);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling BarApi#createBar");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BarApi* | [**createBar**](docs/BarApi.md#createBar) | **POST** /bar | Create a Bar
*FooApi* | [**createFoo**](docs/FooApi.md#createFoo) | **POST** /foo | Create a Foo
*FooApi* | [**getAllFoos**](docs/FooApi.md#getAllFoos) | **GET** /foo | GET all Foos


## Documentation for Models

 - [Addressable](docs/Addressable.md)
 - [Animal](docs/Animal.md)
 - [Apple](docs/Apple.md)
 - [Banana](docs/Banana.md)
 - [Bar](docs/Bar.md)
 - [BarCreate](docs/BarCreate.md)
 - [BarRef](docs/BarRef.md)
 - [BarRefOrValue](docs/BarRefOrValue.md)
 - [Cat](docs/Cat.md)
 - [Dog](docs/Dog.md)
 - [Entity](docs/Entity.md)
 - [EntityRef](docs/EntityRef.md)
 - [Extensible](docs/Extensible.md)
 - [Foo](docs/Foo.md)
 - [FooRef](docs/FooRef.md)
 - [FooRefOrValue](docs/FooRefOrValue.md)
 - [Fruit](docs/Fruit.md)
 - [FruitType](docs/FruitType.md)
 - [Pasta](docs/Pasta.md)
 - [Pizza](docs/Pizza.md)
 - [PizzaSpeziale](docs/PizzaSpeziale.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization

Endpoints do not require authorization.


## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author



