/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.apis

import java.io.IOException
import okhttp3.Call
import okhttp3.HttpUrl


import com.squareup.moshi.Json

import org.openapitools.client.infrastructure.ApiClient
import org.openapitools.client.infrastructure.ApiResponse
import org.openapitools.client.infrastructure.ClientException
import org.openapitools.client.infrastructure.ClientError
import org.openapitools.client.infrastructure.ServerException
import org.openapitools.client.infrastructure.ServerError
import org.openapitools.client.infrastructure.MultiValueMap
import org.openapitools.client.infrastructure.PartConfig
import org.openapitools.client.infrastructure.RequestConfig
import org.openapitools.client.infrastructure.RequestMethod
import org.openapitools.client.infrastructure.ResponseType
import org.openapitools.client.infrastructure.Success
import org.openapitools.client.infrastructure.toMultiValue

open class DefaultApi(basePath: kotlin.String = defaultBasePath, client: Call.Factory = ApiClient.defaultClient) : ApiClient(basePath, client) {
    companion object {
        @JvmStatic
        val defaultBasePath: String by lazy {
            System.getProperties().getProperty(ApiClient.baseUrlKey, "http://localhost")
        }
    }

    /**
     * enum for parameter queryDefaultEnum
     */
     enum class QueryDefaultEnumFindPetsByStatus(val value: kotlin.String) {
         @Json(name = "A") A("A"),
         @Json(name = "B") B("B"),
         @Json(name = "C") C("C");

        /**
         * Override [toString()] to avoid using the enum variable name as the value, and instead use
         * the actual value defined in the API spec file.
         *
         * This solves a problem when the variable name and its value are different, and ensures that
         * the client sends the correct enum values to the server always.
         */
        override fun toString(): kotlin.String = "$value"
     }

    /**
     * enum for parameter headerDefaultEnum
     */
     enum class HeaderDefaultEnumFindPetsByStatus(val value: kotlin.String) {
         @Json(name = "A") A("A"),
         @Json(name = "B") B("B"),
         @Json(name = "C") C("C");

        /**
         * Override [toString()] to avoid using the enum variable name as the value, and instead use
         * the actual value defined in the API spec file.
         *
         * This solves a problem when the variable name and its value are different, and ensures that
         * the client sends the correct enum values to the server always.
         */
        override fun toString(): kotlin.String = "$value"
     }

    /**
     * enum for parameter cookieDefaultEnum
     */
     enum class CookieDefaultEnumFindPetsByStatus(val value: kotlin.String) {
         @Json(name = "A") A("A"),
         @Json(name = "B") B("B"),
         @Json(name = "C") C("C");

        /**
         * Override [toString()] to avoid using the enum variable name as the value, and instead use
         * the actual value defined in the API spec file.
         *
         * This solves a problem when the variable name and its value are different, and ensures that
         * the client sends the correct enum values to the server always.
         */
        override fun toString(): kotlin.String = "$value"
     }

    /**
     * GET /test/parameters/{path_default}/{path_nullable}
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     * @param pathDefault path default
     * @param pathNullable path_nullable
     * @param queryDefault query default (optional, default to "available")
     * @param queryDefaultEnum query default enum (optional, default to QueryDefaultEnum.B)
     * @param queryDefaultInt query default int (optional, default to 3)
     * @param headerDefault header default (optional, default to "available")
     * @param headerDefaultEnum header default enum (optional, default to HeaderDefaultEnum.B)
     * @param headerDefaultInt header default int (optional, default to 3)
     * @param cookieDefault cookie default (optional, default to "available")
     * @param cookieDefaultEnum cookie default enum (optional, default to CookieDefaultEnum.B)
     * @param cookieDefaultInt cookie default int (optional, default to 3)
     * @param queryNullable query nullable (optional)
     * @param headerNullable header nullable (optional)
     * @param cookieNullable cookie_nullable (optional)
     * @param dollarQueryDollarDollarSign query parameter with dollar sign (optional)
     * @return void
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     * @throws UnsupportedOperationException If the API returns an informational or redirection response
     * @throws ClientException If the API returns a client error response
     * @throws ServerException If the API returns a server error response
     */
    @Throws(IllegalStateException::class, IOException::class, UnsupportedOperationException::class, ClientException::class, ServerException::class)
    fun findPetsByStatus(pathDefault: kotlin.String, pathNullable: kotlin.String, queryDefault: kotlin.String? = "available", queryDefaultEnum: QueryDefaultEnumFindPetsByStatus? = QueryDefaultEnumFindPetsByStatus.B, queryDefaultInt: java.math.BigDecimal? = java.math.BigDecimal("3"), headerDefault: kotlin.String? = "available", headerDefaultEnum: HeaderDefaultEnumFindPetsByStatus? = HeaderDefaultEnumFindPetsByStatus.B, headerDefaultInt: java.math.BigDecimal? = java.math.BigDecimal("3"), cookieDefault: kotlin.String? = "available", cookieDefaultEnum: CookieDefaultEnumFindPetsByStatus? = CookieDefaultEnumFindPetsByStatus.B, cookieDefaultInt: java.math.BigDecimal? = java.math.BigDecimal("3"), queryNullable: kotlin.String? = null, headerNullable: kotlin.String? = null, cookieNullable: kotlin.String? = null, dollarQueryDollarDollarSign: kotlin.String? = null) : Unit {
        val localVarResponse = findPetsByStatusWithHttpInfo(pathDefault = pathDefault, pathNullable = pathNullable, queryDefault = queryDefault, queryDefaultEnum = queryDefaultEnum, queryDefaultInt = queryDefaultInt, headerDefault = headerDefault, headerDefaultEnum = headerDefaultEnum, headerDefaultInt = headerDefaultInt, cookieDefault = cookieDefault, cookieDefaultEnum = cookieDefaultEnum, cookieDefaultInt = cookieDefaultInt, queryNullable = queryNullable, headerNullable = headerNullable, cookieNullable = cookieNullable, dollarQueryDollarDollarSign = dollarQueryDollarDollarSign)

        return when (localVarResponse.responseType) {
            ResponseType.Success -> Unit
            ResponseType.Informational -> throw UnsupportedOperationException("Client does not support Informational responses.")
            ResponseType.Redirection -> throw UnsupportedOperationException("Client does not support Redirection responses.")
            ResponseType.ClientError -> {
                val localVarError = localVarResponse as ClientError<*>
                throw ClientException("Client error : ${localVarError.statusCode} ${localVarError.message.orEmpty()}", localVarError.statusCode, localVarResponse)
            }
            ResponseType.ServerError -> {
                val localVarError = localVarResponse as ServerError<*>
                throw ServerException("Server error : ${localVarError.statusCode} ${localVarError.message.orEmpty()} ${localVarError.body}", localVarError.statusCode, localVarResponse)
            }
        }
    }

    /**
     * GET /test/parameters/{path_default}/{path_nullable}
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     * @param pathDefault path default
     * @param pathNullable path_nullable
     * @param queryDefault query default (optional, default to "available")
     * @param queryDefaultEnum query default enum (optional, default to QueryDefaultEnum.B)
     * @param queryDefaultInt query default int (optional, default to 3)
     * @param headerDefault header default (optional, default to "available")
     * @param headerDefaultEnum header default enum (optional, default to HeaderDefaultEnum.B)
     * @param headerDefaultInt header default int (optional, default to 3)
     * @param cookieDefault cookie default (optional, default to "available")
     * @param cookieDefaultEnum cookie default enum (optional, default to CookieDefaultEnum.B)
     * @param cookieDefaultInt cookie default int (optional, default to 3)
     * @param queryNullable query nullable (optional)
     * @param headerNullable header nullable (optional)
     * @param cookieNullable cookie_nullable (optional)
     * @param dollarQueryDollarDollarSign query parameter with dollar sign (optional)
     * @return ApiResponse<Unit?>
     * @throws IllegalStateException If the request is not correctly configured
     * @throws IOException Rethrows the OkHttp execute method exception
     */
    @Throws(IllegalStateException::class, IOException::class)
    fun findPetsByStatusWithHttpInfo(pathDefault: kotlin.String, pathNullable: kotlin.String, queryDefault: kotlin.String?, queryDefaultEnum: QueryDefaultEnumFindPetsByStatus?, queryDefaultInt: java.math.BigDecimal?, headerDefault: kotlin.String?, headerDefaultEnum: HeaderDefaultEnumFindPetsByStatus?, headerDefaultInt: java.math.BigDecimal?, cookieDefault: kotlin.String?, cookieDefaultEnum: CookieDefaultEnumFindPetsByStatus?, cookieDefaultInt: java.math.BigDecimal?, queryNullable: kotlin.String?, headerNullable: kotlin.String?, cookieNullable: kotlin.String?, dollarQueryDollarDollarSign: kotlin.String?) : ApiResponse<Unit?> {
        val localVariableConfig = findPetsByStatusRequestConfig(pathDefault = pathDefault, pathNullable = pathNullable, queryDefault = queryDefault, queryDefaultEnum = queryDefaultEnum, queryDefaultInt = queryDefaultInt, headerDefault = headerDefault, headerDefaultEnum = headerDefaultEnum, headerDefaultInt = headerDefaultInt, cookieDefault = cookieDefault, cookieDefaultEnum = cookieDefaultEnum, cookieDefaultInt = cookieDefaultInt, queryNullable = queryNullable, headerNullable = headerNullable, cookieNullable = cookieNullable, dollarQueryDollarDollarSign = dollarQueryDollarDollarSign)

        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    /**
     * To obtain the request config of the operation findPetsByStatus
     *
     * @param pathDefault path default
     * @param pathNullable path_nullable
     * @param queryDefault query default (optional, default to "available")
     * @param queryDefaultEnum query default enum (optional, default to QueryDefaultEnum.B)
     * @param queryDefaultInt query default int (optional, default to 3)
     * @param headerDefault header default (optional, default to "available")
     * @param headerDefaultEnum header default enum (optional, default to HeaderDefaultEnum.B)
     * @param headerDefaultInt header default int (optional, default to 3)
     * @param cookieDefault cookie default (optional, default to "available")
     * @param cookieDefaultEnum cookie default enum (optional, default to CookieDefaultEnum.B)
     * @param cookieDefaultInt cookie default int (optional, default to 3)
     * @param queryNullable query nullable (optional)
     * @param headerNullable header nullable (optional)
     * @param cookieNullable cookie_nullable (optional)
     * @param dollarQueryDollarDollarSign query parameter with dollar sign (optional)
     * @return RequestConfig
     */
    fun findPetsByStatusRequestConfig(pathDefault: kotlin.String, pathNullable: kotlin.String, queryDefault: kotlin.String?, queryDefaultEnum: QueryDefaultEnumFindPetsByStatus?, queryDefaultInt: java.math.BigDecimal?, headerDefault: kotlin.String?, headerDefaultEnum: HeaderDefaultEnumFindPetsByStatus?, headerDefaultInt: java.math.BigDecimal?, cookieDefault: kotlin.String?, cookieDefaultEnum: CookieDefaultEnumFindPetsByStatus?, cookieDefaultInt: java.math.BigDecimal?, queryNullable: kotlin.String?, headerNullable: kotlin.String?, cookieNullable: kotlin.String?, dollarQueryDollarDollarSign: kotlin.String?) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery: MultiValueMap = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                if (queryDefault != null) {
                    put("query_default", listOf(queryDefault.toString()))
                }
                if (queryDefaultEnum != null) {
                    put("query_default_enum", listOf(queryDefaultEnum.value))
                }
                if (queryDefaultInt != null) {
                    put("query_default_int", listOf(queryDefaultInt.toString()))
                }
                if (queryNullable != null) {
                    put("query_nullable", listOf(queryNullable.toString()))
                }
                if (dollarQueryDollarDollarSign != null) {
                    put("\$query-\$dollar-sign", listOf(dollarQueryDollarDollarSign.toString()))
                }
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        headerDefault?.apply { localVariableHeaders["header_default"] = this.toString() }
        headerDefaultEnum?.apply { localVariableHeaders["header_default_enum"] = this.toString() }
        headerDefaultInt?.apply { localVariableHeaders["header_default_int"] = this.toString() }
        headerNullable?.apply { localVariableHeaders["header_nullable"] = this.toString() }
        
        return RequestConfig(
            method = RequestMethod.GET,
            path = "/test/parameters/{path_default}/{path_nullable}".replace("{"+"path_default"+"}", encodeURIComponent(pathDefault.toString())).replace("{"+"path_nullable"+"}", encodeURIComponent(pathNullable.toString())),
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    private fun encodeURIComponent(uriComponent: kotlin.String): kotlin.String =
        HttpUrl.Builder().scheme("http").host("localhost").addPathSegment(uriComponent).build().encodedPathSegments[0]
}
