/*
 * EmptyObject
 *
 * Ensure rust supports empty objects using serde::Value
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::sync::Arc;
use std::borrow::Borrow;
use std::pin::Pin;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use hyper_util::client::legacy::connect::Connect;
use futures::Future;

use crate::models;
use super::{Error, configuration};
use super::request as __internal_request;

pub struct DefaultApiClient<C: Connect>
    where C: Clone + std::marker::Send + Sync + 'static {
    configuration: Arc<configuration::Configuration<C>>,
}

impl<C: Connect> DefaultApiClient<C>
    where C: Clone + std::marker::Send + Sync {
    pub fn new(configuration: Arc<configuration::Configuration<C>>) -> DefaultApiClient<C> {
        DefaultApiClient {
            configuration,
        }
    }
}

pub trait DefaultApi: Send + Sync {
    fn endpoint_get(&self, ) -> Pin<Box<dyn Future<Output = Result<models::EmptyObject, Error>> + Send>>;
}

impl<C: Connect>DefaultApi for DefaultApiClient<C>
    where C: Clone + std::marker::Send + Sync {
    #[allow(unused_mut)]
    fn endpoint_get(&self, ) -> Pin<Box<dyn Future<Output = Result<models::EmptyObject, Error>> + Send>> {
        let mut req = __internal_request::Request::new(hyper::Method::GET, "/endpoint".to_string())
        ;

        req.execute(self.configuration.borrow())
    }

}
