/*
 * Multipart File Upload Test
 *
 * Regression test for async multipart file uploads with tokio::fs
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;
use serde::{Deserialize, Serialize, de::Error as _};
use crate::{apis::ResponseContent, models};
use super::{Error, configuration, ContentType};
use tokio::fs::File as TokioFile;
use tokio_util::codec::{BytesCodec, FramedRead};

/// struct for passing parameters to the method [`upload_multiple_fields`]
#[derive(Clone, Debug)]
pub struct UploadMultipleFieldsParams {
    /// Primary file (required)
    pub primary_file: std::path::PathBuf,
    /// Upload title
    pub title: Option<String>,
    /// Tags for the upload
    pub tags: Option<Vec<String>>,
    /// Optional thumbnail file
    pub thumbnail: Option<std::path::PathBuf>
}

/// struct for passing parameters to the method [`upload_optional_file`]
#[derive(Clone, Debug)]
pub struct UploadOptionalFileParams {
    /// Optional metadata string
    pub metadata: Option<String>,
    /// Optional file to upload
    pub file: Option<std::path::PathBuf>
}

/// struct for passing parameters to the method [`upload_single_file`]
#[derive(Clone, Debug)]
pub struct UploadSingleFileParams {
    /// File description metadata
    pub description: String,
    /// File to upload
    pub file: std::path::PathBuf
}


/// struct for typed errors of method [`upload_multiple_fields`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UploadMultipleFieldsError {
    Status400(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`upload_optional_file`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UploadOptionalFileError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`upload_single_file`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UploadSingleFileError {
    Status400(),
    UnknownValue(serde_json::Value),
}


/// Tests async multipart with multiple files and text fields
pub async fn upload_multiple_fields(configuration: &configuration::Configuration, params: UploadMultipleFieldsParams) -> Result<models::UploadResponse, Error<UploadMultipleFieldsError>> {

    let uri_str = format!("{}/upload/multiple-fields", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    let mut multipart_form = reqwest::multipart::Form::new();
    if let Some(param_value) = params.title {
        multipart_form = multipart_form.text("title", param_value.to_string());
    }
    if let Some(param_value) = params.tags {
        multipart_form = multipart_form.text("tags", serde_json::to_string(&param_value)?);
    }
    let file = TokioFile::open(&params.primary_file).await?;
    let stream = FramedRead::new(file, BytesCodec::new());
    let file_name = params.primary_file.file_name().map(|n| n.to_string_lossy().to_string()).unwrap_or_default();
    let file_part = reqwest::multipart::Part::stream(reqwest::Body::wrap_stream(stream)).file_name(file_name);
    multipart_form = multipart_form.part("primaryFile", file_part);
    if let Some(ref param_value) = params.thumbnail {
        let file = TokioFile::open(param_value).await?;
        let stream = FramedRead::new(file, BytesCodec::new());
        let file_name = param_value.file_name().map(|n| n.to_string_lossy().to_string()).unwrap_or_default();
        let file_part = reqwest::multipart::Part::stream(reqwest::Body::wrap_stream(stream)).file_name(file_name);
        multipart_form = multipart_form.part("thumbnail", file_part);
    }
    req_builder = req_builder.multipart(multipart_form);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();
    let content_type = resp
        .headers()
        .get("content-type")
        .and_then(|v| v.to_str().ok())
        .unwrap_or("application/octet-stream");
    let content_type = super::ContentType::from(content_type);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        match content_type {
            ContentType::Json => serde_json::from_str(&content).map_err(Error::from),
            ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::UploadResponse`"))),
            ContentType::Unsupported(unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{unknown_type}` content type response that cannot be converted to `models::UploadResponse`")))),
        }
    } else {
        let content = resp.text().await?;
        let entity: Option<UploadMultipleFieldsError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

/// Tests async multipart file upload with optional file parameter
pub async fn upload_optional_file(configuration: &configuration::Configuration, params: UploadOptionalFileParams) -> Result<models::UploadResponse, Error<UploadOptionalFileError>> {

    let uri_str = format!("{}/upload/optional", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    let mut multipart_form = reqwest::multipart::Form::new();
    if let Some(param_value) = params.metadata {
        multipart_form = multipart_form.text("metadata", param_value.to_string());
    }
    if let Some(ref param_value) = params.file {
        let file = TokioFile::open(param_value).await?;
        let stream = FramedRead::new(file, BytesCodec::new());
        let file_name = param_value.file_name().map(|n| n.to_string_lossy().to_string()).unwrap_or_default();
        let file_part = reqwest::multipart::Part::stream(reqwest::Body::wrap_stream(stream)).file_name(file_name);
        multipart_form = multipart_form.part("file", file_part);
    }
    req_builder = req_builder.multipart(multipart_form);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();
    let content_type = resp
        .headers()
        .get("content-type")
        .and_then(|v| v.to_str().ok())
        .unwrap_or("application/octet-stream");
    let content_type = super::ContentType::from(content_type);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        match content_type {
            ContentType::Json => serde_json::from_str(&content).map_err(Error::from),
            ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::UploadResponse`"))),
            ContentType::Unsupported(unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{unknown_type}` content type response that cannot be converted to `models::UploadResponse`")))),
        }
    } else {
        let content = resp.text().await?;
        let entity: Option<UploadOptionalFileError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

/// Tests async multipart file upload with required file parameter
pub async fn upload_single_file(configuration: &configuration::Configuration, params: UploadSingleFileParams) -> Result<models::UploadResponse, Error<UploadSingleFileError>> {

    let uri_str = format!("{}/upload/single", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    let mut multipart_form = reqwest::multipart::Form::new();
    multipart_form = multipart_form.text("description", params.description.to_string());
    let file = TokioFile::open(&params.file).await?;
    let stream = FramedRead::new(file, BytesCodec::new());
    let file_name = params.file.file_name().map(|n| n.to_string_lossy().to_string()).unwrap_or_default();
    let file_part = reqwest::multipart::Part::stream(reqwest::Body::wrap_stream(stream)).file_name(file_name);
    multipart_form = multipart_form.part("file", file_part);
    req_builder = req_builder.multipart(multipart_form);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();
    let content_type = resp
        .headers()
        .get("content-type")
        .and_then(|v| v.to_str().ok())
        .unwrap_or("application/octet-stream");
    let content_type = super::ContentType::from(content_type);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        match content_type {
            ContentType::Json => serde_json::from_str(&content).map_err(Error::from),
            ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::UploadResponse`"))),
            ContentType::Unsupported(unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{unknown_type}` content type response that cannot be converted to `models::UploadResponse`")))),
        }
    } else {
        let content = resp.text().await?;
        let entity: Option<UploadSingleFileError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

