#' OpenAPI Petstore
#'
#' This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#'
#' The version of the OpenAPI document: 1.0.0
#' Generated by: https://openapi-generator.tech
#'
#' ApiClient Class
#'
#' Generic API client for OpenAPI client library builds.
#' OpenAPI generic API client. This client handles the client-
#' server communication, and is invariant across implementations. Specifics of
#' the methods and models for each application are generated from the OpenAPI Generator
#' templates.
#'
#' NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
#' Ref: https://openapi-generator.tech
#' Do not edit the class manually.
#'
#' @docType class
#' @title ApiClient
#' @description ApiClient Class
#' @format An \code{R6Class} generator object
#' @field base_path Base url
#' @field user_agent Default user agent
#' @field default_headers Default headers
#' @field username Username for HTTP basic authentication
#' @field password Password for HTTP basic authentication
#' @field api_keys API keys
#' @field access_token Access token
#' @field oauth_client_id OAuth client ID
#' @field oauth_secret OAuth secret
#' @field oauth_refresh_token OAuth refresh token
#' @field oauth_flow_type OAuth flow type
#' @field oauth_authorization_url Authorization URL
#' @field oauth_token_url Token URL
#' @field oauth_pkce Boolean flag to enable PKCE
#' @field oauth_scopes OAuth scopes
#' @field bearer_token Bearer token
#' @field timeout Default timeout in seconds
#' @field retry_status_codes vector of status codes to retry
#' @field max_retry_attempts maximum number of retries for the status codes
#' @importFrom rlang abort
#' @export
ApiClient  <- R6::R6Class(
  "ApiClient",
  public = list(
    # base path of all requests
    base_path = "http://petstore.swagger.io/v2",
    # user agent in the HTTP request
    user_agent = "PetstoreAgent",
    # default headers in the HTTP request
    default_headers = NULL,
    # username (HTTP basic authentication)
    username = NULL,
    # password (HTTP basic authentication)
    password = NULL,
    # API keys
    api_keys = NULL,
    # Access token
    access_token = NULL,
    # OAuth2 client ID
    oauth_client_id = NULL,
    # OAuth2 secret
    oauth_secret = NULL,
    # OAuth2 refresh token
    oauth_refresh_token = NULL,
    # OAuth2
    # Flow type
    oauth_flow_type = "implicit",
    # Authorization URL
    oauth_authorization_url = "http://petstore.swagger.io/api/oauth/dialog",
    # Token URL
    oauth_token_url = "",
    # Enable PKCE?
    oauth_pkce = TRUE,
    # OAuth scopes
    oauth_scopes = NULL,
    # Bearer token
    bearer_token = NULL,
    # Time Out (seconds)
    timeout = NULL,
    # Vector of status codes to retry
    retry_status_codes = NULL,
    # Maximum number of retry attempts for the retry status codes
    max_retry_attempts = NULL,
    #' Initialize a new ApiClient.
    #'
    #' @description
    #' Initialize a new ApiClient.
    #'
    #' @param base_path Base path.
    #' @param user_agent User agent.
    #' @param default_headers Default headers.
    #' @param username User name.
    #' @param password Password.
    #' @param api_keys API keys.
    #' @param access_token Access token.
    #' @param bearer_token Bearer token.
    #' @param timeout Timeout.
    #' @param retry_status_codes Status codes for retry.
    #' @param max_retry_attempts Maximum number of retry.
    #' @export
    initialize = function(base_path = NULL, user_agent = NULL,
                          default_headers = NULL,
                          username = NULL, password = NULL, api_keys = NULL,
                          access_token = NULL, bearer_token = NULL, timeout = NULL,
                          retry_status_codes = NULL, max_retry_attempts = NULL) {
      if (!is.null(base_path)) {
        self$base_path <- base_path
      }

      if (!is.null(default_headers)) {
        self$default_headers <- default_headers
      }

      if (!is.null(username)) {
        self$username <- username
      }

      if (!is.null(password)) {
        self$password <- password
      }

      if (!is.null(access_token)) {
        self$access_token <- access_token
      }

      if (!is.null(bearer_token)) {
        self$bearer_token <- bearer_token
      }

      if (!is.null(api_keys)) {
        self$api_keys <- api_keys
      } else {
        self$api_keys <- list()
      }

      if (!is.null(user_agent)) {
        self$`user_agent` <- user_agent
      }

      if (!is.null(timeout)) {
        self$timeout <- timeout
      }

      if (!is.null(retry_status_codes)) {
        self$retry_status_codes <- retry_status_codes
      }

      if (!is.null(max_retry_attempts)) {
        self$max_retry_attempts <- max_retry_attempts
      }
    },
    #' Prepare to make an API call with the retry logic.
    #'
    #' @description
    #' Prepare to make an API call with the retry logic.
    #'
    #' @param url URL.
    #' @param method HTTP method.
    #' @param query_params The query parameters.
    #' @param header_params The header parameters.
    #' @param form_params The form parameters.
    #' @param file_params The form parameters to upload files.
    #' @param accepts The HTTP accept headers.
    #' @param content_types The HTTP content-type headers.
    #' @param body The HTTP request body.
    #' @param is_oauth True if the endpoints required OAuth authentication.
    #' @param oauth_scopes OAuth scopes.
    #' @param stream_callback Callback function to process the data stream.
    #' @param ... Other optional arguments.
    #' @return HTTP response
    #' @export
    CallApi = function(url, method, query_params, header_params, form_params,
                       file_params, accepts, content_types, body,
                       is_oauth = FALSE, oauth_scopes = NULL, stream_callback = NULL, ...) {

      # set the URL
      req <- request(url)

      resp <- self$Execute(req, method, query_params, header_params, form_params,
                           file_params, accepts, content_types, body, is_oauth = is_oauth,
                           oauth_scopes = oauth_scopes, stream_callback = stream_callback, ...)
    },
    #' Make an API call
    #'
    #' @description
    #' Make an API call
    #'
    #' @param req httr2 request.
    #' @param method HTTP method.
    #' @param query_params The query parameters.
    #' @param header_params The header parameters.
    #' @param form_params The form parameters.
    #' @param file_params The form parameters for uploading files.
    #' @param accepts The HTTP accept headers.
    #' @param content_types The HTTP content-type headers.
    #' @param body The HTTP request body.
    #' @param is_oauth True if the endpoints required OAuth authentication.
    #' @param oauth_scopes OAuth scopes.
    #' @param stream_callback Callback function to process data stream.
    #' @param ... Other optional arguments.
    #' @return HTTP response
    #' @export
    Execute = function(req, method, query_params, header_params, form_params,
                       file_params, accepts, content_types, body,
                       is_oauth = FALSE, oauth_scopes = NULL, stream_callback = NULL, ...) {

      ## add headers
      req <- req %>% req_headers(!!!header_params)

      ## add default headers
      req <- req %>% req_headers(!!!self$default_headers)

      # set HTTP accept header
      accept <- self$select_header(accepts)
      if (!is.null(accept)) {
        req <- req %>% req_headers("Accept" = accept)
      }

      # set HTTP content-type header
      content_type <- self$select_header(content_types)
      if (!is.null(content_type)) {
        req <- req %>% req_headers("Content-Type" = content_type)
      }

      ## add query parameters
      for (query_param in names(query_params)) {
        if (typeof(query_params[[query_param]]) == "list") {
          # for explode, e.g. a=1,a=2,a=3
          req <- req %>% req_url_query(!!!query_params[[query_param]])
        } else { # for non-explode, e.g. a=1,2,3
          tmp <- list()
          tmp[[query_param]] <- query_params[[query_param]]
          req <- req %>% req_url_query(!!!tmp)
        }
      }

      # has file upload?
      if (!is.null(file_params) && length(file_params) != 0) {
        req <- req %>% req_body_multipart(!!!file_params)

        # add form parameters via req_body_multipart
        if (!is.null(form_params) && length(form_params) != 0) {
          req <- req %>% req_body_multipart(!!!form_params)
        }
      } else { # no file upload
        # add form parameters via req_body_form
        if (!is.null(form_params) && length(form_params) != 0) {
          req <- req %>% req_body_form(!!!form_params)
        }
      }

      # add body parameters
      if (!is.null(body)) {
        req <- req %>% req_body_raw(body)
      }

      # set timeout
      if (!is.null(self$timeout)) {
        req <- req %>% req_timeout(self$timeout)
      }

      # set retry
      if (!is.null(self$max_retry_attempts)) {
        req <- req %>% retry_max_tries(self$timeout)
        req <- req %>% retry_max_seconds(self$timeout)
      }

      # set user agent
      if (!is.null(self$user_agent)) {
        req <- req %>% req_user_agent(self$user_agent)
      }

      # set HTTP verb
      req <- req %>% req_method(method)

      # use oauth authentication if the endpoint requires it
      if (is_oauth && !is.null(self$oauth_client_id) && !is.null(self$oauth_secret)) {
        client <- oauth_client(
          id = self$oauth_client_id,
          secret = obfuscated(self$oauth_secret),
          token_url = self$oauth_token_url,
          name = "petstore-oauth"
        )

        req_oauth_scopes <- NULL
        if (!is.null(self$oauth_scopes)) {
          # use oauth scopes provided by the user
          req_oauth_scopes <- self$oauth_scopes
        } else {
          # use oauth scopes defined in openapi spec
          req_oauth_scopes <- oauth_scopes
        }

        req <- req %>% req_oauth_auth_code(client, scope = req_oauth_scopes,
                                           pkce = self$oauth_pkce,
                                           auth_url = self$oauth_authorization_url)
      }

      # stream data
      if (typeof(stream_callback) == "closure") {
        req %>% req_stream(stream_callback)
      } else {
        # perform the HTTP request
        resp <- req %>%
          req_error(is_error = function(resp) FALSE) %>%
          req_perform()

        # return ApiResponse
        api_response <- ApiResponse$new()
        api_response$status_code <- resp %>% resp_status()
        api_response$status_code_desc <- resp %>% resp_status_desc()
        if (length(resp$body) == 0) {
          api_response$response <- NULL
        } else {
          api_response$response <- resp %>% resp_body_raw()
        }
        api_response$headers <- resp %>% resp_headers()

        api_response
      }
    },
    #' Deserialize the content of API response to the given type.
    #'
    #' @description
    #' Deserialize the content of API response to the given type.
    #'
    #' @param raw_response Raw response.
    #' @param return_type R return type.
    #' @param pkg_env Package environment.
    #' @return Deserialized object.
    #' @export
    deserialize = function(raw_response, return_type, pkg_env) {
      resp_obj <- jsonlite::fromJSON(raw_response)
      self$deserializeObj(resp_obj, return_type, pkg_env)
    },
    #' Deserialize the response from jsonlite object based on the given type.
    #'
    #' @description
    #' Deserialize the response from jsonlite object based on the given type.
    #' by handling complex and nested types by iterating recursively
    #' Example return_types will be like "array[integer]", "map(Pet)", "array[map(Tag)]", etc.
    #'
    #' @param obj Response object.
    #' @param return_type R return type.
    #' @param pkg_env Package environment.
    #' @return Deserialized object.
    #' @export
    deserializeObj = function(obj, return_type, pkg_env) {
      return_obj <- NULL
      primitive_types <- c("character", "numeric", "integer", "logical", "complex")

      # for deserialization, uniqueness requirements do not matter
      return_type <- gsub(pattern = "^(set|array)\\[",
                          replacement = "collection\\[",
                          x = return_type)

      # To handle the "map" type
      if (startsWith(return_type, "map(")) {
        inner_return_type <- regmatches(return_type,
                                        regexec(pattern = "map\\((.*)\\)", return_type))[[1]][2]
        return_obj <- lapply(names(obj), function(name) {
          self$deserializeObj(obj[[name]], inner_return_type, pkg_env)
        })
        names(return_obj) <- names(obj)
      } else if (startsWith(return_type, "collection[")) {
        # To handle the "array" and "set" types
        inner_return_type <- regmatches(return_type,
                                        regexec(pattern = "collection\\[(.*)\\]", return_type))[[1]][2]
        if (c(inner_return_type) %in% primitive_types) {
          return_obj <- vector("list", length = length(obj))
          if (length(obj) > 0) {
            for (row in 1:length(obj)) {
              return_obj[[row]] <- self$deserializeObj(obj[row], inner_return_type, pkg_env)
            }
          }
        } else {
          if (is.list(obj) && length(obj) == 1 && is.data.frame(obj[[1]])) {
            obj <- obj[[1]]
          }
          if (!is.null(nrow(obj))) {
            return_obj <- vector("list", length = nrow(obj))
            if (nrow(obj) > 0) {
              for (row in 1:nrow(obj)) {
                return_obj[[row]] <- self$deserializeObj(obj[row, , drop = FALSE],
                                                         inner_return_type, pkg_env)
              }
            }
          }
        }
      } else if (exists(return_type, pkg_env) && !(c(return_type) %in% primitive_types)) {
        # To handle model objects which are not array or map containers (e.g. Pet)
        return_type <- get(return_type, envir = as.environment(pkg_env))
        return_obj <- return_type$new()
        # check if discriminator is defined
        if (!is.null(return_obj$`_discriminator_property_name`)) {
          data_type <- return_obj$`_discriminator_property_name`
          # use discriminator mapping if provided
          if (!is.null(return_obj$`_discriminator_mapping_name`)) {
            data_type <- (return_obj$`_discriminator_mapping_name`)[[obj[[data_type]]]]
          } else {
            # no mapping provided, use the value directly
            data_type <- obj[[data_type]]
          }
          # create an object of the mapped type (e.g. Cat)
          return_type <- get(data_type, envir = as.environment(pkg_env))
          return_obj <- return_type$new()
        }
        return_obj$fromJSON(
          jsonlite::toJSON(obj, digits = NA, auto_unbox = TRUE)
        )
      } else {
        # To handle primitive type
        return_obj <- obj
      }
      return_obj
    },
    #' Return a property header (for accept or content-type).
    #'
    #' @description
    #' Return a property header (for accept or content-type). If JSON-related MIME is found,
    #' return it. Otherwise, return the first one, if any.
    #'
    #' @param headers A list of headers
    #' @return A header (e.g. 'application/json')
    #' @export
    select_header = function(headers) {
      if (length(headers) == 0) {
        return(invisible(NULL))
      } else {
        for (header in headers) {
          if (str_detect(header, "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$")) {
            # return JSON-related MIME
            return(header)
          }
        }

        # not json mime type, simply return the first one
        return(headers[1])
      }
    },

    #' @description
    #' Deserialize the response
    #' 
    #' @param local_var_resp The API response
    #' @param return_type The target return type for the endpoint (e.g., `"object"`). If `NULL` text will be left as-is.
    #' @return If the raw response is corecable to text, return the text. Otherwise return the raw response.
    DeserializeResponse = function(local_var_resp, return_type = NULL) {
      text <- local_var_resp$response_as_text()
      if (is.na(text)) {
        return(local_var_resp$response)
      } else if (is.null(return_type)) {
        return(text)
      }
      return(self$deserialize(text, return_type, loadNamespace("petstore")))
    },

    #' @description
    #' Write response to a file
    #' 
    #' The function will write out data. 
    #' 
    #' 1. If binary data is detected it will use `writeBin`
    #' 2. If the raw response is coercible to text, the text will be written to a file
    #' 3. If the raw response is not coercible to text, the raw response will be written
    #' 
    #' @param local_var_resp The API response
    #' @param file The name of the data file to save the result
    WriteFile = function(local_var_resp, file) {
      if (self$IsBinary(local_var_resp$response)) {
        writeBin(local_var_resp$response, file)
      } else {
        response <- self$DeserializeResponse(local_var_resp)
        base::write(response, file)
      }
    },

    #' @description
    #' Check response for binary content
    #' 
    #' @param local_var_resp The API response
    IsBinary = function(x) {
      # ref: https://stackoverflow.com/a/17098690/1785752
      b <- readBin(x, "int", n = 1000, size=1, signed=FALSE)
      return(max(b) > 128)
    }
  )
)
