#' OpenAPI Petstore
#'
#' This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#'
#' The version of the OpenAPI document: 1.0.0
#' Generated by: https://openapi-generator.tech
#'
#' @docType class
#' @title ApiResponse
#' @description ApiResponse Class
#' @format An \code{R6Class} generator object
#' @field content The deserialized response body.
#' @field response The raw response from the endpoint.
#' @field status_code The HTTP response status code.
#' @field status_code_desc The brief description of the HTTP response status code.
#' @field headers The HTTP response headers.
#' @export
ApiResponse <- R6::R6Class(
  "ApiResponse",
  public = list(
    content = NULL,
    response = NULL,
    status_code = NULL,
    status_code_desc = NULL,
    headers = NULL,

    #' @description
    #' Initialize a new ApiResponse class.
    #'
    #' @param content The deserialized response body.
    #' @param response The raw response from the endpoint.
    #' @param status_code The HTTP response status code.
    #' @param status_code_desc The brief description of the HTTP response status code.
    #' @param headers The HTTP response headers.
    initialize = function(content = NULL,
                          response = NULL,
                          status_code = NULL,
                          status_code_desc = NULL,
                          headers = NULL) {
      self$content <- content
      self$response <- response
      self$status_code <- status_code
      self$status_code_desc <- status_code_desc
      self$headers <- headers
    },


    #' @description
    #' The response is stored as a raw vector. Use this to access the response after
    #' converting it to text. If the response is not coercible to text NA is returned.
    #'
    #' @param from_encoding The encoding of the raw response.
    #' @param to_encoding The target encoding of the return value.
    response_as_text = function(from_encoding = "", to_encoding = "UTF-8") {
      if (is.null(self$response)) {
        self$response <- charToRaw(jsonlite::toJSON("NULL"))
      }
      text_response <- iconv(readBin(self$response, character()), from = from_encoding, to = to_encoding)
      return(text_response)
    }
  )
)
