#' OpenAPI Petstore
#'
#' This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#'
#' The version of the OpenAPI document: 1.0.0
#' Generated by: https://openapi-generator.tech
#'
#' @docType class
#' @title User operations
#' @description UserApi
#' @format An \code{R6Class} generator object
#' @field api_client Handles the client-server communication.
#'
#' @examples
#' \dontrun{
#' ####################  create_user  ####################
#'
#' library(petstore)
#' var_user <- User$new(123, "username_example", "firstName_example", "lastName_example", "email_example", "password_example", "phone_example", 123) # User | Created user object
#'
#' #Create user
#' api_instance <- UserApi$new()
#'
#' # Configure API key authorization: api_key
#' api_instance$api_client$api_keys["api_key"] <- Sys.getenv("API_KEY")
#'
#' result <- tryCatch(
#'              
#'              api_instance$create_user(var_user),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `create_user`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  create_users_with_array_input  ####################
#'
#' library(petstore)
#' var_user <- c(User$new(123, "username_example", "firstName_example", "lastName_example", "email_example", "password_example", "phone_example", 123)) # array[User] | List of user object
#'
#' #Creates list of users with given input array
#' api_instance <- UserApi$new()
#'
#' # Configure API key authorization: api_key
#' api_instance$api_client$api_keys["api_key"] <- Sys.getenv("API_KEY")
#'
#' result <- tryCatch(
#'              
#'              api_instance$create_users_with_array_input(var_user),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `create_users_with_array_input`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  create_users_with_list_input  ####################
#'
#' library(petstore)
#' var_user <- c(User$new(123, "username_example", "firstName_example", "lastName_example", "email_example", "password_example", "phone_example", 123)) # array[User] | List of user object
#'
#' #Creates list of users with given input array
#' api_instance <- UserApi$new()
#'
#' # Configure API key authorization: api_key
#' api_instance$api_client$api_keys["api_key"] <- Sys.getenv("API_KEY")
#'
#' result <- tryCatch(
#'              
#'              api_instance$create_users_with_list_input(var_user),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `create_users_with_list_input`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  delete_user  ####################
#'
#' library(petstore)
#' var_username <- "username_example" # character | The name that needs to be deleted
#'
#' #Delete user
#' api_instance <- UserApi$new()
#'
#' # Configure API key authorization: api_key
#' api_instance$api_client$api_keys["api_key"] <- Sys.getenv("API_KEY")
#'
#' result <- tryCatch(
#'              
#'              api_instance$delete_user(var_username),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `delete_user`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  get_user_by_name  ####################
#'
#' library(petstore)
#' var_username <- "username_example" # character | The name that needs to be fetched. Use user1 for testing.
#'
#' #Get user by user name
#' api_instance <- UserApi$new()
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$get_user_by_name(var_username, data_file = "result.txt"),
#'              
#'              
#'              api_instance$get_user_by_name(var_username),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `get_user_by_name`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  login_user  ####################
#'
#' library(petstore)
#' var_username <- "username_example" # character | The user name for login
#' var_password <- "password_example" # character | The password for login in clear text
#'
#' #Logs user into the system
#' api_instance <- UserApi$new()
#'
#' result <- tryCatch(
#'              
#'              # to save the result into a file, simply add the optional `data_file` parameter, e.g.
#'              # api_instance$login_user(var_username, var_password, data_file = "result.txt"),
#'              
#'              
#'              api_instance$login_user(var_username, var_password),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `login_user`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' } else {
#'   # deserialized response object
#'   print("The response is ...")
#'   dput(result$toString())
#' }
#'
#'
#'
#' ####################  logout_user  ####################
#'
#' library(petstore)
#'
#' #Logs out current logged in user session
#' api_instance <- UserApi$new()
#'
#' # Configure API key authorization: api_key
#' api_instance$api_client$api_keys["api_key"] <- Sys.getenv("API_KEY")
#'
#' result <- tryCatch(
#'              
#'              api_instance$logout_user(),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `logout_user`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' ####################  update_user  ####################
#'
#' library(petstore)
#' var_username <- "username_example" # character | name that need to be deleted
#' var_user <- User$new(123, "username_example", "firstName_example", "lastName_example", "email_example", "password_example", "phone_example", 123) # User | Updated user object
#'
#' #Updated user
#' api_instance <- UserApi$new()
#'
#' # Configure API key authorization: api_key
#' api_instance$api_client$api_keys["api_key"] <- Sys.getenv("API_KEY")
#'
#' result <- tryCatch(
#'              
#'              api_instance$update_user(var_username, var_user),
#'              ApiException = function(ex) ex
#'           )
#' # In case of error, print the error object
#' if (!is.null(result$ApiException)) {
#'   print("Exception occurs when calling `update_user`:")
#'   dput(result$ApiException$toString())
#'   
#'   # error object
#'   dput(result$ApiException$error_object$toJSONString())
#'   
#' }#'
#' # This endpoint doesn't return data
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @importFrom rlang abort
#' @export
UserApi <- R6::R6Class(
  "UserApi",
  public = list(
    api_client = NULL,

    #' @description
    #' Initialize a new UserApi.
    #'
    #' @param api_client An instance of API client.
    initialize = function(api_client) {
      if (!missing(api_client)) {
        self$api_client <- api_client
      } else {
        self$api_client <- ApiClient$new()
      }
    },

    #' @description
    #' Create user
    #'
    #' @param user Created user object
    #' @param ... Other optional arguments
    #'
    #' @return void
    create_user = function(user, ...) {
      local_var_response <- self$create_user_with_http_info(user, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Create user
    #'
    #' @param user Created user object
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    create_user_with_http_info = function(user, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`user`)) {
        rlang::abort(message = "Missing required parameter `user`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `user`."))
      }

      if (!missing(`user`) && is.null(`user`)) {
        rlang::abort(message = "Invalid value for `user` when calling UserApi$create_user, `user` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `user` when calling UserApi$create_user, `user` is not nullable"))
      }

      if (!is.null(`user`)) {
        local_var_body <- `user`$toJSONString()
      } else {
        local_var_body <- NULL
      }

      local_var_url_path <- "/user"
      # API key authentication
      if ("api_key" %in% names(self$api_client$api_keys) && nchar(self$api_client$api_keys["api_key"]) > 0) {
        header_params["api_key"] <- paste(unlist(self$api_client$api_keys["api_key"]), collapse = "")
      }

      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list("application/json")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Creates list of users with given input array
    #'
    #' @param user List of user object
    #' @param ... Other optional arguments
    #'
    #' @return void
    create_users_with_array_input = function(user, ...) {
      local_var_response <- self$create_users_with_array_input_with_http_info(user, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Creates list of users with given input array
    #'
    #' @param user List of user object
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    create_users_with_array_input_with_http_info = function(user, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`user`)) {
        rlang::abort(message = "Missing required parameter `user`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `user`."))
      }

      if (!missing(`user`) && is.null(`user`)) {
        rlang::abort(message = "Invalid value for `user` when calling UserApi$create_users_with_array_input, `user` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `user` when calling UserApi$create_users_with_array_input, `user` is not nullable"))
      }

      if (!is.null(`user`)) {
        body.items <- paste(unlist(lapply(`user`, function(param) {
                                                             param$toJSONString()
                                                         })), collapse = ",")
        local_var_body <- paste0("[", body.items, "]")
      } else {
        local_var_body <- NULL
      }

      local_var_url_path <- "/user/createWithArray"
      # API key authentication
      if ("api_key" %in% names(self$api_client$api_keys) && nchar(self$api_client$api_keys["api_key"]) > 0) {
        header_params["api_key"] <- paste(unlist(self$api_client$api_keys["api_key"]), collapse = "")
      }

      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list("application/json")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Creates list of users with given input array
    #'
    #' @param user List of user object
    #' @param ... Other optional arguments
    #'
    #' @return void
    create_users_with_list_input = function(user, ...) {
      local_var_response <- self$create_users_with_list_input_with_http_info(user, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Creates list of users with given input array
    #'
    #' @param user List of user object
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    create_users_with_list_input_with_http_info = function(user, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`user`)) {
        rlang::abort(message = "Missing required parameter `user`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `user`."))
      }

      if (!missing(`user`) && is.null(`user`)) {
        rlang::abort(message = "Invalid value for `user` when calling UserApi$create_users_with_list_input, `user` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `user` when calling UserApi$create_users_with_list_input, `user` is not nullable"))
      }

      if (!is.null(`user`)) {
        body.items <- paste(unlist(lapply(`user`, function(param) {
                                                             param$toJSONString()
                                                         })), collapse = ",")
        local_var_body <- paste0("[", body.items, "]")
      } else {
        local_var_body <- NULL
      }

      local_var_url_path <- "/user/createWithList"
      # API key authentication
      if ("api_key" %in% names(self$api_client$api_keys) && nchar(self$api_client$api_keys["api_key"]) > 0) {
        header_params["api_key"] <- paste(unlist(self$api_client$api_keys["api_key"]), collapse = "")
      }

      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list("application/json")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "POST",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Delete user
    #'
    #' @param username The name that needs to be deleted
    #' @param ... Other optional arguments
    #'
    #' @return void
    delete_user = function(username, ...) {
      local_var_response <- self$delete_user_with_http_info(username, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Delete user
    #'
    #' @param username The name that needs to be deleted
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    delete_user_with_http_info = function(username, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`username`)) {
        rlang::abort(message = "Missing required parameter `username`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `username`."))
      }

      if (!missing(`username`) && is.null(`username`)) {
        rlang::abort(message = "Invalid value for `username` when calling UserApi$delete_user, `username` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `username` when calling UserApi$delete_user, `username` is not nullable"))
      }

      local_var_url_path <- "/user/{username}"
      if (!missing(`username`)) {
        local_var_url_path <- gsub("\\{username\\}", URLencode(as.character(`username`), reserved = TRUE), local_var_url_path)
      }

      # API key authentication
      if ("api_key" %in% names(self$api_client$api_keys) && nchar(self$api_client$api_keys["api_key"]) > 0) {
        header_params["api_key"] <- paste(unlist(self$api_client$api_keys["api_key"]), collapse = "")
      }

      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "DELETE",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Get user by user name
    #'
    #' @param username The name that needs to be fetched. Use user1 for testing.
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return User
    get_user_by_name = function(username, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$get_user_by_name_with_http_info(username, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Get user by user name
    #'
    #' @param username The name that needs to be fetched. Use user1 for testing.
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (User) with additional information such as HTTP status code, headers
    get_user_by_name_with_http_info = function(username, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`username`)) {
        rlang::abort(message = "Missing required parameter `username`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `username`."))
      }

      if (!missing(`username`) && is.null(`username`)) {
        rlang::abort(message = "Invalid value for `username` when calling UserApi$get_user_by_name, `username` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `username` when calling UserApi$get_user_by_name, `username` is not nullable"))
      }

      local_var_url_path <- "/user/{username}"
      if (!missing(`username`)) {
        local_var_url_path <- gsub("\\{username\\}", URLencode(as.character(`username`), reserved = TRUE), local_var_url_path)
      }


      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "User"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Logs user into the system
    #'
    #' @param username The user name for login
    #' @param password The password for login in clear text
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return character
    login_user = function(username, password, data_file = NULL, ..., .parse = TRUE) {
      local_var_response <- self$login_user_with_http_info(username, password, data_file = data_file, ..., .parse = .parse)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Logs user into the system
    #'
    #' @param username The user name for login
    #' @param password The password for login in clear text
    #' @param data_file (optional) name of the data file to save the result
    #' @param ... Other optional arguments
    #' @param .parse Logical. If \code{TRUE} then the response will be parsed to a generated type. If \code{FALSE} the response will be returned as unparsed text.
    #'
    #' @return API response (character) with additional information such as HTTP status code, headers
    login_user_with_http_info = function(username, password, data_file = NULL, ..., .parse = TRUE) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`username`)) {
        rlang::abort(message = "Missing required parameter `username`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `username`."))
      }

      if (missing(`password`)) {
        rlang::abort(message = "Missing required parameter `password`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `password`."))
      }

      if (!missing(`username`) && is.null(`username`)) {
        rlang::abort(message = "Invalid value for `username` when calling UserApi$login_user, `username` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `username` when calling UserApi$login_user, `username` is not nullable"))
      }
      if (!is.null(`username`) && !stringr::str_detect(`username`, "^[a-zA-Z0-9]+[a-zA-Z0-9\\.\\-_]*[a-zA-Z0-9]+$")) {
        rlang::abort(message = "Invalid value for `username` when calling UserApi$login_user, must conform to the pattern ^[a-zA-Z0-9]+[a-zA-Z0-9\\.\\-_]*[a-zA-Z0-9]+$.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Invalid value for `username` when calling UserApi$login_user, must conform to the pattern ^[a-zA-Z0-9]+[a-zA-Z0-9\\.\\-_]*[a-zA-Z0-9]+$."))
      }

      if (!missing(`password`) && is.null(`password`)) {
        rlang::abort(message = "Invalid value for `password` when calling UserApi$login_user, `password` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `password` when calling UserApi$login_user, `password` is not nullable"))
      }

      query_params[["username"]] <- `username`

      query_params[["password"]] <- `password`

      local_var_url_path <- "/user/login"

      # The Accept request HTTP header
      local_var_accepts <- list("application/xml", "application/json")

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        # save response in a file
        if (!is.null(data_file)) {
          self$api_client$WriteFile(local_var_resp, data_file)
        }
        if (!.parse) {
          local_var_resp$content <- local_var_resp$response_as_text()
          return(local_var_resp)
        }

        deserialized_resp_obj <- tryCatch(
          self$api_client$DeserializeResponse(local_var_resp, "character"),
          error = function(e) {
            rlang::abort(message = "Failed to deserialize response",
                         .subclass = "ApiException",
                         ApiException = ApiException$new(http_response = local_var_resp))
          }
        )
        local_var_resp$content <- deserialized_resp_obj
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Logs out current logged in user session
    #'
    #' @param ... Other optional arguments
    #'
    #' @return void
    logout_user = function(...) {
      local_var_response <- self$logout_user_with_http_info(...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Logs out current logged in user session
    #'
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    logout_user_with_http_info = function(...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      local_var_url_path <- "/user/logout"
      # API key authentication
      if ("api_key" %in% names(self$api_client$api_keys) && nchar(self$api_client$api_keys["api_key"]) > 0) {
        header_params["api_key"] <- paste(unlist(self$api_client$api_keys["api_key"]), collapse = "")
      }

      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list()

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "GET",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    },

    #' @description
    #' Updated user
    #'
    #' @param username name that need to be deleted
    #' @param user Updated user object
    #' @param ... Other optional arguments
    #'
    #' @return void
    update_user = function(username, user, ...) {
      local_var_response <- self$update_user_with_http_info(username, user, ...)
      if (local_var_response$status_code >= 200 && local_var_response$status_code <= 299) {
        return(local_var_response$content)
      } else if (local_var_response$status_code >= 300 && local_var_response$status_code <= 399) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 400 && local_var_response$status_code <= 499) {
        return(local_var_response)
      } else if (local_var_response$status_code >= 500 && local_var_response$status_code <= 599) {
        return(local_var_response)
      }
    },

    #' @description
    #' Updated user
    #'
    #' @param username name that need to be deleted
    #' @param user Updated user object
    #' @param ... Other optional arguments
    #'
    #' @return API response (void) with additional information such as HTTP status code, headers
    update_user_with_http_info = function(username, user, ...) {
      args <- list(...)
      query_params <- list()
      header_params <- c()
      form_params <- list()
      file_params <- list()
      local_var_body <- NULL
      oauth_scopes <- NULL
      is_oauth <- FALSE

      if (missing(`username`)) {
        rlang::abort(message = "Missing required parameter `username`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `username`."))
      }

      if (missing(`user`)) {
        rlang::abort(message = "Missing required parameter `user`.",
                     .subclass = "ApiException",
                     ApiException = ApiException$new(status = 0,
                                                     reason = "Missing required parameter `user`."))
      }

      if (!missing(`username`) && is.null(`username`)) {
        rlang::abort(message = "Invalid value for `username` when calling UserApi$update_user, `username` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `username` when calling UserApi$update_user, `username` is not nullable"))
      }

      if (!missing(`user`) && is.null(`user`)) {
        rlang::abort(message = "Invalid value for `user` when calling UserApi$update_user, `user` is not nullable",
                     .subclass = "ApiException",
                      ApiException = ApiException$new(status = 0,
                      reason = "Invalid value for `user` when calling UserApi$update_user, `user` is not nullable"))
      }

      if (!is.null(`user`)) {
        local_var_body <- `user`$toJSONString()
      } else {
        local_var_body <- NULL
      }

      local_var_url_path <- "/user/{username}"
      if (!missing(`username`)) {
        local_var_url_path <- gsub("\\{username\\}", URLencode(as.character(`username`), reserved = TRUE), local_var_url_path)
      }

      # API key authentication
      if ("api_key" %in% names(self$api_client$api_keys) && nchar(self$api_client$api_keys["api_key"]) > 0) {
        header_params["api_key"] <- paste(unlist(self$api_client$api_keys["api_key"]), collapse = "")
      }

      # The Accept request HTTP header
      local_var_accepts <- list()

      # The Content-Type representation header
      local_var_content_types <- list("application/json")

      local_var_resp <- self$api_client$CallApi(url = paste0(self$api_client$base_path, local_var_url_path),
                                 method = "PUT",
                                 query_params = query_params,
                                 header_params = header_params,
                                 form_params = form_params,
                                 file_params = file_params,
                                 accepts = local_var_accepts,
                                 content_types = local_var_content_types,
                                 body = local_var_body,
                                 is_oauth = is_oauth,
                                 oauth_scopes = oauth_scopes,
                                 ...)

      if (local_var_resp$status_code >= 200 && local_var_resp$status_code <= 299) {
        local_var_resp$content <- NULL
        return(local_var_resp)
      } 
      
      local_var_error_msg <- local_var_resp$response_as_text()      
      if (local_var_resp$status_code >= 300 && local_var_resp$status_code <= 399) {
        
        if (local_var_error_msg == "") {
          local_var_error_msg <- paste("Server returned ", local_var_resp$status_code, " response status code.")
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 400 && local_var_resp$status_code <= 499) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api client exception encountered."
        }
        rlang::abort(message = local_var_error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      } else if (local_var_resp$status_code >= 500 && local_var_resp$status_code <= 599) {
        if (local_var_error_msg == "") {
          local_var_error_msg <- "Api server exception encountered."
        }
        rlang::abort(message = error_msg,
                     .subclass = "ApiException",
                     ApiException = ApiException$new(http_response = local_var_resp))
      }
    }
  )
)
