% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fake_api.R
\docType{class}
\name{FakeApi}
\alias{FakeApi}
\title{Fake operations}
\format{
An \code{R6Class} generator object
}
\description{
petstore.Fake
}
\details{
OpenAPI Petstore

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

The version of the OpenAPI document: 1.0.0
Generated by: https://openapi-generator.tech
}
\section{Methods}{

\describe{
\strong{ FakeDataFile } \emph{ test data_file to ensure it&#39;s escaped correctly }


\itemize{
\item \emph{ @param } dummy character
\item \emph{ @param } var_data_file character
\item \emph{ @returnType } \link{User} \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : User 
\item response headers :

\tabular{ll}{
}
}

}
}

\examples{
\dontrun{
####################  FakeDataFile  ####################

library(petstore)
var.dummy <- 'dummy_example' # character | dummy required parameter
var.var_data_file <- 'var_data_file_example' # character | header data file

#test data_file to ensure it's escaped correctly
api.instance <- FakeApi$new()

result <- tryCatch(
            api.instance$FakeDataFile(var.dummy, var_data_file=var.var_data_file),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{api_client}}{Handles the client-server communication.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FakeApi-new}{\code{FakeApi$new()}}
\item \href{#method-FakeApi-FakeDataFile}{\code{FakeApi$FakeDataFile()}}
\item \href{#method-FakeApi-FakeDataFileWithHttpInfo}{\code{FakeApi$FakeDataFileWithHttpInfo()}}
\item \href{#method-FakeApi-clone}{\code{FakeApi$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FakeApi-new"></a>}}
\if{latex}{\out{\hypertarget{method-FakeApi-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new FakeApi.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FakeApi$new(api_client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{An instance of API client.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FakeApi-FakeDataFile"></a>}}
\if{latex}{\out{\hypertarget{method-FakeApi-FakeDataFile}{}}}
\subsection{Method \code{FakeDataFile()}}{
test data_file to ensure it's escaped correctly
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FakeApi$FakeDataFile(dummy, var_data_file = NULL, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dummy}}{dummy required parameter}

\item{\code{var_data_file}}{(optional) header data file}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
User
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FakeApi-FakeDataFileWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-FakeApi-FakeDataFileWithHttpInfo}{}}}
\subsection{Method \code{FakeDataFileWithHttpInfo()}}{
test data_file to ensure it's escaped correctly
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FakeApi$FakeDataFileWithHttpInfo(
  dummy,
  var_data_file = NULL,
  data_file = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dummy}}{dummy required parameter}

\item{\code{var_data_file}}{(optional) header data file}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (User) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FakeApi-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FakeApi-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FakeApi$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
