% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pet_api.R
\docType{class}
\name{PetApi}
\alias{PetApi}
\title{Pet operations}
\format{
An \code{R6Class} generator object
}
\description{
petstore.Pet
}
\details{
OpenAPI Petstore

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

The version of the OpenAPI document: 1.0.0
Generated by: https://openapi-generator.tech
}
\section{Methods}{

\describe{
\strong{ AddPet } \emph{ Add a new pet to the store }


\itemize{
\item \emph{ @param } pet \link{Pet}
\item \emph{ @returnType } \link{Pet} \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : Pet 
\item response headers :

\tabular{ll}{
}
\item status code : 405 | Invalid input


\item response headers :

\tabular{ll}{
}
}

\strong{ DeletePet } \emph{ Deletes a pet }


\itemize{
\item \emph{ @param } pet_id integer
\item \emph{ @param } api_key character

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 400 | Invalid pet value


\item response headers :

\tabular{ll}{
}
}

\strong{ FindPetsByStatus } \emph{ Finds Pets by status }
Multiple status values can be provided with comma separated strings

\itemize{
\item \emph{ @param } status Enum < [available, pending, sold] >
\item \emph{ @returnType } list( \link{Pet} ) \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : array[Pet] 
\item response headers :

\tabular{ll}{
}
\item status code : 400 | Invalid status value


\item response headers :

\tabular{ll}{
}
}

\strong{ FindPetsByTags } \emph{ Finds Pets by tags }
Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.

\itemize{
\item \emph{ @param } tags list( character )
\item \emph{ @returnType } list( \link{Pet} ) \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : array[Pet] 
\item response headers :

\tabular{ll}{
}
\item status code : 400 | Invalid tag value


\item response headers :

\tabular{ll}{
}
}

\strong{ GetPetById } \emph{ Find pet by ID }
Returns a single pet

\itemize{
\item \emph{ @param } pet_id integer
\item \emph{ @returnType } \link{Pet} \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : Pet 
\item response headers :

\tabular{ll}{
}
\item status code : 400 | Invalid ID supplied


\item response headers :

\tabular{ll}{
}
\item status code : 404 | Pet not found


\item response headers :

\tabular{ll}{
}
}

\strong{ GetPetByIdStreaming } \emph{ Find pet by ID (streaming) }
Returns a single pet

\itemize{
\item \emph{ @param } pet_id integer
\item \emph{ @returnType } \link{Pet} \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : Pet 
\item response headers :

\tabular{ll}{
}
\item status code : 400 | Invalid ID supplied


\item response headers :

\tabular{ll}{
}
\item status code : 404 | Pet not found


\item response headers :

\tabular{ll}{
}
}

\strong{ UpdatePet } \emph{ Update an existing pet }


\itemize{
\item \emph{ @param } pet \link{Pet}
\item \emph{ @returnType } \link{Pet} \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : Pet 
\item response headers :

\tabular{ll}{
}
\item status code : 400 | Invalid ID supplied


\item response headers :

\tabular{ll}{
}
\item status code : 404 | Pet not found


\item response headers :

\tabular{ll}{
}
\item status code : 405 | Validation exception


\item response headers :

\tabular{ll}{
}
}

\strong{ UpdatePetWithForm } \emph{ Updates a pet in the store with form data }


\itemize{
\item \emph{ @param } pet_id integer
\item \emph{ @param } name character
\item \emph{ @param } status character

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 405 | Invalid input


\item response headers :

\tabular{ll}{
}
}

\strong{ UploadFile } \emph{ uploads an image }


\itemize{
\item \emph{ @param } pet_id integer
\item \emph{ @param } additional_metadata character
\item \emph{ @param } file data.frame
\item \emph{ @returnType } \link{ModelApiResponse} \cr

\item On encountering errors, an error of subclass ApiException will be thrown.

\item status code : 200 | successful operation

\item return type : ModelApiResponse 
\item response headers :

\tabular{ll}{
}
}

}
}

\examples{
\dontrun{
####################  AddPet  ####################

library(petstore)
var.pet <- Pet$new() # Pet | Pet object that needs to be added to the store

#Add a new pet to the store
api.instance <- PetApi$new()

# Configure OAuth2 access token for authorization: petstore_auth
api.instance$api_client$access_token <- 'TODO_YOUR_ACCESS_TOKEN';

result <- tryCatch(
            api.instance$AddPet(var.pet),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  DeletePet  ####################

library(petstore)
var.pet_id <- 56 # integer | Pet id to delete
var.api_key <- 'api_key_example' # character | 

#Deletes a pet
api.instance <- PetApi$new()

# Configure OAuth2 access token for authorization: petstore_auth
api.instance$api_client$access_token <- 'TODO_YOUR_ACCESS_TOKEN';

result <- tryCatch(
            api.instance$DeletePet(var.pet_id, api_key=var.api_key),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  FindPetsByStatus  ####################

library(petstore)
var.status <- ['status_example'] # array[character] | Status values that need to be considered for filter

#Finds Pets by status
api.instance <- PetApi$new()

# Configure OAuth2 access token for authorization: petstore_auth
api.instance$api_client$access_token <- 'TODO_YOUR_ACCESS_TOKEN';

result <- tryCatch(
            api.instance$FindPetsByStatus(var.status),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  FindPetsByTags  ####################

library(petstore)
var.tags <- ['tags_example'] # array[character] | Tags to filter by

#Finds Pets by tags
api.instance <- PetApi$new()

# Configure OAuth2 access token for authorization: petstore_auth
api.instance$api_client$access_token <- 'TODO_YOUR_ACCESS_TOKEN';

result <- tryCatch(
            api.instance$FindPetsByTags(var.tags),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  GetPetById  ####################

library(petstore)
var.pet_id <- 56 # integer | ID of pet to return

#Find pet by ID
api.instance <- PetApi$new()

#Configure API key authorization: api_key
api.instance$api_client$api_keys['api_key'] <- 'TODO_YOUR_API_KEY';

result <- tryCatch(
            api.instance$GetPetById(var.pet_id),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  GetPetByIdStreaming  ####################

library(petstore)
var.pet_id <- 56 # integer | ID of pet to return

#Find pet by ID (streaming)
api.instance <- PetApi$new()

#Configure API key authorization: api_key
api.instance$api_client$api_keys['api_key'] <- 'TODO_YOUR_API_KEY';

result <- tryCatch(
            api.instance$GetPetByIdStreaming(var.pet_id),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  UpdatePet  ####################

library(petstore)
var.pet <- Pet$new() # Pet | Pet object that needs to be added to the store

#Update an existing pet
api.instance <- PetApi$new()

# Configure OAuth2 access token for authorization: petstore_auth
api.instance$api_client$access_token <- 'TODO_YOUR_ACCESS_TOKEN';

result <- tryCatch(
            api.instance$UpdatePet(var.pet),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  UpdatePetWithForm  ####################

library(petstore)
var.pet_id <- 56 # integer | ID of pet that needs to be updated
var.name <- 'name_example' # character | Updated name of the pet
var.status <- 'status_example' # character | Updated status of the pet

#Updates a pet in the store with form data
api.instance <- PetApi$new()

# Configure OAuth2 access token for authorization: petstore_auth
api.instance$api_client$access_token <- 'TODO_YOUR_ACCESS_TOKEN';

result <- tryCatch(
            api.instance$UpdatePetWithForm(var.pet_id, name=var.name, status=var.status),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


####################  UploadFile  ####################

library(petstore)
var.pet_id <- 56 # integer | ID of pet to update
var.additional_metadata <- 'additional_metadata_example' # character | Additional data to pass to server
var.file <- File.new('/path/to/file') # data.frame | file to upload

#uploads an image
api.instance <- PetApi$new()

# Configure OAuth2 access token for authorization: petstore_auth
api.instance$api_client$access_token <- 'TODO_YOUR_ACCESS_TOKEN';

result <- tryCatch(
            api.instance$UploadFile(var.pet_id, additional_metadata=var.additional_metadata, file=var.file),
            ApiException = function(ex) ex
         )
# In case of error, print the error object
if(!is.null(result$ApiException)) {
  cat(result$ApiException$toString())
} else {
# deserialized response object
response.object <- result$content
# response headers
response.headers <- result$response$headers
# response status code
response.status.code <- result$response$status_code
}


}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{api_client}}{Handles the client-server communication.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PetApi-new}{\code{PetApi$new()}}
\item \href{#method-PetApi-AddPet}{\code{PetApi$AddPet()}}
\item \href{#method-PetApi-AddPetWithHttpInfo}{\code{PetApi$AddPetWithHttpInfo()}}
\item \href{#method-PetApi-DeletePet}{\code{PetApi$DeletePet()}}
\item \href{#method-PetApi-DeletePetWithHttpInfo}{\code{PetApi$DeletePetWithHttpInfo()}}
\item \href{#method-PetApi-FindPetsByStatus}{\code{PetApi$FindPetsByStatus()}}
\item \href{#method-PetApi-FindPetsByStatusWithHttpInfo}{\code{PetApi$FindPetsByStatusWithHttpInfo()}}
\item \href{#method-PetApi-FindPetsByTags}{\code{PetApi$FindPetsByTags()}}
\item \href{#method-PetApi-FindPetsByTagsWithHttpInfo}{\code{PetApi$FindPetsByTagsWithHttpInfo()}}
\item \href{#method-PetApi-GetPetById}{\code{PetApi$GetPetById()}}
\item \href{#method-PetApi-GetPetByIdWithHttpInfo}{\code{PetApi$GetPetByIdWithHttpInfo()}}
\item \href{#method-PetApi-GetPetByIdStreaming}{\code{PetApi$GetPetByIdStreaming()}}
\item \href{#method-PetApi-GetPetByIdStreamingWithHttpInfo}{\code{PetApi$GetPetByIdStreamingWithHttpInfo()}}
\item \href{#method-PetApi-UpdatePet}{\code{PetApi$UpdatePet()}}
\item \href{#method-PetApi-UpdatePetWithHttpInfo}{\code{PetApi$UpdatePetWithHttpInfo()}}
\item \href{#method-PetApi-UpdatePetWithForm}{\code{PetApi$UpdatePetWithForm()}}
\item \href{#method-PetApi-UpdatePetWithFormWithHttpInfo}{\code{PetApi$UpdatePetWithFormWithHttpInfo()}}
\item \href{#method-PetApi-UploadFile}{\code{PetApi$UploadFile()}}
\item \href{#method-PetApi-UploadFileWithHttpInfo}{\code{PetApi$UploadFileWithHttpInfo()}}
\item \href{#method-PetApi-clone}{\code{PetApi$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-new"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new PetApi.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$new(api_client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{An instance of API client.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-AddPet"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-AddPet}{}}}
\subsection{Method \code{AddPet()}}{
Add a new pet to the store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$AddPet(pet, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet}}{Pet object that needs to be added to the store}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Pet
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-AddPetWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-AddPetWithHttpInfo}{}}}
\subsection{Method \code{AddPetWithHttpInfo()}}{
Add a new pet to the store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$AddPetWithHttpInfo(pet, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet}}{Pet object that needs to be added to the store}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (Pet) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-DeletePet"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-DeletePet}{}}}
\subsection{Method \code{DeletePet()}}{
Deletes a pet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$DeletePet(pet_id, api_key = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{Pet id to delete}

\item{\code{api_key}}{(optional)}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
void
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-DeletePetWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-DeletePetWithHttpInfo}{}}}
\subsection{Method \code{DeletePetWithHttpInfo()}}{
Deletes a pet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$DeletePetWithHttpInfo(pet_id, api_key = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{Pet id to delete}

\item{\code{api_key}}{(optional)}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (void) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-FindPetsByStatus"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-FindPetsByStatus}{}}}
\subsection{Method \code{FindPetsByStatus()}}{
Finds Pets by status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$FindPetsByStatus(status, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{Status values that need to be considered for filter}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
array[Pet]
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-FindPetsByStatusWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-FindPetsByStatusWithHttpInfo}{}}}
\subsection{Method \code{FindPetsByStatusWithHttpInfo()}}{
Finds Pets by status
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$FindPetsByStatusWithHttpInfo(status, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{Status values that need to be considered for filter}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (array[Pet]) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-FindPetsByTags"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-FindPetsByTags}{}}}
\subsection{Method \code{FindPetsByTags()}}{
Finds Pets by tags
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$FindPetsByTags(tags, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tags}}{Tags to filter by}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
array[Pet]
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-FindPetsByTagsWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-FindPetsByTagsWithHttpInfo}{}}}
\subsection{Method \code{FindPetsByTagsWithHttpInfo()}}{
Finds Pets by tags
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$FindPetsByTagsWithHttpInfo(tags, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tags}}{Tags to filter by}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (array[Pet]) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-GetPetById"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-GetPetById}{}}}
\subsection{Method \code{GetPetById()}}{
Find pet by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$GetPetById(pet_id, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{ID of pet to return}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Pet
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-GetPetByIdWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-GetPetByIdWithHttpInfo}{}}}
\subsection{Method \code{GetPetByIdWithHttpInfo()}}{
Find pet by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$GetPetByIdWithHttpInfo(pet_id, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{ID of pet to return}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (Pet) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-GetPetByIdStreaming"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-GetPetByIdStreaming}{}}}
\subsection{Method \code{GetPetByIdStreaming()}}{
Find pet by ID (streaming)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$GetPetByIdStreaming(
  pet_id,
  stream_callback = NULL,
  data_file = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{ID of pet to return}

\item{\code{stream_callback}}{(optional) callback function to process the data stream}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Pet
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-GetPetByIdStreamingWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-GetPetByIdStreamingWithHttpInfo}{}}}
\subsection{Method \code{GetPetByIdStreamingWithHttpInfo()}}{
Find pet by ID (streaming)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$GetPetByIdStreamingWithHttpInfo(
  pet_id,
  stream_callback = NULL,
  data_file = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{ID of pet to return}

\item{\code{stream_callback}}{(optional) callback function to process the data stream}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (Pet) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-UpdatePet"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-UpdatePet}{}}}
\subsection{Method \code{UpdatePet()}}{
Update an existing pet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$UpdatePet(pet, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet}}{Pet object that needs to be added to the store}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Pet
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-UpdatePetWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-UpdatePetWithHttpInfo}{}}}
\subsection{Method \code{UpdatePetWithHttpInfo()}}{
Update an existing pet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$UpdatePetWithHttpInfo(pet, data_file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet}}{Pet object that needs to be added to the store}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (Pet) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-UpdatePetWithForm"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-UpdatePetWithForm}{}}}
\subsection{Method \code{UpdatePetWithForm()}}{
Updates a pet in the store with form data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$UpdatePetWithForm(pet_id, name = NULL, status = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{ID of pet that needs to be updated}

\item{\code{name}}{(optional) Updated name of the pet}

\item{\code{status}}{(optional) Updated status of the pet}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
void
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-UpdatePetWithFormWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-UpdatePetWithFormWithHttpInfo}{}}}
\subsection{Method \code{UpdatePetWithFormWithHttpInfo()}}{
Updates a pet in the store with form data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$UpdatePetWithFormWithHttpInfo(pet_id, name = NULL, status = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{ID of pet that needs to be updated}

\item{\code{name}}{(optional) Updated name of the pet}

\item{\code{status}}{(optional) Updated status of the pet}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (void) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-UploadFile"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-UploadFile}{}}}
\subsection{Method \code{UploadFile()}}{
uploads an image
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$UploadFile(
  pet_id,
  additional_metadata = NULL,
  file = NULL,
  data_file = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{ID of pet to update}

\item{\code{additional_metadata}}{(optional) Additional data to pass to server}

\item{\code{file}}{(optional) file to upload}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ModelApiResponse
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-UploadFileWithHttpInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-UploadFileWithHttpInfo}{}}}
\subsection{Method \code{UploadFileWithHttpInfo()}}{
uploads an image
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$UploadFileWithHttpInfo(
  pet_id,
  additional_metadata = NULL,
  file = NULL,
  data_file = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pet_id}}{ID of pet to update}

\item{\code{additional_metadata}}{(optional) Additional data to pass to server}

\item{\code{file}}{(optional) file to upload}

\item{\code{data_file}}{(optional) name of the data file to save the result}

\item{\code{...}}{Other optional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
API response (ModelApiResponse) with additional information such as HTTP status code, headers
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PetApi-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PetApi-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PetApi$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
