/*
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the OAS code generator program.
 * https://github.com/OpenAPITools/openapi-generator
 * Do not edit the class manually.
 */

public class OASUserApi {
    OASClient client;

    public OASUserApi(OASClient client) {
        this.client = client;
    }

    public OASUserApi() {
        this.client = new OASClient();
    }

    public OASClient getClient() {
        return this.client;
    }

    /**
     * Create user
     * This can only be done by the logged in user.
     * @param oaSUser Created user object (required)
     * @throws OAS.ApiException if fails to make API call
     */
    public void createUser(Map<String, Object> params) {
        client.assertNotNull(params.get('oaSUser'), 'oaSUser');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'POST', '/user',
            (OASUser) params.get('oaSUser'),
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>(),
            new List<String>{ 'application/json' },
            new List<String> { 'api_key' },
            null
        );
    }
    /**
     * Creates list of users with given input array
     * 
     * @param oaSUser List of user object (required)
     * @throws OAS.ApiException if fails to make API call
     */
    public void createUsersWithArrayInput(Map<String, Object> params) {
        client.assertNotNull(params.get('oaSUser'), 'oaSUser');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'POST', '/user/createWithArray',
            (List<OASUser>) params.get('oaSUser'),
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>(),
            new List<String>{ 'application/json' },
            new List<String> { 'api_key' },
            null
        );
    }
    /**
     * Creates list of users with given input array
     * 
     * @param oaSUser List of user object (required)
     * @throws OAS.ApiException if fails to make API call
     */
    public void createUsersWithListInput(Map<String, Object> params) {
        client.assertNotNull(params.get('oaSUser'), 'oaSUser');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'POST', '/user/createWithList',
            (List<OASUser>) params.get('oaSUser'),
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>(),
            new List<String>{ 'application/json' },
            new List<String> { 'api_key' },
            null
        );
    }
    /**
     * Delete user
     * This can only be done by the logged in user.
     * @param username The name that needs to be deleted (required)
     * @throws OAS.ApiException if fails to make API call
     */
    public void deleteUser(Map<String, Object> params) {
        client.assertNotNull(params.get('username'), 'username');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'DELETE', '/user/{username}', '',
            query, form,
            new Map<String, Object>{
                'username' => (String) params.get('username')
            },
            new Map<String, Object>(),
            new List<String>(),
            new List<String>(),
            new List<String> { 'api_key' },
            null
        );
    }
    /**
     * Get user by user name
     * 
     * @param username The name that needs to be fetched. Use user1 for testing. (required)
     * @return OASUser
     * @throws OAS.ApiException if fails to make API call
     */
    public OASUser getUserByName(Map<String, Object> params) {
        client.assertNotNull(params.get('username'), 'username');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        return (OASUser) client.invoke(
            'GET', '/user/{username}', '',
            query, form,
            new Map<String, Object>{
                'username' => (String) params.get('username')
            },
            new Map<String, Object>(),
            new List<String>{ 'application/xml', 'application/json' },
            new List<String>(),
            new List<String>(),
            OASUser.class
        );
    }
    /**
     * Logs user into the system
     * 
     * @param username The user name for login (required)
     * @param password The password for login in clear text (required)
     * @return String
     * @throws OAS.ApiException if fails to make API call
     */
    public String loginUser(Map<String, Object> params) {
        client.assertNotNull(params.get('username'), 'username');
        client.assertNotNull(params.get('password'), 'password');
        List<OAS.Param> query = new List<OAS.Param>();

        // cast query params to verify their expected type
        query.addAll(client.makeParam('username', (String) params.get('username')));
        query.addAll(client.makeParam('password', (String) params.get('password')));

        List<OAS.Param> form = new List<OAS.Param>();

        return (String) client.invoke(
            'GET', '/user/login', '',
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>{ 'application/xml', 'application/json' },
            new List<String>(),
            new List<String>(),
            String.class
        );
    }
    /**
     * Logs out current logged in user session
     * 
     * @throws OAS.ApiException if fails to make API call
     */
    public void logoutUser() {
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'GET', '/user/logout', '',
            query, form,
            new Map<String, Object>(),
            new Map<String, Object>(),
            new List<String>(),
            new List<String>(),
            new List<String> { 'api_key' },
            null
        );
    }
    /**
     * Updated user
     * This can only be done by the logged in user.
     * @param username name that need to be deleted (required)
     * @param oaSUser Updated user object (required)
     * @throws OAS.ApiException if fails to make API call
     */
    public void updateUser(Map<String, Object> params) {
        client.assertNotNull(params.get('username'), 'username');
        client.assertNotNull(params.get('oaSUser'), 'oaSUser');
        List<OAS.Param> query = new List<OAS.Param>();
        List<OAS.Param> form = new List<OAS.Param>();

        client.invoke(
            'PUT', '/user/{username}',
            (OASUser) params.get('oaSUser'),
            query, form,
            new Map<String, Object>{
                'username' => (String) params.get('username')
            },
            new Map<String, Object>(),
            new List<String>(),
            new List<String>{ 'application/json' },
            new List<String> { 'api_key' },
            null
        );
    }
}
