/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/

#include "oatpp/web/client/HttpRequestExecutor.hpp"
#include "oatpp/parser/json/mapping/ObjectMapper.hpp"
#include "oatpp/network/tcp/client/ConnectionProvider.hpp"


#include "PetApi.hpp"
#include "StoreApi.hpp"
#include "UserApi.hpp"

static int _main_app(void) {
  /* create connection provider */
  auto connectionProvider = oatpp::network::tcp::client::ConnectionProvider::createShared({"localhost", 8080, oatpp::network::Address::IP_4});

  /* create HTTP request executor */
  auto requestExecutor = oatpp::web::client::HttpRequestExecutor::createShared(connectionProvider);

  /* create JSON object mapper */
  auto objectMapper = oatpp::parser::json::mapping::ObjectMapper::createShared();


  /* create API client */
  auto PetApiClient = org::openapitools::client::api::PetApi::createShared(requestExecutor, objectMapper);

  /* create API client */
  auto StoreApiClient = org::openapitools::client::api::StoreApi::createShared(requestExecutor, objectMapper);

  /* create API client */
  auto UserApiClient = org::openapitools::client::api::UserApi::createShared(requestExecutor, objectMapper);


  return 0;
}

int main(int argc, char **argv) {
  /* Init oatpp Environment */
  oatpp::base::Environment::init();

  int ret = _main_app();

  /* Destroy oatpp Environment */
  oatpp::base::Environment::destroy();

  return ret;
}
