# #OpenAPI Petstore
#
##This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
#
#The version of the OpenAPI document: 1.0.0
#
#Generated by: https://openapi-generator.tech
#Generator version: 7.20.0-SNAPSHOT
#

module Petstore
  class FormatTest
    include JSON::Serializable
    include YAML::Serializable

    # Required properties
    @[JSON::Field(key: "number", type: Float64, nillable: false, emit_null: false)]
    property number : Float64

    @[JSON::Field(key: "byte", type: String, nillable: false, emit_null: false)]
    property byte : String

    @[JSON::Field(key: "date", type: Time, nillable: false, emit_null: false)]
    property date : Time

    @[JSON::Field(key: "password", type: String, nillable: false, emit_null: false)]
    property password : String

    # Optional properties
    @[JSON::Field(key: "integer", type: Int32?, nillable: true, emit_null: false)]
    property integer : Int32?

    @[JSON::Field(key: "int32", type: Int32?, nillable: true, emit_null: false)]
    property int32 : Int32?

    @[JSON::Field(key: "int64", type: Int64?, nillable: true, emit_null: false)]
    property int64 : Int64?

    @[JSON::Field(key: "float", type: Float32?, nillable: true, emit_null: false)]
    property float : Float32?

    @[JSON::Field(key: "double", type: Float64?, nillable: true, emit_null: false)]
    property double : Float64?

    @[JSON::Field(key: "decimal", type: BigDecimal?, nillable: true, emit_null: false)]
    property decimal : BigDecimal?

    @[JSON::Field(key: "string", type: String?, nillable: true, emit_null: false)]
    property string : String?

    @[JSON::Field(key: "binary", type: ::File?, nillable: true, emit_null: false)]
    property binary : ::File?

    @[JSON::Field(key: "dateTime", type: Time?, nillable: true, emit_null: false)]
    property date_time : Time?

    @[JSON::Field(key: "uuid", type: String?, nillable: true, emit_null: false)]
    property uuid : String?

    # A string that is a 10 digit number. Can have leading zeros.
    @[JSON::Field(key: "pattern_with_digits", type: String?, nillable: true, emit_null: false)]
    property pattern_with_digits : String?

    # A string starting with 'image_' (case insensitive) and one to three digits following i.e. Image_01.
    @[JSON::Field(key: "pattern_with_digits_and_delimiter", type: String?, nillable: true, emit_null: false)]
    property pattern_with_digits_and_delimiter : String?

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(@number : Float64, @byte : String, @date : Time, @password : String, @integer : Int32? = nil, @int32 : Int32? = nil, @int64 : Int64? = nil, @float : Float32? = nil, @double : Float64? = nil, @decimal : BigDecimal? = nil, @string : String? = nil, @binary : ::File? = nil, @date_time : Time? = nil, @uuid : String? = nil, @pattern_with_digits : String? = nil, @pattern_with_digits_and_delimiter : String? = nil)
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      invalid_properties = Array(String).new
      if !@integer.nil? && @integer.try &.> 100
        invalid_properties.push("invalid value for \"integer\", must be smaller than or equal to 100.")
      end

      if !@integer.nil? && @integer.try &.< 10
        invalid_properties.push("invalid value for \"integer\", must be greater than or equal to 10.")
      end

      if !@int32.nil? && @int32.try &.> 200
        invalid_properties.push("invalid value for \"int32\", must be smaller than or equal to 200.")
      end

      if !@int32.nil? && @int32.try &.< 20
        invalid_properties.push("invalid value for \"int32\", must be greater than or equal to 20.")
      end

      if @number.try &.> 543.2
        invalid_properties.push("invalid value for \"number\", must be smaller than or equal to 543.2.")
      end

      if @number.try &.< 32.1
        invalid_properties.push("invalid value for \"number\", must be greater than or equal to 32.1.")
      end

      if !@float.nil? && @float.try &.> 987.6
        invalid_properties.push("invalid value for \"float\", must be smaller than or equal to 987.6.")
      end

      if !@float.nil? && @float.try &.< 54.3
        invalid_properties.push("invalid value for \"float\", must be greater than or equal to 54.3.")
      end

      if !@double.nil? && @double.try &.> 123.4
        invalid_properties.push("invalid value for \"double\", must be smaller than or equal to 123.4.")
      end

      if !@double.nil? && @double.try &.< 67.8
        invalid_properties.push("invalid value for \"double\", must be greater than or equal to 67.8.")
      end

      pattern = /[a-z]/i
      if !@string.nil? && @string.try &.!~ pattern
        invalid_properties.push("invalid value for \"string\", must conform to the pattern #{pattern}.")
      end

      if @password.try &.to_s.try &.size.try &.> 64
        invalid_properties.push("invalid value for \"password\", the character length must be smaller than or equal to 64.")
      end

      if @password.try &.to_s.try &.size.try &.< 10
        invalid_properties.push("invalid value for \"password\", the character length must be greater than or equal to 10.")
      end

      pattern = /^\d{10}$/
      if !@pattern_with_digits.nil? && @pattern_with_digits.try &.!~ pattern
        invalid_properties.push("invalid value for \"pattern_with_digits\", must conform to the pattern #{pattern}.")
      end

      pattern = /^image_\d{1,3}$/i
      if !@pattern_with_digits_and_delimiter.nil? && @pattern_with_digits_and_delimiter.try &.!~ pattern
        invalid_properties.push("invalid value for \"pattern_with_digits_and_delimiter\", must conform to the pattern #{pattern}.")
      end

      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      return false if !@integer.nil? && @integer.try &.> 100
      return false if !@integer.nil? && @integer.try &.< 10
      return false if !@int32.nil? && @int32.try &.> 200
      return false if !@int32.nil? && @int32.try &.< 20
      return false if @number.try &.> 543.2
      return false if @number.try &.< 32.1
      return false if !@float.nil? && @float.try &.> 987.6
      return false if !@float.nil? && @float.try &.< 54.3
      return false if !@double.nil? && @double.try &.> 123.4
      return false if !@double.nil? && @double.try &.< 67.8
      return false if !@string.nil? && @string.try &.!~ /[a-z]/i
      return false if @password.try &.to_s.try &.size.try &.> 64
      return false if @password.try &.to_s.try &.size.try &.< 10
      return false if !@pattern_with_digits.nil? && @pattern_with_digits.try &.!~ /^\d{10}$/
      return false if !@pattern_with_digits_and_delimiter.nil? && @pattern_with_digits_and_delimiter.try &.!~ /^image_\d{1,3}$/i
      true
    end

    # Custom attribute writer method with validation
    # @param [Object] integer Value to be assigned
    def integer=(integer)
      if !integer.nil? && integer > 100
        raise ArgumentError.new("invalid value for \"integer\", must be smaller than or equal to 100.")
      end

      if !integer.nil? && integer < 10
        raise ArgumentError.new("invalid value for \"integer\", must be greater than or equal to 10.")
      end

      @integer = integer
    end

    # Custom attribute writer method with validation
    # @param [Object] int32 Value to be assigned
    def int32=(int32)
      if !int32.nil? && int32 > 200
        raise ArgumentError.new("invalid value for \"int32\", must be smaller than or equal to 200.")
      end

      if !int32.nil? && int32 < 20
        raise ArgumentError.new("invalid value for \"int32\", must be greater than or equal to 20.")
      end

      @int32 = int32
    end

    # Custom attribute writer method with validation
    # @param [Object] number Value to be assigned
    def number=(number)
      if number > 543.2
        raise ArgumentError.new("invalid value for \"number\", must be smaller than or equal to 543.2.")
      end

      if number < 32.1
        raise ArgumentError.new("invalid value for \"number\", must be greater than or equal to 32.1.")
      end

      @number = number
    end

    # Custom attribute writer method with validation
    # @param [Object] float Value to be assigned
    def float=(float)
      if !float.nil? && float > 987.6
        raise ArgumentError.new("invalid value for \"float\", must be smaller than or equal to 987.6.")
      end

      if !float.nil? && float < 54.3
        raise ArgumentError.new("invalid value for \"float\", must be greater than or equal to 54.3.")
      end

      @float = float
    end

    # Custom attribute writer method with validation
    # @param [Object] double Value to be assigned
    def double=(double)
      if !double.nil? && double > 123.4
        raise ArgumentError.new("invalid value for \"double\", must be smaller than or equal to 123.4.")
      end

      if !double.nil? && double < 67.8
        raise ArgumentError.new("invalid value for \"double\", must be greater than or equal to 67.8.")
      end

      @double = double
    end

    # Custom attribute writer method with validation
    # @param [Object] string Value to be assigned
    def string=(string)
      pattern = /[a-z]/i
      if !string.nil? && string !~ pattern
        raise ArgumentError.new("invalid value for \"string\", must conform to the pattern #{pattern}.")
      end

      @string = string
    end

    # Custom attribute writer method with validation
    # @param [Object] password Value to be assigned
    def password=(password)
      if password.to_s.size > 64
        raise ArgumentError.new("invalid value for \"password\", the character length must be smaller than or equal to 64.")
      end

      if password.to_s.size < 10
        raise ArgumentError.new("invalid value for \"password\", the character length must be greater than or equal to 10.")
      end

      @password = password
    end

    # Custom attribute writer method with validation
    # @param [Object] pattern_with_digits Value to be assigned
    def pattern_with_digits=(pattern_with_digits)
      pattern = /^\d{10}$/
      if !pattern_with_digits.nil? && pattern_with_digits !~ pattern
        raise ArgumentError.new("invalid value for \"pattern_with_digits\", must conform to the pattern #{pattern}.")
      end

      @pattern_with_digits = pattern_with_digits
    end

    # Custom attribute writer method with validation
    # @param [Object] pattern_with_digits_and_delimiter Value to be assigned
    def pattern_with_digits_and_delimiter=(pattern_with_digits_and_delimiter)
      pattern = /^image_\d{1,3}$/i
      if !pattern_with_digits_and_delimiter.nil? && pattern_with_digits_and_delimiter !~ pattern
        raise ArgumentError.new("invalid value for \"pattern_with_digits_and_delimiter\", must conform to the pattern #{pattern}.")
      end

      @pattern_with_digits_and_delimiter = pattern_with_digits_and_delimiter
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(other)
      return true if self.same?(other)
      self.class == other.class &&
          integer == other.integer &&
          int32 == other.int32 &&
          int64 == other.int64 &&
          number == other.number &&
          float == other.float &&
          double == other.double &&
          decimal == other.decimal &&
          string == other.string &&
          byte == other.byte &&
          binary == other.binary &&
          date == other.date &&
          date_time == other.date_time &&
          uuid == other.uuid &&
          password == other.password &&
          pattern_with_digits == other.pattern_with_digits &&
          pattern_with_digits_and_delimiter == other.pattern_with_digits_and_delimiter
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(other)
      self == other
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [integer, int32, int64, number, float, double, decimal, string, byte, binary, date, date_time, uuid, password, pattern_with_digits, pattern_with_digits_and_delimiter].hash
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_h.to_s
    end

    # to_body is an alias to to_h (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_h
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_h
      hash = NetboxClient::RecursiveHash.new
      hash["integer"] = _to_h(integer)
      hash["int32"] = _to_h(int32)
      hash["int64"] = _to_h(int64)
      hash["number"] = _to_h(number)
      hash["float"] = _to_h(float)
      hash["double"] = _to_h(double)
      hash["decimal"] = _to_h(decimal)
      hash["string"] = _to_h(string)
      hash["byte"] = _to_h(byte)
      hash["binary"] = _to_h(binary)
      hash["date"] = _to_h(date)
      hash["dateTime"] = _to_h(date_time)
      hash["uuid"] = _to_h(uuid)
      hash["password"] = _to_h(password)
      hash["pattern_with_digits"] = _to_h(pattern_with_digits)
      hash["pattern_with_digits_and_delimiter"] = _to_h(pattern_with_digits_and_delimiter)
      hash.to_h
    end

    # Outputs non-array value in the form of hash
    # For object, use to_h. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    private def _to_h(value)
      return nil if value.nil?

      if value.is_a?(Hash)
        hash = NetboxClient::RecursiveHash.new
        value.each { |k, v| hash[k] = _to_h(v) }
        hash
      elsif value.is_a?(Array)
        value.compact.map { |v| _to_h(v) }
      elsif value.responds_to?(:to_h)
        value.to_h
      else
        value
      end
    end

  end

end
