/*
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using OpenAPIDateConverter = Org.OpenAPITools.Client.OpenAPIDateConverter;

namespace Org.OpenAPITools.Model
{
    /// <summary>
    /// Model for testing model name same as property name
    /// </summary>
    [DataContract(Name = "Name")]
    public partial class Name : IEquatable<Name>
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Name" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Name() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Name" /> class.
        /// </summary>
        /// <param name="varName">varName (required).</param>
        /// <param name="property">property.</param>
        public Name(int varName = default, string property = default)
        {
            this.VarName = varName;
            this.Property = property;
        }

        /// <summary>
        /// Gets or Sets VarName
        /// </summary>
        [DataMember(Name = "name", IsRequired = true, EmitDefaultValue = true)]
        public int VarName { get; set; }

        /// <summary>
        /// Gets or Sets SnakeCase
        /// </summary>
        [DataMember(Name = "snake_case", EmitDefaultValue = false)]
        public int SnakeCase { get; private set; }

        /// <summary>
        /// Returns false as SnakeCase should not be serialized given that it's read-only.
        /// </summary>
        /// <returns>false (boolean)</returns>
        public bool ShouldSerializeSnakeCase()
        {
            return false;
        }
        /// <summary>
        /// Gets or Sets Property
        /// </summary>
        [DataMember(Name = "property", EmitDefaultValue = false)]
        public string Property { get; set; }

        /// <summary>
        /// Gets or Sets Var123Number
        /// </summary>
        [DataMember(Name = "123Number", EmitDefaultValue = false)]
        public int Var123Number { get; private set; }

        /// <summary>
        /// Returns false as Var123Number should not be serialized given that it's read-only.
        /// </summary>
        /// <returns>false (boolean)</returns>
        public bool ShouldSerializeVar123Number()
        {
            return false;
        }
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Name {\n");
            sb.Append("  VarName: ").Append(VarName).Append("\n");
            sb.Append("  SnakeCase: ").Append(SnakeCase).Append("\n");
            sb.Append("  Property: ").Append(Property).Append("\n");
            sb.Append("  Var123Number: ").Append(Var123Number).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as Name);
        }

        /// <summary>
        /// Returns true if Name instances are equal
        /// </summary>
        /// <param name="input">Instance of Name to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Name input)
        {
            if (input == null)
            {
                return false;
            }
            return 
                (
                    this.VarName == input.VarName ||
                    this.VarName.Equals(input.VarName)
                ) && 
                (
                    this.SnakeCase == input.SnakeCase ||
                    this.SnakeCase.Equals(input.SnakeCase)
                ) && 
                (
                    this.Property == input.Property ||
                    (this.Property != null &&
                    this.Property.Equals(input.Property))
                ) && 
                (
                    this.Var123Number == input.Var123Number ||
                    this.Var123Number.Equals(input.Var123Number)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                hashCode = (hashCode * 59) + this.VarName.GetHashCode();
                hashCode = (hashCode * 59) + this.SnakeCase.GetHashCode();
                if (this.Property != null)
                {
                    hashCode = (hashCode * 59) + this.Property.GetHashCode();
                }
                hashCode = (hashCode * 59) + this.Var123Number.GetHashCode();
                return hashCode;
            }
        }

    }

}
