/*
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using OpenAPIDateConverter = Org.OpenAPITools.Client.OpenAPIDateConverter;

namespace Org.OpenAPITools.Model
{
    /// <summary>
    /// Whale
    /// </summary>
    [DataContract(Name = "whale")]
    public partial class Whale : IEquatable<Whale>
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Whale" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Whale() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Whale" /> class.
        /// </summary>
        /// <param name="hasBaleen">hasBaleen.</param>
        /// <param name="hasTeeth">hasTeeth.</param>
        /// <param name="className">className (required).</param>
        public Whale(bool hasBaleen = default, bool hasTeeth = default, string className = default)
        {
            // to ensure "className" is required (not null)
            if (className == null)
            {
                throw new ArgumentNullException("className is a required property for Whale and cannot be null");
            }
            this.ClassName = className;
            this.HasBaleen = hasBaleen;
            this.HasTeeth = hasTeeth;
        }

        /// <summary>
        /// Gets or Sets HasBaleen
        /// </summary>
        [DataMember(Name = "hasBaleen", EmitDefaultValue = true)]
        public bool HasBaleen { get; set; }

        /// <summary>
        /// Gets or Sets HasTeeth
        /// </summary>
        [DataMember(Name = "hasTeeth", EmitDefaultValue = true)]
        public bool HasTeeth { get; set; }

        /// <summary>
        /// Gets or Sets ClassName
        /// </summary>
        [DataMember(Name = "className", IsRequired = true, EmitDefaultValue = true)]
        public string ClassName { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Whale {\n");
            sb.Append("  HasBaleen: ").Append(HasBaleen).Append("\n");
            sb.Append("  HasTeeth: ").Append(HasTeeth).Append("\n");
            sb.Append("  ClassName: ").Append(ClassName).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as Whale);
        }

        /// <summary>
        /// Returns true if Whale instances are equal
        /// </summary>
        /// <param name="input">Instance of Whale to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(Whale input)
        {
            if (input == null)
            {
                return false;
            }
            return 
                (
                    this.HasBaleen == input.HasBaleen ||
                    this.HasBaleen.Equals(input.HasBaleen)
                ) && 
                (
                    this.HasTeeth == input.HasTeeth ||
                    this.HasTeeth.Equals(input.HasTeeth)
                ) && 
                (
                    this.ClassName == input.ClassName ||
                    (this.ClassName != null &&
                    this.ClassName.Equals(input.ClassName))
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                hashCode = (hashCode * 59) + this.HasBaleen.GetHashCode();
                hashCode = (hashCode * 59) + this.HasTeeth.GetHashCode();
                if (this.ClassName != null)
                {
                    hashCode = (hashCode * 59) + this.ClassName.GetHashCode();
                }
                return hashCode;
            }
        }

    }

}
