/*
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using UnityEngine.Networking;

namespace Org.OpenAPITools.Client
{
#if UNITY_2020_1_OR_NEWER
    public class ConnectionException : Exception
    {
        public UnityWebRequest.Result Result { get; private set; }
        public string Error { get; private set; }

        // NOTE: Cannot keep reference to the request since it will be disposed.
        public ConnectionException(UnityWebRequest request)
            : base($"result={request.result} error={request.error}")
        {
            Result = request.result;
            Error = request.error ?? "";
        }
    }
#else
    // For Unity 2019, define a custom enum that roughly simulates UnityWebRequest.Result.
    public enum UnityWebRequestResultLegacy
    {
        Success,
        ConnectionError,
        ProtocolError,
        DataProcessingError
    }

    public class ConnectionException : Exception
    {
        public UnityWebRequestResultLegacy Result { get; private set; }
        public string Error { get; private set; }

        public ConnectionException(UnityWebRequest request)
            : base($"Error: {request.error}")
        {
            if (request.isNetworkError)
            {
                Result = UnityWebRequestResultLegacy.ConnectionError;
            }
            else if (request.isHttpError)
            {
                Result = UnityWebRequestResultLegacy.ProtocolError;
            }
            else
            {
                Result = UnityWebRequestResultLegacy.Success;
            }

            Error = request.error ?? "";
        }
    }
#endif
}
