# OpenAPI Petstore GDScript Client

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

This *Godot 4* addon was automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

− Servers:
    - [http://petstore.swagger.io/v2](http://petstore.swagger.io/v2)
- API version: 1.0.0
- Build package: org.openapitools.codegen.languages.GdscriptClientCodegen


## Requirements.

Godot `4.x`.


## Installation & Usage

Copy the files into the `addon` directory of your Godot project.

Then, enable the addon in your project settings.

You can now use it anywhere in your code:

```gdscript

# Customize configuration
var config := DemoApiConfig.new()
config.host = "localhost"
config.port = 8080
#config.tls_enabled = true
#config.trusted_chain = preload("res://my_cert_chain.crt")

# Instantiate the api
var api = DemoFakeApi.new(config)
# You can also provide your own HTTPClient, to re-use it across apis.
#var api = DemoFakeApi.new(config, client)


# Invoke an endpoint
api.test_nullable_required_param(
	# username: String = ""   Eg: username_example
	# The name that needs to be fetched. Use user1 for testing.
	username,
	# dummyRequiredNullableParam: String = ""   Eg: dummyRequiredNullableParam_example
	# To test nullable required parameters
	dummyRequiredNullableParam,
	# uPPERCASE: String = ""   Eg: uPPERCASE_example
	# To test parameter names in upper case
	uPPERCASE,
	# On Success
	func(response):
		prints("Success!", "test_nullable_required_param", response)
		
		pass  # do things, make stuff
		,
	# On Error
	func(error):  # error is DemoApiError
		push_error(str(error))
		,
)

```


## Customization

You can [override the templates](https://openapi-generator.tech/docs/templating/).

> 1. Grab templates with `openapi-generator author template -g gdscript --library gdscript`
> 2. Hack around
> 3. Regenerate using `--template <dir>` to target your custom templates dir


## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DemoFakeApi* | [**test_nullable_required_param**](apis/DemoFakeApi.md#test_nullable_required_param) | **GET** /fake/user/{username} | To test nullable required parameters
*DemoPetApi* | [**add_pet**](apis/DemoPetApi.md#add_pet) | **POST** /pet | Add a new pet to the store
*DemoPetApi* | [**delete_pet**](apis/DemoPetApi.md#delete_pet) | **DELETE** /pet/{petId} | Deletes a pet
*DemoPetApi* | [**find_pets_by_status**](apis/DemoPetApi.md#find_pets_by_status) | **GET** /pet/findByStatus | Finds Pets by status
*DemoPetApi* | [**find_pets_by_tags**](apis/DemoPetApi.md#find_pets_by_tags) | **GET** /pet/findByTags | Finds Pets by tags
*DemoPetApi* | [**get_pet_by_id**](apis/DemoPetApi.md#get_pet_by_id) | **GET** /pet/{petId} | Find pet by ID
*DemoPetApi* | [**update_pet**](apis/DemoPetApi.md#update_pet) | **PUT** /pet | Update an existing pet
*DemoPetApi* | [**update_pet_with_form**](apis/DemoPetApi.md#update_pet_with_form) | **POST** /pet/{petId} | Updates a pet in the store with form data
*DemoPetApi* | [**upload_file**](apis/DemoPetApi.md#upload_file) | **POST** /pet/{petId}/uploadImage | uploads an image
*DemoStoreApi* | [**delete_order**](apis/DemoStoreApi.md#delete_order) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*DemoStoreApi* | [**get_inventory**](apis/DemoStoreApi.md#get_inventory) | **GET** /store/inventory | Returns pet inventories by status
*DemoStoreApi* | [**get_order_by_id**](apis/DemoStoreApi.md#get_order_by_id) | **GET** /store/order/{orderId} | Find purchase order by ID
*DemoStoreApi* | [**place_order**](apis/DemoStoreApi.md#place_order) | **POST** /store/order | Place an order for a pet
*DemoTestingApi* | [**tests_file_response_get**](apis/DemoTestingApi.md#tests_file_response_get) | **GET** /tests/fileResponse | Returns an image file
*DemoTestingApi* | [**tests_type_testing_get**](apis/DemoTestingApi.md#tests_type_testing_get) | **GET** /tests/typeTesting | Route to test the TypeTesting schema
*DemoUserApi* | [**create_user**](apis/DemoUserApi.md#create_user) | **POST** /user | Create user
*DemoUserApi* | [**create_users_with_array_input**](apis/DemoUserApi.md#create_users_with_array_input) | **POST** /user/createWithArray | Creates list of users with given input array
*DemoUserApi* | [**create_users_with_list_input**](apis/DemoUserApi.md#create_users_with_list_input) | **POST** /user/createWithList | Creates list of users with given input array
*DemoUserApi* | [**delete_user**](apis/DemoUserApi.md#delete_user) | **DELETE** /user/{username} | Delete user
*DemoUserApi* | [**get_user_by_name**](apis/DemoUserApi.md#get_user_by_name) | **GET** /user/{username} | Get user by user name
*DemoUserApi* | [**login_user**](apis/DemoUserApi.md#login_user) | **GET** /user/login | Logs user into the system
*DemoUserApi* | [**logout_user**](apis/DemoUserApi.md#logout_user) | **GET** /user/logout | Logs out current logged in user session
*DemoUserApi* | [**update_user**](apis/DemoUserApi.md#update_user) | **PUT** /user/{username} | Updated user


## Documentation For Models

- [DemoActionContainerModel](models/DemoActionContainerModel.md)
- [DemoApiResponseModel](models/DemoApiResponseModel.md)
- [DemoArrayItemRefTestModel](models/DemoArrayItemRefTestModel.md)
- [DemoBazModel](models/DemoBazModel.md)
- [DemoCategoryModel](models/DemoCategoryModel.md)
- [DemoEnumArrayTestingModel](models/DemoEnumArrayTestingModel.md)
- [DemoOptionalTestingModel](models/DemoOptionalTestingModel.md)
- [DemoOrderModel](models/DemoOrderModel.md)
- [DemoPetModel](models/DemoPetModel.md)
- [DemoPropertyTestModel](models/DemoPropertyTestModel.md)
- [DemoReturnModel](models/DemoReturnModel.md)
- [DemoTagModel](models/DemoTagModel.md)
- [DemoTypeTestingModel](models/DemoTypeTestingModel.md)
- [DemoUserModel](models/DemoUserModel.md)


## Documentation For Authorization


## petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
  - **write:pets**: modify pets in your account
  - **read:pets**: read your pets

 Authentication schemes defined for the API:
## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header



## Troubleshooting

### `TLS handshake error: -9984`

https://github.com/godotengine/godot/issues/59080#issuecomment-1065973210

