extends Resource
class_name DemoApiConfig

# THIS FILE WAS AUTOMATICALLY GENERATED by the OpenAPI Generator project.
# For more information on how to customize templates, see:
# https://openapi-generator.tech
# https://github.com/OpenAPITools/openapi-generator/tree/master/modules/openapi-generator/src/main/resources/gdscript
# The OpenAPI Generator Community, © Public Domain, 2022

# Configuration options for Api endpoints
# =======================================
#
# Helps share configuration customizations across Apis:
# - host, port & scheme
# - extra headers (low priority, high priority)
# - transport layer security options (TLS certificates)
# - log level
#
# You probably want to make an instance of this class with your own values,
# and feed it to each Api's constructor, before calling the Api's methods.
#
# Since it is a Resource, you may use `ResourceSaver.save()` and `preload()`
# to save it and load it from file, for convenience.
#


# These are constant, immutable default values.  Best not edit them.
# To set different values at runtime, use the @export'ed properties below.
const BEE_DEFAULT_HOST := "petstore.swagger.io"
const BEE_DEFAULT_PORT_HTTP := 80
const BEE_DEFAULT_PORT_HTTPS := 443
const BEE_DEFAULT_POLLING_INTERVAL_MS := 333  # milliseconds


# Configuration also handles logging because it's convenient.
enum LogLevel {
	SILENT,
	ERROR,
	WARNING,
	INFO,
	DEBUG,
}


## Log level to configure verbosity.
@export var log_level := LogLevel.WARNING


## The host to connect to, with or without the protocol scheme.
## Eg: "gitea.com", "https://gitea.com"
## We toggle TLS accordingly to the provided scheme, if any.
@export var host := BEE_DEFAULT_HOST:
	set(value):
		if value.begins_with("https://"):
			tls_enabled = true
			value = value.substr(8)  # "https://".length() == 8
		elif value.begins_with("http://"):
			tls_enabled = false
			value = value.substr(7)  # "http://".length() == 7
		host = value


## Port through which the connection will be established.
## NOTE: changing the host may change the port as well if the scheme was provided, see above.
@export var port := BEE_DEFAULT_PORT_HTTP


## Headers used as base for all requests made by Api instances using this config.
## Those are the lowest priority headers, and are merged with custom headers provided in the bee_request() method call
## as well as the headers override below, to compute the final, actually sent headers.
@export var headers_base := {
	# Stigmergy: everyone does what is left to do (like ants do)
	"User-Agent": "Stigmergiac/1.0 (Godot)",
	# For my mental health's sake, only JSON is supported for now
	"Accept": "application/json",
	"Content-Type": "application/json",
}


## High-priority headers, they will always override other headers coming from the base above or the method call.
@export var headers_override := {}


## Duration of sleep between poll() calls.
@export var polling_interval_ms := BEE_DEFAULT_POLLING_INTERVAL_MS  # milliseconds


## Enable the Transport Security Layer (packet encryption, HTTPS)
@export var tls_enabled := false:
	set(value):
		tls_enabled = value
		port = BEE_DEFAULT_PORT_HTTPS if tls_enabled else BEE_DEFAULT_PORT_HTTP


## You should preload your *.crt file (the whole chain) in here if you want TLS.
## I usually concatenate my /etc/ssl/certs/ca-certificates.crt and webserver certs here.
## Remember to add the *.crt file to the exports, if necessary.
@export var trusted_chain: X509Certificate  # only used if tls is enabled
@export var common_name_override := ""  # for TLSOptions


## Dynamic accessor using the TLS properties above, but you may inject your own
## for example if you need to use TLSOptions.client_unsafe.  Best not @export this.
var tls_options: TLSOptions:
	set(value):
		tls_options = value
	get:
		if not tls_enabled:
			return null
		if not tls_options:
			tls_options = TLSOptions.client(trusted_chain, common_name_override)
		return tls_options


func log_error(message: String):
	if self.log_level >= LogLevel.ERROR:
		push_error(message)

func log_warning(message: String):
	if self.log_level >= LogLevel.WARNING:
		push_warning(message)

func log_info(message: String):
	if self.log_level >= LogLevel.INFO:
		print(message)

func log_debug(message: String):
	if self.log_level >= LogLevel.DEBUG:
		print(message)


# Authentication method `petstore_auth`.
# → Skipped: not implemented in the gdscript templates.  (contribs are welcome)


# Authentication method `api_key`.
# Api Key Authentication `api_key`
func set_security_api_key(value: String):
	self.headers_base["api_key"] = value


