# Go API client for petstore

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```sh
go get github.com/stretchr/testify/assert
go get golang.org/x/oauth2
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```go
import petstore "github.com/GIT_USER_ID/GIT_REPO_ID"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```go
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `petstore.ContextServerIndex` of type `int`.

```go
ctx := context.WithValue(context.Background(), petstore.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `petstore.ContextServerVariables` of type `map[string]string`.

```go
ctx := context.WithValue(context.Background(), petstore.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `petstore.ContextOperationServerIndices` and `petstore.ContextOperationServerVariables` context maps.

```go
ctx := context.WithValue(context.Background(), petstore.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), petstore.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnotherFakeAPI* | [**Call123TestSpecialTags**](docs/AnotherFakeAPI.md#call123testspecialtags) | **Patch** /another-fake/dummy | To test special tags
*FakeAPI* | [**CreateXmlItem**](docs/FakeAPI.md#createxmlitem) | **Post** /fake/create_xml_item | creates an XmlItem
*FakeAPI* | [**FakeOuterBooleanSerialize**](docs/FakeAPI.md#fakeouterbooleanserialize) | **Post** /fake/outer/boolean | 
*FakeAPI* | [**FakeOuterCompositeSerialize**](docs/FakeAPI.md#fakeoutercompositeserialize) | **Post** /fake/outer/composite | 
*FakeAPI* | [**FakeOuterNumberSerialize**](docs/FakeAPI.md#fakeouternumberserialize) | **Post** /fake/outer/number | 
*FakeAPI* | [**FakeOuterStringSerialize**](docs/FakeAPI.md#fakeouterstringserialize) | **Post** /fake/outer/string | 
*FakeAPI* | [**TestBodyWithFileSchema**](docs/FakeAPI.md#testbodywithfileschema) | **Put** /fake/body-with-file-schema | 
*FakeAPI* | [**TestBodyWithQueryParams**](docs/FakeAPI.md#testbodywithqueryparams) | **Put** /fake/body-with-query-params | 
*FakeAPI* | [**TestClientModel**](docs/FakeAPI.md#testclientmodel) | **Patch** /fake | To test \&quot;client\&quot; model
*FakeAPI* | [**TestEndpointParameters**](docs/FakeAPI.md#testendpointparameters) | **Post** /fake | Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
*FakeAPI* | [**TestEnumParameters**](docs/FakeAPI.md#testenumparameters) | **Get** /fake | To test enum parameters
*FakeAPI* | [**TestGroupParameters**](docs/FakeAPI.md#testgroupparameters) | **Delete** /fake | Fake endpoint to test group parameters (optional)
*FakeAPI* | [**TestInlineAdditionalProperties**](docs/FakeAPI.md#testinlineadditionalproperties) | **Post** /fake/inline-additionalProperties | test inline additionalProperties
*FakeAPI* | [**TestJsonFormData**](docs/FakeAPI.md#testjsonformdata) | **Get** /fake/jsonFormData | test json serialization of form data
*FakeAPI* | [**TestQueryParameterCollectionFormat**](docs/FakeAPI.md#testqueryparametercollectionformat) | **Put** /fake/test-query-parameters | 
*FakeClassnameTags123API* | [**TestClassname**](docs/FakeClassnameTags123API.md#testclassname) | **Patch** /fake_classname_test | To test class name in snake case
*PetAPI* | [**AddPet**](docs/PetAPI.md#addpet) | **Post** /pet | Add a new pet to the store
*PetAPI* | [**DeletePet**](docs/PetAPI.md#deletepet) | **Delete** /pet/{petId} | Deletes a pet
*PetAPI* | [**FindPetsByStatus**](docs/PetAPI.md#findpetsbystatus) | **Get** /pet/findByStatus | Finds Pets by status
*PetAPI* | [**FindPetsByTags**](docs/PetAPI.md#findpetsbytags) | **Get** /pet/findByTags | Finds Pets by tags
*PetAPI* | [**GetPetById**](docs/PetAPI.md#getpetbyid) | **Get** /pet/{petId} | Find pet by ID
*PetAPI* | [**UpdatePet**](docs/PetAPI.md#updatepet) | **Put** /pet | Update an existing pet
*PetAPI* | [**UpdatePetWithForm**](docs/PetAPI.md#updatepetwithform) | **Post** /pet/{petId} | Updates a pet in the store with form data
*PetAPI* | [**UploadFile**](docs/PetAPI.md#uploadfile) | **Post** /pet/{petId}/uploadImage | uploads an image
*PetAPI* | [**UploadFileWithRequiredFile**](docs/PetAPI.md#uploadfilewithrequiredfile) | **Post** /fake/{petId}/uploadImageWithRequiredFile | uploads an image (required)
*StoreAPI* | [**DeleteOrder**](docs/StoreAPI.md#deleteorder) | **Delete** /store/order/{order_id} | Delete purchase order by ID
*StoreAPI* | [**GetInventory**](docs/StoreAPI.md#getinventory) | **Get** /store/inventory | Returns pet inventories by status
*StoreAPI* | [**GetOrderById**](docs/StoreAPI.md#getorderbyid) | **Get** /store/order/{order_id} | Find purchase order by ID
*StoreAPI* | [**PlaceOrder**](docs/StoreAPI.md#placeorder) | **Post** /store/order | Place an order for a pet
*UserAPI* | [**CreateUser**](docs/UserAPI.md#createuser) | **Post** /user | Create user
*UserAPI* | [**CreateUsersWithArrayInput**](docs/UserAPI.md#createuserswitharrayinput) | **Post** /user/createWithArray | Creates list of users with given input array
*UserAPI* | [**CreateUsersWithListInput**](docs/UserAPI.md#createuserswithlistinput) | **Post** /user/createWithList | Creates list of users with given input array
*UserAPI* | [**DeleteUser**](docs/UserAPI.md#deleteuser) | **Delete** /user/{username} | Delete user
*UserAPI* | [**GetUserByName**](docs/UserAPI.md#getuserbyname) | **Get** /user/{username} | Get user by user name
*UserAPI* | [**LoginUser**](docs/UserAPI.md#loginuser) | **Get** /user/login | Logs user into the system
*UserAPI* | [**LogoutUser**](docs/UserAPI.md#logoutuser) | **Get** /user/logout | Logs out current logged in user session
*UserAPI* | [**UpdateUser**](docs/UserAPI.md#updateuser) | **Put** /user/{username} | Updated user


## Documentation For Models

 - [AdditionalPropertiesAnyType](docs/AdditionalPropertiesAnyType.md)
 - [AdditionalPropertiesArray](docs/AdditionalPropertiesArray.md)
 - [AdditionalPropertiesBoolean](docs/AdditionalPropertiesBoolean.md)
 - [AdditionalPropertiesClass](docs/AdditionalPropertiesClass.md)
 - [AdditionalPropertiesInteger](docs/AdditionalPropertiesInteger.md)
 - [AdditionalPropertiesNumber](docs/AdditionalPropertiesNumber.md)
 - [AdditionalPropertiesObject](docs/AdditionalPropertiesObject.md)
 - [AdditionalPropertiesString](docs/AdditionalPropertiesString.md)
 - [Animal](docs/Animal.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [ArrayOfArrayOfNumberOnly](docs/ArrayOfArrayOfNumberOnly.md)
 - [ArrayOfNumberOnly](docs/ArrayOfNumberOnly.md)
 - [ArrayTest](docs/ArrayTest.md)
 - [BigCat](docs/BigCat.md)
 - [Capitalization](docs/Capitalization.md)
 - [Cat](docs/Cat.md)
 - [Category](docs/Category.md)
 - [ClassModel](docs/ClassModel.md)
 - [Client](docs/Client.md)
 - [Dog](docs/Dog.md)
 - [EnumArrays](docs/EnumArrays.md)
 - [EnumClass](docs/EnumClass.md)
 - [EnumTest](docs/EnumTest.md)
 - [File](docs/File.md)
 - [FileSchemaTestClass](docs/FileSchemaTestClass.md)
 - [FormatTest](docs/FormatTest.md)
 - [HasOnlyReadOnly](docs/HasOnlyReadOnly.md)
 - [List](docs/List.md)
 - [MapTest](docs/MapTest.md)
 - [MixedPropertiesAndAdditionalPropertiesClass](docs/MixedPropertiesAndAdditionalPropertiesClass.md)
 - [Model200Response](docs/Model200Response.md)
 - [Name](docs/Name.md)
 - [NumberOnly](docs/NumberOnly.md)
 - [Order](docs/Order.md)
 - [OuterComposite](docs/OuterComposite.md)
 - [OuterEnum](docs/OuterEnum.md)
 - [Pet](docs/Pet.md)
 - [ReadOnlyFirst](docs/ReadOnlyFirst.md)
 - [Return](docs/Return.md)
 - [SpecialModelName](docs/SpecialModelName.md)
 - [Tag](docs/Tag.md)
 - [TypeHolderDefault](docs/TypeHolderDefault.md)
 - [TypeHolderExample](docs/TypeHolderExample.md)
 - [User](docs/User.md)
 - [XmlItem](docs/XmlItem.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### petstore_auth


- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://localhost/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets

Example

```go
auth := context.WithValue(context.Background(), petstore.ContextAccessToken, "ACCESSTOKENSTRING")
r, err := client.Service.Operation(auth, args)
```

Or via OAuth2 module to automatically refresh tokens and perform user authentication.

```go
import "golang.org/x/oauth2"

/* Perform OAuth2 round trip request and obtain a token */

tokenSource := oauth2cfg.TokenSource(createContext(httpClient), &token)
auth := context.WithValue(oauth2.NoContext, petstore.ContextOAuth2, tokenSource)
r, err := client.Service.Operation(auth, args)
```

### api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header

Note, each API key must be added to a map of `map[string]APIKey` where the key is: api_key and passed in as the auth context for each request.

Example

```go
auth := context.WithValue(
		context.Background(),
		petstore.ContextAPIKeys,
		map[string]petstore.APIKey{
			"api_key": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```

### api_key_query

- **Type**: API key
- **API key parameter name**: api_key_query
- **Location**: URL query string

Note, each API key must be added to a map of `map[string]APIKey` where the key is: api_key_query and passed in as the auth context for each request.

Example

```go
auth := context.WithValue(
		context.Background(),
		petstore.ContextAPIKeys,
		map[string]petstore.APIKey{
			"api_key_query": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```

### http_basic_test

- **Type**: HTTP basic authentication

Example

```go
auth := context.WithValue(context.Background(), petstore.ContextBasicAuth, petstore.BasicAuth{
	UserName: "username",
	Password: "password",
})
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



