/*
OpenAPI Petstore

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package petstore

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"os"
	"time"
	"reflect"
)


type FakeAPI interface {

	/*
	CreateXmlItem creates an XmlItem

	this route creates an XmlItem

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiCreateXmlItemRequest
	*/
	CreateXmlItem(ctx context.Context) ApiCreateXmlItemRequest

	// CreateXmlItemExecute executes the request
	CreateXmlItemExecute(r ApiCreateXmlItemRequest) (*http.Response, error)

	/*
	FakeOuterBooleanSerialize Method for FakeOuterBooleanSerialize

	Test serialization of outer boolean types

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiFakeOuterBooleanSerializeRequest
	*/
	FakeOuterBooleanSerialize(ctx context.Context) ApiFakeOuterBooleanSerializeRequest

	// FakeOuterBooleanSerializeExecute executes the request
	//  @return bool
	FakeOuterBooleanSerializeExecute(r ApiFakeOuterBooleanSerializeRequest) (bool, *http.Response, error)

	/*
	FakeOuterCompositeSerialize Method for FakeOuterCompositeSerialize

	Test serialization of object with outer number type

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiFakeOuterCompositeSerializeRequest
	*/
	FakeOuterCompositeSerialize(ctx context.Context) ApiFakeOuterCompositeSerializeRequest

	// FakeOuterCompositeSerializeExecute executes the request
	//  @return OuterComposite
	FakeOuterCompositeSerializeExecute(r ApiFakeOuterCompositeSerializeRequest) (*OuterComposite, *http.Response, error)

	/*
	FakeOuterNumberSerialize Method for FakeOuterNumberSerialize

	Test serialization of outer number types

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiFakeOuterNumberSerializeRequest
	*/
	FakeOuterNumberSerialize(ctx context.Context) ApiFakeOuterNumberSerializeRequest

	// FakeOuterNumberSerializeExecute executes the request
	//  @return float32
	FakeOuterNumberSerializeExecute(r ApiFakeOuterNumberSerializeRequest) (float32, *http.Response, error)

	/*
	FakeOuterStringSerialize Method for FakeOuterStringSerialize

	Test serialization of outer string types

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiFakeOuterStringSerializeRequest
	*/
	FakeOuterStringSerialize(ctx context.Context) ApiFakeOuterStringSerializeRequest

	// FakeOuterStringSerializeExecute executes the request
	//  @return string
	FakeOuterStringSerializeExecute(r ApiFakeOuterStringSerializeRequest) (string, *http.Response, error)

	/*
	TestBodyWithFileSchema Method for TestBodyWithFileSchema

	For this test, the body for this request much reference a schema named `File`.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiTestBodyWithFileSchemaRequest
	*/
	TestBodyWithFileSchema(ctx context.Context) ApiTestBodyWithFileSchemaRequest

	// TestBodyWithFileSchemaExecute executes the request
	TestBodyWithFileSchemaExecute(r ApiTestBodyWithFileSchemaRequest) (*http.Response, error)

	/*
	TestBodyWithQueryParams Method for TestBodyWithQueryParams

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiTestBodyWithQueryParamsRequest
	*/
	TestBodyWithQueryParams(ctx context.Context) ApiTestBodyWithQueryParamsRequest

	// TestBodyWithQueryParamsExecute executes the request
	TestBodyWithQueryParamsExecute(r ApiTestBodyWithQueryParamsRequest) (*http.Response, error)

	/*
	TestClientModel To test \"client\" model

	To test "client" model

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiTestClientModelRequest
	*/
	TestClientModel(ctx context.Context) ApiTestClientModelRequest

	// TestClientModelExecute executes the request
	//  @return Client
	TestClientModelExecute(r ApiTestClientModelRequest) (*Client, *http.Response, error)

	/*
	TestEndpointParameters Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트

	Fake endpoint for testing various parameters
 假端點
 偽のエンドポイント
 가짜 엔드 포인트

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiTestEndpointParametersRequest
	*/
	TestEndpointParameters(ctx context.Context) ApiTestEndpointParametersRequest

	// TestEndpointParametersExecute executes the request
	TestEndpointParametersExecute(r ApiTestEndpointParametersRequest) (*http.Response, error)

	/*
	TestEnumParameters To test enum parameters

	To test enum parameters

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiTestEnumParametersRequest
	*/
	TestEnumParameters(ctx context.Context) ApiTestEnumParametersRequest

	// TestEnumParametersExecute executes the request
	TestEnumParametersExecute(r ApiTestEnumParametersRequest) (*http.Response, error)

	/*
	TestGroupParameters Fake endpoint to test group parameters (optional)

	Fake endpoint to test group parameters (optional)

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiTestGroupParametersRequest
	*/
	TestGroupParameters(ctx context.Context) ApiTestGroupParametersRequest

	// TestGroupParametersExecute executes the request
	TestGroupParametersExecute(r ApiTestGroupParametersRequest) (*http.Response, error)

	/*
	TestInlineAdditionalProperties test inline additionalProperties

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiTestInlineAdditionalPropertiesRequest
	*/
	TestInlineAdditionalProperties(ctx context.Context) ApiTestInlineAdditionalPropertiesRequest

	// TestInlineAdditionalPropertiesExecute executes the request
	TestInlineAdditionalPropertiesExecute(r ApiTestInlineAdditionalPropertiesRequest) (*http.Response, error)

	/*
	TestJsonFormData test json serialization of form data

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiTestJsonFormDataRequest
	*/
	TestJsonFormData(ctx context.Context) ApiTestJsonFormDataRequest

	// TestJsonFormDataExecute executes the request
	TestJsonFormDataExecute(r ApiTestJsonFormDataRequest) (*http.Response, error)

	/*
	TestQueryParameterCollectionFormat Method for TestQueryParameterCollectionFormat

	To test the collection format in query parameters

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiTestQueryParameterCollectionFormatRequest
	*/
	TestQueryParameterCollectionFormat(ctx context.Context) ApiTestQueryParameterCollectionFormatRequest

	// TestQueryParameterCollectionFormatExecute executes the request
	TestQueryParameterCollectionFormatExecute(r ApiTestQueryParameterCollectionFormatRequest) (*http.Response, error)
}

// FakeAPIService FakeAPI service
type FakeAPIService service

type ApiCreateXmlItemRequest struct {
	ctx context.Context
	ApiService FakeAPI
	xmlItem *XmlItem
}

// XmlItem Body
func (r ApiCreateXmlItemRequest) XmlItem(xmlItem XmlItem) ApiCreateXmlItemRequest {
	r.xmlItem = &xmlItem
	return r
}

func (r ApiCreateXmlItemRequest) Execute() (*http.Response, error) {
	return r.ApiService.CreateXmlItemExecute(r)
}

/*
CreateXmlItem creates an XmlItem

this route creates an XmlItem

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiCreateXmlItemRequest
*/
func (a *FakeAPIService) CreateXmlItem(ctx context.Context) ApiCreateXmlItemRequest {
	return ApiCreateXmlItemRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *FakeAPIService) CreateXmlItemExecute(r ApiCreateXmlItemRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.CreateXmlItem")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/create_xml_item"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.xmlItem == nil {
		return nil, reportError("xmlItem is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/xml", "application/xml; charset=utf-8", "application/xml; charset=utf-16", "text/xml", "text/xml; charset=utf-8", "text/xml; charset=utf-16"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.xmlItem
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiFakeOuterBooleanSerializeRequest struct {
	ctx context.Context
	ApiService FakeAPI
	body *bool
}

// Input boolean as post body
func (r ApiFakeOuterBooleanSerializeRequest) Body(body bool) ApiFakeOuterBooleanSerializeRequest {
	r.body = &body
	return r
}

func (r ApiFakeOuterBooleanSerializeRequest) Execute() (bool, *http.Response, error) {
	return r.ApiService.FakeOuterBooleanSerializeExecute(r)
}

/*
FakeOuterBooleanSerialize Method for FakeOuterBooleanSerialize

Test serialization of outer boolean types

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiFakeOuterBooleanSerializeRequest
*/
func (a *FakeAPIService) FakeOuterBooleanSerialize(ctx context.Context) ApiFakeOuterBooleanSerializeRequest {
	return ApiFakeOuterBooleanSerializeRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return bool
func (a *FakeAPIService) FakeOuterBooleanSerializeExecute(r ApiFakeOuterBooleanSerializeRequest) (bool, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  bool
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.FakeOuterBooleanSerialize")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/outer/boolean"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"*/*"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiFakeOuterCompositeSerializeRequest struct {
	ctx context.Context
	ApiService FakeAPI
	body *OuterComposite
}

// Input composite as post body
func (r ApiFakeOuterCompositeSerializeRequest) Body(body OuterComposite) ApiFakeOuterCompositeSerializeRequest {
	r.body = &body
	return r
}

func (r ApiFakeOuterCompositeSerializeRequest) Execute() (*OuterComposite, *http.Response, error) {
	return r.ApiService.FakeOuterCompositeSerializeExecute(r)
}

/*
FakeOuterCompositeSerialize Method for FakeOuterCompositeSerialize

Test serialization of object with outer number type

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiFakeOuterCompositeSerializeRequest
*/
func (a *FakeAPIService) FakeOuterCompositeSerialize(ctx context.Context) ApiFakeOuterCompositeSerializeRequest {
	return ApiFakeOuterCompositeSerializeRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return OuterComposite
func (a *FakeAPIService) FakeOuterCompositeSerializeExecute(r ApiFakeOuterCompositeSerializeRequest) (*OuterComposite, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *OuterComposite
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.FakeOuterCompositeSerialize")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/outer/composite"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"*/*"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiFakeOuterNumberSerializeRequest struct {
	ctx context.Context
	ApiService FakeAPI
	body *float32
}

// Input number as post body
func (r ApiFakeOuterNumberSerializeRequest) Body(body float32) ApiFakeOuterNumberSerializeRequest {
	r.body = &body
	return r
}

func (r ApiFakeOuterNumberSerializeRequest) Execute() (float32, *http.Response, error) {
	return r.ApiService.FakeOuterNumberSerializeExecute(r)
}

/*
FakeOuterNumberSerialize Method for FakeOuterNumberSerialize

Test serialization of outer number types

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiFakeOuterNumberSerializeRequest
*/
func (a *FakeAPIService) FakeOuterNumberSerialize(ctx context.Context) ApiFakeOuterNumberSerializeRequest {
	return ApiFakeOuterNumberSerializeRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return float32
func (a *FakeAPIService) FakeOuterNumberSerializeExecute(r ApiFakeOuterNumberSerializeRequest) (float32, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  float32
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.FakeOuterNumberSerialize")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/outer/number"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"*/*"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiFakeOuterStringSerializeRequest struct {
	ctx context.Context
	ApiService FakeAPI
	body *string
}

// Input string as post body
func (r ApiFakeOuterStringSerializeRequest) Body(body string) ApiFakeOuterStringSerializeRequest {
	r.body = &body
	return r
}

func (r ApiFakeOuterStringSerializeRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.FakeOuterStringSerializeExecute(r)
}

/*
FakeOuterStringSerialize Method for FakeOuterStringSerialize

Test serialization of outer string types

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiFakeOuterStringSerializeRequest
*/
func (a *FakeAPIService) FakeOuterStringSerialize(ctx context.Context) ApiFakeOuterStringSerializeRequest {
	return ApiFakeOuterStringSerializeRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *FakeAPIService) FakeOuterStringSerializeExecute(r ApiFakeOuterStringSerializeRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.FakeOuterStringSerialize")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/outer/string"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"*/*"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestBodyWithFileSchemaRequest struct {
	ctx context.Context
	ApiService FakeAPI
	body *FileSchemaTestClass
}

func (r ApiTestBodyWithFileSchemaRequest) Body(body FileSchemaTestClass) ApiTestBodyWithFileSchemaRequest {
	r.body = &body
	return r
}

func (r ApiTestBodyWithFileSchemaRequest) Execute() (*http.Response, error) {
	return r.ApiService.TestBodyWithFileSchemaExecute(r)
}

/*
TestBodyWithFileSchema Method for TestBodyWithFileSchema

For this test, the body for this request much reference a schema named `File`.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestBodyWithFileSchemaRequest
*/
func (a *FakeAPIService) TestBodyWithFileSchema(ctx context.Context) ApiTestBodyWithFileSchemaRequest {
	return ApiTestBodyWithFileSchemaRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *FakeAPIService) TestBodyWithFileSchemaExecute(r ApiTestBodyWithFileSchemaRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.TestBodyWithFileSchema")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/body-with-file-schema"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.body == nil {
		return nil, reportError("body is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiTestBodyWithQueryParamsRequest struct {
	ctx context.Context
	ApiService FakeAPI
	query *string
	body *User
}

func (r ApiTestBodyWithQueryParamsRequest) Query(query string) ApiTestBodyWithQueryParamsRequest {
	r.query = &query
	return r
}

func (r ApiTestBodyWithQueryParamsRequest) Body(body User) ApiTestBodyWithQueryParamsRequest {
	r.body = &body
	return r
}

func (r ApiTestBodyWithQueryParamsRequest) Execute() (*http.Response, error) {
	return r.ApiService.TestBodyWithQueryParamsExecute(r)
}

/*
TestBodyWithQueryParams Method for TestBodyWithQueryParams

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestBodyWithQueryParamsRequest
*/
func (a *FakeAPIService) TestBodyWithQueryParams(ctx context.Context) ApiTestBodyWithQueryParamsRequest {
	return ApiTestBodyWithQueryParamsRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *FakeAPIService) TestBodyWithQueryParamsExecute(r ApiTestBodyWithQueryParamsRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.TestBodyWithQueryParams")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/body-with-query-params"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.query == nil {
		return nil, reportError("query is required and must be specified")
	}
	if r.body == nil {
		return nil, reportError("body is required and must be specified")
	}

	parameterAddToHeaderOrQuery(localVarQueryParams, "query", r.query, "", "")
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiTestClientModelRequest struct {
	ctx context.Context
	ApiService FakeAPI
	body *Client
}

// client model
func (r ApiTestClientModelRequest) Body(body Client) ApiTestClientModelRequest {
	r.body = &body
	return r
}

func (r ApiTestClientModelRequest) Execute() (*Client, *http.Response, error) {
	return r.ApiService.TestClientModelExecute(r)
}

/*
TestClientModel To test \"client\" model

To test "client" model

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestClientModelRequest
*/
func (a *FakeAPIService) TestClientModel(ctx context.Context) ApiTestClientModelRequest {
	return ApiTestClientModelRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return Client
func (a *FakeAPIService) TestClientModelExecute(r ApiTestClientModelRequest) (*Client, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *Client
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.TestClientModel")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.body == nil {
		return localVarReturnValue, nil, reportError("body is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.body
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestEndpointParametersRequest struct {
	ctx context.Context
	ApiService FakeAPI
	number *float32
	double *float64
	patternWithoutDelimiter *string
	byte_ *string
	integer *int32
	int32_ *int32
	int64_ *int64
	float *float32
	string_ *string
	binary *os.File
	date *string
	dateTime *time.Time
	password *string
	callback *string
}

// None
func (r ApiTestEndpointParametersRequest) Number(number float32) ApiTestEndpointParametersRequest {
	r.number = &number
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Double(double float64) ApiTestEndpointParametersRequest {
	r.double = &double
	return r
}

// None
func (r ApiTestEndpointParametersRequest) PatternWithoutDelimiter(patternWithoutDelimiter string) ApiTestEndpointParametersRequest {
	r.patternWithoutDelimiter = &patternWithoutDelimiter
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Byte_(byte_ string) ApiTestEndpointParametersRequest {
	r.byte_ = &byte_
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Integer(integer int32) ApiTestEndpointParametersRequest {
	r.integer = &integer
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Int32_(int32_ int32) ApiTestEndpointParametersRequest {
	r.int32_ = &int32_
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Int64_(int64_ int64) ApiTestEndpointParametersRequest {
	r.int64_ = &int64_
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Float(float float32) ApiTestEndpointParametersRequest {
	r.float = &float
	return r
}

// None
func (r ApiTestEndpointParametersRequest) String_(string_ string) ApiTestEndpointParametersRequest {
	r.string_ = &string_
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Binary(binary *os.File) ApiTestEndpointParametersRequest {
	r.binary = binary
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Date(date string) ApiTestEndpointParametersRequest {
	r.date = &date
	return r
}

// None
func (r ApiTestEndpointParametersRequest) DateTime(dateTime time.Time) ApiTestEndpointParametersRequest {
	r.dateTime = &dateTime
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Password(password string) ApiTestEndpointParametersRequest {
	r.password = &password
	return r
}

// None
func (r ApiTestEndpointParametersRequest) Callback(callback string) ApiTestEndpointParametersRequest {
	r.callback = &callback
	return r
}

func (r ApiTestEndpointParametersRequest) Execute() (*http.Response, error) {
	return r.ApiService.TestEndpointParametersExecute(r)
}

/*
TestEndpointParameters Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트

Fake endpoint for testing various parameters
 假端點
 偽のエンドポイント
 가짜 엔드 포인트

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestEndpointParametersRequest
*/
func (a *FakeAPIService) TestEndpointParameters(ctx context.Context) ApiTestEndpointParametersRequest {
	return ApiTestEndpointParametersRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *FakeAPIService) TestEndpointParametersExecute(r ApiTestEndpointParametersRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.TestEndpointParameters")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.number == nil {
		return nil, reportError("number is required and must be specified")
	}
	if *r.number < 32.1 {
		return nil, reportError("number must be greater than 32.1")
	}
	if *r.number > 543.2 {
		return nil, reportError("number must be less than 543.2")
	}
	if r.double == nil {
		return nil, reportError("double is required and must be specified")
	}
	if *r.double < 67.8 {
		return nil, reportError("double must be greater than 67.8")
	}
	if *r.double > 123.4 {
		return nil, reportError("double must be less than 123.4")
	}
	if r.patternWithoutDelimiter == nil {
		return nil, reportError("patternWithoutDelimiter is required and must be specified")
	}
	if r.byte_ == nil {
		return nil, reportError("byte_ is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.integer != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "integer", r.integer, "", "")
	}
	if r.int32_ != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "int32", r.int32_, "", "")
	}
	if r.int64_ != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "int64", r.int64_, "", "")
	}
	parameterAddToHeaderOrQuery(localVarFormParams, "number", r.number, "", "")
	if r.float != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "float", r.float, "", "")
	}
	parameterAddToHeaderOrQuery(localVarFormParams, "double", r.double, "", "")
	if r.string_ != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "string", r.string_, "", "")
	}
	parameterAddToHeaderOrQuery(localVarFormParams, "pattern_without_delimiter", r.patternWithoutDelimiter, "", "")
	parameterAddToHeaderOrQuery(localVarFormParams, "byte", r.byte_, "", "")
	var binaryLocalVarFormFileName string
	var binaryLocalVarFileName     string
	var binaryLocalVarFileBytes    []byte

	binaryLocalVarFormFileName = "binary"
	binaryLocalVarFile := r.binary

	if binaryLocalVarFile != nil {
		fbs, _ := io.ReadAll(binaryLocalVarFile)

		binaryLocalVarFileBytes = fbs
		binaryLocalVarFileName = binaryLocalVarFile.Name()
		binaryLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: binaryLocalVarFileBytes, fileName: binaryLocalVarFileName, formFileName: binaryLocalVarFormFileName})
	}
	if r.date != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "date", r.date, "", "")
	}
	if r.dateTime != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "dateTime", r.dateTime, "", "")
	}
	if r.password != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "password", r.password, "", "")
	}
	if r.callback != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "callback", r.callback, "", "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiTestEnumParametersRequest struct {
	ctx context.Context
	ApiService FakeAPI
	enumHeaderStringArray *[]string
	enumHeaderString *string
	enumQueryStringArray *[]string
	enumQueryString *string
	enumQueryInteger *int32
	enumQueryDouble *float64
	enumFormStringArray *[]string
	enumFormString *string
}

// Header parameter enum test (string array)
func (r ApiTestEnumParametersRequest) EnumHeaderStringArray(enumHeaderStringArray []string) ApiTestEnumParametersRequest {
	r.enumHeaderStringArray = &enumHeaderStringArray
	return r
}

// Header parameter enum test (string)
func (r ApiTestEnumParametersRequest) EnumHeaderString(enumHeaderString string) ApiTestEnumParametersRequest {
	r.enumHeaderString = &enumHeaderString
	return r
}

// Query parameter enum test (string array)
func (r ApiTestEnumParametersRequest) EnumQueryStringArray(enumQueryStringArray []string) ApiTestEnumParametersRequest {
	r.enumQueryStringArray = &enumQueryStringArray
	return r
}

// Query parameter enum test (string)
func (r ApiTestEnumParametersRequest) EnumQueryString(enumQueryString string) ApiTestEnumParametersRequest {
	r.enumQueryString = &enumQueryString
	return r
}

// Query parameter enum test (double)
func (r ApiTestEnumParametersRequest) EnumQueryInteger(enumQueryInteger int32) ApiTestEnumParametersRequest {
	r.enumQueryInteger = &enumQueryInteger
	return r
}

// Query parameter enum test (double)
func (r ApiTestEnumParametersRequest) EnumQueryDouble(enumQueryDouble float64) ApiTestEnumParametersRequest {
	r.enumQueryDouble = &enumQueryDouble
	return r
}

// Form parameter enum test (string array)
func (r ApiTestEnumParametersRequest) EnumFormStringArray(enumFormStringArray []string) ApiTestEnumParametersRequest {
	r.enumFormStringArray = &enumFormStringArray
	return r
}

// Form parameter enum test (string)
func (r ApiTestEnumParametersRequest) EnumFormString(enumFormString string) ApiTestEnumParametersRequest {
	r.enumFormString = &enumFormString
	return r
}

func (r ApiTestEnumParametersRequest) Execute() (*http.Response, error) {
	return r.ApiService.TestEnumParametersExecute(r)
}

/*
TestEnumParameters To test enum parameters

To test enum parameters

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestEnumParametersRequest
*/
func (a *FakeAPIService) TestEnumParameters(ctx context.Context) ApiTestEnumParametersRequest {
	return ApiTestEnumParametersRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *FakeAPIService) TestEnumParametersExecute(r ApiTestEnumParametersRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.TestEnumParameters")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.enumQueryStringArray != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "enum_query_string_array", r.enumQueryStringArray, "form", "csv")
	}
	if r.enumQueryString != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "enum_query_string", r.enumQueryString, "", "")
	} else {
		var defaultValue string = "-efg"
		parameterAddToHeaderOrQuery(localVarQueryParams, "enum_query_string", defaultValue, "", "")
		r.enumQueryString = &defaultValue
	}
	if r.enumQueryInteger != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "enum_query_integer", r.enumQueryInteger, "", "")
	}
	if r.enumQueryDouble != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "enum_query_double", r.enumQueryDouble, "", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.enumHeaderStringArray != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "enum_header_string_array", r.enumHeaderStringArray, "simple", "csv")
	}
	if r.enumHeaderString != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "enum_header_string", r.enumHeaderString, "", "")
	}
	if r.enumFormStringArray != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "enum_form_string_array", r.enumFormStringArray, "", "csv")
	}
	if r.enumFormString != nil {
		parameterAddToHeaderOrQuery(localVarFormParams, "enum_form_string", r.enumFormString, "", "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiTestGroupParametersRequest struct {
	ctx context.Context
	ApiService FakeAPI
	requiredStringGroup *int32
	requiredBooleanGroup *bool
	requiredInt64Group *int64
	stringGroup *int32
	booleanGroup *bool
	int64Group *int64
}

// Required String in group parameters
func (r ApiTestGroupParametersRequest) RequiredStringGroup(requiredStringGroup int32) ApiTestGroupParametersRequest {
	r.requiredStringGroup = &requiredStringGroup
	return r
}

// Required Boolean in group parameters
func (r ApiTestGroupParametersRequest) RequiredBooleanGroup(requiredBooleanGroup bool) ApiTestGroupParametersRequest {
	r.requiredBooleanGroup = &requiredBooleanGroup
	return r
}

// Required Integer in group parameters
func (r ApiTestGroupParametersRequest) RequiredInt64Group(requiredInt64Group int64) ApiTestGroupParametersRequest {
	r.requiredInt64Group = &requiredInt64Group
	return r
}

// String in group parameters
func (r ApiTestGroupParametersRequest) StringGroup(stringGroup int32) ApiTestGroupParametersRequest {
	r.stringGroup = &stringGroup
	return r
}

// Boolean in group parameters
func (r ApiTestGroupParametersRequest) BooleanGroup(booleanGroup bool) ApiTestGroupParametersRequest {
	r.booleanGroup = &booleanGroup
	return r
}

// Integer in group parameters
func (r ApiTestGroupParametersRequest) Int64Group(int64Group int64) ApiTestGroupParametersRequest {
	r.int64Group = &int64Group
	return r
}

func (r ApiTestGroupParametersRequest) Execute() (*http.Response, error) {
	return r.ApiService.TestGroupParametersExecute(r)
}

/*
TestGroupParameters Fake endpoint to test group parameters (optional)

Fake endpoint to test group parameters (optional)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestGroupParametersRequest
*/
func (a *FakeAPIService) TestGroupParameters(ctx context.Context) ApiTestGroupParametersRequest {
	return ApiTestGroupParametersRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *FakeAPIService) TestGroupParametersExecute(r ApiTestGroupParametersRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.TestGroupParameters")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.requiredStringGroup == nil {
		return nil, reportError("requiredStringGroup is required and must be specified")
	}
	if r.requiredBooleanGroup == nil {
		return nil, reportError("requiredBooleanGroup is required and must be specified")
	}
	if r.requiredInt64Group == nil {
		return nil, reportError("requiredInt64Group is required and must be specified")
	}

	parameterAddToHeaderOrQuery(localVarQueryParams, "required_string_group", r.requiredStringGroup, "", "")
	parameterAddToHeaderOrQuery(localVarQueryParams, "required_int64_group", r.requiredInt64Group, "", "")
	if r.stringGroup != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "string_group", r.stringGroup, "", "")
	}
	if r.int64Group != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "int64_group", r.int64Group, "", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	parameterAddToHeaderOrQuery(localVarHeaderParams, "required_boolean_group", r.requiredBooleanGroup, "", "")
	if r.booleanGroup != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "boolean_group", r.booleanGroup, "", "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiTestInlineAdditionalPropertiesRequest struct {
	ctx context.Context
	ApiService FakeAPI
	param *map[string]string
}

// request body
func (r ApiTestInlineAdditionalPropertiesRequest) Param(param map[string]string) ApiTestInlineAdditionalPropertiesRequest {
	r.param = &param
	return r
}

func (r ApiTestInlineAdditionalPropertiesRequest) Execute() (*http.Response, error) {
	return r.ApiService.TestInlineAdditionalPropertiesExecute(r)
}

/*
TestInlineAdditionalProperties test inline additionalProperties

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestInlineAdditionalPropertiesRequest
*/
func (a *FakeAPIService) TestInlineAdditionalProperties(ctx context.Context) ApiTestInlineAdditionalPropertiesRequest {
	return ApiTestInlineAdditionalPropertiesRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *FakeAPIService) TestInlineAdditionalPropertiesExecute(r ApiTestInlineAdditionalPropertiesRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.TestInlineAdditionalProperties")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/inline-additionalProperties"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.param == nil {
		return nil, reportError("param is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.param
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiTestJsonFormDataRequest struct {
	ctx context.Context
	ApiService FakeAPI
	param *string
	param2 *string
}

// field1
func (r ApiTestJsonFormDataRequest) Param(param string) ApiTestJsonFormDataRequest {
	r.param = &param
	return r
}

// field2
func (r ApiTestJsonFormDataRequest) Param2(param2 string) ApiTestJsonFormDataRequest {
	r.param2 = &param2
	return r
}

func (r ApiTestJsonFormDataRequest) Execute() (*http.Response, error) {
	return r.ApiService.TestJsonFormDataExecute(r)
}

/*
TestJsonFormData test json serialization of form data

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestJsonFormDataRequest
*/
func (a *FakeAPIService) TestJsonFormData(ctx context.Context) ApiTestJsonFormDataRequest {
	return ApiTestJsonFormDataRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *FakeAPIService) TestJsonFormDataExecute(r ApiTestJsonFormDataRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.TestJsonFormData")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/jsonFormData"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.param == nil {
		return nil, reportError("param is required and must be specified")
	}
	if r.param2 == nil {
		return nil, reportError("param2 is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	parameterAddToHeaderOrQuery(localVarFormParams, "param", r.param, "", "")
	parameterAddToHeaderOrQuery(localVarFormParams, "param2", r.param2, "", "")
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiTestQueryParameterCollectionFormatRequest struct {
	ctx context.Context
	ApiService FakeAPI
	pipe *[]string
	ioutil *[]string
	http *[]string
	url *[]string
	context *[]string
}

func (r ApiTestQueryParameterCollectionFormatRequest) Pipe(pipe []string) ApiTestQueryParameterCollectionFormatRequest {
	r.pipe = &pipe
	return r
}

func (r ApiTestQueryParameterCollectionFormatRequest) Ioutil(ioutil []string) ApiTestQueryParameterCollectionFormatRequest {
	r.ioutil = &ioutil
	return r
}

func (r ApiTestQueryParameterCollectionFormatRequest) Http(http []string) ApiTestQueryParameterCollectionFormatRequest {
	r.http = &http
	return r
}

func (r ApiTestQueryParameterCollectionFormatRequest) Url(url []string) ApiTestQueryParameterCollectionFormatRequest {
	r.url = &url
	return r
}

func (r ApiTestQueryParameterCollectionFormatRequest) Context(context []string) ApiTestQueryParameterCollectionFormatRequest {
	r.context = &context
	return r
}

func (r ApiTestQueryParameterCollectionFormatRequest) Execute() (*http.Response, error) {
	return r.ApiService.TestQueryParameterCollectionFormatExecute(r)
}

/*
TestQueryParameterCollectionFormat Method for TestQueryParameterCollectionFormat

To test the collection format in query parameters

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryParameterCollectionFormatRequest
*/
func (a *FakeAPIService) TestQueryParameterCollectionFormat(ctx context.Context) ApiTestQueryParameterCollectionFormatRequest {
	return ApiTestQueryParameterCollectionFormatRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
func (a *FakeAPIService) TestQueryParameterCollectionFormatExecute(r ApiTestQueryParameterCollectionFormatRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "FakeAPIService.TestQueryParameterCollectionFormat")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/fake/test-query-parameters"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.pipe == nil {
		return nil, reportError("pipe is required and must be specified")
	}
	if r.ioutil == nil {
		return nil, reportError("ioutil is required and must be specified")
	}
	if r.http == nil {
		return nil, reportError("http is required and must be specified")
	}
	if r.url == nil {
		return nil, reportError("url is required and must be specified")
	}
	if r.context == nil {
		return nil, reportError("context is required and must be specified")
	}

	parameterAddToHeaderOrQuery(localVarQueryParams, "pipe", r.pipe, "form", "csv")
	parameterAddToHeaderOrQuery(localVarQueryParams, "ioutil", r.ioutil, "", "csv")
	parameterAddToHeaderOrQuery(localVarQueryParams, "http", r.http, "spaceDelimited", "ssv")
	parameterAddToHeaderOrQuery(localVarQueryParams, "url", r.url, "form", "csv")
	{
		t := *r.context
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "context", s.Index(i).Interface(), "form", "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "context", t, "form", "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}
