{-
   OpenAPI Petstore

   This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

   OpenAPI Version: 3.0.1
   OpenAPI Petstore API version: 1.0.0
   Generated by OpenAPI Generator (https://openapi-generator.tech)
-}

{-|
Module : OpenAPIPetstore.API.User
-}

{-# LANGUAGE FlexibleContexts #-}
{-# LANGUAGE FlexibleInstances #-}
{-# LANGUAGE MonoLocalBinds #-}
{-# LANGUAGE MultiParamTypeClasses #-}
{-# LANGUAGE OverloadedStrings #-}
{-# OPTIONS_GHC -fno-warn-name-shadowing -fno-warn-unused-binds -fno-warn-unused-imports #-}

module OpenAPIPetstore.API.User where

import OpenAPIPetstore.Core
import OpenAPIPetstore.MimeTypes
import OpenAPIPetstore.Model as M

import qualified Data.Aeson as A
import qualified Data.ByteString as B
import qualified Data.ByteString.Lazy as BL
import qualified Data.Data as P (Typeable, TypeRep, typeOf, typeRep)
import qualified Data.Foldable as P
import qualified Data.Map as Map
import qualified Data.Maybe as P
import qualified Data.Proxy as P (Proxy(..))
import qualified Data.Set as Set
import qualified Data.String as P
import qualified Data.Text as T
import qualified Data.Text.Encoding as T
import qualified Data.Text.Lazy as TL
import qualified Data.Text.Lazy.Encoding as TL
import qualified Data.Time as TI
import qualified Network.HTTP.Client.MultipartFormData as NH
import qualified Network.HTTP.Media as ME
import qualified Network.HTTP.Types as NH
import qualified Web.FormUrlEncoded as WH
import qualified Web.HttpApiData as WH

import Data.Text (Text)
import GHC.Base ((<|>))

import Prelude ((==),(/=),($), (.),(<$>),(<*>),(>>=),Maybe(..),Bool(..),Char,Double,FilePath,Float,Int,Integer,String,fmap,undefined,mempty,maybe,pure,Monad,Applicative,Functor)
import qualified Prelude as P

-- * Operations


-- ** User

-- *** createUser

-- | @POST \/user@
-- 
-- Create user
-- 
-- This can only be done by the logged in user.
-- 
createUser
  :: (Consumes CreateUser contentType, MimeRender contentType User)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> User -- ^ "body" -  Created user object
  -> OpenAPIPetstoreRequest CreateUser contentType NoContent MimeNoContent
createUser _ body =
  _mkRequest "POST" ["/user"]
    `setBodyParam` body

data CreateUser 

-- | /Body Param/ "body" - Created user object
instance HasBodyParam CreateUser User 

-- | @*/*@
instance MimeType mtype => Consumes CreateUser mtype

instance Produces CreateUser MimeNoContent


-- *** createUsersWithArrayInput

-- | @POST \/user\/createWithArray@
-- 
-- Creates list of users with given input array
-- 
createUsersWithArrayInput
  :: (Consumes CreateUsersWithArrayInput contentType, MimeRender contentType Body)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> Body -- ^ "body" -  List of user object
  -> OpenAPIPetstoreRequest CreateUsersWithArrayInput contentType NoContent MimeNoContent
createUsersWithArrayInput _ body =
  _mkRequest "POST" ["/user/createWithArray"]
    `setBodyParam` body

data CreateUsersWithArrayInput 

-- | /Body Param/ "body" - List of user object
instance HasBodyParam CreateUsersWithArrayInput Body 

-- | @*/*@
instance MimeType mtype => Consumes CreateUsersWithArrayInput mtype

instance Produces CreateUsersWithArrayInput MimeNoContent


-- *** createUsersWithListInput

-- | @POST \/user\/createWithList@
-- 
-- Creates list of users with given input array
-- 
createUsersWithListInput
  :: (Consumes CreateUsersWithListInput contentType, MimeRender contentType Body)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> Body -- ^ "body" -  List of user object
  -> OpenAPIPetstoreRequest CreateUsersWithListInput contentType NoContent MimeNoContent
createUsersWithListInput _ body =
  _mkRequest "POST" ["/user/createWithList"]
    `setBodyParam` body

data CreateUsersWithListInput 

-- | /Body Param/ "body" - List of user object
instance HasBodyParam CreateUsersWithListInput Body 

-- | @*/*@
instance MimeType mtype => Consumes CreateUsersWithListInput mtype

instance Produces CreateUsersWithListInput MimeNoContent


-- *** deleteUser

-- | @DELETE \/user\/{username}@
-- 
-- Delete user
-- 
-- This can only be done by the logged in user.
-- 
deleteUser
  :: Username -- ^ "username" -  The name that needs to be deleted
  -> OpenAPIPetstoreRequest DeleteUser MimeNoContent NoContent MimeNoContent
deleteUser (Username username) =
  _mkRequest "DELETE" ["/user/",toPath username]

data DeleteUser  
instance Produces DeleteUser MimeNoContent


-- *** getUserByName

-- | @GET \/user\/{username}@
-- 
-- Get user by user name
-- 
getUserByName
  :: Accept accept -- ^ request accept ('MimeType')
  -> Username -- ^ "username" -  The name that needs to be fetched. Use user1 for testing.
  -> OpenAPIPetstoreRequest GetUserByName MimeNoContent User accept
getUserByName  _ (Username username) =
  _mkRequest "GET" ["/user/",toPath username]

data GetUserByName  
-- | @application/xml@
instance Produces GetUserByName MimeXML
-- | @application/json@
instance Produces GetUserByName MimeJSON


-- *** loginUser

-- | @GET \/user\/login@
-- 
-- Logs user into the system
-- 
loginUser
  :: Accept accept -- ^ request accept ('MimeType')
  -> Username -- ^ "username" -  The user name for login
  -> Password -- ^ "password" -  The password for login in clear text
  -> OpenAPIPetstoreRequest LoginUser MimeNoContent Text accept
loginUser  _ (Username username) (Password password) =
  _mkRequest "GET" ["/user/login"]
    `addQuery` toQuery ("username", Just username)
    `addQuery` toQuery ("password", Just password)

data LoginUser  
-- | @application/xml@
instance Produces LoginUser MimeXML
-- | @application/json@
instance Produces LoginUser MimeJSON


-- *** logoutUser

-- | @GET \/user\/logout@
-- 
-- Logs out current logged in user session
-- 
logoutUser
  :: OpenAPIPetstoreRequest LogoutUser MimeNoContent NoContent MimeNoContent
logoutUser =
  _mkRequest "GET" ["/user/logout"]

data LogoutUser  
instance Produces LogoutUser MimeNoContent


-- *** updateUser

-- | @PUT \/user\/{username}@
-- 
-- Updated user
-- 
-- This can only be done by the logged in user.
-- 
updateUser
  :: (Consumes UpdateUser contentType, MimeRender contentType User)
  => ContentType contentType -- ^ request content-type ('MimeType')
  -> User -- ^ "body" -  Updated user object
  -> Username -- ^ "username" -  name that need to be deleted
  -> OpenAPIPetstoreRequest UpdateUser contentType NoContent MimeNoContent
updateUser _ body (Username username) =
  _mkRequest "PUT" ["/user/",toPath username]
    `setBodyParam` body

data UpdateUser 

-- | /Body Param/ "body" - Updated user object
instance HasBodyParam UpdateUser User 

-- | @*/*@
instance MimeType mtype => Consumes UpdateUser mtype

instance Produces UpdateUser MimeNoContent

