/*
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package org.openapitools.client.api;

import org.openapitools.client.ApiResponse;
import java.util.List;
import java.util.Map;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.openapitools.client.model.User;

/**
 * OpenAPI Petstore
 *
 * <p>This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 */
public interface UserApi {

 /**
  * Create user
  * This can only be done by the logged in user.
  * @param user Created user object (required)
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> createUser(User user);

 /**
  * Creates list of users with given input array
  * 
  * @param user List of user object (required)
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> createUsersWithArrayInput(List<User> user);

 /**
  * Creates list of users with given input array
  * 
  * @param user List of user object (required)
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> createUsersWithListInput(List<User> user);

 /**
  * Delete user
  * This can only be done by the logged in user.
  * @param username The name that needs to be deleted (required)
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> deleteUser(String username);

 /**
  * Get user by user name
  * 
  * @param username The name that needs to be fetched. Use user1 for testing. (required)
  * @return {@code ApiResponse<User>}
  */
  ApiResponse<User> getUserByName(String username);

 /**
  * Logs user into the system
  * 
  * @param username The user name for login (required)
  * @param password The password for login in clear text (required)
  * @return {@code ApiResponse<String>}
  */
  ApiResponse<String> loginUser(String username, String password);

 /**
  * Logs out current logged in user session
  * 
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> logoutUser();

 /**
  * Updated user
  * This can only be done by the logged in user.
  * @param username name that need to be deleted (required)
  * @param user Updated user object (required)
  * @return {@code ApiResponse<Void>}
  */
  ApiResponse<Void> updateUser(String username, User user);

}
