/*
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.math.BigDecimal;
import org.openapitools.client.model.Client;
import java.io.File;
import org.openapitools.client.model.FileSchemaTestClass;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import org.openapitools.client.model.OuterComposite;
import org.openapitools.client.model.User;
import org.openapitools.client.model.XmlItem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.http.Method;
import io.restassured.response.Response;

import javax.validation.constraints.*;
import javax.validation.Valid;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openapitools.client.JSON;
import static io.restassured.http.Method.*;

public class FakeApi {

    private Supplier<RequestSpecBuilder> reqSpecSupplier;
    private Consumer<RequestSpecBuilder> reqSpecCustomizer;

    private FakeApi(Supplier<RequestSpecBuilder> reqSpecSupplier) {
        this.reqSpecSupplier = reqSpecSupplier;
    }

    public static FakeApi fake(Supplier<RequestSpecBuilder> reqSpecSupplier) {
        return new FakeApi(reqSpecSupplier);
    }

    private RequestSpecBuilder createReqSpec() {
        RequestSpecBuilder reqSpec = reqSpecSupplier.get();
        if(reqSpecCustomizer != null) {
            reqSpecCustomizer.accept(reqSpec);
        }
        return reqSpec;
    }

    public List<Oper> getAllOperations() {
        return Arrays.asList(
                createXmlItem(),
                fakeOuterBooleanSerialize(),
                fakeOuterCompositeSerialize(),
                fakeOuterNumberSerialize(),
                fakeOuterStringSerialize(),
                testBodyWithFileSchema(),
                testBodyWithQueryParams(),
                testClientModel(),
                testEndpointParameters(),
                testEnumParameters(),
                testGroupParameters(),
                testInlineAdditionalProperties(),
                testJsonFormData(),
                testQueryParameterCollectionFormat()
        );
    }

    public CreateXmlItemOper createXmlItem() {
        return new CreateXmlItemOper(createReqSpec());
    }

    public FakeOuterBooleanSerializeOper fakeOuterBooleanSerialize() {
        return new FakeOuterBooleanSerializeOper(createReqSpec());
    }

    public FakeOuterCompositeSerializeOper fakeOuterCompositeSerialize() {
        return new FakeOuterCompositeSerializeOper(createReqSpec());
    }

    public FakeOuterNumberSerializeOper fakeOuterNumberSerialize() {
        return new FakeOuterNumberSerializeOper(createReqSpec());
    }

    public FakeOuterStringSerializeOper fakeOuterStringSerialize() {
        return new FakeOuterStringSerializeOper(createReqSpec());
    }

    public TestBodyWithFileSchemaOper testBodyWithFileSchema() {
        return new TestBodyWithFileSchemaOper(createReqSpec());
    }

    public TestBodyWithQueryParamsOper testBodyWithQueryParams() {
        return new TestBodyWithQueryParamsOper(createReqSpec());
    }

    public TestClientModelOper testClientModel() {
        return new TestClientModelOper(createReqSpec());
    }

    public TestEndpointParametersOper testEndpointParameters() {
        return new TestEndpointParametersOper(createReqSpec());
    }

    public TestEnumParametersOper testEnumParameters() {
        return new TestEnumParametersOper(createReqSpec());
    }

    public TestGroupParametersOper testGroupParameters() {
        return new TestGroupParametersOper(createReqSpec());
    }

    public TestInlineAdditionalPropertiesOper testInlineAdditionalProperties() {
        return new TestInlineAdditionalPropertiesOper(createReqSpec());
    }

    public TestJsonFormDataOper testJsonFormData() {
        return new TestJsonFormDataOper(createReqSpec());
    }

    public TestQueryParameterCollectionFormatOper testQueryParameterCollectionFormat() {
        return new TestQueryParameterCollectionFormatOper(createReqSpec());
    }

    /**
     * Customize request specification
     * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
     * @return api
     */
    public FakeApi reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
        this.reqSpecCustomizer = reqSpecCustomizer;
        return this;
    }

    /**
     * creates an XmlItem
     * this route creates an XmlItem
     *
     * @see #body XmlItem Body (required)
     */
    public static class CreateXmlItemOper implements Oper {

        public static final Method REQ_METHOD = POST;
        public static final String REQ_URI = "/fake/create_xml_item";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public CreateXmlItemOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/xml");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /fake/create_xml_item
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

         /**
         * @param xmlItem (XmlItem) XmlItem Body (required)
         * @return operation
         */
        public CreateXmlItemOper body(@javax.annotation.Nonnull XmlItem xmlItem) {
            reqSpec.setBody(xmlItem);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public CreateXmlItemOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public CreateXmlItemOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * 
     * Test serialization of outer boolean types
     *
     * @see #body Input boolean as post body (optional)
     * return Boolean
     */
    public static class FakeOuterBooleanSerializeOper implements Oper {

        public static final Method REQ_METHOD = POST;
        public static final String REQ_URI = "/fake/outer/boolean";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public FakeOuterBooleanSerializeOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("*/*");
            reqSpec.setAccept("*/*");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /fake/outer/boolean
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

        /**
         * POST /fake/outer/boolean
         * @param handler handler
         * @return Boolean
         */
        public Boolean executeAs(Function<Response, Response> handler) {
            Type type = new TypeToken<Boolean>(){}.getType();
            return execute(handler).as(type);
        }

         /**
         * @param body (Boolean) Input boolean as post body (optional)
         * @return operation
         */
        public FakeOuterBooleanSerializeOper body(@javax.annotation.Nullable Boolean body) {
            reqSpec.setBody(body);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public FakeOuterBooleanSerializeOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public FakeOuterBooleanSerializeOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * 
     * Test serialization of object with outer number type
     *
     * @see #body Input composite as post body (optional)
     * return OuterComposite
     */
    public static class FakeOuterCompositeSerializeOper implements Oper {

        public static final Method REQ_METHOD = POST;
        public static final String REQ_URI = "/fake/outer/composite";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public FakeOuterCompositeSerializeOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("*/*");
            reqSpec.setAccept("*/*");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /fake/outer/composite
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

        /**
         * POST /fake/outer/composite
         * @param handler handler
         * @return OuterComposite
         */
        public OuterComposite executeAs(Function<Response, Response> handler) {
            Type type = new TypeToken<OuterComposite>(){}.getType();
            return execute(handler).as(type);
        }

         /**
         * @param body (OuterComposite) Input composite as post body (optional)
         * @return operation
         */
        public FakeOuterCompositeSerializeOper body(@javax.annotation.Nullable OuterComposite body) {
            reqSpec.setBody(body);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public FakeOuterCompositeSerializeOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public FakeOuterCompositeSerializeOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * 
     * Test serialization of outer number types
     *
     * @see #body Input number as post body (optional)
     * return BigDecimal
     */
    public static class FakeOuterNumberSerializeOper implements Oper {

        public static final Method REQ_METHOD = POST;
        public static final String REQ_URI = "/fake/outer/number";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public FakeOuterNumberSerializeOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("*/*");
            reqSpec.setAccept("*/*");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /fake/outer/number
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

        /**
         * POST /fake/outer/number
         * @param handler handler
         * @return BigDecimal
         */
        public BigDecimal executeAs(Function<Response, Response> handler) {
            Type type = new TypeToken<BigDecimal>(){}.getType();
            return execute(handler).as(type);
        }

         /**
         * @param body (BigDecimal) Input number as post body (optional)
         * @return operation
         */
        public FakeOuterNumberSerializeOper body(@javax.annotation.Nullable BigDecimal body) {
            reqSpec.setBody(body);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public FakeOuterNumberSerializeOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public FakeOuterNumberSerializeOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * 
     * Test serialization of outer string types
     *
     * @see #body Input string as post body (optional)
     * return String
     */
    public static class FakeOuterStringSerializeOper implements Oper {

        public static final Method REQ_METHOD = POST;
        public static final String REQ_URI = "/fake/outer/string";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public FakeOuterStringSerializeOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("*/*");
            reqSpec.setAccept("*/*");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /fake/outer/string
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

        /**
         * POST /fake/outer/string
         * @param handler handler
         * @return String
         */
        public String executeAs(Function<Response, Response> handler) {
            Type type = new TypeToken<String>(){}.getType();
            return execute(handler).as(type);
        }

         /**
         * @param body (String) Input string as post body (optional)
         * @return operation
         */
        public FakeOuterStringSerializeOper body(@javax.annotation.Nullable String body) {
            reqSpec.setBody(body);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public FakeOuterStringSerializeOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public FakeOuterStringSerializeOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * 
     * For this test, the body for this request much reference a schema named &#x60;File&#x60;.
     *
     * @see #body  (required)
     */
    public static class TestBodyWithFileSchemaOper implements Oper {

        public static final Method REQ_METHOD = PUT;
        public static final String REQ_URI = "/fake/body-with-file-schema";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public TestBodyWithFileSchemaOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/json");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * PUT /fake/body-with-file-schema
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

         /**
         * @param body (FileSchemaTestClass)  (required)
         * @return operation
         */
        public TestBodyWithFileSchemaOper body(@javax.annotation.Nonnull FileSchemaTestClass body) {
            reqSpec.setBody(body);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public TestBodyWithFileSchemaOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public TestBodyWithFileSchemaOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * 
     * 
     *
     * @see #queryQuery  (required)
     * @see #body  (required)
     */
    public static class TestBodyWithQueryParamsOper implements Oper {

        public static final Method REQ_METHOD = PUT;
        public static final String REQ_URI = "/fake/body-with-query-params";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public TestBodyWithQueryParamsOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/json");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * PUT /fake/body-with-query-params
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

         /**
         * @param body (User)  (required)
         * @return operation
         */
        public TestBodyWithQueryParamsOper body(@javax.annotation.Nonnull User body) {
            reqSpec.setBody(body);
            return this;
        }

        public static final String QUERY_QUERY = "query";

        /**
         * @param query (String)  (required)
         * @return operation
         */
        public TestBodyWithQueryParamsOper queryQuery(Object... query) {
            reqSpec.addQueryParam(QUERY_QUERY, query);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public TestBodyWithQueryParamsOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public TestBodyWithQueryParamsOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * To test \&quot;client\&quot; model
     * To test \&quot;client\&quot; model
     *
     * @see #body client model (required)
     * return Client
     */
    public static class TestClientModelOper implements Oper {

        public static final Method REQ_METHOD = PATCH;
        public static final String REQ_URI = "/fake";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public TestClientModelOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/json");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * PATCH /fake
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

        /**
         * PATCH /fake
         * @param handler handler
         * @return Client
         */
        public Client executeAs(Function<Response, Response> handler) {
            Type type = new TypeToken<Client>(){}.getType();
            return execute(handler).as(type);
        }

         /**
         * @param body (Client) client model (required)
         * @return operation
         */
        public TestClientModelOper body(@javax.annotation.Nonnull Client body) {
            reqSpec.setBody(body);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public TestClientModelOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public TestClientModelOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     * Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     *
     * @see #numberForm None (required)
     * @see #_doubleForm None (required)
     * @see #patternWithoutDelimiterForm None (required)
     * @see #_byteForm None (required)
     * @see #integerForm None (optional)
     * @see #int32Form None (optional)
     * @see #int64Form None (optional)
     * @see #_floatForm None (optional)
     * @see #stringForm None (optional)
     * @see #binaryMultiPart None (optional)
     * @see #dateForm None (optional)
     * @see #dateTimeForm None (optional)
     * @see #passwordForm None (optional)
     * @see #paramCallbackForm None (optional)
     */
    public static class TestEndpointParametersOper implements Oper {

        public static final Method REQ_METHOD = POST;
        public static final String REQ_URI = "/fake";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public TestEndpointParametersOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/x-www-form-urlencoded");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /fake
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

         public static final String INTEGER_FORM = "integer";

         /**
         * @param integer (Integer) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper integerForm(Object... integer) {
            reqSpec.addFormParam(INTEGER_FORM, integer);
            return this;
         }

         public static final String INT32_FORM = "int32";

         /**
         * @param int32 (Integer) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper int32Form(Object... int32) {
            reqSpec.addFormParam(INT32_FORM, int32);
            return this;
         }

         public static final String INT64_FORM = "int64";

         /**
         * @param int64 (Long) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper int64Form(Object... int64) {
            reqSpec.addFormParam(INT64_FORM, int64);
            return this;
         }

         public static final String NUMBER_FORM = "number";

         /**
         * @param number (BigDecimal) None (required)
         * @return operation
         */
         public TestEndpointParametersOper numberForm(Object... number) {
            reqSpec.addFormParam(NUMBER_FORM, number);
            return this;
         }

         public static final String _FLOAT_FORM = "float";

         /**
         * @param _float (Float) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper _floatForm(Object... _float) {
            reqSpec.addFormParam(_FLOAT_FORM, _float);
            return this;
         }

         public static final String _DOUBLE_FORM = "double";

         /**
         * @param _double (Double) None (required)
         * @return operation
         */
         public TestEndpointParametersOper _doubleForm(Object... _double) {
            reqSpec.addFormParam(_DOUBLE_FORM, _double);
            return this;
         }

         public static final String STRING_FORM = "string";

         /**
         * @param string (String) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper stringForm(Object... string) {
            reqSpec.addFormParam(STRING_FORM, string);
            return this;
         }

         public static final String PATTERN_WITHOUT_DELIMITER_FORM = "pattern_without_delimiter";

         /**
         * @param patternWithoutDelimiter (String) None (required)
         * @return operation
         */
         public TestEndpointParametersOper patternWithoutDelimiterForm(Object... patternWithoutDelimiter) {
            reqSpec.addFormParam(PATTERN_WITHOUT_DELIMITER_FORM, patternWithoutDelimiter);
            return this;
         }

         public static final String _BYTE_FORM = "byte";

         /**
         * @param _byte (byte[]) None (required)
         * @return operation
         */
         public TestEndpointParametersOper _byteForm(Object... _byte) {
            reqSpec.addFormParam(_BYTE_FORM, _byte);
            return this;
         }

         public static final String DATE_FORM = "date";

         /**
         * @param date (LocalDate) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper dateForm(Object... date) {
            reqSpec.addFormParam(DATE_FORM, date);
            return this;
         }

         public static final String DATE_TIME_FORM = "dateTime";

         /**
         * @param dateTime (OffsetDateTime) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper dateTimeForm(Object... dateTime) {
            reqSpec.addFormParam(DATE_TIME_FORM, dateTime);
            return this;
         }

         public static final String PASSWORD_FORM = "password";

         /**
         * @param password (String) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper passwordForm(Object... password) {
            reqSpec.addFormParam(PASSWORD_FORM, password);
            return this;
         }

         public static final String PARAM_CALLBACK_FORM = "callback";

         /**
         * @param paramCallback (String) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper paramCallbackForm(Object... paramCallback) {
            reqSpec.addFormParam(PARAM_CALLBACK_FORM, paramCallback);
            return this;
         }

         /**
         * It will assume that the control name is file and the &lt;content-type&gt; is &lt;application/octet-stream&gt;
         * @see #reqSpec for customise
         * @param binary (File) None (optional)
         * @return operation
         */
         public TestEndpointParametersOper binaryMultiPart(@javax.annotation.Nullable File binary) {
            reqSpec.addMultiPart(binary);
            return this;
         }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public TestEndpointParametersOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public TestEndpointParametersOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * To test enum parameters
     * To test enum parameters
     *
     * @see #enumHeaderStringArrayHeader Header parameter enum test (string array) (optional)
     * @see #enumHeaderStringHeader Header parameter enum test (string) (optional, default to -efg)
     * @see #enumQueryStringArrayQuery Query parameter enum test (string array) (optional)
     * @see #enumQueryStringQuery Query parameter enum test (string) (optional, default to -efg)
     * @see #enumQueryIntegerQuery Query parameter enum test (double) (optional)
     * @see #enumQueryDoubleQuery Query parameter enum test (double) (optional)
     * @see #enumFormStringArrayForm Form parameter enum test (string array) (optional, default to $)
     * @see #enumFormStringForm Form parameter enum test (string) (optional, default to -efg)
     */
    public static class TestEnumParametersOper implements Oper {

        public static final Method REQ_METHOD = GET;
        public static final String REQ_URI = "/fake";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public TestEnumParametersOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/x-www-form-urlencoded");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * GET /fake
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

        public static final String ENUM_HEADER_STRING_ARRAY_HEADER = "enum_header_string_array";

        /**
         * @param enumHeaderStringArray (List&lt;String&gt;) Header parameter enum test (string array) (optional)
         * @return operation
         */
        public TestEnumParametersOper enumHeaderStringArrayHeader(String enumHeaderStringArray) {
            reqSpec.addHeader(ENUM_HEADER_STRING_ARRAY_HEADER, enumHeaderStringArray);
            return this;
        }

        public static final String ENUM_HEADER_STRING_HEADER = "enum_header_string";

        /**
         * @param enumHeaderString (String) Header parameter enum test (string) (optional, default to -efg)
         * @return operation
         */
        public TestEnumParametersOper enumHeaderStringHeader(String enumHeaderString) {
            reqSpec.addHeader(ENUM_HEADER_STRING_HEADER, enumHeaderString);
            return this;
        }

        public static final String ENUM_QUERY_STRING_ARRAY_QUERY = "enum_query_string_array";

        /**
         * @param enumQueryStringArray (List&lt;String&gt;) Query parameter enum test (string array) (optional)
         * @return operation
         */
        public TestEnumParametersOper enumQueryStringArrayQuery(Object... enumQueryStringArray) {
            reqSpec.addQueryParam(ENUM_QUERY_STRING_ARRAY_QUERY, enumQueryStringArray);
            return this;
        }

        public static final String ENUM_QUERY_STRING_QUERY = "enum_query_string";

        /**
         * @param enumQueryString (String) Query parameter enum test (string) (optional, default to -efg)
         * @return operation
         */
        public TestEnumParametersOper enumQueryStringQuery(Object... enumQueryString) {
            reqSpec.addQueryParam(ENUM_QUERY_STRING_QUERY, enumQueryString);
            return this;
        }

        public static final String ENUM_QUERY_INTEGER_QUERY = "enum_query_integer";

        /**
         * @param enumQueryInteger (Integer) Query parameter enum test (double) (optional)
         * @return operation
         */
        public TestEnumParametersOper enumQueryIntegerQuery(Object... enumQueryInteger) {
            reqSpec.addQueryParam(ENUM_QUERY_INTEGER_QUERY, enumQueryInteger);
            return this;
        }

        public static final String ENUM_QUERY_DOUBLE_QUERY = "enum_query_double";

        /**
         * @param enumQueryDouble (Double) Query parameter enum test (double) (optional)
         * @return operation
         */
        public TestEnumParametersOper enumQueryDoubleQuery(Object... enumQueryDouble) {
            reqSpec.addQueryParam(ENUM_QUERY_DOUBLE_QUERY, enumQueryDouble);
            return this;
        }

         public static final String ENUM_FORM_STRING_ARRAY_FORM = "enum_form_string_array";

         /**
         * @param enumFormStringArray (List&lt;String&gt;) Form parameter enum test (string array) (optional, default to $)
         * @return operation
         */
         public TestEnumParametersOper enumFormStringArrayForm(Object... enumFormStringArray) {
            reqSpec.addFormParam(ENUM_FORM_STRING_ARRAY_FORM, enumFormStringArray);
            return this;
         }

         public static final String ENUM_FORM_STRING_FORM = "enum_form_string";

         /**
         * @param enumFormString (String) Form parameter enum test (string) (optional, default to -efg)
         * @return operation
         */
         public TestEnumParametersOper enumFormStringForm(Object... enumFormString) {
            reqSpec.addFormParam(ENUM_FORM_STRING_FORM, enumFormString);
            return this;
         }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public TestEnumParametersOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public TestEnumParametersOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * Fake endpoint to test group parameters (optional)
     * Fake endpoint to test group parameters (optional)
     *
     * @see #requiredStringGroupQuery Required String in group parameters (required)
     * @see #requiredBooleanGroupHeader Required Boolean in group parameters (required)
     * @see #requiredInt64GroupQuery Required Integer in group parameters (required)
     * @see #stringGroupQuery String in group parameters (optional)
     * @see #booleanGroupHeader Boolean in group parameters (optional)
     * @see #int64GroupQuery Integer in group parameters (optional)
     */
    public static class TestGroupParametersOper implements Oper {

        public static final Method REQ_METHOD = DELETE;
        public static final String REQ_URI = "/fake";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public TestGroupParametersOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * DELETE /fake
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

        public static final String REQUIRED_BOOLEAN_GROUP_HEADER = "required_boolean_group";

        /**
         * @param requiredBooleanGroup (Boolean) Required Boolean in group parameters (required)
         * @return operation
         */
        public TestGroupParametersOper requiredBooleanGroupHeader(String requiredBooleanGroup) {
            reqSpec.addHeader(REQUIRED_BOOLEAN_GROUP_HEADER, requiredBooleanGroup);
            return this;
        }

        public static final String BOOLEAN_GROUP_HEADER = "boolean_group";

        /**
         * @param booleanGroup (Boolean) Boolean in group parameters (optional)
         * @return operation
         */
        public TestGroupParametersOper booleanGroupHeader(String booleanGroup) {
            reqSpec.addHeader(BOOLEAN_GROUP_HEADER, booleanGroup);
            return this;
        }

        public static final String REQUIRED_STRING_GROUP_QUERY = "required_string_group";

        /**
         * @param requiredStringGroup (Integer) Required String in group parameters (required)
         * @return operation
         */
        public TestGroupParametersOper requiredStringGroupQuery(Object... requiredStringGroup) {
            reqSpec.addQueryParam(REQUIRED_STRING_GROUP_QUERY, requiredStringGroup);
            return this;
        }

        public static final String REQUIRED_INT64_GROUP_QUERY = "required_int64_group";

        /**
         * @param requiredInt64Group (Long) Required Integer in group parameters (required)
         * @return operation
         */
        public TestGroupParametersOper requiredInt64GroupQuery(Object... requiredInt64Group) {
            reqSpec.addQueryParam(REQUIRED_INT64_GROUP_QUERY, requiredInt64Group);
            return this;
        }

        public static final String STRING_GROUP_QUERY = "string_group";

        /**
         * @param stringGroup (Integer) String in group parameters (optional)
         * @return operation
         */
        public TestGroupParametersOper stringGroupQuery(Object... stringGroup) {
            reqSpec.addQueryParam(STRING_GROUP_QUERY, stringGroup);
            return this;
        }

        public static final String INT64_GROUP_QUERY = "int64_group";

        /**
         * @param int64Group (Long) Integer in group parameters (optional)
         * @return operation
         */
        public TestGroupParametersOper int64GroupQuery(Object... int64Group) {
            reqSpec.addQueryParam(INT64_GROUP_QUERY, int64Group);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public TestGroupParametersOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public TestGroupParametersOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * test inline additionalProperties
     * 
     *
     * @see #body request body (required)
     */
    public static class TestInlineAdditionalPropertiesOper implements Oper {

        public static final Method REQ_METHOD = POST;
        public static final String REQ_URI = "/fake/inline-additionalProperties";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public TestInlineAdditionalPropertiesOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/json");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * POST /fake/inline-additionalProperties
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

         /**
         * @param param (Map&lt;String, String&gt;) request body (required)
         * @return operation
         */
        public TestInlineAdditionalPropertiesOper body(@javax.annotation.Nonnull Map<String, String> param) {
            reqSpec.setBody(param);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public TestInlineAdditionalPropertiesOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public TestInlineAdditionalPropertiesOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * test json serialization of form data
     * 
     *
     * @see #paramForm field1 (required)
     * @see #param2Form field2 (required)
     */
    public static class TestJsonFormDataOper implements Oper {

        public static final Method REQ_METHOD = GET;
        public static final String REQ_URI = "/fake/jsonFormData";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public TestJsonFormDataOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setContentType("application/x-www-form-urlencoded");
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * GET /fake/jsonFormData
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

         public static final String PARAM_FORM = "param";

         /**
         * @param param (String) field1 (required)
         * @return operation
         */
         public TestJsonFormDataOper paramForm(Object... param) {
            reqSpec.addFormParam(PARAM_FORM, param);
            return this;
         }

         public static final String PARAM2_FORM = "param2";

         /**
         * @param param2 (String) field2 (required)
         * @return operation
         */
         public TestJsonFormDataOper param2Form(Object... param2) {
            reqSpec.addFormParam(PARAM2_FORM, param2);
            return this;
         }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public TestJsonFormDataOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public TestJsonFormDataOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
    /**
     * 
     * To test the collection format in query parameters
     *
     * @see #pipeQuery  (required)
     * @see #ioutilQuery  (required)
     * @see #httpQuery  (required)
     * @see #urlQuery  (required)
     * @see #contextQuery  (required)
     */
    public static class TestQueryParameterCollectionFormatOper implements Oper {

        public static final Method REQ_METHOD = PUT;
        public static final String REQ_URI = "/fake/test-query-parameters";

        private RequestSpecBuilder reqSpec;
        private ResponseSpecBuilder respSpec;

        public TestQueryParameterCollectionFormatOper(RequestSpecBuilder reqSpec) {
            this.reqSpec = reqSpec;
            reqSpec.setAccept("application/json");
            this.respSpec = new ResponseSpecBuilder();
        }

        /**
         * PUT /fake/test-query-parameters
         * @param handler handler
         * @param <T> type
         * @return type
         */
        @Override
        public <T> T execute(Function<Response, T> handler) {
            return handler.apply(RestAssured.given().spec(reqSpec.build()).expect().spec(respSpec.build()).when().request(REQ_METHOD, REQ_URI));
        }

        public static final String PIPE_QUERY = "pipe";

        /**
         * @param pipe (List&lt;String&gt;)  (required)
         * @return operation
         */
        public TestQueryParameterCollectionFormatOper pipeQuery(Object... pipe) {
            reqSpec.addQueryParam(PIPE_QUERY, pipe);
            return this;
        }

        public static final String IOUTIL_QUERY = "ioutil";

        /**
         * @param ioutil (List&lt;String&gt;)  (required)
         * @return operation
         */
        public TestQueryParameterCollectionFormatOper ioutilQuery(Object... ioutil) {
            reqSpec.addQueryParam(IOUTIL_QUERY, ioutil);
            return this;
        }

        public static final String HTTP_QUERY = "http";

        /**
         * @param http (List&lt;String&gt;)  (required)
         * @return operation
         */
        public TestQueryParameterCollectionFormatOper httpQuery(Object... http) {
            reqSpec.addQueryParam(HTTP_QUERY, http);
            return this;
        }

        public static final String URL_QUERY = "url";

        /**
         * @param url (List&lt;String&gt;)  (required)
         * @return operation
         */
        public TestQueryParameterCollectionFormatOper urlQuery(Object... url) {
            reqSpec.addQueryParam(URL_QUERY, url);
            return this;
        }

        public static final String CONTEXT_QUERY = "context";

        /**
         * @param context (List&lt;String&gt;)  (required)
         * @return operation
         */
        public TestQueryParameterCollectionFormatOper contextQuery(Object... context) {
            reqSpec.addQueryParam(CONTEXT_QUERY, context);
            return this;
        }

        /**
         * Customize request specification
         * @param reqSpecCustomizer consumer to modify the RequestSpecBuilder
         * @return operation
         */
        public TestQueryParameterCollectionFormatOper reqSpec(Consumer<RequestSpecBuilder> reqSpecCustomizer) {
            reqSpecCustomizer.accept(reqSpec);
            return this;
        }

        /**
         * Customize response specification
         * @param respSpecCustomizer consumer to modify the ResponseSpecBuilder
         * @return operation
         */
        public TestQueryParameterCollectionFormatOper respSpec(Consumer<ResponseSpecBuilder> respSpecCustomizer) {
            respSpecCustomizer.accept(respSpec);
            return this;
        }
    }
}
