/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import BasquePig from './BasquePig';
import DanishPig from './DanishPig';

/**
 * The Pig model module.
 * @module model/Pig
 * @version 1.0.0
 */
class Pig {
    /**
     * Constructs a new <code>Pig</code>.
     * @alias module:model/Pig
     * @param {(module:model/BasquePig|module:model/DanishPig)} instance The actual instance to initialize Pig.
     */
    constructor(instance = null) {
        if (instance === null) {
            this.actualInstance = null;
            return;
        }
        var match = 0;
        var errorMessages = [];
        try {
            if (typeof instance === "BasquePig") {
                this.actualInstance = instance;
            } else {
                // plain JS object
                // validate the object
                BasquePig.validateJSON(instance); // throw an exception if no match
                // create BasquePig from JS object
                this.actualInstance = BasquePig.constructFromObject(instance);
            }
            match++;
        } catch(err) {
            // json data failed to deserialize into BasquePig
            errorMessages.push("Failed to construct BasquePig: " + err)
        }

        try {
            if (typeof instance === "DanishPig") {
                this.actualInstance = instance;
            } else {
                // plain JS object
                // validate the object
                DanishPig.validateJSON(instance); // throw an exception if no match
                // create DanishPig from JS object
                this.actualInstance = DanishPig.constructFromObject(instance);
            }
            match++;
        } catch(err) {
            // json data failed to deserialize into DanishPig
            errorMessages.push("Failed to construct DanishPig: " + err)
        }

        if (match > 1) {
            throw new Error("Multiple matches found constructing `Pig` with oneOf schemas BasquePig, DanishPig. Input: " + JSON.stringify(instance));
        } else if (match === 0) {
            this.actualInstance = null; // clear the actual instance in case there are multiple matches
            throw new Error("No match found constructing `Pig` with oneOf schemas BasquePig, DanishPig. Details: " +
                            errorMessages.join(", "));
        } else { // only 1 match
            // the input is valid
        }
    }

    /**
     * Constructs a <code>Pig</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Pig} obj Optional instance to populate.
     * @return {module:model/Pig} The populated <code>Pig</code> instance.
     */
    static constructFromObject(data, obj) {
        return new Pig(data);
    }

    /**
     * Gets the actual instance, which can be <code>BasquePig</code>, <code>DanishPig</code>.
     * @return {(module:model/BasquePig|module:model/DanishPig)} The actual instance.
     */
    getActualInstance() {
        return this.actualInstance;
    }

    /**
     * Sets the actual instance, which can be <code>BasquePig</code>, <code>DanishPig</code>.
     * @param {(module:model/BasquePig|module:model/DanishPig)} obj The actual instance.
     */
    setActualInstance(obj) {
       this.actualInstance = Pig.constructFromObject(obj).getActualInstance();
    }

    /**
     * Returns the JSON representation of the actual instance.
     * @return {string}
     */
    toJSON = function(){
        return this.getActualInstance();
    }

    /**
     * Create an instance of Pig from a JSON string.
     * @param {string} json_string JSON string.
     * @return {module:model/Pig} An instance of Pig.
     */
    static fromJSON = function(json_string){
        return Pig.constructFromObject(JSON.parse(json_string));
    }
}

/**
 * @member {String} className
 */
Pig.prototype['className'] = undefined;

/**
 * @member {String} color
 */
Pig.prototype['color'] = undefined;

/**
 * @member {Number} size
 */
Pig.prototype['size'] = undefined;


Pig.OneOf = ["BasquePig", "DanishPig"];

export default Pig;

