/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The EnumArrays model module.
 * @module model/EnumArrays
 * @version 1.0.0
 */
class EnumArrays {
    /**
     * Constructs a new <code>EnumArrays</code>.
     * @alias module:model/EnumArrays
     */
    constructor() { 
        
        EnumArrays.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>EnumArrays</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/EnumArrays} obj Optional instance to populate.
     * @return {module:model/EnumArrays} The populated <code>EnumArrays</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new EnumArrays();

            if (data.hasOwnProperty('just_symbol')) {
                obj['just_symbol'] = ApiClient.convertToType(data['just_symbol'], 'String');
            }
            if (data.hasOwnProperty('array_enum')) {
                obj['array_enum'] = ApiClient.convertToType(data['array_enum'], ['String']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>EnumArrays</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>EnumArrays</code>.
     */
    static validateJSON(data) {
        // ensure the json data is a string
        if (data['just_symbol'] && !(typeof data['just_symbol'] === 'string' || data['just_symbol'] instanceof String)) {
            throw new Error("Expected the field `just_symbol` to be a primitive type in the JSON string but got " + data['just_symbol']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['array_enum'])) {
            throw new Error("Expected the field `array_enum` to be an array in the JSON data but got " + data['array_enum']);
        }

        return true;
    }


}



/**
 * @member {module:model/EnumArrays.JustSymbolEnum} just_symbol
 */
EnumArrays.prototype['just_symbol'] = undefined;

/**
 * @member {Array.<module:model/EnumArrays.ArrayEnumEnum>} array_enum
 */
EnumArrays.prototype['array_enum'] = undefined;





/**
 * Allowed values for the <code>just_symbol</code> property.
 * @enum {String}
 * @readonly
 */
EnumArrays['JustSymbolEnum'] = {

    /**
     * value: ">="
     * @const
     */
    "GREATER_THAN_OR_EQUAL_TO": ">=",

    /**
     * value: "$"
     * @const
     */
    "DOLLAR": "$"
};


/**
 * Allowed values for the <code>arrayEnum</code> property.
 * @enum {String}
 * @readonly
 */
EnumArrays['ArrayEnumEnum'] = {

    /**
     * value: "fish"
     * @const
     */
    "fish": "fish",

    /**
     * value: "crab"
     * @const
     */
    "crab": "crab"
};



export default EnumArrays;

