/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The StringOrBoolean model module.
 * @module model/StringOrBoolean
 * @version 1.0.0
 */
class StringOrBoolean {
    /**
     * Constructs a new <code>StringOrBoolean</code>.
     * String or boolean
     * @alias module:model/StringOrBoolean
     * @param {(module:model/Boolean|module:model/String)} instance The actual instance to initialize StringOrBoolean.
     */
    constructor(instance = null) {
        if (instance === null) {
            this.actualInstance = null;
            return;
        }
        var match = 0;
        var errorMessages = [];
        try {
            // validate string
            if (!(typeof instance === 'string')) {
                throw new Error("Invalid value. Must be string. Input: " + JSON.stringify(instance));
            }
            this.actualInstance = instance;
            match++;
        } catch(err) {
            // json data failed to deserialize into String
            errorMessages.push("Failed to construct String: " + err)
        }

        try {
            // validate boolean
            if (!(typeof instance === 'boolean')) {
                throw new Error("Invalid value. Must be boolean. Input: " + JSON.stringify(instance));
            }
            this.actualInstance = instance;
            match++;
        } catch(err) {
            // json data failed to deserialize into Boolean
            errorMessages.push("Failed to construct Boolean: " + err)
        }

        if (match > 1) {
            throw new Error("Multiple matches found constructing `StringOrBoolean` with oneOf schemas Boolean, String. Input: " + JSON.stringify(instance));
        } else if (match === 0) {
            this.actualInstance = null; // clear the actual instance in case there are multiple matches
            throw new Error("No match found constructing `StringOrBoolean` with oneOf schemas Boolean, String. Details: " +
                            errorMessages.join(", "));
        } else { // only 1 match
            // the input is valid
        }
    }

    /**
     * Constructs a <code>StringOrBoolean</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/StringOrBoolean} obj Optional instance to populate.
     * @return {module:model/StringOrBoolean} The populated <code>StringOrBoolean</code> instance.
     */
    static constructFromObject(data, obj) {
        return new StringOrBoolean(data);
    }

    /**
     * Gets the actual instance, which can be <code>Boolean</code>, <code>String</code>.
     * @return {(module:model/Boolean|module:model/String)} The actual instance.
     */
    getActualInstance() {
        return this.actualInstance;
    }

    /**
     * Sets the actual instance, which can be <code>Boolean</code>, <code>String</code>.
     * @param {(module:model/Boolean|module:model/String)} obj The actual instance.
     */
    setActualInstance(obj) {
       this.actualInstance = StringOrBoolean.constructFromObject(obj).getActualInstance();
    }

    /**
     * Returns the JSON representation of the actual instance.
     * @return {string}
     */
    toJSON = function(){
        return this.getActualInstance();
    }

    /**
     * Create an instance of StringOrBoolean from a JSON string.
     * @param {string} json_string JSON string.
     * @return {module:model/StringOrBoolean} An instance of StringOrBoolean.
     */
    static fromJSON = function(json_string){
        return StringOrBoolean.constructFromObject(JSON.parse(json_string));
    }
}


StringOrBoolean.OneOf = ["Boolean", "String"];

export default StringOrBoolean;

