"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserApiFetchParamCreator = exports.UserApi = exports.StoreApiFetchParamCreator = exports.StoreApi = exports.RequiredError = exports.PetApiFetchParamCreator = exports.PetApi = exports.COLLECTION_FORMATS = void 0;

var url = _interopRequireWildcard(require("url"));

var portableFetch = _interopRequireWildcard(require("portable-fetch"));

var _configuration = require("./configuration");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/* eslint-disable no-use-before-define */

/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 * NOTE: This class is auto generated by OpenAPI-Generator
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
const BASE_PATH = "http://petstore.swagger.io/v2".replace(/\/+$/, "");
/**
 *
 * @export
 */

const COLLECTION_FORMATS = {
  csv: ",",
  ssv: " ",
  tsv: "\t",
  pipes: "|"
};
/**
 *
 * @export
 */

exports.COLLECTION_FORMATS = COLLECTION_FORMATS;

/**
 * * @export
 * @class RequiredError
 * @extends {Error}
 */
class RequiredError extends Error {
  constructor(field, msg) {
    super(msg);
    this.name = "RequiredError";
  }

}
/**
 * Describes the result of uploading an image resource
 * @export
 */


exports.RequiredError = RequiredError;

/**
 * PetApi - fetch parameter creator
 * @export
 */
const PetApiFetchParamCreator = function (configuration) {
  return {
    /**
     * 
     * @summary Add a new pet to the store
     * @throws {RequiredError}
     */
    addPet(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling addPet.');
      }

      const localVarPath = `/pet`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        const localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Deletes a pet
     * @throws {RequiredError}
     */
    deletePet(petId, apiKey, options) {
      // verify required parameter 'petId' is not null or undefined
      if (petId === null || petId === undefined) {
        throw new RequiredError('petId', 'Required parameter petId was null or undefined when calling deletePet.');
      }

      const localVarPath = `/pet/{petId}`.replace(`{${"petId"}}`, encodeURIComponent(String(petId)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'DELETE'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        const localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (apiKey !== undefined && apiKey !== null) {
        localVarHeaderParameter['api_key'] = apiKey;
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * Multiple status values can be provided with comma separated strings
     * @summary Finds Pets by status
     * @throws {RequiredError}
     */
    findPetsByStatus(status, options) {
      // verify required parameter 'status' is not null or undefined
      if (status === null || status === undefined) {
        throw new RequiredError('status', 'Required parameter status was null or undefined when calling findPetsByStatus.');
      }

      const localVarPath = `/pet/findByStatus`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        const localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (status) {
        localVarQueryParameter['status'] = status.join(COLLECTION_FORMATS["csv"]);
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @summary Finds Pets by tags
     * @throws {RequiredError}
     */
    findPetsByTags(tags, options) {
      // verify required parameter 'tags' is not null or undefined
      if (tags === null || tags === undefined) {
        throw new RequiredError('tags', 'Required parameter tags was null or undefined when calling findPetsByTags.');
      }

      const localVarPath = `/pet/findByTags`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        const localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (tags) {
        localVarQueryParameter['tags'] = tags.join(COLLECTION_FORMATS["csv"]);
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * Returns a single pet
     * @summary Find pet by ID
     * @throws {RequiredError}
     */
    getPetById(petId, options) {
      // verify required parameter 'petId' is not null or undefined
      if (petId === null || petId === undefined) {
        throw new RequiredError('petId', 'Required parameter petId was null or undefined when calling getPetById.');
      }

      const localVarPath = `/pet/{petId}`.replace(`{${"petId"}}`, encodeURIComponent(String(petId)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {}; // authentication api_key required

      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue = typeof configuration.apiKey === 'function' ? configuration.apiKey("api_key") : configuration.apiKey;
        localVarHeaderParameter["api_key"] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Update an existing pet
     * @throws {RequiredError}
     */
    updatePet(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling updatePet.');
      }

      const localVarPath = `/pet`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'PUT'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {}; // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        const localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Updates a pet in the store with form data
     * @throws {RequiredError}
     */
    updatePetWithForm(petId, name, status, options) {
      // verify required parameter 'petId' is not null or undefined
      if (petId === null || petId === undefined) {
        throw new RequiredError('petId', 'Required parameter petId was null or undefined when calling updatePetWithForm.');
      }

      const localVarPath = `/pet/{petId}`.replace(`{${"petId"}}`, encodeURIComponent(String(petId)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      const localVarFormParams = new FormData(); // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        const localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (name !== undefined) {
        localVarFormParams.set('name', name);
      }

      if (status !== undefined) {
        localVarFormParams.set('status', status);
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      localVarRequestOptions.body = localVarFormParams;
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary uploads an image
     * @throws {RequiredError}
     */
    uploadFile(petId, additionalMetadata, file, options) {
      // verify required parameter 'petId' is not null or undefined
      if (petId === null || petId === undefined) {
        throw new RequiredError('petId', 'Required parameter petId was null or undefined when calling uploadFile.');
      }

      const localVarPath = `/pet/{petId}/uploadImage`.replace(`{${"petId"}}`, encodeURIComponent(String(petId)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      const localVarFormParams = new FormData(); // authentication petstore_auth required
      // oauth required

      if (configuration && configuration.accessToken) {
        const localVarAccessTokenValue = typeof configuration.accessToken === 'function' ? configuration.accessToken("petstore_auth", ["write:pets", "read:pets"]) : configuration.accessToken;
        localVarHeaderParameter["Authorization"] = "Bearer " + localVarAccessTokenValue;
      }

      if (additionalMetadata !== undefined) {
        localVarFormParams.set('additionalMetadata', additionalMetadata);
      }

      if (file !== undefined) {
        localVarFormParams.set('file', file);
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      localVarRequestOptions.body = localVarFormParams;
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    }

  };
};

exports.PetApiFetchParamCreator = PetApiFetchParamCreator;

/**
 * PetApi - factory function to inject configuration 
 * @export
 */
const PetApi = function (configuration, fetch = portableFetch) {
  const basePath = configuration && configuration.basePath || BASE_PATH;
  return {
    /**
     * 
     * @summary Add a new pet to the store
     * @throws {RequiredError}
     */
    addPet(body, options = {}) {
      const localVarFetchArgs = PetApiFetchParamCreator(configuration).addPet(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Deletes a pet
     * @throws {RequiredError}
     */
    deletePet(petId, apiKey, options = {}) {
      const localVarFetchArgs = PetApiFetchParamCreator(configuration).deletePet(petId, apiKey, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * Multiple status values can be provided with comma separated strings
     * @summary Finds Pets by status
     * @throws {RequiredError}
     */
    findPetsByStatus(status, options = {}) {
      const localVarFetchArgs = PetApiFetchParamCreator(configuration).findPetsByStatus(status, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @summary Finds Pets by tags
     * @throws {RequiredError}
     */
    findPetsByTags(tags, options = {}) {
      const localVarFetchArgs = PetApiFetchParamCreator(configuration).findPetsByTags(tags, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * Returns a single pet
     * @summary Find pet by ID
     * @throws {RequiredError}
     */
    getPetById(petId, options = {}) {
      const localVarFetchArgs = PetApiFetchParamCreator(configuration).getPetById(petId, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Update an existing pet
     * @throws {RequiredError}
     */
    updatePet(body, options = {}) {
      const localVarFetchArgs = PetApiFetchParamCreator(configuration).updatePet(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Updates a pet in the store with form data
     * @throws {RequiredError}
     */
    updatePetWithForm(petId, name, status, options = {}) {
      const localVarFetchArgs = PetApiFetchParamCreator(configuration).updatePetWithForm(petId, name, status, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary uploads an image
     * @throws {RequiredError}
     */
    uploadFile(petId, additionalMetadata, file, options = {}) {
      const localVarFetchArgs = PetApiFetchParamCreator(configuration).uploadFile(petId, additionalMetadata, file, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    }

  };
};
/**
 * StoreApi - fetch parameter creator
 * @export
 */


exports.PetApi = PetApi;

const StoreApiFetchParamCreator = function (configuration) {
  return {
    /**
     * For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors
     * @summary Delete purchase order by ID
     * @throws {RequiredError}
     */
    deleteOrder(orderId, options) {
      // verify required parameter 'orderId' is not null or undefined
      if (orderId === null || orderId === undefined) {
        throw new RequiredError('orderId', 'Required parameter orderId was null or undefined when calling deleteOrder.');
      }

      const localVarPath = `/store/order/{orderId}`.replace(`{${"orderId"}}`, encodeURIComponent(String(orderId)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'DELETE'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * Returns a map of status codes to quantities
     * @summary Returns pet inventories by status
     * @throws {RequiredError}
     */
    getInventory(options) {
      const localVarPath = `/store/inventory`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {}; // authentication api_key required

      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue = typeof configuration.apiKey === 'function' ? configuration.apiKey("api_key") : configuration.apiKey;
        localVarHeaderParameter["api_key"] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * For valid response try integer IDs with value <= 5 or > 10. Other values will generate exceptions
     * @summary Find purchase order by ID
     * @throws {RequiredError}
     */
    getOrderById(orderId, options) {
      // verify required parameter 'orderId' is not null or undefined
      if (orderId === null || orderId === undefined) {
        throw new RequiredError('orderId', 'Required parameter orderId was null or undefined when calling getOrderById.');
      }

      const localVarPath = `/store/order/{orderId}`.replace(`{${"orderId"}}`, encodeURIComponent(String(orderId)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Place an order for a pet
     * @throws {RequiredError}
     */
    placeOrder(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling placeOrder.');
      }

      const localVarPath = `/store/order`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    }

  };
};

exports.StoreApiFetchParamCreator = StoreApiFetchParamCreator;

/**
 * StoreApi - factory function to inject configuration 
 * @export
 */
const StoreApi = function (configuration, fetch = portableFetch) {
  const basePath = configuration && configuration.basePath || BASE_PATH;
  return {
    /**
     * For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors
     * @summary Delete purchase order by ID
     * @throws {RequiredError}
     */
    deleteOrder(orderId, options = {}) {
      const localVarFetchArgs = StoreApiFetchParamCreator(configuration).deleteOrder(orderId, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * Returns a map of status codes to quantities
     * @summary Returns pet inventories by status
     * @throws {RequiredError}
     */
    getInventory(options = {}) {
      const localVarFetchArgs = StoreApiFetchParamCreator(configuration).getInventory(options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * For valid response try integer IDs with value <= 5 or > 10. Other values will generate exceptions
     * @summary Find purchase order by ID
     * @throws {RequiredError}
     */
    getOrderById(orderId, options = {}) {
      const localVarFetchArgs = StoreApiFetchParamCreator(configuration).getOrderById(orderId, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Place an order for a pet
     * @throws {RequiredError}
     */
    placeOrder(body, options = {}) {
      const localVarFetchArgs = StoreApiFetchParamCreator(configuration).placeOrder(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    }

  };
};
/**
 * UserApi - fetch parameter creator
 * @export
 */


exports.StoreApi = StoreApi;

const UserApiFetchParamCreator = function (configuration) {
  return {
    /**
     * This can only be done by the logged in user.
     * @summary Create user
     * @throws {RequiredError}
     */
    createUser(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling createUser.');
      }

      const localVarPath = `/user`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Creates list of users with given input array
     * @throws {RequiredError}
     */
    createUsersWithArrayInput(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling createUsersWithArrayInput.');
      }

      const localVarPath = `/user/createWithArray`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Creates list of users with given input array
     * @throws {RequiredError}
     */
    createUsersWithListInput(body, options) {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling createUsersWithListInput.');
      }

      const localVarPath = `/user/createWithList`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'POST'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * This can only be done by the logged in user.
     * @summary Delete user
     * @throws {RequiredError}
     */
    deleteUser(username, options) {
      // verify required parameter 'username' is not null or undefined
      if (username === null || username === undefined) {
        throw new RequiredError('username', 'Required parameter username was null or undefined when calling deleteUser.');
      }

      const localVarPath = `/user/{username}`.replace(`{${"username"}}`, encodeURIComponent(String(username)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'DELETE'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Get user by user name
     * @throws {RequiredError}
     */
    getUserByName(username, options) {
      // verify required parameter 'username' is not null or undefined
      if (username === null || username === undefined) {
        throw new RequiredError('username', 'Required parameter username was null or undefined when calling getUserByName.');
      }

      const localVarPath = `/user/{username}`.replace(`{${"username"}}`, encodeURIComponent(String(username)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Logs user into the system
     * @throws {RequiredError}
     */
    loginUser(username, password, options) {
      // verify required parameter 'username' is not null or undefined
      if (username === null || username === undefined) {
        throw new RequiredError('username', 'Required parameter username was null or undefined when calling loginUser.');
      } // verify required parameter 'password' is not null or undefined


      if (password === null || password === undefined) {
        throw new RequiredError('password', 'Required parameter password was null or undefined when calling loginUser.');
      }

      const localVarPath = `/user/login`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};

      if (username !== undefined) {
        localVarQueryParameter['username'] = username;
      }

      if (password !== undefined) {
        localVarQueryParameter['password'] = password;
      }

      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * 
     * @summary Logs out current logged in user session
     * @throws {RequiredError}
     */
    logoutUser(options) {
      const localVarPath = `/user/logout`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'GET'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    },

    /**
     * This can only be done by the logged in user.
     * @summary Updated user
     * @throws {RequiredError}
     */
    updateUser(username, body, options) {
      // verify required parameter 'username' is not null or undefined
      if (username === null || username === undefined) {
        throw new RequiredError('username', 'Required parameter username was null or undefined when calling updateUser.');
      } // verify required parameter 'body' is not null or undefined


      if (body === null || body === undefined) {
        throw new RequiredError('body', 'Required parameter body was null or undefined when calling updateUser.');
      }

      const localVarPath = `/user/{username}`.replace(`{${"username"}}`, encodeURIComponent(String(username)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({}, {
        method: 'PUT'
      }, options);
      const localVarHeaderParameter = {};
      const localVarQueryParameter = {};
      localVarHeaderParameter['Content-Type'] = 'application/json';
      localVarUrlObj.query = Object.assign({}, localVarUrlObj.query, localVarQueryParameter, options.query); // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943

      localVarUrlObj.search = null;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization = typeof body !== "string" || localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body != null ? body : {}) : body || "";
      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      };
    }

  };
};

exports.UserApiFetchParamCreator = UserApiFetchParamCreator;

/**
 * UserApi - factory function to inject configuration 
 * @export
 */
const UserApi = function (configuration, fetch = portableFetch) {
  const basePath = configuration && configuration.basePath || BASE_PATH;
  return {
    /**
     * This can only be done by the logged in user.
     * @summary Create user
     * @throws {RequiredError}
     */
    createUser(body, options = {}) {
      const localVarFetchArgs = UserApiFetchParamCreator(configuration).createUser(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Creates list of users with given input array
     * @throws {RequiredError}
     */
    createUsersWithArrayInput(body, options = {}) {
      const localVarFetchArgs = UserApiFetchParamCreator(configuration).createUsersWithArrayInput(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Creates list of users with given input array
     * @throws {RequiredError}
     */
    createUsersWithListInput(body, options = {}) {
      const localVarFetchArgs = UserApiFetchParamCreator(configuration).createUsersWithListInput(body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * This can only be done by the logged in user.
     * @summary Delete user
     * @throws {RequiredError}
     */
    deleteUser(username, options = {}) {
      const localVarFetchArgs = UserApiFetchParamCreator(configuration).deleteUser(username, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Get user by user name
     * @throws {RequiredError}
     */
    getUserByName(username, options = {}) {
      const localVarFetchArgs = UserApiFetchParamCreator(configuration).getUserByName(username, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Logs user into the system
     * @throws {RequiredError}
     */
    loginUser(username, password, options = {}) {
      const localVarFetchArgs = UserApiFetchParamCreator(configuration).loginUser(username, password, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response.json();
        } else {
          throw response;
        }
      });
    },

    /**
     * 
     * @summary Logs out current logged in user session
     * @throws {RequiredError}
     */
    logoutUser(options = {}) {
      const localVarFetchArgs = UserApiFetchParamCreator(configuration).logoutUser(options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    },

    /**
     * This can only be done by the logged in user.
     * @summary Updated user
     * @throws {RequiredError}
     */
    updateUser(username, body, options = {}) {
      const localVarFetchArgs = UserApiFetchParamCreator(configuration).updateUser(username, body, options);
      return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
        if (response.status >= 200 && response.status < 300) {
          return response;
        } else {
          throw response;
        }
      });
    }

  };
};

exports.UserApi = UserApi;