/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The Color model module.
 * @module model/Color
 * @version 1.0.0
 */
class Color {
    /**
     * Constructs a new <code>Color</code>.
     * RGB array, RGBA array, or hex string.
     * @alias module:model/Color
     * @param {(module:model/String|module:model/[Number])} instance The actual instance to initialize Color.
     */
    constructor(instance = null) {
        if (instance === null) {
            this.actualInstance = null;
            return;
        }
        var match = 0;
        var errorMessages = [];
        // RGB three element array with values 0-255.
        try {
            // validate array data type
            if (!Array.isArray(instance)) {
                throw new Error("Invalid data type. Expecting array. Input: " + instance);
            }
            if (instance.length > 3 || instance.length < 3) {
                throw new Error("Invalid array size. Minimim: 3. Maximum: 3. Input: " + instance);
            }
            // validate array of integer
            for (const item of instance) {
                if (!(typeof item === 'number' && item % 1 === 0)) {
                    throw new Error("Invalid array items. Must be integer. Input: " + instance);
                }
                if (item > 255 || item < 0) {
                    throw new Error("Invalid integer value in an array items. Max.: 255. Min.: 0. Input: " + instance);
                }
            }
            this.actualInstance = instance;
            match++;
        } catch(err) {
            // json data failed to deserialize into [Number]
            errorMessages.push("Failed to construct [Number]: " + err)
        }

        // RGBA four element array with values 0-255.
        try {
            // validate array data type
            if (!Array.isArray(instance)) {
                throw new Error("Invalid data type. Expecting array. Input: " + instance);
            }
            if (instance.length > 4 || instance.length < 4) {
                throw new Error("Invalid array size. Minimim: 4. Maximum: 4. Input: " + instance);
            }
            // validate array of integer
            for (const item of instance) {
                if (!(typeof item === 'number' && item % 1 === 0)) {
                    throw new Error("Invalid array items. Must be integer. Input: " + instance);
                }
                if (item > 255 || item < 0) {
                    throw new Error("Invalid integer value in an array items. Max.: 255. Min.: 0. Input: " + instance);
                }
            }
            this.actualInstance = instance;
            match++;
        } catch(err) {
            // json data failed to deserialize into [Number]
            errorMessages.push("Failed to construct [Number]: " + err)
        }

        // Hex color string, such as #00FF00.
        try {
            // validate string
            if (!(typeof instance === 'string')) {
                throw new Error("Invalid value. Must be string. Input: " + JSON.stringify(instance));
            }
            if (!/^#(?:[0-9a-fA-F]{3}){1,2}$/.test(instance)) {
                throw new Error("Invalid string value. Must conform to /^#(?:[0-9a-fA-F]{3}){1,2}$/. Input: " + JSON.stringify(instance));
            }
            if (instance.length > 7 && instance.length < 7) {
                throw new Error("Invalid string value. Max. length: 7. Min. length: 7. Input: " + JSON.stringify(instance));
            }
            this.actualInstance = instance;
            match++;
        } catch(err) {
            // json data failed to deserialize into String
            errorMessages.push("Failed to construct String: " + err)
        }

        if (match > 1) {
            throw new Error("Multiple matches found constructing `Color` with oneOf schemas String, [Number]. Input: " + JSON.stringify(instance));
        } else if (match === 0) {
            this.actualInstance = null; // clear the actual instance in case there are multiple matches
            throw new Error("No match found constructing `Color` with oneOf schemas String, [Number]. Details: " +
                            errorMessages.join(", "));
        } else { // only 1 match
            // the input is valid
        }
    }

    /**
     * Constructs a <code>Color</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Color} obj Optional instance to populate.
     * @return {module:model/Color} The populated <code>Color</code> instance.
     */
    static constructFromObject(data, obj) {
        return new Color(data);
    }

    /**
     * Gets the actual instance, which can be <code>String</code>, <code>[Number]</code>.
     * @return {(module:model/String|module:model/[Number])} The actual instance.
     */
    getActualInstance() {
        return this.actualInstance;
    }

    /**
     * Sets the actual instance, which can be <code>String</code>, <code>[Number]</code>.
     * @param {(module:model/String|module:model/[Number])} obj The actual instance.
     */
    setActualInstance(obj) {
       this.actualInstance = Color.constructFromObject(obj).getActualInstance();
    }

    /**
     * Returns the JSON representation of the actual instance.
     * @return {string}
     */
    toJSON = function(){
        return this.getActualInstance();
    }

    /**
     * Create an instance of Color from a JSON string.
     * @param {string} json_string JSON string.
     * @return {module:model/Color} An instance of Color.
     */
    static fromJSON = function(json_string){
        return Color.constructFromObject(JSON.parse(json_string));
    }
}


Color.OneOf = ["String", "[Number]"];

export default Color;

