/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import DeprecatedObject from './DeprecatedObject';

/**
 * The ObjectWithDeprecatedFields model module.
 * @module model/ObjectWithDeprecatedFields
 * @version 1.0.0
 */
class ObjectWithDeprecatedFields {
    /**
     * Constructs a new <code>ObjectWithDeprecatedFields</code>.
     * @alias module:model/ObjectWithDeprecatedFields
     */
    constructor() { 
        
        ObjectWithDeprecatedFields.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>ObjectWithDeprecatedFields</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ObjectWithDeprecatedFields} obj Optional instance to populate.
     * @return {module:model/ObjectWithDeprecatedFields} The populated <code>ObjectWithDeprecatedFields</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ObjectWithDeprecatedFields();

            if (data.hasOwnProperty('uuid')) {
                obj['uuid'] = ApiClient.convertToType(data['uuid'], 'String');
            }
            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'Number');
            }
            if (data.hasOwnProperty('deprecatedRef')) {
                obj['deprecatedRef'] = DeprecatedObject.constructFromObject(data['deprecatedRef']);
            }
            if (data.hasOwnProperty('bars')) {
                obj['bars'] = ApiClient.convertToType(data['bars'], ['String']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ObjectWithDeprecatedFields</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ObjectWithDeprecatedFields</code>.
     */
    static validateJSON(data) {
        // ensure the json data is a string
        if (data['uuid'] && !(typeof data['uuid'] === 'string' || data['uuid'] instanceof String)) {
            throw new Error("Expected the field `uuid` to be a primitive type in the JSON string but got " + data['uuid']);
        }
        // validate the optional field `deprecatedRef`
        if (data['deprecatedRef']) { // data not null
          DeprecatedObject.validateJSON(data['deprecatedRef']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['bars'])) {
            throw new Error("Expected the field `bars` to be an array in the JSON data but got " + data['bars']);
        }

        return true;
    }


}



/**
 * @member {String} uuid
 */
ObjectWithDeprecatedFields.prototype['uuid'] = undefined;

/**
 * @member {Number} id
 */
ObjectWithDeprecatedFields.prototype['id'] = undefined;

/**
 * @member {module:model/DeprecatedObject} deprecatedRef
 */
ObjectWithDeprecatedFields.prototype['deprecatedRef'] = undefined;

/**
 * @member {Array.<String>} bars
 */
ObjectWithDeprecatedFields.prototype['bars'] = undefined;






export default ObjectWithDeprecatedFields;

