# OpenAPI Petstore - Jetbrains API Client

## General API description

This is a sample server Petstore server. For this sample, you can use the api key &#x60;special-key&#x60; to test the authorization filters.

* API basepath : [http://petstore.swagger.io/v2](http://petstore.swagger.io/v2)
* Version : 1.0.0

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*, but will link to the `.http` file that contains the endpoint definition.
There may be multiple requests for a single endpoint, one for each example described in the OpenAPI specification.

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PetApi* | [**addPet**](Apis/PetApi.http#addpet) | **POST** /pet | Add a new pet to the store
*PetApi* | [**deletePet**](Apis/PetApi.http#deletepet) | **DELETE** /pet/{petId} | Deletes a pet
*PetApi* | [**findPetsByStatus**](Apis/PetApi.http#findpetsbystatus) | **GET** /pet/findByStatus | Finds Pets by status
*PetApi* | [**findPetsByTags**](Apis/PetApi.http#findpetsbytags) | **GET** /pet/findByTags | Finds Pets by tags
*PetApi* | [**getPetById**](Apis/PetApi.http#getpetbyid) | **GET** /pet/{petId} | Find pet by ID
*PetApi* | [**updatePet**](Apis/PetApi.http#updatepet) | **PUT** /pet | Update an existing pet
*PetApi* | [**updatePetWithForm**](Apis/PetApi.http#updatepetwithform) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApi* | [**uploadFile**](Apis/PetApi.http#uploadfile) | **POST** /pet/{petId}/uploadImage | uploads an image
*StoreApi* | [**deleteOrder**](Apis/StoreApi.http#deleteorder) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*StoreApi* | [**getInventory**](Apis/StoreApi.http#getinventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreApi* | [**getOrderById**](Apis/StoreApi.http#getorderbyid) | **GET** /store/order/{orderId} | Find purchase order by ID
*StoreApi* | [**placeOrder**](Apis/StoreApi.http#placeorder) | **POST** /store/order | Place an order for a pet
*UserApi* | [**createUser**](Apis/UserApi.http#createuser) | **POST** /user | Create user
*UserApi* | [**createUsersWithArrayInput**](Apis/UserApi.http#createuserswitharrayinput) | **POST** /user/createWithArray | Creates list of users with given input array
*UserApi* | [**createUsersWithListInput**](Apis/UserApi.http#createuserswithlistinput) | **POST** /user/createWithList | Creates list of users with given input array
*UserApi* | [**deleteUser**](Apis/UserApi.http#deleteuser) | **DELETE** /user/{username} | Delete user
*UserApi* | [**getUserByName**](Apis/UserApi.http#getuserbyname) | **GET** /user/{username} | Get user by user name
*UserApi* | [**loginUser**](Apis/UserApi.http#loginuser) | **GET** /user/login | Logs user into the system
*UserApi* | [**logoutUser**](Apis/UserApi.http#logoutuser) | **GET** /user/logout | Logs out current logged in user session
*UserApi* | [**updateUser**](Apis/UserApi.http#updateuser) | **PUT** /user/{username} | Updated user


## Usage

### Prerequisites

You need [IntelliJ](https://www.jetbrains.com/idea/) to be able to run those queries. More information can be found [here](https://www.jetbrains.com/help/idea/http-client-in-product-code-editor.html).
You may have some luck running queries using the [Code REST Client](https://marketplace.visualstudio.com/items?itemName=humao.rest-client) as well, but your mileage may vary.

### Variables and Environment files

* Generally speaking, you want queries to be specific using custom variables. All variables in the `.http` files have the `` format.
* You can create [public or private environment files](https://www.jetbrains.com/help/idea/exploring-http-syntax.html#environment-variables) to dynamically replace the variables at runtime.

_Note: don't commit private environment files! They typically will contain sensitive information like API Keys._

### Customizations

If you have control over the generation of the files here, there are two main things you can do

* Select elements to replace as variables during generation. The process is case-sensitive. For example, API_KEY -> 
    * For this, run the generation with the `bodyVariables` property, followed by a "-" separated list of variables
    * Example: `--additional-properties bodyVariables=YOUR_MERCHANT_ACCOUNT-YOUR_COMPANY_ACCOUNT-YOUR_BALANCE_PLATFORM`
* Add custom headers to _all_ requests. This can be useful for example if your specifications are missing [security schemes](https://github.com/github/rest-api-description/issues/237).
    * For this, run the generation with the `customHeaders` property, followed by a "&" separated list of variables
    * Example : `--additional-properties=customHeaders="Cookie:X-API-KEY="&"Accept-Encoding=gzip"`

_This client was generated by the [jetbrains-http-client](https://openapi-generator.tech/docs/generators/jetbrains-http-client) generator of OpenAPI Generator_