/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.apis

import com.fasterxml.jackson.annotation.JsonProperty

import org.springframework.web.reactive.function.client.WebClient
import org.springframework.web.reactive.function.client.WebClientResponseException
import org.springframework.http.codec.json.Jackson2JsonDecoder
import org.springframework.http.codec.json.Jackson2JsonEncoder
import org.springframework.http.ResponseEntity
import org.springframework.http.MediaType
import reactor.core.publisher.Mono
import org.springframework.util.LinkedMultiValueMap

import org.openapitools.client.models.User
import org.openapitools.client.infrastructure.*

open class UserApi(client: WebClient) : ApiClient(client) {

    constructor(baseUrl: String) : this(WebClient.builder()
        .baseUrl(baseUrl)
        .codecs {
            it.defaultCodecs().jackson2JsonEncoder(Jackson2JsonEncoder(Serializer.jacksonObjectMapper, MediaType.APPLICATION_JSON))
            it.defaultCodecs().jackson2JsonDecoder(Jackson2JsonDecoder(Serializer.jacksonObjectMapper, MediaType.APPLICATION_JSON))
        }
        .build()
    )


    @Throws(WebClientResponseException::class)
    fun createUser(user: User): Mono<Unit> {
        return createUserWithHttpInfo(user = user)
            .map { Unit }
    }

    @Throws(WebClientResponseException::class)
    fun createUserWithHttpInfo(user: User): Mono<ResponseEntity<Unit>> {
        val localVariableConfig = createUserRequestConfig(user = user)
        return request<User, Unit>(
            localVariableConfig
        )
    }

    fun createUserRequestConfig(user: User) : RequestConfig<User> {
        val localVariableBody = user
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        
        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/user",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun createUsersWithArrayInput(user: kotlin.collections.List<User>): Mono<Unit> {
        return createUsersWithArrayInputWithHttpInfo(user = user)
            .map { Unit }
    }

    @Throws(WebClientResponseException::class)
    fun createUsersWithArrayInputWithHttpInfo(user: kotlin.collections.List<User>): Mono<ResponseEntity<Unit>> {
        val localVariableConfig = createUsersWithArrayInputRequestConfig(user = user)
        return request<kotlin.collections.List<User>, Unit>(
            localVariableConfig
        )
    }

    fun createUsersWithArrayInputRequestConfig(user: kotlin.collections.List<User>) : RequestConfig<kotlin.collections.List<User>> {
        val localVariableBody = user
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        
        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/user/createWithArray",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun createUsersWithListInput(user: kotlin.collections.List<User>): Mono<Unit> {
        return createUsersWithListInputWithHttpInfo(user = user)
            .map { Unit }
    }

    @Throws(WebClientResponseException::class)
    fun createUsersWithListInputWithHttpInfo(user: kotlin.collections.List<User>): Mono<ResponseEntity<Unit>> {
        val localVariableConfig = createUsersWithListInputRequestConfig(user = user)
        return request<kotlin.collections.List<User>, Unit>(
            localVariableConfig
        )
    }

    fun createUsersWithListInputRequestConfig(user: kotlin.collections.List<User>) : RequestConfig<kotlin.collections.List<User>> {
        val localVariableBody = user
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        
        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/user/createWithList",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun deleteUser(username: kotlin.String): Mono<Unit> {
        return deleteUserWithHttpInfo(username = username)
            .map { Unit }
    }

    @Throws(WebClientResponseException::class)
    fun deleteUserWithHttpInfo(username: kotlin.String): Mono<ResponseEntity<Unit>> {
        val localVariableConfig = deleteUserRequestConfig(username = username)
        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    fun deleteUserRequestConfig(username: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        
        val params = mutableMapOf<String, Any>(
            "username" to username,
        )

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/user/{username}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun getUserByName(username: kotlin.String): Mono<User> {
        return getUserByNameWithHttpInfo(username = username)
            .map { it.body!! }
    }

    @Throws(WebClientResponseException::class)
    fun getUserByNameWithHttpInfo(username: kotlin.String): Mono<ResponseEntity<User>> {
        val localVariableConfig = getUserByNameRequestConfig(username = username)
        return request<Unit, User>(
            localVariableConfig
        )
    }

    fun getUserByNameRequestConfig(username: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
            "username" to username,
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/user/{username}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun loginUser(username: kotlin.String, password: kotlin.String): Mono<kotlin.String> {
        return loginUserWithHttpInfo(username = username, password = password)
            .map { it.body!! }
    }

    @Throws(WebClientResponseException::class)
    fun loginUserWithHttpInfo(username: kotlin.String, password: kotlin.String): Mono<ResponseEntity<kotlin.String>> {
        val localVariableConfig = loginUserRequestConfig(username = username, password = password)
        return request<Unit, kotlin.String>(
            localVariableConfig
        )
    }

    fun loginUserRequestConfig(username: kotlin.String, password: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("username", listOf(username.toString()))
                put("password", listOf(password.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/user/login",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun logoutUser(): Mono<Unit> {
        return logoutUserWithHttpInfo()
            .map { Unit }
    }

    @Throws(WebClientResponseException::class)
    fun logoutUserWithHttpInfo(): Mono<ResponseEntity<Unit>> {
        val localVariableConfig = logoutUserRequestConfig()
        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    fun logoutUserRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        
        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/user/logout",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(WebClientResponseException::class)
    fun updateUser(username: kotlin.String, user: User): Mono<Unit> {
        return updateUserWithHttpInfo(username = username, user = user)
            .map { Unit }
    }

    @Throws(WebClientResponseException::class)
    fun updateUserWithHttpInfo(username: kotlin.String, user: User): Mono<ResponseEntity<Unit>> {
        val localVariableConfig = updateUserRequestConfig(username = username, user = user)
        return request<User, Unit>(
            localVariableConfig
        )
    }

    fun updateUserRequestConfig(username: kotlin.String, user: User) : RequestConfig<User> {
        val localVariableBody = user
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        
        val params = mutableMapOf<String, Any>(
            "username" to username,
        )

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/user/{username}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

}
