/**
 *
 * Please note:
 * This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit this file manually.
 *
 */

@file:Suppress(
    "ArrayInDataClass",
    "EnumEntryName",
    "RemoveRedundantQualifierName",
    "UnusedImport"
)

package org.openapitools.client.apis

import com.fasterxml.jackson.annotation.JsonProperty

import org.springframework.web.client.RestClient
import org.springframework.web.client.RestClientResponseException

import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter
import org.springframework.http.ResponseEntity
import org.springframework.http.MediaType


import org.openapitools.client.models.User
import org.openapitools.client.infrastructure.*

open class UserApi(client: RestClient) : ApiClient(client) {

    constructor(baseUrl: String) : this(RestClient.builder()
        .baseUrl(baseUrl)
        .messageConverters { it.add(MappingJackson2HttpMessageConverter()) }
        .build()
    )


    @Throws(RestClientResponseException::class)
    fun createUser(user: User): Unit {
        createUserWithHttpInfo(user = user)
    }

    @Throws(RestClientResponseException::class)
    fun createUserWithHttpInfo(user: User): ResponseEntity<Unit> {
        val localVariableConfig = createUserRequestConfig(user = user)
        return request<User, Unit>(
            localVariableConfig
        )
    }

    fun createUserRequestConfig(user: User) : RequestConfig<User> {
        val localVariableBody = user
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        
        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/user",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun createUsersWithArrayInput(user: kotlin.collections.List<User>): Unit {
        createUsersWithArrayInputWithHttpInfo(user = user)
    }

    @Throws(RestClientResponseException::class)
    fun createUsersWithArrayInputWithHttpInfo(user: kotlin.collections.List<User>): ResponseEntity<Unit> {
        val localVariableConfig = createUsersWithArrayInputRequestConfig(user = user)
        return request<kotlin.collections.List<User>, Unit>(
            localVariableConfig
        )
    }

    fun createUsersWithArrayInputRequestConfig(user: kotlin.collections.List<User>) : RequestConfig<kotlin.collections.List<User>> {
        val localVariableBody = user
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        
        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/user/createWithArray",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun createUsersWithListInput(user: kotlin.collections.List<User>): Unit {
        createUsersWithListInputWithHttpInfo(user = user)
    }

    @Throws(RestClientResponseException::class)
    fun createUsersWithListInputWithHttpInfo(user: kotlin.collections.List<User>): ResponseEntity<Unit> {
        val localVariableConfig = createUsersWithListInputRequestConfig(user = user)
        return request<kotlin.collections.List<User>, Unit>(
            localVariableConfig
        )
    }

    fun createUsersWithListInputRequestConfig(user: kotlin.collections.List<User>) : RequestConfig<kotlin.collections.List<User>> {
        val localVariableBody = user
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        
        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.POST,
            path = "/user/createWithList",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun deleteUser(username: kotlin.String): Unit {
        deleteUserWithHttpInfo(username = username)
    }

    @Throws(RestClientResponseException::class)
    fun deleteUserWithHttpInfo(username: kotlin.String): ResponseEntity<Unit> {
        val localVariableConfig = deleteUserRequestConfig(username = username)
        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    fun deleteUserRequestConfig(username: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        
        val params = mutableMapOf<String, Any>(
            "username" to username,
        )

        return RequestConfig(
            method = RequestMethod.DELETE,
            path = "/user/{username}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun getUserByName(username: kotlin.String): User {
        val result = getUserByNameWithHttpInfo(username = username)
        return result.body!!
    }

    @Throws(RestClientResponseException::class)
    fun getUserByNameWithHttpInfo(username: kotlin.String): ResponseEntity<User> {
        val localVariableConfig = getUserByNameRequestConfig(username = username)
        return request<Unit, User>(
            localVariableConfig
        )
    }

    fun getUserByNameRequestConfig(username: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
            "username" to username,
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/user/{username}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun loginUser(username: kotlin.String, password: kotlin.String): kotlin.String {
        val result = loginUserWithHttpInfo(username = username, password = password)
        return result.body!!
    }

    @Throws(RestClientResponseException::class)
    fun loginUserWithHttpInfo(username: kotlin.String, password: kotlin.String): ResponseEntity<kotlin.String> {
        val localVariableConfig = loginUserRequestConfig(username = username, password = password)
        return request<Unit, kotlin.String>(
            localVariableConfig
        )
    }

    fun loginUserRequestConfig(username: kotlin.String, password: kotlin.String) : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
            .apply {
                put("username", listOf(username.toString()))
                put("password", listOf(password.toString()))
            }
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Accept"] = "application/xml, application/json"

        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/user/login",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = false,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun logoutUser(): Unit {
        logoutUserWithHttpInfo()
    }

    @Throws(RestClientResponseException::class)
    fun logoutUserWithHttpInfo(): ResponseEntity<Unit> {
        val localVariableConfig = logoutUserRequestConfig()
        return request<Unit, Unit>(
            localVariableConfig
        )
    }

    fun logoutUserRequestConfig() : RequestConfig<Unit> {
        val localVariableBody = null
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        
        val params = mutableMapOf<String, Any>(
        )

        return RequestConfig(
            method = RequestMethod.GET,
            path = "/user/logout",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }


    @Throws(RestClientResponseException::class)
    fun updateUser(username: kotlin.String, user: User): Unit {
        updateUserWithHttpInfo(username = username, user = user)
    }

    @Throws(RestClientResponseException::class)
    fun updateUserWithHttpInfo(username: kotlin.String, user: User): ResponseEntity<Unit> {
        val localVariableConfig = updateUserRequestConfig(username = username, user = user)
        return request<User, Unit>(
            localVariableConfig
        )
    }

    fun updateUserRequestConfig(username: kotlin.String, user: User) : RequestConfig<User> {
        val localVariableBody = user
        val localVariableQuery = mutableMapOf<kotlin.String, kotlin.collections.List<kotlin.String>>()
        val localVariableHeaders: MutableMap<String, String> = mutableMapOf()
        localVariableHeaders["Content-Type"] = "application/json"
        
        val params = mutableMapOf<String, Any>(
            "username" to username,
        )

        return RequestConfig(
            method = RequestMethod.PUT,
            path = "/user/{username}",
            params = params,
            query = localVariableQuery,
            headers = localVariableHeaders,
            requiresAuthentication = true,
            body = localVariableBody
        )
    }

}
