# org.openapitools.client - Kotlin client library for OpenAPI Petstore

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://github.com/OAI/OpenAPI-Specification) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.KotlinClientCodegen

## Requires

* Kotlin 2.2.20
* Gradle 8.14

## Build

First, create the gradle wrapper script:

```
gradle wrapper
```

Then, run:

```
./gradlew check assemble
```

This runs all tests and packages the library.

## Features/Implementation Notes

* Supports JSON inputs/outputs, File inputs, and Form inputs.
* Supports collection formats for query parameters: csv, tsv, ssv, pipes.
* Some Kotlin and Java types are fully qualified to avoid conflicts with types defined in OpenAPI definitions.
* Implementation of ApiClient is intended to reduce method counts, specifically to benefit Android targets.

<a id="documentation-for-api-endpoints"></a>
## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

| Class | Method | HTTP request | Description |
| ------------ | ------------- | ------------- | ------------- |
| *PetApi* | [**addPet**](docs/PetApi.md#addpet) | **POST** pet | Add a new pet to the store |
| *PetApi* | [**deletePet**](docs/PetApi.md#deletepet) | **DELETE** pet/{petId} | Deletes a pet |
| *PetApi* | [**findPetsByStatus**](docs/PetApi.md#findpetsbystatus) | **GET** pet/findByStatus | Finds Pets by status |
| *PetApi* | [**findPetsByTags**](docs/PetApi.md#findpetsbytags) | **GET** pet/findByTags | Finds Pets by tags |
| *PetApi* | [**getPetById**](docs/PetApi.md#getpetbyid) | **GET** pet/{petId} | Find pet by ID |
| *PetApi* | [**updatePet**](docs/PetApi.md#updatepet) | **PUT** pet | Update an existing pet |
| *PetApi* | [**updatePetWithForm**](docs/PetApi.md#updatepetwithform) | **POST** pet/{petId} | Updates a pet in the store with form data |
| *PetApi* | [**uploadFile**](docs/PetApi.md#uploadfile) | **POST** pet/{petId}/uploadImage | uploads an image |
| *StoreApi* | [**deleteOrder**](docs/StoreApi.md#deleteorder) | **DELETE** store/order/{orderId} | Delete purchase order by ID |
| *StoreApi* | [**getInventory**](docs/StoreApi.md#getinventory) | **GET** store/inventory | Returns pet inventories by status |
| *StoreApi* | [**getOrderById**](docs/StoreApi.md#getorderbyid) | **GET** store/order/{orderId} | Find purchase order by ID |
| *StoreApi* | [**placeOrder**](docs/StoreApi.md#placeorder) | **POST** store/order | Place an order for a pet |
| *UserApi* | [**createUser**](docs/UserApi.md#createuser) | **POST** user | Create user |
| *UserApi* | [**createUsersWithArrayInput**](docs/UserApi.md#createuserswitharrayinput) | **POST** user/createWithArray | Creates list of users with given input array |
| *UserApi* | [**createUsersWithListInput**](docs/UserApi.md#createuserswithlistinput) | **POST** user/createWithList | Creates list of users with given input array |
| *UserApi* | [**deleteUser**](docs/UserApi.md#deleteuser) | **DELETE** user/{username} | Delete user |
| *UserApi* | [**getUserByName**](docs/UserApi.md#getuserbyname) | **GET** user/{username} | Get user by user name |
| *UserApi* | [**loginUser**](docs/UserApi.md#loginuser) | **GET** user/login | Logs user into the system |
| *UserApi* | [**logoutUser**](docs/UserApi.md#logoutuser) | **GET** user/logout | Logs out current logged in user session |
| *UserApi* | [**updateUser**](docs/UserApi.md#updateuser) | **PUT** user/{username} | Updated user |


<a id="documentation-for-models"></a>
## Documentation for Models

 - [org.openapitools.client.models.Category](docs/Category.md)
 - [org.openapitools.client.models.ModelApiResponse](docs/ModelApiResponse.md)
 - [org.openapitools.client.models.Order](docs/Order.md)
 - [org.openapitools.client.models.Pet](docs/Pet.md)
 - [org.openapitools.client.models.Tag](docs/Tag.md)
 - [org.openapitools.client.models.User](docs/User.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="petstore_auth"></a>
### petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
  - write:pets: modify pets in your account
  - read:pets: read your pets

<a id="api_key"></a>
### api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header

