#
# OpenAPI Petstore
# 
# This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
# The version of the OpenAPI document: 1.0.0
# 
# Generated by: https://openapi-generator.tech
#

import json
import tables
import marshal
import options

import model_pet_alert_level
import model_pet_review

type Action* {.pure.} = enum
  Create
  Update
  Delete

type `From`* {.pure.} = enum
  Api
  Web
  Mobile

type PetAuditLog* = object
  ## 
  id*: Option[string] ## Audit log unique identifier
  action*: Option[Action]
  priority*: Option[PetAlertLevel]
  `from`*: Option[`From`]
  reviews*: Option[seq[PetReview]]

func `%`*(v: Action): JsonNode =
  result = case v:
    of Action.Create: %"create"
    of Action.Update: %"update"
    of Action.Delete: %"delete"
func `$`*(v: Action): string =
  result = case v:
    of Action.Create: $("create")
    of Action.Update: $("update")
    of Action.Delete: $("delete")

proc to*(node: JsonNode, T: typedesc[Action]): Action =
  if node.kind != JString:
    raise newException(ValueError, "Expected string for enum Action, got " & $node.kind)
  let strVal = node.getStr()
  case strVal:
  of $("create"):
    return Action.Create
  of $("update"):
    return Action.Update
  of $("delete"):
    return Action.Delete
  else:
    raise newException(ValueError, "Invalid enum value for Action: " & strVal)

func `%`*(v: `From`): JsonNode =
  result = case v:
    of `From`.Api: %"api"
    of `From`.Web: %"web"
    of `From`.Mobile: %"mobile"
func `$`*(v: `From`): string =
  result = case v:
    of `From`.Api: $("api")
    of `From`.Web: $("web")
    of `From`.Mobile: $("mobile")

proc to*(node: JsonNode, T: typedesc[`From`]): `From` =
  if node.kind != JString:
    raise newException(ValueError, "Expected string for enum `From`, got " & $node.kind)
  let strVal = node.getStr()
  case strVal:
  of $("api"):
    return `From`.Api
  of $("web"):
    return `From`.Web
  of $("mobile"):
    return `From`.Mobile
  else:
    raise newException(ValueError, "Invalid enum value for `From`: " & strVal)


# Custom JSON deserialization for PetAuditLog with custom field names
proc to*(node: JsonNode, T: typedesc[PetAuditLog]): PetAuditLog =
  result = PetAuditLog()
  if node.kind == JObject:
    if node.hasKey("_id") and node["_id"].kind != JNull:
      result.id = some(to(node["_id"], typeof(result.id.get())))
    if node.hasKey("action") and node["action"].kind != JNull:
      result.action = some(to(node["action"], Action))
    if node.hasKey("priority") and node["priority"].kind != JNull:
      result.priority = some(to(node["priority"], typeof(result.priority.get())))
    if node.hasKey("from") and node["from"].kind != JNull:
      result.`from` = some(to(node["from"], `From`))
    if node.hasKey("reviews") and node["reviews"].kind != JNull:
      # Optional array of types with custom JSON - manually iterate and deserialize
      let arrayNode = node["reviews"]
      if arrayNode.kind == JArray:
        var arr: seq[PetReview] = @[]
        for item in arrayNode.items:
          arr.add(to(item, PetReview))
        result.reviews = some(arr)

# Custom JSON serialization for PetAuditLog with custom field names
proc `%`*(obj: PetAuditLog): JsonNode =
  result = newJObject()
  if obj.id.isSome():
    result["_id"] = %obj.id.get()
  if obj.action.isSome():
    result["action"] = %obj.action.get()
  if obj.priority.isSome():
    result["priority"] = %obj.priority.get()
  if obj.`from`.isSome():
    result["from"] = %obj.`from`.get()
  if obj.reviews.isSome():
    result["reviews"] = %obj.reviews.get()

