#import <Foundation/Foundation.h>
#import "SWGUser.h"
#import "SWGApi.h"

/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key \"special-key\" to test the authorization filters
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/



@interface SWGUserApi: NSObject <SWGApi>

extern NSString* kSWGUserApiErrorDomain;
extern NSInteger kSWGUserApiMissingParamErrorCode;

-(instancetype) initWithApiClient:(SWGApiClient *)apiClient NS_DESIGNATED_INITIALIZER;

/// Create user
/// This can only be done by the logged in user.
///
/// @param user Created user object (optional)
/// 
///  code:0 message:"successful operation"
///
/// @return void
-(NSURLSessionTask*) createUserWithUser: (SWGUser*) user
    completionHandler: (void (^)(NSError* error)) handler;


/// Creates list of users with given input array
/// 
///
/// @param user List of user object (optional)
/// 
///  code:0 message:"successful operation"
///
/// @return void
-(NSURLSessionTask*) createUsersWithArrayInputWithUser: (NSArray<SWGUser>*) user
    completionHandler: (void (^)(NSError* error)) handler;


/// Creates list of users with given input array
/// 
///
/// @param user List of user object (optional)
/// 
///  code:0 message:"successful operation"
///
/// @return void
-(NSURLSessionTask*) createUsersWithListInputWithUser: (NSArray<SWGUser>*) user
    completionHandler: (void (^)(NSError* error)) handler;


/// Delete user
/// This can only be done by the logged in user.
///
/// @param username The name that needs to be deleted
/// 
///  code:400 message:"Invalid username supplied",
///  code:404 message:"User not found"
///
/// @return void
-(NSURLSessionTask*) deleteUserWithUsername: (NSString*) username
    completionHandler: (void (^)(NSError* error)) handler;


/// Get user by user name
/// 
///
/// @param username The name that needs to be fetched. Use user1 for testing. 
/// 
///  code:200 message:"successful operation",
///  code:400 message:"Invalid username supplied",
///  code:404 message:"User not found"
///
/// @return SWGUser*
-(NSURLSessionTask*) getUserByNameWithUsername: (NSString*) username
    completionHandler: (void (^)(SWGUser* output, NSError* error)) handler;


/// Logs user into the system
/// 
///
/// @param username The user name for login (optional)
/// @param password The password for login in clear text (optional)
/// 
///  code:200 message:"successful operation",
///  code:400 message:"Invalid username/password supplied"
///
/// @return NSString*
-(NSURLSessionTask*) loginUserWithUsername: (NSString*) username
    password: (NSString*) password
    completionHandler: (void (^)(NSString* output, NSError* error)) handler;


/// Logs out current logged in user session
/// 
///
/// 
///  code:0 message:"successful operation"
///
/// @return void
-(NSURLSessionTask*) logoutUserWithCompletionHandler: 
    (void (^)(NSError* error)) handler;


/// Updated user
/// This can only be done by the logged in user.
///
/// @param username name that need to be deleted
/// @param user Updated user object (optional)
/// 
///  code:400 message:"Invalid user supplied",
///  code:404 message:"User not found"
///
/// @return void
-(NSURLSessionTask*) updateUserWithUsername: (NSString*) username
    user: (SWGUser*) user
    completionHandler: (void (^)(NSError* error)) handler;



@end
