# NAME

WWW::OpenAPIClient::Role - a Moose role for the OpenAPI Petstore

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

# VERSION

Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PerlClientCodegen

## A note on Moose

This role is the only component of the library that uses Moose. See
WWW::OpenAPIClient::ApiFactory for non-Moosey usage.

# SYNOPSIS

The Perl Generator in the OpenAPI Generator project builds a library of Perl modules to interact with
a web service defined by a OpenAPI Specification. See below for how to build the
library.

This module provides an interface to the generated library. All the classes,
objects, and methods (well, not quite \*all\*, see below) are flattened into this
role.

        package MyApp;
        use Moose;
        with 'WWW::OpenAPIClient::Role';

        package main;

        my $api = MyApp->new({ tokens => $tokens });

        my $pet = $api->get_pet_by_id(pet_id => $pet_id);


## Structure of the library

The library consists of a set of API classes, one for each endpoint. These APIs
implement the method calls available on each endpoint.

Additionally, there is a set of "object" classes, which represent the objects
returned by and sent to the methods on the endpoints.

An API factory class is provided, which builds instances of each endpoint API.

This Moose role flattens all the methods from the endpoint APIs onto the consuming
class. It also provides methods to retrieve the endpoint API objects, and the API
factory object, should you need it.

For documentation of all these methods, see AUTOMATIC DOCUMENTATION below.

## Configuring authentication

In the normal case, the OpenAPI Spec will describe what parameters are
required and where to put them. You just need to supply the tokens.

    my $tokens = {
        # basic
        username => $username,
        password => $password,

        # oauth
        access_token => $oauth_token,

        # keys
        $some_key => { token => $token,
                       prefix => $prefix,
                       in => $in,             # 'head||query',
                       },

        $another => { token => $token,
                      prefix => $prefix,
                      in => $in,              # 'head||query',
                      },
        ...,

        };

        my $api = MyApp->new({ tokens => $tokens });

Note these are all optional, as are `prefix` and `in`, and depend on the API
you are accessing. Usually `prefix` and `in` will be determined by the code generator from
the spec and you will not need to set them at run time. If not, `in` will
default to 'head' and `prefix` to the empty string.

The tokens will be placed in a L<WWW::OpenAPIClient::Configuration> instance
as follows, but you don't need to know about this.

- `$cfg->{username}`

    String. The username for basic auth.

- `$cfg->{password}`

    String. The password for basic auth.

- `$cfg->{api_key}`

    Hashref. Keyed on the name of each key (there can be multiple tokens).

            $cfg->{api_key} = {
                    secretKey => 'aaaabbbbccccdddd',
                    anotherKey => '1111222233334444',
                    };

- `$cfg->{api_key_prefix}`

    Hashref. Keyed on the name of each key (there can be multiple tokens). Note not
    all api keys require a prefix.

            $cfg->{api_key_prefix} = {
                    secretKey => 'string',
                    anotherKey => 'same or some other string',
                    };

- `$cfg->{access_token}`

    String. The OAuth access token.

# METHODS

## `base_url`

The generated code has the `base_url` already set as a default value. This method
returns the current value of `base_url`.

## `api_factory`

Returns an API factory object. You probably won't need to call this directly.

        $self->api_factory('Pet'); # returns a WWW::OpenAPIClient::PetApi instance

        $self->pet_api;            # the same

# MISSING METHODS

Most of the methods on the API are delegated to individual endpoint API objects
(e.g. Pet API, Store API, User API etc). Where different endpoint APIs use the
same method name (e.g. `new()`), these methods can't be delegated. So you need
to call `$api->pet_api->new()`.

In principle, every API is susceptible to the presence of a few, random, undelegatable
method names. In practice, because of the way method names are constructed, it's
unlikely in general that any methods will be undelegatable, except for:

        new()
        class_documentation()
        method_documentation()

To call these methods, you need to get a handle on the relevant object, either
by calling `$api->foo_api` or by retrieving an object, e.g.
`$api->get_pet_by_id(pet_id => $pet_id)`. They are class methods, so
you could also call them on class names.

# BUILDING YOUR LIBRARY

See the homepage `https://openapi-generator.tech` for full details.
But briefly, clone the git repository, build the codegen codebase, set up your build
config file, then run the API build script. You will need git, Java 7 or 8 and Apache
maven 3.0.3 or better already installed.

The config file should specify the project name for the generated library:

        {"moduleName":"WWW::MyProjectName"}

Your library files will be built under `WWW::MyProjectName`.

          $ git clone https://github.com/openapitools/openapi-generator
          $ cd openapi-generator
          $ mvn package
          $ java -jar modules/openapi-generator-cli/target/openapi-generator-cli.jar generate \
    -i [URL or file path to JSON OpenAPI API spec] \
    -g perl \
    -c /path/to/config/file.json \
    -o /path/to/output/folder

Bang, all done. Run the `autodoc` script in the `bin` directory to see the API
you just built.

# AUTOMATIC DOCUMENTATION

You can print out a summary of the generated API by running the included
`autodoc` script in the `bin` directory of your generated library. A few
output formats are supported:

          Usage: autodoc [OPTION]

    -w           wide format (default)
    -n           narrow format
    -p           POD format
    -H           HTML format
    -m           Markdown format
    -h           print this help message
    -c           your application class


The `-c` option allows you to load and inspect your own application. A dummy
namespace is used if you don't supply your own class.

# DOCUMENTATION FROM THE OpenAPI Spec

Additional documentation for each class and method may be provided by the OpenAPI
spec. If so, this is available via the `class_documentation()` and
`method_documentation()` methods on each generated object class, and the
`method_documentation()` method on the endpoint API classes:

        my $cmdoc = $api->pet_api->method_documentation->{$method_name};

        my $odoc = $api->get_pet_by_id->(pet_id => $pet_id)->class_documentation;
        my $omdoc = $api->get_pet_by_id->(pet_id => $pet_id)->method_documentation->{method_name};


Each of these calls returns a hashref with various useful pieces of information.

# Installation Prerequisites

Use [cpanm](https://metacpan.org/pod/distribution/App-cpanminus/bin/cpanm) to install the module dependencies:

```
cpanm --local-lib=~/perl5 local::lib && eval $(perl -I ~/perl5/lib/perl5/ -Mlocal::lib)
cpanm --quiet --no-interactive Class::Accessor Test::Exception Test::More Log::Any LWP::UserAgent URI::Query Module::Runtime DateTime Module::Find Moose::Role JSON
```

# LOAD THE MODULES

To load the API packages:
```perl
use WWW::OpenAPIClient::AnotherFakeApi;
use WWW::OpenAPIClient::DefaultApi;
use WWW::OpenAPIClient::FakeApi;
use WWW::OpenAPIClient::FakeClassnameTags123Api;
use WWW::OpenAPIClient::PetApi;
use WWW::OpenAPIClient::StoreApi;
use WWW::OpenAPIClient::UserApi;

```

To load the models:
```perl
use WWW::OpenAPIClient::Object::AdditionalPropertiesClass;
use WWW::OpenAPIClient::Object::Adult;
use WWW::OpenAPIClient::Object::AllOfWithSingleRef;
use WWW::OpenAPIClient::Object::Animal;
use WWW::OpenAPIClient::Object::ApiResponse;
use WWW::OpenAPIClient::Object::ArrayOfArrayOfNumberOnly;
use WWW::OpenAPIClient::Object::ArrayOfNumberOnly;
use WWW::OpenAPIClient::Object::ArrayTest;
use WWW::OpenAPIClient::Object::Capitalization;
use WWW::OpenAPIClient::Object::Cat;
use WWW::OpenAPIClient::Object::Category;
use WWW::OpenAPIClient::Object::Child;
use WWW::OpenAPIClient::Object::ChildWithNullable;
use WWW::OpenAPIClient::Object::ClassModel;
use WWW::OpenAPIClient::Object::Client;
use WWW::OpenAPIClient::Object::DeprecatedModel;
use WWW::OpenAPIClient::Object::Dog;
use WWW::OpenAPIClient::Object::EnumArrays;
use WWW::OpenAPIClient::Object::EnumClass;
use WWW::OpenAPIClient::Object::EnumTest;
use WWW::OpenAPIClient::Object::FakeBigDecimalMap200Response;
use WWW::OpenAPIClient::Object::File;
use WWW::OpenAPIClient::Object::FileSchemaTestClass;
use WWW::OpenAPIClient::Object::Foo;
use WWW::OpenAPIClient::Object::FooGetDefaultResponse;
use WWW::OpenAPIClient::Object::FormatTest;
use WWW::OpenAPIClient::Object::HasOnlyReadOnly;
use WWW::OpenAPIClient::Object::HealthCheckResult;
use WWW::OpenAPIClient::Object::Human;
use WWW::OpenAPIClient::Object::List;
use WWW::OpenAPIClient::Object::MapTest;
use WWW::OpenAPIClient::Object::MixedPropertiesAndAdditionalPropertiesClass;
use WWW::OpenAPIClient::Object::Model200Response;
use WWW::OpenAPIClient::Object::ModelReturn;
use WWW::OpenAPIClient::Object::Name;
use WWW::OpenAPIClient::Object::NullableClass;
use WWW::OpenAPIClient::Object::NumberOnly;
use WWW::OpenAPIClient::Object::ObjectWithDeprecatedFields;
use WWW::OpenAPIClient::Object::Order;
use WWW::OpenAPIClient::Object::OuterComposite;
use WWW::OpenAPIClient::Object::OuterEnum;
use WWW::OpenAPIClient::Object::OuterEnumDefaultValue;
use WWW::OpenAPIClient::Object::OuterEnumInteger;
use WWW::OpenAPIClient::Object::OuterEnumIntegerDefaultValue;
use WWW::OpenAPIClient::Object::OuterObjectWithEnumProperty;
use WWW::OpenAPIClient::Object::ParentWithNullable;
use WWW::OpenAPIClient::Object::Person;
use WWW::OpenAPIClient::Object::Pet;
use WWW::OpenAPIClient::Object::ReadOnlyFirst;
use WWW::OpenAPIClient::Object::SingleRefType;
use WWW::OpenAPIClient::Object::SpecialModelName;
use WWW::OpenAPIClient::Object::Tag;
use WWW::OpenAPIClient::Object::TestInlineFreeformAdditionalPropertiesRequest;
use WWW::OpenAPIClient::Object::User;

````

# GETTING STARTED
Put the Perl SDK under the 'lib' folder in your project directory, then run the following
```perl
#!/usr/bin/perl
use lib 'lib';
use strict;
use warnings;
# load the API package
use WWW::OpenAPIClient::AnotherFakeApi;
use WWW::OpenAPIClient::DefaultApi;
use WWW::OpenAPIClient::FakeApi;
use WWW::OpenAPIClient::FakeClassnameTags123Api;
use WWW::OpenAPIClient::PetApi;
use WWW::OpenAPIClient::StoreApi;
use WWW::OpenAPIClient::UserApi;

# load the models
use WWW::OpenAPIClient::Object::AdditionalPropertiesClass;
use WWW::OpenAPIClient::Object::Adult;
use WWW::OpenAPIClient::Object::AllOfWithSingleRef;
use WWW::OpenAPIClient::Object::Animal;
use WWW::OpenAPIClient::Object::ApiResponse;
use WWW::OpenAPIClient::Object::ArrayOfArrayOfNumberOnly;
use WWW::OpenAPIClient::Object::ArrayOfNumberOnly;
use WWW::OpenAPIClient::Object::ArrayTest;
use WWW::OpenAPIClient::Object::Capitalization;
use WWW::OpenAPIClient::Object::Cat;
use WWW::OpenAPIClient::Object::Category;
use WWW::OpenAPIClient::Object::Child;
use WWW::OpenAPIClient::Object::ChildWithNullable;
use WWW::OpenAPIClient::Object::ClassModel;
use WWW::OpenAPIClient::Object::Client;
use WWW::OpenAPIClient::Object::DeprecatedModel;
use WWW::OpenAPIClient::Object::Dog;
use WWW::OpenAPIClient::Object::EnumArrays;
use WWW::OpenAPIClient::Object::EnumClass;
use WWW::OpenAPIClient::Object::EnumTest;
use WWW::OpenAPIClient::Object::FakeBigDecimalMap200Response;
use WWW::OpenAPIClient::Object::File;
use WWW::OpenAPIClient::Object::FileSchemaTestClass;
use WWW::OpenAPIClient::Object::Foo;
use WWW::OpenAPIClient::Object::FooGetDefaultResponse;
use WWW::OpenAPIClient::Object::FormatTest;
use WWW::OpenAPIClient::Object::HasOnlyReadOnly;
use WWW::OpenAPIClient::Object::HealthCheckResult;
use WWW::OpenAPIClient::Object::Human;
use WWW::OpenAPIClient::Object::List;
use WWW::OpenAPIClient::Object::MapTest;
use WWW::OpenAPIClient::Object::MixedPropertiesAndAdditionalPropertiesClass;
use WWW::OpenAPIClient::Object::Model200Response;
use WWW::OpenAPIClient::Object::ModelReturn;
use WWW::OpenAPIClient::Object::Name;
use WWW::OpenAPIClient::Object::NullableClass;
use WWW::OpenAPIClient::Object::NumberOnly;
use WWW::OpenAPIClient::Object::ObjectWithDeprecatedFields;
use WWW::OpenAPIClient::Object::Order;
use WWW::OpenAPIClient::Object::OuterComposite;
use WWW::OpenAPIClient::Object::OuterEnum;
use WWW::OpenAPIClient::Object::OuterEnumDefaultValue;
use WWW::OpenAPIClient::Object::OuterEnumInteger;
use WWW::OpenAPIClient::Object::OuterEnumIntegerDefaultValue;
use WWW::OpenAPIClient::Object::OuterObjectWithEnumProperty;
use WWW::OpenAPIClient::Object::ParentWithNullable;
use WWW::OpenAPIClient::Object::Person;
use WWW::OpenAPIClient::Object::Pet;
use WWW::OpenAPIClient::Object::ReadOnlyFirst;
use WWW::OpenAPIClient::Object::SingleRefType;
use WWW::OpenAPIClient::Object::SpecialModelName;
use WWW::OpenAPIClient::Object::Tag;
use WWW::OpenAPIClient::Object::TestInlineFreeformAdditionalPropertiesRequest;
use WWW::OpenAPIClient::Object::User;

# for displaying the API response data
use Data::Dumper;


my $api_instance = WWW::OpenAPIClient::AnotherFakeApi->new(
);

my $client = WWW::OpenAPIClient::Object::Client->new(); # Client | client model

eval {
    my $result = $api_instance->call_123_test_special_tags(client => $client);
    print Dumper($result);
};
if ($@) {
    warn "Exception when calling AnotherFakeApi->call_123_test_special_tags: $@\n";
}

```

# DOCUMENTATION FOR API ENDPOINTS

All URIs are relative to *http://petstore.swagger.io:80/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnotherFakeApi* | [**call_123_test_special_tags**](docs/AnotherFakeApi.md#call_123_test_special_tags) | **PATCH** /another-fake/dummy | To test special tags
*DefaultApi* | [**foo_get**](docs/DefaultApi.md#foo_get) | **GET** /foo | 
*FakeApi* | [**fake_big_decimal_map**](docs/FakeApi.md#fake_big_decimal_map) | **GET** /fake/BigDecimalMap | 
*FakeApi* | [**fake_health_get**](docs/FakeApi.md#fake_health_get) | **GET** /fake/health | Health check endpoint
*FakeApi* | [**fake_http_signature_test**](docs/FakeApi.md#fake_http_signature_test) | **GET** /fake/http-signature-test | test http signature authentication
*FakeApi* | [**fake_outer_boolean_serialize**](docs/FakeApi.md#fake_outer_boolean_serialize) | **POST** /fake/outer/boolean | 
*FakeApi* | [**fake_outer_composite_serialize**](docs/FakeApi.md#fake_outer_composite_serialize) | **POST** /fake/outer/composite | 
*FakeApi* | [**fake_outer_number_serialize**](docs/FakeApi.md#fake_outer_number_serialize) | **POST** /fake/outer/number | 
*FakeApi* | [**fake_outer_string_serialize**](docs/FakeApi.md#fake_outer_string_serialize) | **POST** /fake/outer/string | 
*FakeApi* | [**fake_property_enum_integer_serialize**](docs/FakeApi.md#fake_property_enum_integer_serialize) | **POST** /fake/property/enum-int | 
*FakeApi* | [**test_additional_properties_reference**](docs/FakeApi.md#test_additional_properties_reference) | **POST** /fake/additionalProperties-reference | test referenced additionalProperties
*FakeApi* | [**test_body_with_binary**](docs/FakeApi.md#test_body_with_binary) | **PUT** /fake/body-with-binary | 
*FakeApi* | [**test_body_with_file_schema**](docs/FakeApi.md#test_body_with_file_schema) | **PUT** /fake/body-with-file-schema | 
*FakeApi* | [**test_body_with_query_params**](docs/FakeApi.md#test_body_with_query_params) | **PUT** /fake/body-with-query-params | 
*FakeApi* | [**test_client_model**](docs/FakeApi.md#test_client_model) | **PATCH** /fake | To test \&quot;client\&quot; model
*FakeApi* | [**test_endpoint_parameters**](docs/FakeApi.md#test_endpoint_parameters) | **POST** /fake | Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
*FakeApi* | [**test_enum_parameters**](docs/FakeApi.md#test_enum_parameters) | **GET** /fake | To test enum parameters
*FakeApi* | [**test_group_parameters**](docs/FakeApi.md#test_group_parameters) | **DELETE** /fake | Fake endpoint to test group parameters (optional)
*FakeApi* | [**test_inline_additional_properties**](docs/FakeApi.md#test_inline_additional_properties) | **POST** /fake/inline-additionalProperties | test inline additionalProperties
*FakeApi* | [**test_inline_freeform_additional_properties**](docs/FakeApi.md#test_inline_freeform_additional_properties) | **POST** /fake/inline-freeform-additionalProperties | test inline free-form additionalProperties
*FakeApi* | [**test_json_form_data**](docs/FakeApi.md#test_json_form_data) | **GET** /fake/jsonFormData | test json serialization of form data
*FakeApi* | [**test_nullable**](docs/FakeApi.md#test_nullable) | **POST** /fake/nullable | test nullable parent property
*FakeApi* | [**test_query_parameter_collection_format**](docs/FakeApi.md#test_query_parameter_collection_format) | **PUT** /fake/test-query-parameters | 
*FakeClassnameTags123Api* | [**test_classname**](docs/FakeClassnameTags123Api.md#test_classname) | **PATCH** /fake_classname_test | To test class name in snake case
*PetApi* | [**add_pet**](docs/PetApi.md#add_pet) | **POST** /pet | Add a new pet to the store
*PetApi* | [**delete_pet**](docs/PetApi.md#delete_pet) | **DELETE** /pet/{petId} | Deletes a pet
*PetApi* | [**find_pets_by_status**](docs/PetApi.md#find_pets_by_status) | **GET** /pet/findByStatus | Finds Pets by status
*PetApi* | [**find_pets_by_tags**](docs/PetApi.md#find_pets_by_tags) | **GET** /pet/findByTags | Finds Pets by tags
*PetApi* | [**get_pet_by_id**](docs/PetApi.md#get_pet_by_id) | **GET** /pet/{petId} | Find pet by ID
*PetApi* | [**update_pet**](docs/PetApi.md#update_pet) | **PUT** /pet | Update an existing pet
*PetApi* | [**update_pet_with_form**](docs/PetApi.md#update_pet_with_form) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApi* | [**upload_file**](docs/PetApi.md#upload_file) | **POST** /pet/{petId}/uploadImage | uploads an image
*PetApi* | [**upload_file_with_required_file**](docs/PetApi.md#upload_file_with_required_file) | **POST** /fake/{petId}/uploadImageWithRequiredFile | uploads an image (required)
*StoreApi* | [**delete_order**](docs/StoreApi.md#delete_order) | **DELETE** /store/order/{order_id} | Delete purchase order by ID
*StoreApi* | [**get_inventory**](docs/StoreApi.md#get_inventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreApi* | [**get_order_by_id**](docs/StoreApi.md#get_order_by_id) | **GET** /store/order/{order_id} | Find purchase order by ID
*StoreApi* | [**place_order**](docs/StoreApi.md#place_order) | **POST** /store/order | Place an order for a pet
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /user | Create user
*UserApi* | [**create_users_with_array_input**](docs/UserApi.md#create_users_with_array_input) | **POST** /user/createWithArray | Creates list of users with given input array
*UserApi* | [**create_users_with_list_input**](docs/UserApi.md#create_users_with_list_input) | **POST** /user/createWithList | Creates list of users with given input array
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user/{username} | Delete user
*UserApi* | [**get_user_by_name**](docs/UserApi.md#get_user_by_name) | **GET** /user/{username} | Get user by user name
*UserApi* | [**login_user**](docs/UserApi.md#login_user) | **GET** /user/login | Logs user into the system
*UserApi* | [**logout_user**](docs/UserApi.md#logout_user) | **GET** /user/logout | Logs out current logged in user session
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /user/{username} | Updated user


# DOCUMENTATION FOR MODELS
 - [WWW::OpenAPIClient::Object::AdditionalPropertiesClass](docs/AdditionalPropertiesClass.md)
 - [WWW::OpenAPIClient::Object::Adult](docs/Adult.md)
 - [WWW::OpenAPIClient::Object::AllOfWithSingleRef](docs/AllOfWithSingleRef.md)
 - [WWW::OpenAPIClient::Object::Animal](docs/Animal.md)
 - [WWW::OpenAPIClient::Object::ApiResponse](docs/ApiResponse.md)
 - [WWW::OpenAPIClient::Object::ArrayOfArrayOfNumberOnly](docs/ArrayOfArrayOfNumberOnly.md)
 - [WWW::OpenAPIClient::Object::ArrayOfNumberOnly](docs/ArrayOfNumberOnly.md)
 - [WWW::OpenAPIClient::Object::ArrayTest](docs/ArrayTest.md)
 - [WWW::OpenAPIClient::Object::Capitalization](docs/Capitalization.md)
 - [WWW::OpenAPIClient::Object::Cat](docs/Cat.md)
 - [WWW::OpenAPIClient::Object::Category](docs/Category.md)
 - [WWW::OpenAPIClient::Object::Child](docs/Child.md)
 - [WWW::OpenAPIClient::Object::ChildWithNullable](docs/ChildWithNullable.md)
 - [WWW::OpenAPIClient::Object::ClassModel](docs/ClassModel.md)
 - [WWW::OpenAPIClient::Object::Client](docs/Client.md)
 - [WWW::OpenAPIClient::Object::DeprecatedModel](docs/DeprecatedModel.md)
 - [WWW::OpenAPIClient::Object::Dog](docs/Dog.md)
 - [WWW::OpenAPIClient::Object::EnumArrays](docs/EnumArrays.md)
 - [WWW::OpenAPIClient::Object::EnumClass](docs/EnumClass.md)
 - [WWW::OpenAPIClient::Object::EnumTest](docs/EnumTest.md)
 - [WWW::OpenAPIClient::Object::FakeBigDecimalMap200Response](docs/FakeBigDecimalMap200Response.md)
 - [WWW::OpenAPIClient::Object::File](docs/File.md)
 - [WWW::OpenAPIClient::Object::FileSchemaTestClass](docs/FileSchemaTestClass.md)
 - [WWW::OpenAPIClient::Object::Foo](docs/Foo.md)
 - [WWW::OpenAPIClient::Object::FooGetDefaultResponse](docs/FooGetDefaultResponse.md)
 - [WWW::OpenAPIClient::Object::FormatTest](docs/FormatTest.md)
 - [WWW::OpenAPIClient::Object::HasOnlyReadOnly](docs/HasOnlyReadOnly.md)
 - [WWW::OpenAPIClient::Object::HealthCheckResult](docs/HealthCheckResult.md)
 - [WWW::OpenAPIClient::Object::Human](docs/Human.md)
 - [WWW::OpenAPIClient::Object::List](docs/List.md)
 - [WWW::OpenAPIClient::Object::MapTest](docs/MapTest.md)
 - [WWW::OpenAPIClient::Object::MixedPropertiesAndAdditionalPropertiesClass](docs/MixedPropertiesAndAdditionalPropertiesClass.md)
 - [WWW::OpenAPIClient::Object::Model200Response](docs/Model200Response.md)
 - [WWW::OpenAPIClient::Object::ModelReturn](docs/ModelReturn.md)
 - [WWW::OpenAPIClient::Object::Name](docs/Name.md)
 - [WWW::OpenAPIClient::Object::NullableClass](docs/NullableClass.md)
 - [WWW::OpenAPIClient::Object::NumberOnly](docs/NumberOnly.md)
 - [WWW::OpenAPIClient::Object::ObjectWithDeprecatedFields](docs/ObjectWithDeprecatedFields.md)
 - [WWW::OpenAPIClient::Object::Order](docs/Order.md)
 - [WWW::OpenAPIClient::Object::OuterComposite](docs/OuterComposite.md)
 - [WWW::OpenAPIClient::Object::OuterEnum](docs/OuterEnum.md)
 - [WWW::OpenAPIClient::Object::OuterEnumDefaultValue](docs/OuterEnumDefaultValue.md)
 - [WWW::OpenAPIClient::Object::OuterEnumInteger](docs/OuterEnumInteger.md)
 - [WWW::OpenAPIClient::Object::OuterEnumIntegerDefaultValue](docs/OuterEnumIntegerDefaultValue.md)
 - [WWW::OpenAPIClient::Object::OuterObjectWithEnumProperty](docs/OuterObjectWithEnumProperty.md)
 - [WWW::OpenAPIClient::Object::ParentWithNullable](docs/ParentWithNullable.md)
 - [WWW::OpenAPIClient::Object::Person](docs/Person.md)
 - [WWW::OpenAPIClient::Object::Pet](docs/Pet.md)
 - [WWW::OpenAPIClient::Object::ReadOnlyFirst](docs/ReadOnlyFirst.md)
 - [WWW::OpenAPIClient::Object::SingleRefType](docs/SingleRefType.md)
 - [WWW::OpenAPIClient::Object::SpecialModelName](docs/SpecialModelName.md)
 - [WWW::OpenAPIClient::Object::Tag](docs/Tag.md)
 - [WWW::OpenAPIClient::Object::TestInlineFreeformAdditionalPropertiesRequest](docs/TestInlineFreeformAdditionalPropertiesRequest.md)
 - [WWW::OpenAPIClient::Object::User](docs/User.md)


# DOCUMENTATION FOR AUTHORIZATION

Authentication schemes defined for the API:
## petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
  - **write:pets**: modify pets in your account
  - **read:pets**: read your pets

## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header

## api_key_query

- **Type**: API key
- **API key parameter name**: api_key_query
- **Location**: URL query string

## http_basic_test

- **Type**: HTTP basic authentication

## bearer_test

- **Type**: HTTP Bearer Token authentication (JWT)

## http_signature_test

- **Type**: HTTP signature authentication

