<?php
/**
 * PetApi
 * PHP version 8.1
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * @generated Generated by: https://openapi-generator.tech
 * Generator version: 7.20.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use InvalidArgumentException;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\ObjectSerializer;

/**
 * PetApi Class Doc Comment
 *
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PetApi
{
    /**
     * @var ClientInterface
     */
    protected ClientInterface $client;

    /**
     * @var Configuration
     */
    protected Configuration $config;

    /**
     * @var HeaderSelector
     */
    protected HeaderSelector $headerSelector;

    /**
     * @var int Host index
     */
    protected int $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addPet' => [
            'application/json',
            'application/xml',
        ],
        'deletePet' => [
            'application/json',
        ],
        'findPetsByStatus' => [
            'application/json',
        ],
        'findPetsByTags' => [
            'application/json',
        ],
        'getPetById' => [
            'application/json',
        ],
        'updatePet' => [
            'application/json',
            'application/xml',
        ],
        'updatePetWithForm' => [
            'application/x-www-form-urlencoded',
        ],
        'uploadFile' => [
            'multipart/form-data',
        ],
        'uploadFileWithRequiredFile' => [
            'multipart/form-data',
        ],
    ];

    /**
     * @param ClientInterface|null $client
     * @param Configuration|null   $config
     * @param HeaderSelector|null  $selector
     * @param int                  $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex(int $hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex(): int
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig(): Configuration
    {
        return $this->config;
    }

    /**
     * Operation addPet
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function addPet(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['addPet'][0]
    ): void
    {
        $this->addPetWithHttpInfo($pet, $hostIndex, $variables, $contentType);
    }

    /**
     * Operation addPetWithHttpInfo
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addPetWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['addPet'][0]
    ): array
    {
        $request = $this->addPetRequest($pet, $hostIndex, $variables, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation addPetAsync
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function addPetAsync(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['addPet'][0]
    ): PromiseInterface
    {
        return $this->addPetAsyncWithHttpInfo($pet, $hostIndex, $variables, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addPetAsyncWithHttpInfo
     *
     * Add a new pet to the store
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function addPetAsyncWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['addPet'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->addPetRequest($pet, $hostIndex, $variables, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addPet'
     *
    * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
    * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
    *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
    *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addPetRequest(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['addPet'][0]
    ): Request
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet when calling addPet'
            );
        }


        $resourcePath = '/pet';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        # Preserve the original behavior of server indexing.
        if ($hostIndex === null) {
            $hostIndex = $this->hostIndex;
        }

        $hostSettings = $this->getHostSettingsForaddPet();

        if ($hostIndex < 0 || $hostIndex >= count($hostSettings)) {
            throw new InvalidArgumentException("Invalid index {$hostIndex} when selecting the host. Must be less than ".count($hostSettings));
        }
        $operationHost = Configuration::getHostString($hostSettings, $hostIndex, $variables);
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Returns an array of host settings for Operation addPet
     *
     * @return array an array of host settings
     */
    protected function getHostSettingsForaddPet(): array
    {
        return [
            [
                "url" => "http://localhost/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://petstore.swagger.io/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://path-server-test.petstore.local/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://{server}.swagger.io:{port}/v2",
                "description" => "test server with variables",
                "variables" => [
                    "server" => [
                    "description" => "target server",
                    "default_value" => "petstore",
                    "enum_values" => [
                        "petstore",
                        "qa-petstore",
                        "dev-petstore",
                    ]
                    ],
                    "port" => [
                    "description" => "No description provided",
                    "default_value" => "80",
                    "enum_values" => [
                        "80",
                        "8080",
                    ]
                    ]
                ]
            ]
        ];
    }

    /**
     * Operation deletePet
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function deletePet(
        int $pet_id,
        ?string $api_key = null,
        string $contentType = self::contentTypes['deletePet'][0]
    ): void
    {
        $this->deletePetWithHttpInfo($pet_id, $api_key, $contentType);
    }

    /**
     * Operation deletePetWithHttpInfo
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePetWithHttpInfo(
        int $pet_id,
        ?string $api_key = null,
        string $contentType = self::contentTypes['deletePet'][0]
    ): array
    {
        $request = $this->deletePetRequest($pet_id, $api_key, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation deletePetAsync
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function deletePetAsync(
        int $pet_id,
        ?string $api_key = null,
        string $contentType = self::contentTypes['deletePet'][0]
    ): PromiseInterface
    {
        return $this->deletePetAsyncWithHttpInfo($pet_id, $api_key, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePetAsyncWithHttpInfo
     *
     * Deletes a pet
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function deletePetAsyncWithHttpInfo(
        int $pet_id,
        ?string $api_key = null,
        string $contentType = self::contentTypes['deletePet'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->deletePetRequest($pet_id, $api_key, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePet'
     *
     * @param  int $pet_id Pet id to delete (required)
     * @param  string|null $api_key (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePetRequest(
        int $pet_id,
        ?string $api_key = null,
        string $contentType = self::contentTypes['deletePet'][0]
    ): Request
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet_id when calling deletePet'
            );
        }



        $resourcePath = '/pet/{petId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($api_key !== null) {
            $headerParams['api_key'] = ObjectSerializer::toHeaderValue($api_key);
        }

        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findPetsByStatus
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet[]|null
     */
    public function findPetsByStatus(
        array $status,
        string $contentType = self::contentTypes['findPetsByStatus'][0]
    ): ?array
    {
        list($response) = $this->findPetsByStatusWithHttpInfo($status, $contentType);
        return $response;
    }

    /**
     * Operation findPetsByStatusWithHttpInfo
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet[], HTTP status code, HTTP response headers (array of strings)
     */
    public function findPetsByStatusWithHttpInfo(
        array $status,
        string $contentType = self::contentTypes['findPetsByStatus'][0]
    ): array
    {
        $request = $this->findPetsByStatusRequest($status, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet[]',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation findPetsByStatusAsync
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function findPetsByStatusAsync(
        array $status,
        string $contentType = self::contentTypes['findPetsByStatus'][0]
    ): PromiseInterface
    {
        return $this->findPetsByStatusAsyncWithHttpInfo($status, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findPetsByStatusAsyncWithHttpInfo
     *
     * Finds Pets by status
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function findPetsByStatusAsyncWithHttpInfo(
        array $status,
        string $contentType = self::contentTypes['findPetsByStatus'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet[]';
        $request = $this->findPetsByStatusRequest($status, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findPetsByStatus'
     *
     * @param  string[] $status Status values that need to be considered for filter (required) (deprecated)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByStatus'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function findPetsByStatusRequest(
        array $status,
        string $contentType = self::contentTypes['findPetsByStatus'][0]
    ): Request
    {

        // verify the required parameter 'status' is set
        if ($status === null || (is_array($status) && count($status) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $status when calling findPetsByStatus'
            );
        }


        $resourcePath = '/pet/findByStatus';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'status', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/xml', 'application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findPetsByTags
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet[]|null
     * @deprecated
     */
    public function findPetsByTags(
        array $tags,
        string $contentType = self::contentTypes['findPetsByTags'][0]
    ): ?array
    {
        list($response) = $this->findPetsByTagsWithHttpInfo($tags, $contentType);
        return $response;
    }

    /**
     * Operation findPetsByTagsWithHttpInfo
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet[], HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function findPetsByTagsWithHttpInfo(
        array $tags,
        string $contentType = self::contentTypes['findPetsByTags'][0]
    ): array
    {
        $request = $this->findPetsByTagsRequest($tags, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet[]',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation findPetsByTagsAsync
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     * @deprecated
     */
    public function findPetsByTagsAsync(
        array $tags,
        string $contentType = self::contentTypes['findPetsByTags'][0]
    ): PromiseInterface
    {
        return $this->findPetsByTagsAsyncWithHttpInfo($tags, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findPetsByTagsAsyncWithHttpInfo
     *
     * Finds Pets by tags
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     * @deprecated
     */
    public function findPetsByTagsAsyncWithHttpInfo(
        array $tags,
        string $contentType = self::contentTypes['findPetsByTags'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet[]';
        $request = $this->findPetsByTagsRequest($tags, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findPetsByTags'
     *
     * @param  string[] $tags Tags to filter by (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findPetsByTags'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function findPetsByTagsRequest(
        array $tags,
        string $contentType = self::contentTypes['findPetsByTags'][0]
    ): Request
    {

        // verify the required parameter 'tags' is set
        if ($tags === null || (is_array($tags) && count($tags) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $tags when calling findPetsByTags'
            );
        }
        

        $resourcePath = '/pet/findByTags';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $tags,
            'tags', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/xml', 'application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPetById
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet|null
     */
    public function getPetById(
        int $pet_id,
        string $contentType = self::contentTypes['getPetById'][0]
    ): ?\OpenAPI\Client\Model\Pet
    {
        list($response) = $this->getPetByIdWithHttpInfo($pet_id, $contentType);
        return $response;
    }

    /**
     * Operation getPetByIdWithHttpInfo
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPetByIdWithHttpInfo(
        int $pet_id,
        string $contentType = self::contentTypes['getPetById'][0]
    ): array
    {
        $request = $this->getPetByIdRequest($pet_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation getPetByIdAsync
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function getPetByIdAsync(
        int $pet_id,
        string $contentType = self::contentTypes['getPetById'][0]
    ): PromiseInterface
    {
        return $this->getPetByIdAsyncWithHttpInfo($pet_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPetByIdAsyncWithHttpInfo
     *
     * Find pet by ID
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function getPetByIdAsyncWithHttpInfo(
        int $pet_id,
        string $contentType = self::contentTypes['getPetById'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->getPetByIdRequest($pet_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPetById'
     *
     * @param  int $pet_id ID of pet to return (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPetById'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPetByIdRequest(
        int $pet_id,
        string $contentType = self::contentTypes['getPetById'][0]
    ): Request
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet_id when calling getPetById'
            );
        }


        $resourcePath = '/pet/{petId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/xml', 'application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api_key');
        if ($apiKey !== null) {
            $headers['api_key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePet
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function updatePet(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['updatePet'][0]
    ): void
    {
        $this->updatePetWithHttpInfo($pet, $hostIndex, $variables, $contentType);
    }

    /**
     * Operation updatePetWithHttpInfo
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePetWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['updatePet'][0]
    ): array
    {
        $request = $this->updatePetRequest($pet, $hostIndex, $variables, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation updatePetAsync
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function updatePetAsync(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['updatePet'][0]
    ): PromiseInterface
    {
        return $this->updatePetAsyncWithHttpInfo($pet, $hostIndex, $variables, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePetAsyncWithHttpInfo
     *
     * Update an existing pet
     *
     * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
     * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
     *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
     *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function updatePetAsyncWithHttpInfo(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['updatePet'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->updatePetRequest($pet, $hostIndex, $variables, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePet'
     *
    * This operation contains host(s) defined in the OpenAPI spec. Use 'hostIndex' to select the host.
    * if needed, use the 'variables' parameter to pass variables to the host.
     * URL: http://localhost/v2
     * URL: http://petstore.swagger.io/v2
     * URL: http://path-server-test.petstore.local/v2
     * URL: http://{server}.swagger.io:{port}/v2
     *  Variables:
    *    - server: target server
     *      Allowed values:
     *        - petstore
     *        - qa-petstore
     *        - dev-petstore
    *    - port:  No description provided
     *      Allowed values:
     *        - 80
     *        - 8080
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  null|int $hostIndex Host index. Defaults to null. If null, then the library will use $this->hostIndex instead
     * @param  array $variables Associative array of variables to pass to the host. Defaults to empty array.
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePet'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePetRequest(
        \OpenAPI\Client\Model\Pet $pet,
        ?int $hostIndex = null,
        array $variables = [],
        string $contentType = self::contentTypes['updatePet'][0]
    ): Request
    {

        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet when calling updatePet'
            );
        }


        $resourcePath = '/pet';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        # Preserve the original behavior of server indexing.
        if ($hostIndex === null) {
            $hostIndex = $this->hostIndex;
        }

        $hostSettings = $this->getHostSettingsForupdatePet();

        if ($hostIndex < 0 || $hostIndex >= count($hostSettings)) {
            throw new InvalidArgumentException("Invalid index {$hostIndex} when selecting the host. Must be less than ".count($hostSettings));
        }
        $operationHost = Configuration::getHostString($hostSettings, $hostIndex, $variables);
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Returns an array of host settings for Operation updatePet
     *
     * @return array an array of host settings
     */
    protected function getHostSettingsForupdatePet(): array
    {
        return [
            [
                "url" => "http://localhost/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://petstore.swagger.io/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://path-server-test.petstore.local/v2",
                "description" => "No description provided",
            ],
            [
                "url" => "http://{server}.swagger.io:{port}/v2",
                "description" => "test server with variables",
                "variables" => [
                    "server" => [
                    "description" => "target server",
                    "default_value" => "petstore",
                    "enum_values" => [
                        "petstore",
                        "qa-petstore",
                        "dev-petstore",
                    ]
                    ],
                    "port" => [
                    "description" => "No description provided",
                    "default_value" => "80",
                    "enum_values" => [
                        "80",
                        "8080",
                    ]
                    ]
                ]
            ]
        ];
    }

    /**
     * Operation updatePetWithForm
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return void
     */
    public function updatePetWithForm(
        int $pet_id,
        ?string $name = null,
        ?string $status = null,
        string $contentType = self::contentTypes['updatePetWithForm'][0]
    ): void
    {
        $this->updatePetWithFormWithHttpInfo($pet_id, $name, $status, $contentType);
    }

    /**
     * Operation updatePetWithFormWithHttpInfo
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePetWithFormWithHttpInfo(
        int $pet_id,
        ?string $name = null,
        ?string $status = null,
        string $contentType = self::contentTypes['updatePetWithForm'][0]
    ): array
    {
        $request = $this->updatePetWithFormRequest($pet_id, $name, $status, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        
            throw $e;
        }
    }

    /**
     * Operation updatePetWithFormAsync
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function updatePetWithFormAsync(
        int $pet_id,
        ?string $name = null,
        ?string $status = null,
        string $contentType = self::contentTypes['updatePetWithForm'][0]
    ): PromiseInterface
    {
        return $this->updatePetWithFormAsyncWithHttpInfo($pet_id, $name, $status, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePetWithFormAsyncWithHttpInfo
     *
     * Updates a pet in the store with form data
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function updatePetWithFormAsyncWithHttpInfo(
        int $pet_id,
        ?string $name = null,
        ?string $status = null,
        string $contentType = self::contentTypes['updatePetWithForm'][0]
    ): PromiseInterface
    {
        $returnType = '';
        $request = $this->updatePetWithFormRequest($pet_id, $name, $status, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePetWithForm'
     *
     * @param  int $pet_id ID of pet that needs to be updated (required)
     * @param  string|null $name Updated name of the pet (optional)
     * @param  string|null $status Updated status of the pet (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePetWithForm'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePetWithFormRequest(
        int $pet_id,
        ?string $name = null,
        ?string $status = null,
        string $contentType = self::contentTypes['updatePetWithForm'][0]
    ): Request
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet_id when calling updatePetWithForm'
            );
        }




        $resourcePath = '/pet/{petId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'name' => $name,
            'status' => $status,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadFile
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadFile(
        int $pet_id,
        ?string $additional_metadata = null,
        ?\SplFileObject $file = null,
        string $contentType = self::contentTypes['uploadFile'][0]
    ): \OpenAPI\Client\Model\ApiResponse
    {
        list($response) = $this->uploadFileWithHttpInfo($pet_id, $additional_metadata, $file, $contentType);
        return $response;
    }

    /**
     * Operation uploadFileWithHttpInfo
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadFileWithHttpInfo(
        int $pet_id,
        ?string $additional_metadata = null,
        ?\SplFileObject $file = null,
        string $contentType = self::contentTypes['uploadFile'][0]
    ): array
    {
        $request = $this->uploadFileRequest($pet_id, $additional_metadata, $file, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation uploadFileAsync
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function uploadFileAsync(
        int $pet_id,
        ?string $additional_metadata = null,
        ?\SplFileObject $file = null,
        string $contentType = self::contentTypes['uploadFile'][0]
    ): PromiseInterface
    {
        return $this->uploadFileAsyncWithHttpInfo($pet_id, $additional_metadata, $file, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadFileAsyncWithHttpInfo
     *
     * uploads an image
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function uploadFileAsyncWithHttpInfo(
        int $pet_id,
        ?string $additional_metadata = null,
        ?\SplFileObject $file = null,
        string $contentType = self::contentTypes['uploadFile'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadFileRequest($pet_id, $additional_metadata, $file, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadFile'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  \SplFileObject|null $file file to upload (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFile'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadFileRequest(
        int $pet_id,
        ?string $additional_metadata = null,
        ?\SplFileObject $file = null,
        string $contentType = self::contentTypes['uploadFile'][0]
    ): Request
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadFile'
            );
        }




        $resourcePath = '/pet/{petId}/uploadImage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'additional_metadata' => $additional_metadata,
            'file' => $file,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadFileWithRequiredFile
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return \OpenAPI\Client\Model\ApiResponse
     */
    public function uploadFileWithRequiredFile(
        int $pet_id,
        \SplFileObject $required_file,
        ?string $additional_metadata = null,
        string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0]
    ): \OpenAPI\Client\Model\ApiResponse
    {
        list($response) = $this->uploadFileWithRequiredFileWithHttpInfo($pet_id, $required_file, $additional_metadata, $contentType);
        return $response;
    }

    /**
     * Operation uploadFileWithRequiredFileWithHttpInfo
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws ApiException on non-2xx response or if the response body is not in the expected format
     * @throws InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadFileWithRequiredFileWithHttpInfo(
        int $pet_id,
        \SplFileObject $required_file,
        ?string $additional_metadata = null,
        string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0]
    ): array
    {
        $request = $this->uploadFileWithRequiredFileRequest($pet_id, $required_file, $additional_metadata, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ApiResponse',
                        $request,
                        $response,
                    );
            }
            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ApiResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ApiResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        
            throw $e;
        }
    }

    /**
     * Operation uploadFileWithRequiredFileAsync
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function uploadFileWithRequiredFileAsync(
        int $pet_id,
        \SplFileObject $required_file,
        ?string $additional_metadata = null,
        string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0]
    ): PromiseInterface
    {
        return $this->uploadFileWithRequiredFileAsyncWithHttpInfo($pet_id, $required_file, $additional_metadata, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadFileWithRequiredFileAsyncWithHttpInfo
     *
     * uploads an image (required)
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return PromiseInterface
     */
    public function uploadFileWithRequiredFileAsyncWithHttpInfo(
        int $pet_id,
        \SplFileObject $required_file,
        ?string $additional_metadata = null,
        string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0]
    ): PromiseInterface
    {
        $returnType = '\OpenAPI\Client\Model\ApiResponse';
        $request = $this->uploadFileWithRequiredFileRequest($pet_id, $required_file, $additional_metadata, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if (in_array($returnType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadFileWithRequiredFile'
     *
     * @param  int $pet_id ID of pet to update (required)
     * @param  \SplFileObject $required_file file to upload (required)
     * @param  string|null $additional_metadata Additional data to pass to server (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadFileWithRequiredFile'] to see the possible values for this operation
     *
     * @throws InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadFileWithRequiredFileRequest(
        int $pet_id,
        \SplFileObject $required_file,
        ?string $additional_metadata = null,
        string $contentType = self::contentTypes['uploadFileWithRequiredFile'][0]
    ): Request
    {

        // verify the required parameter 'pet_id' is set
        if ($pet_id === null || (is_array($pet_id) && count($pet_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $pet_id when calling uploadFileWithRequiredFile'
            );
        }

        // verify the required parameter 'required_file' is set
        if ($required_file === null || (is_array($required_file) && count($required_file) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $required_file when calling uploadFileWithRequiredFile'
            );
        }



        $resourcePath = '/fake/{petId}/uploadImageWithRequiredFile';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($pet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'petId' . '}',
                ObjectSerializer::toPathValue($pet_id),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'additional_metadata' => $additional_metadata,
            'required_file' => $required_file,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption(): array
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response,
    ): array {
        if (in_array($dataType, ['\SplFileObject', '\Psr\Http\Message\StreamInterface'])) {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode,
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
