<?php
/**
 * FakeApi
 * PHP version 7.2
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * OpenAPI Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.20.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Psr7\MultipartStream;
use Http\Client\Common\Plugin\ErrorPlugin;
use Http\Client\Common\Plugin\RedirectPlugin;
use Http\Client\Common\PluginClient;
use Http\Client\Common\PluginClientFactory;
use Http\Client\Exception\HttpException;
use Http\Client\HttpAsyncClient;
use Http\Discovery\HttpAsyncClientDiscovery;
use Http\Discovery\Psr17FactoryDiscovery;
use Http\Discovery\Psr18ClientDiscovery;
use Http\Message\RequestFactory;
use Http\Promise\Promise;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\DebugPlugin;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\ObjectSerializer;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestFactoryInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\StreamFactoryInterface;
use Psr\Http\Message\UriFactoryInterface;
use Psr\Http\Message\UriInterface;
use function sprintf;

/**
 * FakeApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FakeApi
{
    /**
     * @var PluginClient
     */
    protected $httpClient;

    /**
     * @var PluginClient
     */
    protected $httpAsyncClient;

    /**
     * @var UriFactoryInterface
     */
    protected $uriFactory;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @var RequestFactoryInterface
     */
    protected $requestFactory;

    /**
     * @var StreamFactoryInterface
     */
    protected $streamFactory;

    public function __construct(
        ?ClientInterface $httpClient = null,
        ?Configuration $config = null,
        ?HttpAsyncClient $httpAsyncClient = null,
        ?UriFactoryInterface $uriFactory = null,
        ?RequestFactoryInterface $requestFactory = null,
        ?StreamFactoryInterface $streamFactory = null,
        ?HeaderSelector $selector = null,
        ?array $plugins = null,
        $hostIndex = 0
    ) {
        $this->config = $config ?? (new Configuration())->setHost('http://petstore.swagger.io:80/v2');
        $this->requestFactory = $requestFactory ?? Psr17FactoryDiscovery::findRequestFactory();
        $this->streamFactory = $streamFactory ?? Psr17FactoryDiscovery::findStreamFactory();

        $plugins = $plugins ?? [
            new RedirectPlugin(['strict' => true]),
            new ErrorPlugin(),
        ];

        if ($this->config->getDebug()) {
            $plugins[] = new DebugPlugin(fopen($this->config->getDebugFile(), 'ab'));
        }

        $this->httpClient = (new PluginClientFactory())->createClient(
            $httpClient ?? Psr18ClientDiscovery::find(),
            $plugins
        );

        $this->httpAsyncClient = (new PluginClientFactory())->createClient(
            $httpAsyncClient ?? HttpAsyncClientDiscovery::find(),
            $plugins
        );

        $this->uriFactory = $uriFactory ?? Psr17FactoryDiscovery::findUriFactory();

        $this->headerSelector = $selector ?? new HeaderSelector();

        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation fakeBigDecimalMap
     *
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\FakeBigDecimalMap200Response
     */
    public function fakeBigDecimalMap()
    {
        list($response) = $this->fakeBigDecimalMapWithHttpInfo();
        return $response;
    }

    /**
     * Operation fakeBigDecimalMapWithHttpInfo
     *
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\FakeBigDecimalMap200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeBigDecimalMapWithHttpInfo()
    {
        $request = $this->fakeBigDecimalMapRequest();

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\FakeBigDecimalMap200Response',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\FakeBigDecimalMap200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\FakeBigDecimalMap200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeBigDecimalMapAsync
     *
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeBigDecimalMapAsync()
    {
        return $this->fakeBigDecimalMapAsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeBigDecimalMapAsyncWithHttpInfo
     *
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeBigDecimalMapAsyncWithHttpInfo()
    {
        $returnType = '\OpenAPI\Client\Model\FakeBigDecimalMap200Response';
        $request = $this->fakeBigDecimalMapRequest();

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeBigDecimalMap'
     *
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeBigDecimalMapRequest()
    {

        $resourcePath = '/fake/BigDecimalMap';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeEnumEndpoint
     *
     * test endpoint with enum parameter
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\EnumClass
     */
    public function fakeEnumEndpoint($enum_class, $enum_class_array, $enum_class_map)
    {
        list($response) = $this->fakeEnumEndpointWithHttpInfo($enum_class, $enum_class_array, $enum_class_map);
        return $response;
    }

    /**
     * Operation fakeEnumEndpointWithHttpInfo
     *
     * test endpoint with enum parameter
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\EnumClass, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeEnumEndpointWithHttpInfo($enum_class, $enum_class_array, $enum_class_map)
    {
        $request = $this->fakeEnumEndpointRequest($enum_class, $enum_class_array, $enum_class_map);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\EnumClass',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\EnumClass',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\EnumClass',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeEnumEndpointAsync
     *
     * test endpoint with enum parameter
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeEnumEndpointAsync($enum_class, $enum_class_array, $enum_class_map)
    {
        return $this->fakeEnumEndpointAsyncWithHttpInfo($enum_class, $enum_class_array, $enum_class_map)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeEnumEndpointAsyncWithHttpInfo
     *
     * test endpoint with enum parameter
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeEnumEndpointAsyncWithHttpInfo($enum_class, $enum_class_array, $enum_class_map)
    {
        $returnType = '\OpenAPI\Client\Model\EnumClass';
        $request = $this->fakeEnumEndpointRequest($enum_class, $enum_class_array, $enum_class_map);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeEnumEndpoint'
     *
     * @param  \OpenAPI\Client\Model\EnumClass $enum_class enum class parameter (required)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_class_array enum class parameter (required)
     * @param  array<string,\OpenAPI\Client\Model\EnumClass> $enum_class_map enum class parameter (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeEnumEndpointRequest($enum_class, $enum_class_array, $enum_class_map)
    {
        // verify the required parameter 'enum_class' is set
        if ($enum_class === null || (is_array($enum_class) && count($enum_class) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $enum_class when calling fakeEnumEndpoint'
            );
        }
        // verify the required parameter 'enum_class_array' is set
        if ($enum_class_array === null || (is_array($enum_class_array) && count($enum_class_array) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $enum_class_array when calling fakeEnumEndpoint'
            );
        }
        // verify the required parameter 'enum_class_map' is set
        if ($enum_class_map === null || (is_array($enum_class_map) && count($enum_class_map) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $enum_class_map when calling fakeEnumEndpoint'
            );
        }

        $resourcePath = '/fake/enum/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($enum_class !== null) {
            if('form' === 'form' && is_array($enum_class)) {
                foreach($enum_class as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['enum-class'] = $enum_class;
            }
        }
        // query params
        if ($enum_class_array !== null) {
            if('form' === 'form' && is_array($enum_class_array)) {
                foreach($enum_class_array as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['enum-class-array'] = $enum_class_array;
            }
        }
        // query params
        if ($enum_class_map !== null) {
            if('form' === 'form' && is_array($enum_class_map)) {
                foreach($enum_class_map as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['enum-class-map'] = $enum_class_map;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeHealthGet
     *
     * Health check endpoint
     *
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\HealthCheckResult
     */
    public function fakeHealthGet()
    {
        list($response) = $this->fakeHealthGetWithHttpInfo();
        return $response;
    }

    /**
     * Operation fakeHealthGetWithHttpInfo
     *
     * Health check endpoint
     *
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\HealthCheckResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeHealthGetWithHttpInfo()
    {
        $request = $this->fakeHealthGetRequest();

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\HealthCheckResult',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\HealthCheckResult',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\HealthCheckResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeHealthGetAsync
     *
     * Health check endpoint
     *
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeHealthGetAsync()
    {
        return $this->fakeHealthGetAsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeHealthGetAsyncWithHttpInfo
     *
     * Health check endpoint
     *
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeHealthGetAsyncWithHttpInfo()
    {
        $returnType = '\OpenAPI\Client\Model\HealthCheckResult';
        $request = $this->fakeHealthGetRequest();

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeHealthGet'
     *
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeHealthGetRequest()
    {

        $resourcePath = '/fake/health';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeHttpSignatureTest
     *
     * test http signature authentication
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $query_1 query parameter (optional)
     * @param  string $header_1 header parameter (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function fakeHttpSignatureTest($pet, $query_1 = null, $header_1 = null)
    {
        $this->fakeHttpSignatureTestWithHttpInfo($pet, $query_1, $header_1);
    }

    /**
     * Operation fakeHttpSignatureTestWithHttpInfo
     *
     * test http signature authentication
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $query_1 query parameter (optional)
     * @param  string $header_1 header parameter (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeHttpSignatureTestWithHttpInfo($pet, $query_1 = null, $header_1 = null)
    {
        $request = $this->fakeHttpSignatureTestRequest($pet, $query_1, $header_1);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeHttpSignatureTestAsync
     *
     * test http signature authentication
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $query_1 query parameter (optional)
     * @param  string $header_1 header parameter (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeHttpSignatureTestAsync($pet, $query_1 = null, $header_1 = null)
    {
        return $this->fakeHttpSignatureTestAsyncWithHttpInfo($pet, $query_1, $header_1)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeHttpSignatureTestAsyncWithHttpInfo
     *
     * test http signature authentication
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $query_1 query parameter (optional)
     * @param  string $header_1 header parameter (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeHttpSignatureTestAsyncWithHttpInfo($pet, $query_1 = null, $header_1 = null)
    {
        $returnType = '';
        $request = $this->fakeHttpSignatureTestRequest($pet, $query_1, $header_1);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeHttpSignatureTest'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     * @param  string $query_1 query parameter (optional)
     * @param  string $header_1 header parameter (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeHttpSignatureTestRequest($pet, $query_1 = null, $header_1 = null)
    {
        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeHttpSignatureTest'
            );
        }

        $resourcePath = '/fake/http-signature-test';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($query_1 !== null) {
            if('form' === 'form' && is_array($query_1)) {
                foreach($query_1 as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['query_1'] = $query_1;
            }
        }

        // header params
        if ($header_1 !== null) {
            $headerParams['header_1'] = ObjectSerializer::toHeaderValue($header_1);
        }



        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/jsonapplication/xml',
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeOuterBooleanSerialize
     *
     * @param  bool $body Input boolean as post body (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return bool
     */
    public function fakeOuterBooleanSerialize($body = null)
    {
        list($response) = $this->fakeOuterBooleanSerializeWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation fakeOuterBooleanSerializeWithHttpInfo
     *
     * @param  bool $body Input boolean as post body (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of bool, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeOuterBooleanSerializeWithHttpInfo($body = null)
    {
        $request = $this->fakeOuterBooleanSerializeRequest($body);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'bool',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                'bool',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'bool',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeOuterBooleanSerializeAsync
     *
     * @param  bool $body Input boolean as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeOuterBooleanSerializeAsync($body = null)
    {
        return $this->fakeOuterBooleanSerializeAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeOuterBooleanSerializeAsyncWithHttpInfo
     *
     * @param  bool $body Input boolean as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeOuterBooleanSerializeAsyncWithHttpInfo($body = null)
    {
        $returnType = 'bool';
        $request = $this->fakeOuterBooleanSerializeRequest($body);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeOuterBooleanSerialize'
     *
     * @param  bool $body Input boolean as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeOuterBooleanSerializeRequest($body = null)
    {

        $resourcePath = '/fake/outer/boolean';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeOuterCompositeSerialize
     *
     * @param  \OpenAPI\Client\Model\OuterComposite $outer_composite Input composite as post body (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OuterComposite
     */
    public function fakeOuterCompositeSerialize($outer_composite = null)
    {
        list($response) = $this->fakeOuterCompositeSerializeWithHttpInfo($outer_composite);
        return $response;
    }

    /**
     * Operation fakeOuterCompositeSerializeWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\OuterComposite $outer_composite Input composite as post body (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OuterComposite, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeOuterCompositeSerializeWithHttpInfo($outer_composite = null)
    {
        $request = $this->fakeOuterCompositeSerializeRequest($outer_composite);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OuterComposite',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OuterComposite',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OuterComposite',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeOuterCompositeSerializeAsync
     *
     * @param  \OpenAPI\Client\Model\OuterComposite $outer_composite Input composite as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeOuterCompositeSerializeAsync($outer_composite = null)
    {
        return $this->fakeOuterCompositeSerializeAsyncWithHttpInfo($outer_composite)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeOuterCompositeSerializeAsyncWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\OuterComposite $outer_composite Input composite as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeOuterCompositeSerializeAsyncWithHttpInfo($outer_composite = null)
    {
        $returnType = '\OpenAPI\Client\Model\OuterComposite';
        $request = $this->fakeOuterCompositeSerializeRequest($outer_composite);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeOuterCompositeSerialize'
     *
     * @param  \OpenAPI\Client\Model\OuterComposite $outer_composite Input composite as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeOuterCompositeSerializeRequest($outer_composite = null)
    {

        $resourcePath = '/fake/outer/composite';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($outer_composite)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($outer_composite));
            } else {
                $httpBody = $outer_composite;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeOuterNumberSerialize
     *
     * @param  float $body Input number as post body (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return float
     */
    public function fakeOuterNumberSerialize($body = null)
    {
        list($response) = $this->fakeOuterNumberSerializeWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation fakeOuterNumberSerializeWithHttpInfo
     *
     * @param  float $body Input number as post body (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of float, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeOuterNumberSerializeWithHttpInfo($body = null)
    {
        $request = $this->fakeOuterNumberSerializeRequest($body);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'float',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                'float',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'float',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeOuterNumberSerializeAsync
     *
     * @param  float $body Input number as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeOuterNumberSerializeAsync($body = null)
    {
        return $this->fakeOuterNumberSerializeAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeOuterNumberSerializeAsyncWithHttpInfo
     *
     * @param  float $body Input number as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeOuterNumberSerializeAsyncWithHttpInfo($body = null)
    {
        $returnType = 'float';
        $request = $this->fakeOuterNumberSerializeRequest($body);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeOuterNumberSerialize'
     *
     * @param  float $body Input number as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeOuterNumberSerializeRequest($body = null)
    {

        $resourcePath = '/fake/outer/number';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeOuterStringSerialize
     *
     * @param  string $body Input string as post body (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string
     */
    public function fakeOuterStringSerialize($body = null)
    {
        list($response) = $this->fakeOuterStringSerializeWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation fakeOuterStringSerializeWithHttpInfo
     *
     * @param  string $body Input string as post body (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeOuterStringSerializeWithHttpInfo($body = null)
    {
        $request = $this->fakeOuterStringSerializeRequest($body);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeOuterStringSerializeAsync
     *
     * @param  string $body Input string as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeOuterStringSerializeAsync($body = null)
    {
        return $this->fakeOuterStringSerializeAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeOuterStringSerializeAsyncWithHttpInfo
     *
     * @param  string $body Input string as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeOuterStringSerializeAsyncWithHttpInfo($body = null)
    {
        $returnType = 'string';
        $request = $this->fakeOuterStringSerializeRequest($body);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeOuterStringSerialize'
     *
     * @param  string $body Input string as post body (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeOuterStringSerializeRequest($body = null)
    {

        $resourcePath = '/fake/outer/string';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakePropertyEnumIntegerSerialize
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\OuterObjectWithEnumProperty
     */
    public function fakePropertyEnumIntegerSerialize($outer_object_with_enum_property)
    {
        list($response) = $this->fakePropertyEnumIntegerSerializeWithHttpInfo($outer_object_with_enum_property);
        return $response;
    }

    /**
     * Operation fakePropertyEnumIntegerSerializeWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\OuterObjectWithEnumProperty, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakePropertyEnumIntegerSerializeWithHttpInfo($outer_object_with_enum_property)
    {
        $request = $this->fakePropertyEnumIntegerSerializeRequest($outer_object_with_enum_property);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\OuterObjectWithEnumProperty',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\OuterObjectWithEnumProperty',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\OuterObjectWithEnumProperty',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakePropertyEnumIntegerSerializeAsync
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakePropertyEnumIntegerSerializeAsync($outer_object_with_enum_property)
    {
        return $this->fakePropertyEnumIntegerSerializeAsyncWithHttpInfo($outer_object_with_enum_property)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakePropertyEnumIntegerSerializeAsyncWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakePropertyEnumIntegerSerializeAsyncWithHttpInfo($outer_object_with_enum_property)
    {
        $returnType = '\OpenAPI\Client\Model\OuterObjectWithEnumProperty';
        $request = $this->fakePropertyEnumIntegerSerializeRequest($outer_object_with_enum_property);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakePropertyEnumIntegerSerialize'
     *
     * @param  \OpenAPI\Client\Model\OuterObjectWithEnumProperty $outer_object_with_enum_property Input enum (int) as post body (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakePropertyEnumIntegerSerializeRequest($outer_object_with_enum_property)
    {
        // verify the required parameter 'outer_object_with_enum_property' is set
        if ($outer_object_with_enum_property === null || (is_array($outer_object_with_enum_property) && count($outer_object_with_enum_property) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $outer_object_with_enum_property when calling fakePropertyEnumIntegerSerialize'
            );
        }

        $resourcePath = '/fake/property/enum-int';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['*/*'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($outer_object_with_enum_property)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($outer_object_with_enum_property));
            } else {
                $httpBody = $outer_object_with_enum_property;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeWith400And4xxRangeResponseEndpoint
     *
     * test endpoint with 400 and 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function fakeWith400And4xxRangeResponseEndpoint($pet)
    {
        list($response) = $this->fakeWith400And4xxRangeResponseEndpointWithHttpInfo($pet);
        return $response;
    }

    /**
     * Operation fakeWith400And4xxRangeResponseEndpointWithHttpInfo
     *
     * test endpoint with 400 and 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith400And4xxRangeResponseEndpointWithHttpInfo($pet)
    {
        $request = $this->fakeWith400And4xxRangeResponseEndpointRequest($pet);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                
            }

            if ($this->responseWithinRangeCode('4xx', $statusCode)) {
                return $this->handleResponseWithDataType(
                    '\OpenAPI\Client\Model\ErrorResponse',
                    $request,
                    $response,
                );
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                
            }
        
            if ($this->responseWithinRangeCode('4xx', $e->getCode())) {
                $data = ObjectSerializer::deserialize(
                    $e->getResponseBody(),
                    '\OpenAPI\Client\Model\ErrorResponse',
                    $e->getResponseHeaders()
                );
                $e->setResponseObject($data);
                throw $e;
            }

            throw $e;
        }
    }

    /**
     * Operation fakeWith400And4xxRangeResponseEndpointAsync
     *
     * test endpoint with 400 and 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith400And4xxRangeResponseEndpointAsync($pet)
    {
        return $this->fakeWith400And4xxRangeResponseEndpointAsyncWithHttpInfo($pet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith400And4xxRangeResponseEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400 and 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith400And4xxRangeResponseEndpointAsyncWithHttpInfo($pet)
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith400And4xxRangeResponseEndpointRequest($pet);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith400And4xxRangeResponseEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeWith400And4xxRangeResponseEndpointRequest($pet)
    {
        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith400And4xxRangeResponseEndpoint'
            );
        }

        $resourcePath = '/fake/with_400_and_4xx_range_response/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/jsonapplication/xml',
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint
     *
     * test endpoint with 400 and 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint($pet)
    {
        list($response) = $this->fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo($pet);
        return $response;
    }

    /**
     * Operation fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo
     *
     * test endpoint with 400 and 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo($pet)
    {
        $request = $this->fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointRequest($pet);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsync
     *
     * test endpoint with 400 and 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsync($pet)
    {
        return $this->fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo($pet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400 and 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo($pet)
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointRequest($pet);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeWith400And4xxRangeResponseNo4xxDatatypeEndpointRequest($pet)
    {
        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith400And4xxRangeResponseNo4xxDatatypeEndpoint'
            );
        }

        $resourcePath = '/fake/with_400_and_4xx_range_response_no_4xx_datatype/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/jsonapplication/xml',
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeWith400ResponseEndpoint
     *
     * test endpoint with 400 response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse
     */
    public function fakeWith400ResponseEndpoint($pet)
    {
        list($response) = $this->fakeWith400ResponseEndpointWithHttpInfo($pet);
        return $response;
    }

    /**
     * Operation fakeWith400ResponseEndpointWithHttpInfo
     *
     * test endpoint with 400 response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith400ResponseEndpointWithHttpInfo($pet)
    {
        $request = $this->fakeWith400ResponseEndpointRequest($pet);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeWith400ResponseEndpointAsync
     *
     * test endpoint with 400 response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith400ResponseEndpointAsync($pet)
    {
        return $this->fakeWith400ResponseEndpointAsyncWithHttpInfo($pet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith400ResponseEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400 response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith400ResponseEndpointAsyncWithHttpInfo($pet)
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith400ResponseEndpointRequest($pet);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith400ResponseEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeWith400ResponseEndpointRequest($pet)
    {
        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith400ResponseEndpoint'
            );
        }

        $resourcePath = '/fake/with_400_response/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/jsonapplication/xml',
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeWith4xxRangeResponseEndpoint
     *
     * test endpoint with 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse
     */
    public function fakeWith4xxRangeResponseEndpoint($pet)
    {
        list($response) = $this->fakeWith4xxRangeResponseEndpointWithHttpInfo($pet);
        return $response;
    }

    /**
     * Operation fakeWith4xxRangeResponseEndpointWithHttpInfo
     *
     * test endpoint with 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith4xxRangeResponseEndpointWithHttpInfo($pet)
    {
        $request = $this->fakeWith4xxRangeResponseEndpointRequest($pet);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
                
            }

            if ($this->responseWithinRangeCode('4xx', $statusCode)) {
                return $this->handleResponseWithDataType(
                    '\OpenAPI\Client\Model\ErrorResponse',
                    $request,
                    $response,
                );
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                
            }
        
            if ($this->responseWithinRangeCode('4xx', $e->getCode())) {
                $data = ObjectSerializer::deserialize(
                    $e->getResponseBody(),
                    '\OpenAPI\Client\Model\ErrorResponse',
                    $e->getResponseHeaders()
                );
                $e->setResponseObject($data);
                throw $e;
            }

            throw $e;
        }
    }

    /**
     * Operation fakeWith4xxRangeResponseEndpointAsync
     *
     * test endpoint with 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith4xxRangeResponseEndpointAsync($pet)
    {
        return $this->fakeWith4xxRangeResponseEndpointAsyncWithHttpInfo($pet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith4xxRangeResponseEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400-499 range response http code with dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith4xxRangeResponseEndpointAsyncWithHttpInfo($pet)
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith4xxRangeResponseEndpointRequest($pet);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith4xxRangeResponseEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeWith4xxRangeResponseEndpointRequest($pet)
    {
        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith4xxRangeResponseEndpoint'
            );
        }

        $resourcePath = '/fake/with_4xx_range_response/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/jsonapplication/xml',
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation fakeWith4xxRangeResponseNo4xxDatatypeEndpoint
     *
     * test endpoint with 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Pet
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpoint($pet)
    {
        list($response) = $this->fakeWith4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo($pet);
        return $response;
    }

    /**
     * Operation fakeWith4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo
     *
     * test endpoint with 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Pet, HTTP status code, HTTP response headers (array of strings)
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpointWithHttpInfo($pet)
    {
        $request = $this->fakeWith4xxRangeResponseNo4xxDatatypeEndpointRequest($pet);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Pet',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Pet',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Pet',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsync
     *
     * test endpoint with 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsync($pet)
    {
        return $this->fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo($pet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo
     *
     * test endpoint with 400-499 range response http code without dataType
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpointAsyncWithHttpInfo($pet)
    {
        $returnType = '\OpenAPI\Client\Model\Pet';
        $request = $this->fakeWith4xxRangeResponseNo4xxDatatypeEndpointRequest($pet);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'
     *
     * @param  \OpenAPI\Client\Model\Pet $pet Pet object that needs to be added to the store (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function fakeWith4xxRangeResponseNo4xxDatatypeEndpointRequest($pet)
    {
        // verify the required parameter 'pet' is set
        if ($pet === null || (is_array($pet) && count($pet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pet when calling fakeWith4xxRangeResponseNo4xxDatatypeEndpoint'
            );
        }

        $resourcePath = '/fake/with_4xx_range_response_no_4xx_datatype/endpoint';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/jsonapplication/xml',
            $multipart
        );

        // for model (json/xml)
        if (isset($pet)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($pet));
            } else {
                $httpBody = $pet;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation getParameterNameMapping
     *
     * parameter name mapping test
     *
     * @param  int $underscore_type _type (required)
     * @param  string $type type (required)
     * @param  string $type_with_underscore type_ (required)
     * @param  string $type_with_dash type- (required)
     * @param  string $http_debug_option http debug option (to test parameter naming option) (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function getParameterNameMapping($underscore_type, $type, $type_with_underscore, $type_with_dash, $http_debug_option)
    {
        $this->getParameterNameMappingWithHttpInfo($underscore_type, $type, $type_with_underscore, $type_with_dash, $http_debug_option);
    }

    /**
     * Operation getParameterNameMappingWithHttpInfo
     *
     * parameter name mapping test
     *
     * @param  int $underscore_type _type (required)
     * @param  string $type type (required)
     * @param  string $type_with_underscore type_ (required)
     * @param  string $type_with_dash type- (required)
     * @param  string $http_debug_option http debug option (to test parameter naming option) (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getParameterNameMappingWithHttpInfo($underscore_type, $type, $type_with_underscore, $type_with_dash, $http_debug_option)
    {
        $request = $this->getParameterNameMappingRequest($underscore_type, $type, $type_with_underscore, $type_with_dash, $http_debug_option);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation getParameterNameMappingAsync
     *
     * parameter name mapping test
     *
     * @param  int $underscore_type _type (required)
     * @param  string $type type (required)
     * @param  string $type_with_underscore type_ (required)
     * @param  string $type_with_dash type- (required)
     * @param  string $http_debug_option http debug option (to test parameter naming option) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function getParameterNameMappingAsync($underscore_type, $type, $type_with_underscore, $type_with_dash, $http_debug_option)
    {
        return $this->getParameterNameMappingAsyncWithHttpInfo($underscore_type, $type, $type_with_underscore, $type_with_dash, $http_debug_option)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getParameterNameMappingAsyncWithHttpInfo
     *
     * parameter name mapping test
     *
     * @param  int $underscore_type _type (required)
     * @param  string $type type (required)
     * @param  string $type_with_underscore type_ (required)
     * @param  string $type_with_dash type- (required)
     * @param  string $http_debug_option http debug option (to test parameter naming option) (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function getParameterNameMappingAsyncWithHttpInfo($underscore_type, $type, $type_with_underscore, $type_with_dash, $http_debug_option)
    {
        $returnType = '';
        $request = $this->getParameterNameMappingRequest($underscore_type, $type, $type_with_underscore, $type_with_dash, $http_debug_option);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'getParameterNameMapping'
     *
     * @param  int $underscore_type _type (required)
     * @param  string $type type (required)
     * @param  string $type_with_underscore type_ (required)
     * @param  string $type_with_dash type- (required)
     * @param  string $http_debug_option http debug option (to test parameter naming option) (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function getParameterNameMappingRequest($underscore_type, $type, $type_with_underscore, $type_with_dash, $http_debug_option)
    {
        // verify the required parameter 'underscore_type' is set
        if ($underscore_type === null || (is_array($underscore_type) && count($underscore_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $underscore_type when calling getParameterNameMapping'
            );
        }
        // verify the required parameter 'type' is set
        if ($type === null || (is_array($type) && count($type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $type when calling getParameterNameMapping'
            );
        }
        // verify the required parameter 'type_with_underscore' is set
        if ($type_with_underscore === null || (is_array($type_with_underscore) && count($type_with_underscore) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $type_with_underscore when calling getParameterNameMapping'
            );
        }
        // verify the required parameter 'type_with_dash' is set
        if ($type_with_dash === null || (is_array($type_with_dash) && count($type_with_dash) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $type_with_dash when calling getParameterNameMapping'
            );
        }
        // verify the required parameter 'http_debug_option' is set
        if ($http_debug_option === null || (is_array($http_debug_option) && count($http_debug_option) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $http_debug_option when calling getParameterNameMapping'
            );
        }

        $resourcePath = '/fake/parameter-name-mapping';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($type !== null) {
            if('form' === 'form' && is_array($type)) {
                foreach($type as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['type'] = $type;
            }
        }
        // query params
        if ($http_debug_option !== null) {
            if('form' === 'form' && is_array($http_debug_option)) {
                foreach($http_debug_option as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['http_debug_option'] = $http_debug_option;
            }
        }

        // header params
        if ($underscore_type !== null) {
            $headerParams['_type'] = ObjectSerializer::toHeaderValue($underscore_type);
        }
        // header params
        if ($type_with_underscore !== null) {
            $headerParams['type_'] = ObjectSerializer::toHeaderValue($type_with_underscore);
        }
        // header params
        if ($type_with_dash !== null) {
            $headerParams['type-'] = ObjectSerializer::toHeaderValue($type_with_dash);
        }



        $headers = $this->headerSelector->selectHeaders(
            [],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation testAdditionalPropertiesReference
     *
     * test referenced additionalProperties
     *
     * @param  array<string,mixed> $request_body request body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testAdditionalPropertiesReference($request_body)
    {
        $this->testAdditionalPropertiesReferenceWithHttpInfo($request_body);
    }

    /**
     * Operation testAdditionalPropertiesReferenceWithHttpInfo
     *
     * test referenced additionalProperties
     *
     * @param  array<string,mixed> $request_body request body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testAdditionalPropertiesReferenceWithHttpInfo($request_body)
    {
        $request = $this->testAdditionalPropertiesReferenceRequest($request_body);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testAdditionalPropertiesReferenceAsync
     *
     * test referenced additionalProperties
     *
     * @param  array<string,mixed> $request_body request body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testAdditionalPropertiesReferenceAsync($request_body)
    {
        return $this->testAdditionalPropertiesReferenceAsyncWithHttpInfo($request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testAdditionalPropertiesReferenceAsyncWithHttpInfo
     *
     * test referenced additionalProperties
     *
     * @param  array<string,mixed> $request_body request body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testAdditionalPropertiesReferenceAsyncWithHttpInfo($request_body)
    {
        $returnType = '';
        $request = $this->testAdditionalPropertiesReferenceRequest($request_body);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testAdditionalPropertiesReference'
     *
     * @param  array<string,mixed> $request_body request body (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testAdditionalPropertiesReferenceRequest($request_body)
    {
        // verify the required parameter 'request_body' is set
        if ($request_body === null || (is_array($request_body) && count($request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_body when calling testAdditionalPropertiesReference'
            );
        }

        $resourcePath = '/fake/additionalProperties-reference';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($request_body)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($request_body));
            } else {
                $httpBody = $request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation testBodyWithBinary
     *
     * @param  \SplFileObject $body image to upload (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testBodyWithBinary($body)
    {
        $this->testBodyWithBinaryWithHttpInfo($body);
    }

    /**
     * Operation testBodyWithBinaryWithHttpInfo
     *
     * @param  \SplFileObject $body image to upload (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBodyWithBinaryWithHttpInfo($body)
    {
        $request = $this->testBodyWithBinaryRequest($body);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testBodyWithBinaryAsync
     *
     * @param  \SplFileObject $body image to upload (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testBodyWithBinaryAsync($body)
    {
        return $this->testBodyWithBinaryAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBodyWithBinaryAsyncWithHttpInfo
     *
     * @param  \SplFileObject $body image to upload (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testBodyWithBinaryAsyncWithHttpInfo($body)
    {
        $returnType = '';
        $request = $this->testBodyWithBinaryRequest($body);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBodyWithBinary'
     *
     * @param  \SplFileObject $body image to upload (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testBodyWithBinaryRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling testBodyWithBinary'
            );
        }

        $resourcePath = '/fake/body-with-binary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            'image/png',
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('PUT', $uri, $headers, $httpBody);
    }

    /**
     * Operation testBodyWithFileSchema
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class file_schema_test_class (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testBodyWithFileSchema($file_schema_test_class)
    {
        $this->testBodyWithFileSchemaWithHttpInfo($file_schema_test_class);
    }

    /**
     * Operation testBodyWithFileSchemaWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBodyWithFileSchemaWithHttpInfo($file_schema_test_class)
    {
        $request = $this->testBodyWithFileSchemaRequest($file_schema_test_class);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testBodyWithFileSchemaAsync
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testBodyWithFileSchemaAsync($file_schema_test_class)
    {
        return $this->testBodyWithFileSchemaAsyncWithHttpInfo($file_schema_test_class)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBodyWithFileSchemaAsyncWithHttpInfo
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testBodyWithFileSchemaAsyncWithHttpInfo($file_schema_test_class)
    {
        $returnType = '';
        $request = $this->testBodyWithFileSchemaRequest($file_schema_test_class);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBodyWithFileSchema'
     *
     * @param  \OpenAPI\Client\Model\FileSchemaTestClass $file_schema_test_class (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testBodyWithFileSchemaRequest($file_schema_test_class)
    {
        // verify the required parameter 'file_schema_test_class' is set
        if ($file_schema_test_class === null || (is_array($file_schema_test_class) && count($file_schema_test_class) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_schema_test_class when calling testBodyWithFileSchema'
            );
        }

        $resourcePath = '/fake/body-with-file-schema';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($file_schema_test_class)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($file_schema_test_class));
            } else {
                $httpBody = $file_schema_test_class;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('PUT', $uri, $headers, $httpBody);
    }

    /**
     * Operation testBodyWithQueryParams
     *
     * @param  string $query query (required)
     * @param  \OpenAPI\Client\Model\User $user user (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testBodyWithQueryParams($query, $user)
    {
        $this->testBodyWithQueryParamsWithHttpInfo($query, $user);
    }

    /**
     * Operation testBodyWithQueryParamsWithHttpInfo
     *
     * @param  string $query (required)
     * @param  \OpenAPI\Client\Model\User $user (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testBodyWithQueryParamsWithHttpInfo($query, $user)
    {
        $request = $this->testBodyWithQueryParamsRequest($query, $user);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testBodyWithQueryParamsAsync
     *
     * @param  string $query (required)
     * @param  \OpenAPI\Client\Model\User $user (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testBodyWithQueryParamsAsync($query, $user)
    {
        return $this->testBodyWithQueryParamsAsyncWithHttpInfo($query, $user)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testBodyWithQueryParamsAsyncWithHttpInfo
     *
     * @param  string $query (required)
     * @param  \OpenAPI\Client\Model\User $user (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testBodyWithQueryParamsAsyncWithHttpInfo($query, $user)
    {
        $returnType = '';
        $request = $this->testBodyWithQueryParamsRequest($query, $user);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testBodyWithQueryParams'
     *
     * @param  string $query (required)
     * @param  \OpenAPI\Client\Model\User $user (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testBodyWithQueryParamsRequest($query, $user)
    {
        // verify the required parameter 'query' is set
        if ($query === null || (is_array($query) && count($query) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $query when calling testBodyWithQueryParams'
            );
        }
        // verify the required parameter 'user' is set
        if ($user === null || (is_array($user) && count($user) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user when calling testBodyWithQueryParams'
            );
        }

        $resourcePath = '/fake/body-with-query-params';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($query !== null) {
            if('form' === 'form' && is_array($query)) {
                foreach($query as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['query'] = $query;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($user)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($user));
            } else {
                $httpBody = $user;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('PUT', $uri, $headers, $httpBody);
    }

    /**
     * Operation testClientModel
     *
     * To test \&quot;client\&quot; model
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Client
     */
    public function testClientModel($client)
    {
        list($response) = $this->testClientModelWithHttpInfo($client);
        return $response;
    }

    /**
     * Operation testClientModelWithHttpInfo
     *
     * To test \&quot;client\&quot; model
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Client, HTTP status code, HTTP response headers (array of strings)
     */
    public function testClientModelWithHttpInfo($client)
    {
        $request = $this->testClientModelRequest($client);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Client',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $request,
                    $response
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Client',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Client',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation testClientModelAsync
     *
     * To test \&quot;client\&quot; model
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testClientModelAsync($client)
    {
        return $this->testClientModelAsyncWithHttpInfo($client)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testClientModelAsyncWithHttpInfo
     *
     * To test \&quot;client\&quot; model
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testClientModelAsyncWithHttpInfo($client)
    {
        $returnType = '\OpenAPI\Client\Model\Client';
        $request = $this->testClientModelRequest($client);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testClientModel'
     *
     * @param  \OpenAPI\Client\Model\Client $client client model (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testClientModelRequest($client)
    {
        // verify the required parameter 'client' is set
        if ($client === null || (is_array($client) && count($client) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $client when calling testClientModel'
            );
        }

        $resourcePath = '/fake';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($client)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($client));
            } else {
                $httpBody = $client;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('PATCH', $uri, $headers, $httpBody);
    }

    /**
     * Operation testEndpointParameters
     *
     * Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int $integer None (optional)
     * @param  int $int32 None (optional)
     * @param  int $int64 None (optional)
     * @param  float $float None (optional)
     * @param  string $string None (optional)
     * @param  \SplFileObject $binary None (optional)
     * @param  \DateTime $date None (optional)
     * @param  \DateTime $date_time None (optional)
     * @param  string $password None (optional)
     * @param  string $callback None (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testEndpointParameters($number, $double, $pattern_without_delimiter, $byte, $integer = null, $int32 = null, $int64 = null, $float = null, $string = null, $binary = null, $date = null, $date_time = null, $password = null, $callback = null)
    {
        $this->testEndpointParametersWithHttpInfo($number, $double, $pattern_without_delimiter, $byte, $integer, $int32, $int64, $float, $string, $binary, $date, $date_time, $password, $callback);
    }

    /**
     * Operation testEndpointParametersWithHttpInfo
     *
     * Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int $integer None (optional)
     * @param  int $int32 None (optional)
     * @param  int $int64 None (optional)
     * @param  float $float None (optional)
     * @param  string $string None (optional)
     * @param  \SplFileObject $binary None (optional)
     * @param  \DateTime $date None (optional)
     * @param  \DateTime $date_time None (optional)
     * @param  string $password None (optional)
     * @param  string $callback None (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEndpointParametersWithHttpInfo($number, $double, $pattern_without_delimiter, $byte, $integer = null, $int32 = null, $int64 = null, $float = null, $string = null, $binary = null, $date = null, $date_time = null, $password = null, $callback = null)
    {
        $request = $this->testEndpointParametersRequest($number, $double, $pattern_without_delimiter, $byte, $integer, $int32, $int64, $float, $string, $binary, $date, $date_time, $password, $callback);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testEndpointParametersAsync
     *
     * Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int $integer None (optional)
     * @param  int $int32 None (optional)
     * @param  int $int64 None (optional)
     * @param  float $float None (optional)
     * @param  string $string None (optional)
     * @param  \SplFileObject $binary None (optional)
     * @param  \DateTime $date None (optional)
     * @param  \DateTime $date_time None (optional)
     * @param  string $password None (optional)
     * @param  string $callback None (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testEndpointParametersAsync($number, $double, $pattern_without_delimiter, $byte, $integer = null, $int32 = null, $int64 = null, $float = null, $string = null, $binary = null, $date = null, $date_time = null, $password = null, $callback = null)
    {
        return $this->testEndpointParametersAsyncWithHttpInfo($number, $double, $pattern_without_delimiter, $byte, $integer, $int32, $int64, $float, $string, $binary, $date, $date_time, $password, $callback)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEndpointParametersAsyncWithHttpInfo
     *
     * Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int $integer None (optional)
     * @param  int $int32 None (optional)
     * @param  int $int64 None (optional)
     * @param  float $float None (optional)
     * @param  string $string None (optional)
     * @param  \SplFileObject $binary None (optional)
     * @param  \DateTime $date None (optional)
     * @param  \DateTime $date_time None (optional)
     * @param  string $password None (optional)
     * @param  string $callback None (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testEndpointParametersAsyncWithHttpInfo($number, $double, $pattern_without_delimiter, $byte, $integer = null, $int32 = null, $int64 = null, $float = null, $string = null, $binary = null, $date = null, $date_time = null, $password = null, $callback = null)
    {
        $returnType = '';
        $request = $this->testEndpointParametersRequest($number, $double, $pattern_without_delimiter, $byte, $integer, $int32, $int64, $float, $string, $binary, $date, $date_time, $password, $callback);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEndpointParameters'
     *
     * @param  float $number None (required)
     * @param  float $double None (required)
     * @param  string $pattern_without_delimiter None (required)
     * @param  string $byte None (required)
     * @param  int $integer None (optional)
     * @param  int $int32 None (optional)
     * @param  int $int64 None (optional)
     * @param  float $float None (optional)
     * @param  string $string None (optional)
     * @param  \SplFileObject $binary None (optional)
     * @param  \DateTime $date None (optional)
     * @param  \DateTime $date_time None (optional)
     * @param  string $password None (optional)
     * @param  string $callback None (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testEndpointParametersRequest($number, $double, $pattern_without_delimiter, $byte, $integer = null, $int32 = null, $int64 = null, $float = null, $string = null, $binary = null, $date = null, $date_time = null, $password = null, $callback = null)
    {
        // verify the required parameter 'number' is set
        if ($number === null || (is_array($number) && count($number) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $number when calling testEndpointParameters'
            );
        }
        if ($number > 543.2) {
            throw new \InvalidArgumentException('invalid value for "$number" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 543.2.');
        }
        if ($number < 32.1) {
            throw new \InvalidArgumentException('invalid value for "$number" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 32.1.');
        }

        // verify the required parameter 'double' is set
        if ($double === null || (is_array($double) && count($double) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $double when calling testEndpointParameters'
            );
        }
        if ($double > 123.4) {
            throw new \InvalidArgumentException('invalid value for "$double" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 123.4.');
        }
        if ($double < 67.8) {
            throw new \InvalidArgumentException('invalid value for "$double" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 67.8.');
        }

        // verify the required parameter 'pattern_without_delimiter' is set
        if ($pattern_without_delimiter === null || (is_array($pattern_without_delimiter) && count($pattern_without_delimiter) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pattern_without_delimiter when calling testEndpointParameters'
            );
        }
        if (!preg_match("/^[A-Z].*/", $pattern_without_delimiter)) {
            throw new \InvalidArgumentException("invalid value for \"pattern_without_delimiter\" when calling FakeApi.testEndpointParameters, must conform to the pattern /^[A-Z].*/.");
        }

        // verify the required parameter 'byte' is set
        if ($byte === null || (is_array($byte) && count($byte) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $byte when calling testEndpointParameters'
            );
        }
        if ($integer !== null && $integer > 100) {
            throw new \InvalidArgumentException('invalid value for "$integer" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 100.');
        }
        if ($integer !== null && $integer < 10) {
            throw new \InvalidArgumentException('invalid value for "$integer" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 10.');
        }

        if ($int32 !== null && $int32 > 200) {
            throw new \InvalidArgumentException('invalid value for "$int32" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 200.');
        }
        if ($int32 !== null && $int32 < 20) {
            throw new \InvalidArgumentException('invalid value for "$int32" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 20.');
        }

        if ($float !== null && $float > 987.6) {
            throw new \InvalidArgumentException('invalid value for "$float" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 987.6.');
        }

        if ($string !== null && !preg_match("/[a-z]/i", $string)) {
            throw new \InvalidArgumentException("invalid value for \"string\" when calling FakeApi.testEndpointParameters, must conform to the pattern /[a-z]/i.");
        }

        if ($password !== null && strlen($password) > 64) {
            throw new \InvalidArgumentException('invalid length for "$password" when calling FakeApi.testEndpointParameters, must be smaller than or equal to 64.');
        }
        if ($password !== null && strlen($password) < 10) {
            throw new \InvalidArgumentException('invalid length for "$password" when calling FakeApi.testEndpointParameters, must be bigger than or equal to 10.');
        }


        $resourcePath = '/fake';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'integer' => $integer,
            'int32' => $int32,
            'int64' => $int64,
            'number' => $number,
            'float' => $float,
            'double' => $double,
            'string' => $string,
            'pattern_without_delimiter' => $pattern_without_delimiter,
            'byte' => $byte,
            'binary' => $binary,
            'date' => $date,
            'date_time' => $date_time,
            'password' => $password,
            'callback' => $callback,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/x-www-form-urlencoded',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation testEnumParameters
     *
     * To test enum parameters
     *
     * @param  string[] $enum_header_string_array Header parameter enum test (string array) (optional)
     * @param  string $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[] $enum_query_string_array Query parameter enum test (string array) (optional)
     * @param  string $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_query_model_array enum_query_model_array (optional)
     * @param  string[] $enum_form_string_array Form parameter enum test (string array) (optional, default to '$')
     * @param  string $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testEnumParameters($enum_header_string_array = null, $enum_header_string = '-efg', $enum_query_string_array = null, $enum_query_string = '-efg', $enum_query_integer = null, $enum_query_double = null, $enum_query_model_array = null, $enum_form_string_array = '$', $enum_form_string = '-efg')
    {
        $this->testEnumParametersWithHttpInfo($enum_header_string_array, $enum_header_string, $enum_query_string_array, $enum_query_string, $enum_query_integer, $enum_query_double, $enum_query_model_array, $enum_form_string_array, $enum_form_string);
    }

    /**
     * Operation testEnumParametersWithHttpInfo
     *
     * To test enum parameters
     *
     * @param  string[] $enum_header_string_array Header parameter enum test (string array) (optional)
     * @param  string $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[] $enum_query_string_array Query parameter enum test (string array) (optional)
     * @param  string $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_query_model_array (optional)
     * @param  string[] $enum_form_string_array Form parameter enum test (string array) (optional, default to '$')
     * @param  string $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testEnumParametersWithHttpInfo($enum_header_string_array = null, $enum_header_string = '-efg', $enum_query_string_array = null, $enum_query_string = '-efg', $enum_query_integer = null, $enum_query_double = null, $enum_query_model_array = null, $enum_form_string_array = '$', $enum_form_string = '-efg')
    {
        $request = $this->testEnumParametersRequest($enum_header_string_array, $enum_header_string, $enum_query_string_array, $enum_query_string, $enum_query_integer, $enum_query_double, $enum_query_model_array, $enum_form_string_array, $enum_form_string);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testEnumParametersAsync
     *
     * To test enum parameters
     *
     * @param  string[] $enum_header_string_array Header parameter enum test (string array) (optional)
     * @param  string $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[] $enum_query_string_array Query parameter enum test (string array) (optional)
     * @param  string $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_query_model_array (optional)
     * @param  string[] $enum_form_string_array Form parameter enum test (string array) (optional, default to '$')
     * @param  string $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testEnumParametersAsync($enum_header_string_array = null, $enum_header_string = '-efg', $enum_query_string_array = null, $enum_query_string = '-efg', $enum_query_integer = null, $enum_query_double = null, $enum_query_model_array = null, $enum_form_string_array = '$', $enum_form_string = '-efg')
    {
        return $this->testEnumParametersAsyncWithHttpInfo($enum_header_string_array, $enum_header_string, $enum_query_string_array, $enum_query_string, $enum_query_integer, $enum_query_double, $enum_query_model_array, $enum_form_string_array, $enum_form_string)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testEnumParametersAsyncWithHttpInfo
     *
     * To test enum parameters
     *
     * @param  string[] $enum_header_string_array Header parameter enum test (string array) (optional)
     * @param  string $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[] $enum_query_string_array Query parameter enum test (string array) (optional)
     * @param  string $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_query_model_array (optional)
     * @param  string[] $enum_form_string_array Form parameter enum test (string array) (optional, default to '$')
     * @param  string $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testEnumParametersAsyncWithHttpInfo($enum_header_string_array = null, $enum_header_string = '-efg', $enum_query_string_array = null, $enum_query_string = '-efg', $enum_query_integer = null, $enum_query_double = null, $enum_query_model_array = null, $enum_form_string_array = '$', $enum_form_string = '-efg')
    {
        $returnType = '';
        $request = $this->testEnumParametersRequest($enum_header_string_array, $enum_header_string, $enum_query_string_array, $enum_query_string, $enum_query_integer, $enum_query_double, $enum_query_model_array, $enum_form_string_array, $enum_form_string);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testEnumParameters'
     *
     * @param  string[] $enum_header_string_array Header parameter enum test (string array) (optional)
     * @param  string $enum_header_string Header parameter enum test (string) (optional, default to '-efg')
     * @param  string[] $enum_query_string_array Query parameter enum test (string array) (optional)
     * @param  string $enum_query_string Query parameter enum test (string) (optional, default to '-efg')
     * @param  int $enum_query_integer Query parameter enum test (double) (optional)
     * @param  float $enum_query_double Query parameter enum test (double) (optional)
     * @param  \OpenAPI\Client\Model\EnumClass[] $enum_query_model_array (optional)
     * @param  string[] $enum_form_string_array Form parameter enum test (string array) (optional, default to '$')
     * @param  string $enum_form_string Form parameter enum test (string) (optional, default to '-efg')
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testEnumParametersRequest($enum_header_string_array = null, $enum_header_string = '-efg', $enum_query_string_array = null, $enum_query_string = '-efg', $enum_query_integer = null, $enum_query_double = null, $enum_query_model_array = null, $enum_form_string_array = '$', $enum_form_string = '-efg')
    {

        $resourcePath = '/fake';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($enum_query_string_array !== null) {
            if('form' === 'form' && is_array($enum_query_string_array)) {
                foreach($enum_query_string_array as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['enum_query_string_array'] = $enum_query_string_array;
            }
        }
        // query params
        if ($enum_query_string !== null) {
            if('form' === 'form' && is_array($enum_query_string)) {
                foreach($enum_query_string as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['enum_query_string'] = $enum_query_string;
            }
        }
        // query params
        if ($enum_query_integer !== null) {
            if('form' === 'form' && is_array($enum_query_integer)) {
                foreach($enum_query_integer as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['enum_query_integer'] = $enum_query_integer;
            }
        }
        // query params
        if ($enum_query_double !== null) {
            if('form' === 'form' && is_array($enum_query_double)) {
                foreach($enum_query_double as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['enum_query_double'] = $enum_query_double;
            }
        }
        // query params
        if ($enum_query_model_array !== null) {
            if('form' === 'form' && is_array($enum_query_model_array)) {
                foreach($enum_query_model_array as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['enum_query_model_array'] = $enum_query_model_array;
            }
        }

        // header params
        if (is_array($enum_header_string_array)) {
            $enum_header_string_array = ObjectSerializer::serializeCollection($enum_header_string_array, 'csv');
        }
        if ($enum_header_string_array !== null) {
            $headerParams['enum_header_string_array'] = ObjectSerializer::toHeaderValue($enum_header_string_array);
        }
        // header params
        if ($enum_header_string !== null) {
            $headerParams['enum_header_string'] = ObjectSerializer::toHeaderValue($enum_header_string);
        }


        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'enum_form_string_array' => $enum_form_string_array,
            'enum_form_string' => $enum_form_string,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/x-www-form-urlencoded',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation testGroupParameters
     *
     * Fake endpoint to test group parameters (optional)
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int $string_group String in group parameters (optional)
     * @param  bool $boolean_group Boolean in group parameters (optional)
     * @param  int $int64_group Integer in group parameters (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testGroupParameters($associative_array)
    {
        $this->testGroupParametersWithHttpInfo($associative_array);
    }

    /**
     * Operation testGroupParametersWithHttpInfo
     *
     * Fake endpoint to test group parameters (optional)
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int $string_group String in group parameters (optional)
     * @param  bool $boolean_group Boolean in group parameters (optional)
     * @param  int $int64_group Integer in group parameters (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testGroupParametersWithHttpInfo($associative_array)
    {
        $request = $this->testGroupParametersRequest($associative_array);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testGroupParametersAsync
     *
     * Fake endpoint to test group parameters (optional)
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int $string_group String in group parameters (optional)
     * @param  bool $boolean_group Boolean in group parameters (optional)
     * @param  int $int64_group Integer in group parameters (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testGroupParametersAsync($associative_array)
    {
        return $this->testGroupParametersAsyncWithHttpInfo($associative_array)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testGroupParametersAsyncWithHttpInfo
     *
     * Fake endpoint to test group parameters (optional)
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int $string_group String in group parameters (optional)
     * @param  bool $boolean_group Boolean in group parameters (optional)
     * @param  int $int64_group Integer in group parameters (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testGroupParametersAsyncWithHttpInfo($associative_array)
    {
        $returnType = '';
        $request = $this->testGroupParametersRequest($associative_array);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testGroupParameters'
     *
     * Note: the input parameter is an associative array with the keys listed as the parameter name below
     *
     * @param  int $required_string_group Required String in group parameters (required)
     * @param  bool $required_boolean_group Required Boolean in group parameters (required)
     * @param  int $required_int64_group Required Integer in group parameters (required)
     * @param  int $string_group String in group parameters (optional)
     * @param  bool $boolean_group Boolean in group parameters (optional)
     * @param  int $int64_group Integer in group parameters (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testGroupParametersRequest($associative_array)
    {
        // unbox the parameters from the associative array
        $required_string_group = array_key_exists('required_string_group', $associative_array) ? $associative_array['required_string_group'] : null;
        $required_boolean_group = array_key_exists('required_boolean_group', $associative_array) ? $associative_array['required_boolean_group'] : null;
        $required_int64_group = array_key_exists('required_int64_group', $associative_array) ? $associative_array['required_int64_group'] : null;
        $string_group = array_key_exists('string_group', $associative_array) ? $associative_array['string_group'] : null;
        $boolean_group = array_key_exists('boolean_group', $associative_array) ? $associative_array['boolean_group'] : null;
        $int64_group = array_key_exists('int64_group', $associative_array) ? $associative_array['int64_group'] : null;

        // verify the required parameter 'required_string_group' is set
        if ($required_string_group === null || (is_array($required_string_group) && count($required_string_group) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $required_string_group when calling testGroupParameters'
            );
        }
        // verify the required parameter 'required_boolean_group' is set
        if ($required_boolean_group === null || (is_array($required_boolean_group) && count($required_boolean_group) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $required_boolean_group when calling testGroupParameters'
            );
        }
        // verify the required parameter 'required_int64_group' is set
        if ($required_int64_group === null || (is_array($required_int64_group) && count($required_int64_group) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $required_int64_group when calling testGroupParameters'
            );
        }

        $resourcePath = '/fake';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if ($required_string_group !== null) {
            if('form' === 'form' && is_array($required_string_group)) {
                foreach($required_string_group as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['required_string_group'] = $required_string_group;
            }
        }
        // query params
        if ($required_int64_group !== null) {
            if('form' === 'form' && is_array($required_int64_group)) {
                foreach($required_int64_group as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['required_int64_group'] = $required_int64_group;
            }
        }
        // query params
        if ($string_group !== null) {
            if('form' === 'form' && is_array($string_group)) {
                foreach($string_group as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['string_group'] = $string_group;
            }
        }
        // query params
        if ($int64_group !== null) {
            if('form' === 'form' && is_array($int64_group)) {
                foreach($int64_group as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['int64_group'] = $int64_group;
            }
        }

        // header params
        if ($required_boolean_group !== null) {
            $headerParams['required_boolean_group'] = ObjectSerializer::toHeaderValue($required_boolean_group);
        }
        // header params
        if ($boolean_group !== null) {
            $headerParams['boolean_group'] = ObjectSerializer::toHeaderValue($boolean_group);
        }



        $headers = $this->headerSelector->selectHeaders(
            [],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer (JWT) authentication (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('DELETE', $uri, $headers, $httpBody);
    }

    /**
     * Operation testInlineAdditionalProperties
     *
     * test inline additionalProperties
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testInlineAdditionalProperties($request_body)
    {
        $this->testInlineAdditionalPropertiesWithHttpInfo($request_body);
    }

    /**
     * Operation testInlineAdditionalPropertiesWithHttpInfo
     *
     * test inline additionalProperties
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testInlineAdditionalPropertiesWithHttpInfo($request_body)
    {
        $request = $this->testInlineAdditionalPropertiesRequest($request_body);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testInlineAdditionalPropertiesAsync
     *
     * test inline additionalProperties
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testInlineAdditionalPropertiesAsync($request_body)
    {
        return $this->testInlineAdditionalPropertiesAsyncWithHttpInfo($request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testInlineAdditionalPropertiesAsyncWithHttpInfo
     *
     * test inline additionalProperties
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testInlineAdditionalPropertiesAsyncWithHttpInfo($request_body)
    {
        $returnType = '';
        $request = $this->testInlineAdditionalPropertiesRequest($request_body);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testInlineAdditionalProperties'
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testInlineAdditionalPropertiesRequest($request_body)
    {
        // verify the required parameter 'request_body' is set
        if ($request_body === null || (is_array($request_body) && count($request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_body when calling testInlineAdditionalProperties'
            );
        }

        $resourcePath = '/fake/inline-additionalProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($request_body)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($request_body));
            } else {
                $httpBody = $request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation testInlineFreeformAdditionalProperties
     *
     * test inline free-form additionalProperties
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testInlineFreeformAdditionalProperties($test_inline_freeform_additional_properties_request)
    {
        $this->testInlineFreeformAdditionalPropertiesWithHttpInfo($test_inline_freeform_additional_properties_request);
    }

    /**
     * Operation testInlineFreeformAdditionalPropertiesWithHttpInfo
     *
     * test inline free-form additionalProperties
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testInlineFreeformAdditionalPropertiesWithHttpInfo($test_inline_freeform_additional_properties_request)
    {
        $request = $this->testInlineFreeformAdditionalPropertiesRequest($test_inline_freeform_additional_properties_request);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testInlineFreeformAdditionalPropertiesAsync
     *
     * test inline free-form additionalProperties
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testInlineFreeformAdditionalPropertiesAsync($test_inline_freeform_additional_properties_request)
    {
        return $this->testInlineFreeformAdditionalPropertiesAsyncWithHttpInfo($test_inline_freeform_additional_properties_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testInlineFreeformAdditionalPropertiesAsyncWithHttpInfo
     *
     * test inline free-form additionalProperties
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testInlineFreeformAdditionalPropertiesAsyncWithHttpInfo($test_inline_freeform_additional_properties_request)
    {
        $returnType = '';
        $request = $this->testInlineFreeformAdditionalPropertiesRequest($test_inline_freeform_additional_properties_request);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testInlineFreeformAdditionalProperties'
     *
     * @param  \OpenAPI\Client\Model\TestInlineFreeformAdditionalPropertiesRequest $test_inline_freeform_additional_properties_request request body (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testInlineFreeformAdditionalPropertiesRequest($test_inline_freeform_additional_properties_request)
    {
        // verify the required parameter 'test_inline_freeform_additional_properties_request' is set
        if ($test_inline_freeform_additional_properties_request === null || (is_array($test_inline_freeform_additional_properties_request) && count($test_inline_freeform_additional_properties_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $test_inline_freeform_additional_properties_request when calling testInlineFreeformAdditionalProperties'
            );
        }

        $resourcePath = '/fake/inline-freeform-additionalProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($test_inline_freeform_additional_properties_request)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($test_inline_freeform_additional_properties_request));
            } else {
                $httpBody = $test_inline_freeform_additional_properties_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }

    /**
     * Operation testJsonFormData
     *
     * test json serialization of form data
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testJsonFormData($param, $param2)
    {
        $this->testJsonFormDataWithHttpInfo($param, $param2);
    }

    /**
     * Operation testJsonFormDataWithHttpInfo
     *
     * test json serialization of form data
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testJsonFormDataWithHttpInfo($param, $param2)
    {
        $request = $this->testJsonFormDataRequest($param, $param2);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testJsonFormDataAsync
     *
     * test json serialization of form data
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testJsonFormDataAsync($param, $param2)
    {
        return $this->testJsonFormDataAsyncWithHttpInfo($param, $param2)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testJsonFormDataAsyncWithHttpInfo
     *
     * test json serialization of form data
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testJsonFormDataAsyncWithHttpInfo($param, $param2)
    {
        $returnType = '';
        $request = $this->testJsonFormDataRequest($param, $param2);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testJsonFormData'
     *
     * @param  string $param field1 (required)
     * @param  string $param2 field2 (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testJsonFormDataRequest($param, $param2)
    {
        // verify the required parameter 'param' is set
        if ($param === null || (is_array($param) && count($param) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $param when calling testJsonFormData'
            );
        }
        // verify the required parameter 'param2' is set
        if ($param2 === null || (is_array($param2) && count($param2) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $param2 when calling testJsonFormData'
            );
        }

        $resourcePath = '/fake/jsonFormData';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;




        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'param' => $param,
            'param2' => $param2,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/x-www-form-urlencoded',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('GET', $uri, $headers, $httpBody);
    }

    /**
     * Operation testQueryParameterCollectionFormat
     *
     * @param  string[] $pipe pipe (required)
     * @param  string[] $ioutil ioutil (required)
     * @param  string[] $http http (required)
     * @param  string[] $url url (required)
     * @param  string[] $context context (required)
     * @param  string $allow_empty allow_empty (required)
     * @param  array<string,string> $language language (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testQueryParameterCollectionFormat($pipe, $ioutil, $http, $url, $context, $allow_empty, $language = null)
    {
        $this->testQueryParameterCollectionFormatWithHttpInfo($pipe, $ioutil, $http, $url, $context, $allow_empty, $language);
    }

    /**
     * Operation testQueryParameterCollectionFormatWithHttpInfo
     *
     * @param  string[] $pipe (required)
     * @param  string[] $ioutil (required)
     * @param  string[] $http (required)
     * @param  string[] $url (required)
     * @param  string[] $context (required)
     * @param  string $allow_empty (required)
     * @param  array<string,string> $language (optional)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testQueryParameterCollectionFormatWithHttpInfo($pipe, $ioutil, $http, $url, $context, $allow_empty, $language = null)
    {
        $request = $this->testQueryParameterCollectionFormatRequest($pipe, $ioutil, $http, $url, $context, $allow_empty, $language);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testQueryParameterCollectionFormatAsync
     *
     * @param  string[] $pipe (required)
     * @param  string[] $ioutil (required)
     * @param  string[] $http (required)
     * @param  string[] $url (required)
     * @param  string[] $context (required)
     * @param  string $allow_empty (required)
     * @param  array<string,string> $language (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testQueryParameterCollectionFormatAsync($pipe, $ioutil, $http, $url, $context, $allow_empty, $language = null)
    {
        return $this->testQueryParameterCollectionFormatAsyncWithHttpInfo($pipe, $ioutil, $http, $url, $context, $allow_empty, $language)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testQueryParameterCollectionFormatAsyncWithHttpInfo
     *
     * @param  string[] $pipe (required)
     * @param  string[] $ioutil (required)
     * @param  string[] $http (required)
     * @param  string[] $url (required)
     * @param  string[] $context (required)
     * @param  string $allow_empty (required)
     * @param  array<string,string> $language (optional)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testQueryParameterCollectionFormatAsyncWithHttpInfo($pipe, $ioutil, $http, $url, $context, $allow_empty, $language = null)
    {
        $returnType = '';
        $request = $this->testQueryParameterCollectionFormatRequest($pipe, $ioutil, $http, $url, $context, $allow_empty, $language);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testQueryParameterCollectionFormat'
     *
     * @param  string[] $pipe (required)
     * @param  string[] $ioutil (required)
     * @param  string[] $http (required)
     * @param  string[] $url (required)
     * @param  string[] $context (required)
     * @param  string $allow_empty (required)
     * @param  array<string,string> $language (optional)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testQueryParameterCollectionFormatRequest($pipe, $ioutil, $http, $url, $context, $allow_empty, $language = null)
    {
        // verify the required parameter 'pipe' is set
        if ($pipe === null || (is_array($pipe) && count($pipe) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pipe when calling testQueryParameterCollectionFormat'
            );
        }
        // verify the required parameter 'ioutil' is set
        if ($ioutil === null || (is_array($ioutil) && count($ioutil) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $ioutil when calling testQueryParameterCollectionFormat'
            );
        }
        // verify the required parameter 'http' is set
        if ($http === null || (is_array($http) && count($http) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $http when calling testQueryParameterCollectionFormat'
            );
        }
        // verify the required parameter 'url' is set
        if ($url === null || (is_array($url) && count($url) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $url when calling testQueryParameterCollectionFormat'
            );
        }
        // verify the required parameter 'context' is set
        if ($context === null || (is_array($context) && count($context) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $context when calling testQueryParameterCollectionFormat'
            );
        }
        // verify the required parameter 'allow_empty' is set
        if ($allow_empty === null || (is_array($allow_empty) && count($allow_empty) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $allow_empty when calling testQueryParameterCollectionFormat'
            );
        }

        $resourcePath = '/fake/test-query-parameters';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;

        // query params
        if (is_array($pipe)) {
            $pipe = ObjectSerializer::serializeCollection($pipe, 'pipeDelimited', true);
        }
        if ($pipe !== null) {
            $queryParams['pipe'] = $pipe;
        }
        // query params
        if (is_array($ioutil)) {
            $ioutil = ObjectSerializer::serializeCollection($ioutil, 'form', true);
        }
        if ($ioutil !== null) {
            $queryParams['ioutil'] = $ioutil;
        }
        // query params
        if (is_array($http)) {
            $http = ObjectSerializer::serializeCollection($http, 'spaceDelimited', true);
        }
        if ($http !== null) {
            $queryParams['http'] = $http;
        }
        // query params
        if (is_array($url)) {
            $url = ObjectSerializer::serializeCollection($url, 'form', true);
        }
        if ($url !== null) {
            $queryParams['url'] = $url;
        }
        // query params
        if ($context !== null) {
            if('form' === 'form' && is_array($context)) {
                foreach($context as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['context'] = $context;
            }
        }
        // query params
        if ($language !== null) {
            if('form' === 'form' && is_array($language)) {
                foreach($language as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['language'] = $language;
            }
        }
        // query params
        if ($allow_empty !== null) {
            if('form' === 'form' && is_array($allow_empty)) {
                foreach($allow_empty as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['allowEmpty'] = $allow_empty;
            }
        }




        $headers = $this->headerSelector->selectHeaders(
            [],
            '',
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('PUT', $uri, $headers, $httpBody);
    }

    /**
     * Operation testStringMapReference
     *
     * test referenced string map
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function testStringMapReference($request_body)
    {
        $this->testStringMapReferenceWithHttpInfo($request_body);
    }

    /**
     * Operation testStringMapReferenceWithHttpInfo
     *
     * test referenced string map
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function testStringMapReferenceWithHttpInfo($request_body)
    {
        $request = $this->testStringMapReferenceRequest($request_body);

        try {
            try {
                $response = $this->httpClient->sendRequest($request);
            } catch (HttpException $e) {
                $response = $e->getResponse();
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $response->getStatusCode(),
                        (string) $request->getUri()
                    ),
                    $request,
                    $response,
                    $e
                );
            } catch (ClientExceptionInterface $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $request,
                    null,
                    $e
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation testStringMapReferenceAsync
     *
     * test referenced string map
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testStringMapReferenceAsync($request_body)
    {
        return $this->testStringMapReferenceAsyncWithHttpInfo($request_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation testStringMapReferenceAsyncWithHttpInfo
     *
     * test referenced string map
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \InvalidArgumentException
     * @return Promise
     */
    public function testStringMapReferenceAsyncWithHttpInfo($request_body)
    {
        $returnType = '';
        $request = $this->testStringMapReferenceRequest($request_body);

        return $this->httpAsyncClient->sendAsyncRequest($request)
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function (HttpException $exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $exception->getRequest(),
                        $exception->getResponse(),
                        $exception
                    );
                }
            );
    }

    /**
     * Create request for operation 'testStringMapReference'
     *
     * @param  array<string,string> $request_body request body (required)
     *
     * @throws \InvalidArgumentException
     * @return RequestInterface
     */
    public function testStringMapReferenceRequest($request_body)
    {
        // verify the required parameter 'request_body' is set
        if ($request_body === null || (is_array($request_body) && count($request_body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $request_body when calling testStringMapReference'
            );
        }

        $resourcePath = '/fake/stringMap-reference';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = null;
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            'application/json',
            $multipart
        );

        // for model (json/xml)
        if (isset($request_body)) {
            if ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($request_body));
            } else {
                $httpBody = $request_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($this->headerSelector->isJsonMime($headers['Content-Type'])) {
                $httpBody = json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();

        $uri = $this->createUri($operationHost, $resourcePath, $queryParams);

        return $this->createRequest('POST', $uri, $headers, $httpBody);
    }


    /**
     * @param string $method
     * @param string|UriInterface $uri
     * @param array $headers
     * @param string|StreamInterface|null $body
     *
     * @return RequestInterface
     */
    protected function createRequest(string $method, $uri, array $headers = [], $body = null): RequestInterface
    {
        if ($this->requestFactory instanceof RequestFactory) {
            return $this->requestFactory->createRequest(
                $method,
                $uri,
                $headers,
                $body
            );
        }

        if (is_string($body) && '' !== $body && null === $this->streamFactory) {
            throw new \RuntimeException('Cannot create request: A stream factory is required to create a request with a non-empty string body.');
        }

        $request = $this->requestFactory->createRequest($method, $uri);

        foreach ($headers as $key => $value) {
            $request = $request->withHeader($key, $value);
        }

        if (null !== $body && '' !== $body) {
            $request = $request->withBody(
                is_string($body) ? $this->streamFactory->createStream($body) : $body
            );
        }

        return $request;
    }

    private function createUri(
        string $operationHost,
        string $resourcePath,
        array $queryParams
    ): UriInterface {
        $parsedUrl = parse_url($operationHost);

        $host = $parsedUrl['host'] ?? null;
        $scheme = $parsedUrl['scheme'] ?? null;
        $basePath = $parsedUrl['path'] ?? null;
        $port = $parsedUrl['port'] ?? null;
        $user = $parsedUrl['user'] ?? null;
        $password = $parsedUrl['pass'] ?? null;

        $uri = $this->uriFactory->createUri($basePath . $resourcePath)
            ->withHost($host)
            ->withScheme($scheme)
            ->withPort($port)
            ->withQuery(ObjectSerializer::buildQuery($queryParams));

        if ($user) {
            $uri = $uri->withUserInfo($user, $password);
        }

        return $uri;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
			$request,
                        $response,
                        $exception
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
