#
# OpenAPI Petstore
# This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: "" \
# Version: 1.0.0
# Generated by OpenAPI Generator: https://openapi-generator.tech
#

<#
.SYNOPSIS

No summary available.

.DESCRIPTION

No description available.

.PARAMETER Json

JSON object

.OUTPUTS

FruitReq<PSCustomObject>
#>
function ConvertFrom-PSJsonToFruitReq {
    [CmdletBinding()]
    Param (
        [AllowEmptyString()]
        [string]$Json
    )

    Process {
        $match = 0
        $matchType = $null
        $matchInstance = $null

        # nullable check
        if ([string]::IsNullOrEmpty($Json) -or $Json -eq "{}") {
            return [PSCustomObject]@{
                "ActualType" = $null
                "ActualInstance" = $null
                "OneOfSchemas" = @("AppleReq", "BananaReq")
            }
        }

        # try to match AppleReq defined in the oneOf schemas
        try {
            $matchInstance = ConvertFrom-PSJsonToAppleReq $Json

            foreach($property in $matchInstance.PsObject.Properties) {
                if ($null -ne $property.Value) {
                    $matchType = "AppleReq"
                    $match++
                    break
                }
            }
        } catch {
            # fail to match the schema defined in oneOf, proceed to the next one
            Write-Debug "Failed to match 'AppleReq' defined in oneOf (PSFruitReq). Proceeding to the next one if any."
        }

        # try to match BananaReq defined in the oneOf schemas
        try {
            $matchInstance = ConvertFrom-PSJsonToBananaReq $Json

            foreach($property in $matchInstance.PsObject.Properties) {
                if ($null -ne $property.Value) {
                    $matchType = "BananaReq"
                    $match++
                    break
                }
            }
        } catch {
            # fail to match the schema defined in oneOf, proceed to the next one
            Write-Debug "Failed to match 'BananaReq' defined in oneOf (PSFruitReq). Proceeding to the next one if any."
        }

        if ($match -gt 1) {
            throw "Error! The JSON payload matches more than one type defined in oneOf schemas ([AppleReq, BananaReq]). JSON Payload: $($Json)"
        } elseif ($match -eq 1) {
            return [PSCustomObject]@{
                "ActualType" = ${matchType}
                "ActualInstance" = ${matchInstance}
                "OneOfSchemas" = @("AppleReq", "BananaReq")
            }
        } else {
            throw "Error! The JSON payload doesn't matches any type defined in oneOf schemas ([AppleReq, BananaReq]). JSON Payload: $($Json)"
        }
    }
}

